/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.code.FrameInfoEncoder;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.ImageSingletons;

public class CompilationInfoSupport {
    protected boolean sealed;
    private final Set<AnalysisMethod> forcedCompilations = new HashSet<AnalysisMethod>();
    private final Set<AnalysisMethod> frameInformationRequired = new HashSet<AnalysisMethod>();
    private final Map<AnalysisMethod, Set<Long>> deoptEntries = new HashMap<AnalysisMethod, Set<Long>>();
    private final Set<AnalysisMethod> deoptInliningExcludes = new HashSet<AnalysisMethod>();

    public static CompilationInfoSupport singleton() {
        return (CompilationInfoSupport)ImageSingletons.lookup(CompilationInfoSupport.class);
    }

    public void registerForcedCompilation(ResolvedJavaMethod method) {
        assert (!this.sealed);
        this.forcedCompilations.add(CompilationInfoSupport.toAnalysisMethod(method));
    }

    public boolean isForcedCompilation(ResolvedJavaMethod method) {
        assert (this.seal());
        return this.forcedCompilations.contains(CompilationInfoSupport.toAnalysisMethod(method));
    }

    public void registerFrameInformationRequired(AnalysisMethod method) {
        assert (!this.sealed);
        this.frameInformationRequired.add(method);
        this.deoptEntries.computeIfAbsent(method, m -> new HashSet());
    }

    public boolean isFrameInformationRequired(ResolvedJavaMethod method) {
        assert (this.seal());
        return this.frameInformationRequired.contains(CompilationInfoSupport.toAnalysisMethod(method));
    }

    public void registerDeoptEntry(ResolvedJavaMethod method, int bci, boolean duringCall, boolean rethrowException) {
        assert (!this.sealed);
        assert (bci >= 0);
        long encodedBci = FrameInfoEncoder.encodeBci(bci, duringCall, rethrowException);
        this.deoptEntries.computeIfAbsent(CompilationInfoSupport.toAnalysisMethod(method), m -> new HashSet()).add(encodedBci);
    }

    protected boolean isDeoptTarget(ResolvedJavaMethod method) {
        assert (this.seal());
        return this.deoptEntries.containsKey(CompilationInfoSupport.toAnalysisMethod(method));
    }

    protected boolean isDeoptEntry(ResolvedJavaMethod method, int bci, boolean duringCall, boolean rethrowException) {
        assert (this.seal());
        Set<Long> bciSet = this.deoptEntries.get(CompilationInfoSupport.toAnalysisMethod(method));
        assert (bciSet != null) : "can only query for deopt entries for methods registered as deopt targets";
        long encodedBci = FrameInfoEncoder.encodeBci(bci, duringCall, rethrowException);
        return bciSet.contains(encodedBci);
    }

    public void registerAsDeoptInlininingExclude(ResolvedJavaMethod method) {
        assert (!this.sealed);
        this.deoptInliningExcludes.add(CompilationInfoSupport.toAnalysisMethod(method));
    }

    public boolean isDeoptInliningExclude(ResolvedJavaMethod method) {
        assert (this.seal());
        return this.deoptInliningExcludes.contains(CompilationInfoSupport.toAnalysisMethod(method));
    }

    public Map<AnalysisMethod, Set<Long>> getDeoptEntries() {
        assert (this.seal());
        return this.deoptEntries;
    }

    private static AnalysisMethod toAnalysisMethod(ResolvedJavaMethod method) {
        if (method instanceof AnalysisMethod) {
            return (AnalysisMethod)method;
        }
        if (method instanceof HostedMethod) {
            return ((HostedMethod)method).wrapped;
        }
        throw VMError.shouldNotReachHere();
    }

    private boolean seal() {
        this.sealed = true;
        return true;
    }
}

