/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.ReferenceMapEncoder;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import jdk.vm.ci.code.ReferenceMap;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.meta.Value;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public class SubstrateReferenceMap
extends ReferenceMap
implements ReferenceMapEncoder.Input {
    private final BitSet input = new BitSet();
    private EconomicMap<Integer, Set<Integer>> derived;
    private Map<Integer, Object> debugAllUsedRegisters;
    private Map<Integer, Object> debugAllUsedStackSlots;

    public SubstrateReferenceMap() {
        assert (ConfigurationValues.getObjectLayout().getReferenceSize() > 2) : "needs to be three bits or more for encoding and validation";
    }

    public boolean isOffsetMarked(int offset) {
        return this.input.get(offset);
    }

    public boolean isOffsetCompressed(int offset) {
        assert (this.isOffsetMarked(offset));
        return this.input.get(offset + 1);
    }

    public void markReferenceAtOffset(int offset, boolean compressed) {
        assert (this.isValidToMark(offset, compressed)) : "already marked or would overlap with predecessor or successor";
        this.input.set(offset);
        if (compressed) {
            this.input.set(offset + 1);
        }
    }

    public void markReferenceAtOffset(int offset, int baseOffset, boolean compressed) {
        HashSet<Integer> derivedOffsets;
        if (offset == baseOffset) {
            if (this.derived == null || !this.derived.containsKey((Object)baseOffset)) {
                this.markReferenceAtOffset(baseOffset, compressed);
            }
            return;
        }
        if (!this.isOffsetMarked(baseOffset)) {
            this.markReferenceAtOffset(baseOffset, compressed);
        }
        if (this.derived == null) {
            this.derived = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        }
        if ((derivedOffsets = (HashSet<Integer>)this.derived.get((Object)baseOffset)) == null) {
            derivedOffsets = new HashSet<Integer>();
            this.derived.put((Object)baseOffset, derivedOffsets);
        }
        assert (!derivedOffsets.contains(offset));
        derivedOffsets.add(offset);
    }

    private boolean isValidToMark(int offset, boolean isCompressed) {
        int uncompressedSize = FrameAccess.uncompressedReferenceSize();
        int compressedSize = ConfigurationValues.getObjectLayout().getReferenceSize();
        int previousOffset = this.input.previousSetBit(offset - 1);
        if (previousOffset != -1) {
            int minOffset = previousOffset + uncompressedSize;
            if (previousOffset != 0 && this.input.get(previousOffset - 1)) {
                minOffset = --previousOffset + compressedSize;
            }
            if (offset < minOffset) {
                return false;
            }
        }
        int size = isCompressed ? compressedSize : uncompressedSize;
        int nextIndex = this.input.nextSetBit(offset);
        return nextIndex == -1 || offset + size <= nextIndex;
    }

    public Map<Integer, Object> getDebugAllUsedRegisters() {
        return this.debugAllUsedRegisters;
    }

    boolean debugMarkRegister(int offset, Value value) {
        if (this.debugAllUsedRegisters == null) {
            this.debugAllUsedRegisters = new HashMap<Integer, Object>();
        }
        this.debugAllUsedRegisters.put(offset, value);
        return true;
    }

    public Map<Integer, Object> getDebugAllUsedStackSlots() {
        return this.debugAllUsedStackSlots;
    }

    boolean debugMarkStackSlot(int offset, StackSlot value) {
        if (this.debugAllUsedStackSlots == null) {
            this.debugAllUsedStackSlots = new HashMap<Integer, Object>();
        }
        this.debugAllUsedStackSlots.put(offset, value);
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.input.isEmpty();
    }

    @Override
    public ReferenceMapEncoder.OffsetIterator getOffsets() {
        return new ReferenceMapEncoder.OffsetIterator(){
            private int nextIndex;
            {
                this.nextIndex = SubstrateReferenceMap.this.input.nextSetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex != -1;
            }

            @Override
            public int nextInt() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int index = this.nextIndex;
                this.nextIndex = SubstrateReferenceMap.this.input.nextSetBit(index + 2);
                return index;
            }

            @Override
            public boolean isNextCompressed() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return SubstrateReferenceMap.this.isOffsetCompressed(this.nextIndex);
            }

            @Override
            public boolean isNextDerived() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return SubstrateReferenceMap.this.derived != null && SubstrateReferenceMap.this.derived.containsKey((Object)this.nextIndex);
            }

            @Override
            public Set<Integer> getDerivedOffsets(int baseOffset) {
                if (SubstrateReferenceMap.this.derived == null || !SubstrateReferenceMap.this.derived.containsKey((Object)baseOffset)) {
                    throw new NoSuchElementException();
                }
                return (Set)SubstrateReferenceMap.this.derived.get((Object)baseOffset);
            }
        };
    }

    public int hashCode() {
        return this.input.hashCode() + (this.derived == null ? 0 : this.derived.hashCode());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SubstrateReferenceMap) {
            SubstrateReferenceMap other = (SubstrateReferenceMap)obj;
            if (!this.input.equals(other.input)) {
                return false;
            }
            if (this.derived == null || other.derived == null) {
                return this.derived == null && other.derived == null;
            }
            if (this.derived.size() != other.derived.size()) {
                return false;
            }
            Iterator iterator = this.derived.getKeys().iterator();
            while (iterator.hasNext()) {
                int base = (Integer)iterator.next();
                if (((Set)this.derived.get((Object)base)).equals(other.derived.get((Object)base))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean hasNoDerivedOffsets() {
        return this.derived == null || this.derived.isEmpty();
    }

    public void verify() {
        if (this.derived == null) {
            return;
        }
        Iterator iterator = this.derived.getKeys().iterator();
        while (iterator.hasNext()) {
            int baseOffset = (Integer)iterator.next();
            Iterator iterator2 = ((Set)this.derived.get((Object)baseOffset)).iterator();
            while (iterator2.hasNext()) {
                int derivedOffset = (Integer)iterator2.next();
                assert (!this.derived.containsKey((Object)derivedOffset));
            }
        }
    }

    public void dump(StringBuilder builder) {
        if (this.input.isEmpty()) {
            builder.append("[]");
            return;
        }
        builder.append('[');
        this.input.stream().forEach(offset -> {
            builder.append(offset);
            if (this.derived != null && this.derived.containsKey((Object)offset)) {
                builder.append(" -> {");
                Iterator iterator = ((Set)this.derived.get((Object)offset)).iterator();
                while (iterator.hasNext()) {
                    int derivedOffset = (Integer)iterator.next();
                    builder.append(derivedOffset);
                    builder.append(", ");
                }
                builder.replace(builder.length() - 2, builder.length(), "}");
            }
            builder.append(", ");
        });
        builder.replace(builder.length() - 2, builder.length(), "]");
    }
}

