/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.mult;

import org.ejml.MatrixDimensionException;
import org.ejml.concurrency.EjmlConcurrency;
import org.ejml.data.ZMatrixD1;
import org.ejml.data.ZMatrixRMaj;
import org.ejml.dense.row.CommonOps_ZDRM;

public class MatrixMatrixMult_MT_ZDRM {
    public static void mult_reorder(ZMatrixRMaj a, ZMatrixRMaj b, ZMatrixRMaj c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a.numCols == 0 || a.numRows == 0) {
            CommonOps_ZDRM.fill((ZMatrixD1)c, 0.0, 0.0);
            return;
        }
        int strideA = a.getRowStride();
        int strideB = b.getRowStride();
        int strideC = c.getRowStride();
        int endOfKLoop = b.numRows * strideB;
        EjmlConcurrency.loopFor((int)0, (int)a.numRows, i -> {
            double imagB;
            double realB;
            int indexCbase = i * strideC;
            int indexA = i * strideA;
            int indexB = 0;
            int indexC = indexCbase;
            int end = indexB + strideB;
            double realA = a.data[indexA++];
            double imagA = a.data[indexA++];
            while (indexB < end) {
                realB = b.data[indexB++];
                imagB = b.data[indexB++];
                c.data[indexC++] = realA * realB - imagA * imagB;
                c.data[indexC++] = realA * imagB + imagA * realB;
            }
            while (indexB != endOfKLoop) {
                indexC = indexCbase;
                end = indexB + strideB;
                realA = a.data[indexA++];
                imagA = a.data[indexA++];
                while (indexB < end) {
                    realB = b.data[indexB++];
                    imagB = b.data[indexB++];
                    int n = indexC++;
                    c.data[n] = c.data[n] + (realA * realB - imagA * imagB);
                    int n2 = indexC++;
                    c.data[n2] = c.data[n2] + (realA * imagB + imagA * realB);
                }
            }
        });
    }

    public static void mult_small(ZMatrixRMaj a, ZMatrixRMaj b, ZMatrixRMaj c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int strideA = a.getRowStride();
        int strideB = b.getRowStride();
        EjmlConcurrency.loopFor((int)0, (int)a.numRows, i -> {
            int aIndexStart = i * strideA;
            int indexC = i * strideB;
            for (int j = 0; j < b.numCols; ++j) {
                double realTotal = 0.0;
                double imagTotal = 0.0;
                int indexA = aIndexStart;
                int indexB = j * 2;
                int end = indexA + strideA;
                while (indexA < end) {
                    double realA = a.data[indexA++];
                    double imagA = a.data[indexA++];
                    double realB = b.data[indexB];
                    double imagB = b.data[indexB + 1];
                    realTotal += realA * realB - imagA * imagB;
                    imagTotal += realA * imagB + imagA * realB;
                    indexB += strideB;
                }
                c.data[indexC++] = realTotal;
                c.data[indexC++] = imagTotal;
            }
        });
    }

    public static void multTransA_reorder(ZMatrixRMaj a, ZMatrixRMaj b, ZMatrixRMaj c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a.numCols == 0 || a.numRows == 0) {
            CommonOps_ZDRM.fill((ZMatrixD1)c, 0.0, 0.0);
            return;
        }
        EjmlConcurrency.loopFor((int)0, (int)a.numCols, i -> {
            int indexC_start = i * c.numCols * 2;
            double realA = a.data[i * 2];
            double imagA = a.data[i * 2 + 1];
            int indexB = 0;
            int end = indexB + b.numCols * 2;
            int indexC = indexC_start;
            while (indexB < end) {
                double realB = b.data[indexB++];
                double imagB = b.data[indexB++];
                c.data[indexC++] = realA * realB + imagA * imagB;
                c.data[indexC++] = realA * imagB - imagA * realB;
            }
            for (int k = 1; k < a.numRows; ++k) {
                realA = a.getReal(k, i);
                imagA = a.getImag(k, i);
                end = indexB + b.numCols * 2;
                indexC = indexC_start;
                while (indexB < end) {
                    double realB = b.data[indexB++];
                    double imagB = b.data[indexB++];
                    int n = indexC++;
                    c.data[n] = c.data[n] + (realA * realB + imagA * imagB);
                    int n2 = indexC++;
                    c.data[n2] = c.data[n2] + (realA * imagB - imagA * realB);
                }
            }
        });
    }

    public static void multTransA_small(ZMatrixRMaj a, ZMatrixRMaj b, ZMatrixRMaj c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        EjmlConcurrency.loopFor((int)0, (int)a.numCols, i -> {
            int indexC = i * 2 * b.numCols;
            for (int j = 0; j < b.numCols; ++j) {
                int indexB;
                int indexA = i * 2;
                int end = indexB + b.numRows * b.numCols * 2;
                double realTotal = 0.0;
                double imagTotal = 0.0;
                for (indexB = j * 2; indexB < end; indexB += b.numCols * 2) {
                    double realA = a.data[indexA];
                    double imagA = a.data[indexA + 1];
                    double realB = b.data[indexB];
                    double imagB = b.data[indexB + 1];
                    realTotal += realA * realB + imagA * imagB;
                    imagTotal += realA * imagB - imagA * realB;
                    indexA += a.numCols * 2;
                }
                c.data[indexC++] = realTotal;
                c.data[indexC++] = imagTotal;
            }
        });
    }

    public static void multTransB(ZMatrixRMaj a, ZMatrixRMaj b, ZMatrixRMaj c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numRows != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        EjmlConcurrency.loopFor((int)0, (int)a.numRows, xA -> {
            int indexC = xA * b.numRows * 2;
            int aIndexStart = xA * a.numCols * 2;
            int end = aIndexStart + b.numCols * 2;
            int indexB = 0;
            for (int xB = 0; xB < b.numRows; ++xB) {
                int indexA = aIndexStart;
                double realTotal = 0.0;
                double imagTotal = 0.0;
                while (indexA < end) {
                    double realA = a.data[indexA++];
                    double imagA = a.data[indexA++];
                    double realB = b.data[indexB++];
                    double imagB = b.data[indexB++];
                    realTotal += realA * realB + imagA * imagB;
                    imagTotal += imagA * realB - realA * imagB;
                }
                c.data[indexC++] = realTotal;
                c.data[indexC++] = imagTotal;
            }
        });
    }

    public static void multTransAB(ZMatrixRMaj a, ZMatrixRMaj b, ZMatrixRMaj c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != c.numRows || b.numRows != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        EjmlConcurrency.loopFor((int)0, (int)a.numCols, i -> {
            int indexC = i * b.numRows * 2;
            int indexB = 0;
            for (int j = 0; j < b.numRows; ++j) {
                int indexA = i * 2;
                int end = indexB + b.numCols * 2;
                double realTotal = 0.0;
                double imagTotal = 0.0;
                while (indexB < end) {
                    double realA = a.data[indexA];
                    double imagA = -a.data[indexA + 1];
                    double realB = b.data[indexB++];
                    double imagB = -b.data[indexB++];
                    realTotal += realA * realB - imagA * imagB;
                    imagTotal += realA * imagB + imagA * realB;
                    indexA += a.numCols * 2;
                }
                c.data[indexC++] = realTotal;
                c.data[indexC++] = imagTotal;
            }
        });
    }

    public static void multAdd_reorder(ZMatrixRMaj a, ZMatrixRMaj b, ZMatrixRMaj c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a.numCols == 0 || a.numRows == 0) {
            return;
        }
        int strideA = a.getRowStride();
        int strideB = b.getRowStride();
        int strideC = c.getRowStride();
        int endOfKLoop = b.numRows * strideB;
        EjmlConcurrency.loopFor((int)0, (int)a.numRows, i -> {
            double imagB;
            double realB;
            int indexCbase = i * strideC;
            int indexA = i * strideA;
            int indexB = 0;
            int indexC = indexCbase;
            int end = indexB + strideB;
            double realA = a.data[indexA++];
            double imagA = a.data[indexA++];
            while (indexB < end) {
                realB = b.data[indexB++];
                imagB = b.data[indexB++];
                int n = indexC++;
                c.data[n] = c.data[n] + (realA * realB - imagA * imagB);
                int n2 = indexC++;
                c.data[n2] = c.data[n2] + (realA * imagB + imagA * realB);
            }
            while (indexB != endOfKLoop) {
                indexC = indexCbase;
                end = indexB + strideB;
                realA = a.data[indexA++];
                imagA = a.data[indexA++];
                while (indexB < end) {
                    realB = b.data[indexB++];
                    imagB = b.data[indexB++];
                    int n = indexC++;
                    c.data[n] = c.data[n] + (realA * realB - imagA * imagB);
                    int n3 = indexC++;
                    c.data[n3] = c.data[n3] + (realA * imagB + imagA * realB);
                }
            }
        });
    }

    public static void multAdd_small(ZMatrixRMaj a, ZMatrixRMaj b, ZMatrixRMaj c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int strideA = a.getRowStride();
        int strideB = b.getRowStride();
        EjmlConcurrency.loopFor((int)0, (int)a.numRows, i -> {
            int aIndexStart = i * strideA;
            int indexC = i * strideB;
            for (int j = 0; j < b.numCols; ++j) {
                double realTotal = 0.0;
                double imagTotal = 0.0;
                int indexA = aIndexStart;
                int indexB = j * 2;
                int end = indexA + strideA;
                while (indexA < end) {
                    double realA = a.data[indexA++];
                    double imagA = a.data[indexA++];
                    double realB = b.data[indexB];
                    double imagB = b.data[indexB + 1];
                    realTotal += realA * realB - imagA * imagB;
                    imagTotal += realA * imagB + imagA * realB;
                    indexB += strideB;
                }
                int n = indexC++;
                c.data[n] = c.data[n] + realTotal;
                int n2 = indexC++;
                c.data[n2] = c.data[n2] + imagTotal;
            }
        });
    }

    public static void multAddTransA_reorder(ZMatrixRMaj a, ZMatrixRMaj b, ZMatrixRMaj c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a.numCols == 0 || a.numRows == 0) {
            return;
        }
        EjmlConcurrency.loopFor((int)0, (int)a.numCols, i -> {
            int indexC_start = i * c.numCols * 2;
            double realA = a.data[i * 2];
            double imagA = a.data[i * 2 + 1];
            int indexB = 0;
            int end = indexB + b.numCols * 2;
            int indexC = indexC_start;
            while (indexB < end) {
                double realB = b.data[indexB++];
                double imagB = b.data[indexB++];
                int n = indexC++;
                c.data[n] = c.data[n] + (realA * realB + imagA * imagB);
                int n2 = indexC++;
                c.data[n2] = c.data[n2] + (realA * imagB - imagA * realB);
            }
            for (int k = 1; k < a.numRows; ++k) {
                realA = a.getReal(k, i);
                imagA = a.getImag(k, i);
                end = indexB + b.numCols * 2;
                indexC = indexC_start;
                while (indexB < end) {
                    double realB = b.data[indexB++];
                    double imagB = b.data[indexB++];
                    int n = indexC++;
                    c.data[n] = c.data[n] + (realA * realB + imagA * imagB);
                    int n3 = indexC++;
                    c.data[n3] = c.data[n3] + (realA * imagB - imagA * realB);
                }
            }
        });
    }

    public static void multAddTransA_small(ZMatrixRMaj a, ZMatrixRMaj b, ZMatrixRMaj c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        EjmlConcurrency.loopFor((int)0, (int)a.numCols, i -> {
            int indexC = i * 2 * b.numCols;
            for (int j = 0; j < b.numCols; ++j) {
                int indexB;
                int indexA = i * 2;
                int end = indexB + b.numRows * b.numCols * 2;
                double realTotal = 0.0;
                double imagTotal = 0.0;
                for (indexB = j * 2; indexB < end; indexB += b.numCols * 2) {
                    double realA = a.data[indexA];
                    double imagA = a.data[indexA + 1];
                    double realB = b.data[indexB];
                    double imagB = b.data[indexB + 1];
                    realTotal += realA * realB + imagA * imagB;
                    imagTotal += realA * imagB - imagA * realB;
                    indexA += a.numCols * 2;
                }
                int n = indexC++;
                c.data[n] = c.data[n] + realTotal;
                int n2 = indexC++;
                c.data[n2] = c.data[n2] + imagTotal;
            }
        });
    }

    public static void multAddTransB(ZMatrixRMaj a, ZMatrixRMaj b, ZMatrixRMaj c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numRows != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        EjmlConcurrency.loopFor((int)0, (int)a.numRows, xA -> {
            int indexC = xA * b.numRows * 2;
            int aIndexStart = xA * a.numCols * 2;
            int end = aIndexStart + b.numCols * 2;
            int indexB = 0;
            for (int xB = 0; xB < b.numRows; ++xB) {
                int indexA = aIndexStart;
                double realTotal = 0.0;
                double imagTotal = 0.0;
                while (indexA < end) {
                    double realA = a.data[indexA++];
                    double imagA = a.data[indexA++];
                    double realB = b.data[indexB++];
                    double imagB = b.data[indexB++];
                    realTotal += realA * realB + imagA * imagB;
                    imagTotal += imagA * realB - realA * imagB;
                }
                int n = indexC++;
                c.data[n] = c.data[n] + realTotal;
                int n2 = indexC++;
                c.data[n2] = c.data[n2] + imagTotal;
            }
        });
    }

    public static void multAddTransAB(ZMatrixRMaj a, ZMatrixRMaj b, ZMatrixRMaj c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != c.numRows || b.numRows != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        EjmlConcurrency.loopFor((int)0, (int)a.numCols, i -> {
            int indexC = i * b.numRows * 2;
            int indexB = 0;
            for (int j = 0; j < b.numRows; ++j) {
                int indexA = i * 2;
                int end = indexB + b.numCols * 2;
                double realTotal = 0.0;
                double imagTotal = 0.0;
                while (indexB < end) {
                    double realA = a.data[indexA];
                    double imagA = -a.data[indexA + 1];
                    double realB = b.data[indexB++];
                    double imagB = -b.data[indexB++];
                    realTotal += realA * realB - imagA * imagB;
                    imagTotal += realA * imagB + imagA * realB;
                    indexA += a.numCols * 2;
                }
                int n = indexC++;
                c.data[n] = c.data[n] + realTotal;
                int n2 = indexC++;
                c.data[n2] = c.data[n2] + imagTotal;
            }
        });
    }

    public static void mult_reorder(double realAlpha, double imagAlpha, ZMatrixRMaj a, ZMatrixRMaj b, ZMatrixRMaj c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a.numCols == 0 || a.numRows == 0) {
            CommonOps_ZDRM.fill((ZMatrixD1)c, 0.0, 0.0);
            return;
        }
        int strideA = a.getRowStride();
        int strideB = b.getRowStride();
        int strideC = c.getRowStride();
        int endOfKLoop = b.numRows * strideB;
        EjmlConcurrency.loopFor((int)0, (int)a.numRows, i -> {
            double imagB;
            double realB;
            int indexCbase = i * strideC;
            int indexA = i * strideA;
            int indexB = 0;
            int indexC = indexCbase;
            int end = indexB + strideB;
            double realTmp = a.data[indexA++];
            double imagTmp = a.data[indexA++];
            double realA = realAlpha * realTmp - imagAlpha * imagTmp;
            double imagA = realAlpha * imagTmp + imagAlpha * realTmp;
            while (indexB < end) {
                realB = b.data[indexB++];
                imagB = b.data[indexB++];
                c.data[indexC++] = realA * realB - imagA * imagB;
                c.data[indexC++] = realA * imagB + imagA * realB;
            }
            while (indexB != endOfKLoop) {
                indexC = indexCbase;
                end = indexB + strideB;
                realTmp = a.data[indexA++];
                imagTmp = a.data[indexA++];
                realA = realAlpha * realTmp - imagAlpha * imagTmp;
                imagA = realAlpha * imagTmp + imagAlpha * realTmp;
                while (indexB < end) {
                    realB = b.data[indexB++];
                    imagB = b.data[indexB++];
                    int n = indexC++;
                    c.data[n] = c.data[n] + (realA * realB - imagA * imagB);
                    int n2 = indexC++;
                    c.data[n2] = c.data[n2] + (realA * imagB + imagA * realB);
                }
            }
        });
    }

    public static void mult_small(double realAlpha, double imagAlpha, ZMatrixRMaj a, ZMatrixRMaj b, ZMatrixRMaj c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int strideA = a.getRowStride();
        int strideB = b.getRowStride();
        EjmlConcurrency.loopFor((int)0, (int)a.numRows, i -> {
            int aIndexStart = i * strideA;
            int indexC = i * strideB;
            for (int j = 0; j < b.numCols; ++j) {
                double realTotal = 0.0;
                double imagTotal = 0.0;
                int indexA = aIndexStart;
                int indexB = j * 2;
                int end = indexA + strideA;
                while (indexA < end) {
                    double realA = a.data[indexA++];
                    double imagA = a.data[indexA++];
                    double realB = b.data[indexB];
                    double imagB = b.data[indexB + 1];
                    realTotal += realA * realB - imagA * imagB;
                    imagTotal += realA * imagB + imagA * realB;
                    indexB += strideB;
                }
                c.data[indexC++] = realAlpha * realTotal - imagAlpha * imagTotal;
                c.data[indexC++] = realAlpha * imagTotal + imagAlpha * realTotal;
            }
        });
    }

    public static void multTransA_reorder(double realAlpha, double imagAlpha, ZMatrixRMaj a, ZMatrixRMaj b, ZMatrixRMaj c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a.numCols == 0 || a.numRows == 0) {
            CommonOps_ZDRM.fill((ZMatrixD1)c, 0.0, 0.0);
            return;
        }
        EjmlConcurrency.loopFor((int)0, (int)a.numCols, i -> {
            int indexC_start = i * c.numCols * 2;
            double realTmp = a.data[i * 2];
            double imagTmp = a.data[i * 2 + 1];
            double realA = realAlpha * realTmp + imagAlpha * imagTmp;
            double imagA = realAlpha * imagTmp - imagAlpha * realTmp;
            int indexB = 0;
            int end = indexB + b.numCols * 2;
            int indexC = indexC_start;
            while (indexB < end) {
                double realB = b.data[indexB++];
                double imagB = b.data[indexB++];
                c.data[indexC++] = realA * realB + imagA * imagB;
                c.data[indexC++] = realA * imagB - imagA * realB;
            }
            for (int k = 1; k < a.numRows; ++k) {
                realTmp = a.getReal(k, i);
                imagTmp = a.getImag(k, i);
                realA = realAlpha * realTmp + imagAlpha * imagTmp;
                imagA = realAlpha * imagTmp - imagAlpha * realTmp;
                end = indexB + b.numCols * 2;
                indexC = indexC_start;
                while (indexB < end) {
                    double realB = b.data[indexB++];
                    double imagB = b.data[indexB++];
                    int n = indexC++;
                    c.data[n] = c.data[n] + (realA * realB + imagA * imagB);
                    int n2 = indexC++;
                    c.data[n2] = c.data[n2] + (realA * imagB - imagA * realB);
                }
            }
        });
    }

    public static void multTransA_small(double realAlpha, double imagAlpha, ZMatrixRMaj a, ZMatrixRMaj b, ZMatrixRMaj c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        EjmlConcurrency.loopFor((int)0, (int)a.numCols, i -> {
            int indexC = i * 2 * b.numCols;
            for (int j = 0; j < b.numCols; ++j) {
                int indexB;
                int indexA = i * 2;
                int end = indexB + b.numRows * b.numCols * 2;
                double realTotal = 0.0;
                double imagTotal = 0.0;
                for (indexB = j * 2; indexB < end; indexB += b.numCols * 2) {
                    double realA = a.data[indexA];
                    double imagA = a.data[indexA + 1];
                    double realB = b.data[indexB];
                    double imagB = b.data[indexB + 1];
                    realTotal += realA * realB + imagA * imagB;
                    imagTotal += realA * imagB - imagA * realB;
                    indexA += a.numCols * 2;
                }
                c.data[indexC++] = realAlpha * realTotal - imagAlpha * imagTotal;
                c.data[indexC++] = realAlpha * imagTotal + imagAlpha * realTotal;
            }
        });
    }

    public static void multTransB(double realAlpha, double imagAlpha, ZMatrixRMaj a, ZMatrixRMaj b, ZMatrixRMaj c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numRows != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        EjmlConcurrency.loopFor((int)0, (int)a.numRows, xA -> {
            int indexC = xA * b.numRows * 2;
            int aIndexStart = xA * a.numCols * 2;
            int end = aIndexStart + b.numCols * 2;
            int indexB = 0;
            for (int xB = 0; xB < b.numRows; ++xB) {
                int indexA = aIndexStart;
                double realTotal = 0.0;
                double imagTotal = 0.0;
                while (indexA < end) {
                    double realA = a.data[indexA++];
                    double imagA = a.data[indexA++];
                    double realB = b.data[indexB++];
                    double imagB = b.data[indexB++];
                    realTotal += realA * realB + imagA * imagB;
                    imagTotal += imagA * realB - realA * imagB;
                }
                c.data[indexC++] = realAlpha * realTotal - imagAlpha * imagTotal;
                c.data[indexC++] = realAlpha * imagTotal + imagAlpha * realTotal;
            }
        });
    }

    public static void multTransAB(double realAlpha, double imagAlpha, ZMatrixRMaj a, ZMatrixRMaj b, ZMatrixRMaj c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != c.numRows || b.numRows != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        EjmlConcurrency.loopFor((int)0, (int)a.numCols, i -> {
            int indexC = i * b.numRows * 2;
            int indexB = 0;
            for (int j = 0; j < b.numRows; ++j) {
                int indexA = i * 2;
                int end = indexB + b.numCols * 2;
                double realTotal = 0.0;
                double imagTotal = 0.0;
                while (indexB < end) {
                    double realA = a.data[indexA];
                    double imagA = -a.data[indexA + 1];
                    double realB = b.data[indexB++];
                    double imagB = -b.data[indexB++];
                    realTotal += realA * realB - imagA * imagB;
                    imagTotal += realA * imagB + imagA * realB;
                    indexA += a.numCols * 2;
                }
                c.data[indexC++] = realAlpha * realTotal - imagAlpha * imagTotal;
                c.data[indexC++] = realAlpha * imagTotal + imagAlpha * realTotal;
            }
        });
    }

    public static void multAdd_reorder(double realAlpha, double imagAlpha, ZMatrixRMaj a, ZMatrixRMaj b, ZMatrixRMaj c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a.numCols == 0 || a.numRows == 0) {
            return;
        }
        int strideA = a.getRowStride();
        int strideB = b.getRowStride();
        int strideC = c.getRowStride();
        int endOfKLoop = b.numRows * strideB;
        EjmlConcurrency.loopFor((int)0, (int)a.numRows, i -> {
            double imagB;
            double realB;
            int indexCbase = i * strideC;
            int indexA = i * strideA;
            int indexB = 0;
            int indexC = indexCbase;
            int end = indexB + strideB;
            double realTmp = a.data[indexA++];
            double imagTmp = a.data[indexA++];
            double realA = realAlpha * realTmp - imagAlpha * imagTmp;
            double imagA = realAlpha * imagTmp + imagAlpha * realTmp;
            while (indexB < end) {
                realB = b.data[indexB++];
                imagB = b.data[indexB++];
                int n = indexC++;
                c.data[n] = c.data[n] + (realA * realB - imagA * imagB);
                int n2 = indexC++;
                c.data[n2] = c.data[n2] + (realA * imagB + imagA * realB);
            }
            while (indexB != endOfKLoop) {
                indexC = indexCbase;
                end = indexB + strideB;
                realTmp = a.data[indexA++];
                imagTmp = a.data[indexA++];
                realA = realAlpha * realTmp - imagAlpha * imagTmp;
                imagA = realAlpha * imagTmp + imagAlpha * realTmp;
                while (indexB < end) {
                    realB = b.data[indexB++];
                    imagB = b.data[indexB++];
                    int n = indexC++;
                    c.data[n] = c.data[n] + (realA * realB - imagA * imagB);
                    int n3 = indexC++;
                    c.data[n3] = c.data[n3] + (realA * imagB + imagA * realB);
                }
            }
        });
    }

    public static void multAdd_small(double realAlpha, double imagAlpha, ZMatrixRMaj a, ZMatrixRMaj b, ZMatrixRMaj c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        int strideA = a.getRowStride();
        int strideB = b.getRowStride();
        EjmlConcurrency.loopFor((int)0, (int)a.numRows, i -> {
            int aIndexStart = i * strideA;
            int indexC = i * strideB;
            for (int j = 0; j < b.numCols; ++j) {
                double realTotal = 0.0;
                double imagTotal = 0.0;
                int indexA = aIndexStart;
                int indexB = j * 2;
                int end = indexA + strideA;
                while (indexA < end) {
                    double realA = a.data[indexA++];
                    double imagA = a.data[indexA++];
                    double realB = b.data[indexB];
                    double imagB = b.data[indexB + 1];
                    realTotal += realA * realB - imagA * imagB;
                    imagTotal += realA * imagB + imagA * realB;
                    indexB += strideB;
                }
                int n = indexC++;
                c.data[n] = c.data[n] + (realAlpha * realTotal - imagAlpha * imagTotal);
                int n2 = indexC++;
                c.data[n2] = c.data[n2] + (realAlpha * imagTotal + imagAlpha * realTotal);
            }
        });
    }

    public static void multAddTransA_reorder(double realAlpha, double imagAlpha, ZMatrixRMaj a, ZMatrixRMaj b, ZMatrixRMaj c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        if (a.numCols == 0 || a.numRows == 0) {
            return;
        }
        EjmlConcurrency.loopFor((int)0, (int)a.numCols, i -> {
            int indexC_start = i * c.numCols * 2;
            double realTmp = a.data[i * 2];
            double imagTmp = a.data[i * 2 + 1];
            double realA = realAlpha * realTmp + imagAlpha * imagTmp;
            double imagA = realAlpha * imagTmp - imagAlpha * realTmp;
            int indexB = 0;
            int end = indexB + b.numCols * 2;
            int indexC = indexC_start;
            while (indexB < end) {
                double realB = b.data[indexB++];
                double imagB = b.data[indexB++];
                int n = indexC++;
                c.data[n] = c.data[n] + (realA * realB + imagA * imagB);
                int n2 = indexC++;
                c.data[n2] = c.data[n2] + (realA * imagB - imagA * realB);
            }
            for (int k = 1; k < a.numRows; ++k) {
                realTmp = a.getReal(k, i);
                imagTmp = a.getImag(k, i);
                realA = realAlpha * realTmp + imagAlpha * imagTmp;
                imagA = realAlpha * imagTmp - imagAlpha * realTmp;
                end = indexB + b.numCols * 2;
                indexC = indexC_start;
                while (indexB < end) {
                    double realB = b.data[indexB++];
                    double imagB = b.data[indexB++];
                    int n = indexC++;
                    c.data[n] = c.data[n] + (realA * realB + imagA * imagB);
                    int n3 = indexC++;
                    c.data[n3] = c.data[n3] + (realA * imagB - imagA * realB);
                }
            }
        });
    }

    public static void multAddTransA_small(double realAlpha, double imagAlpha, ZMatrixRMaj a, ZMatrixRMaj b, ZMatrixRMaj c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != c.numRows || b.numCols != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        EjmlConcurrency.loopFor((int)0, (int)a.numCols, i -> {
            int indexC = i * 2 * b.numCols;
            for (int j = 0; j < b.numCols; ++j) {
                int indexB;
                int indexA = i * 2;
                int end = indexB + b.numRows * b.numCols * 2;
                double realTotal = 0.0;
                double imagTotal = 0.0;
                for (indexB = j * 2; indexB < end; indexB += b.numCols * 2) {
                    double realA = a.data[indexA];
                    double imagA = a.data[indexA + 1];
                    double realB = b.data[indexB];
                    double imagB = b.data[indexB + 1];
                    realTotal += realA * realB + imagA * imagB;
                    imagTotal += realA * imagB - imagA * realB;
                    indexA += a.numCols * 2;
                }
                int n = indexC++;
                c.data[n] = c.data[n] + (realAlpha * realTotal - imagAlpha * imagTotal);
                int n2 = indexC++;
                c.data[n2] = c.data[n2] + (realAlpha * imagTotal + imagAlpha * realTotal);
            }
        });
    }

    public static void multAddTransB(double realAlpha, double imagAlpha, ZMatrixRMaj a, ZMatrixRMaj b, ZMatrixRMaj c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numCols != b.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numRows != c.numRows || b.numRows != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        EjmlConcurrency.loopFor((int)0, (int)a.numRows, xA -> {
            int indexC = xA * b.numRows * 2;
            int aIndexStart = xA * a.numCols * 2;
            int end = aIndexStart + b.numCols * 2;
            int indexB = 0;
            for (int xB = 0; xB < b.numRows; ++xB) {
                int indexA = aIndexStart;
                double realTotal = 0.0;
                double imagTotal = 0.0;
                while (indexA < end) {
                    double realA = a.data[indexA++];
                    double imagA = a.data[indexA++];
                    double realB = b.data[indexB++];
                    double imagB = b.data[indexB++];
                    realTotal += realA * realB + imagA * imagB;
                    imagTotal += imagA * realB - realA * imagB;
                }
                int n = indexC++;
                c.data[n] = c.data[n] + (realAlpha * realTotal - imagAlpha * imagTotal);
                int n2 = indexC++;
                c.data[n2] = c.data[n2] + (realAlpha * imagTotal + imagAlpha * realTotal);
            }
        });
    }

    public static void multAddTransAB(double realAlpha, double imagAlpha, ZMatrixRMaj a, ZMatrixRMaj b, ZMatrixRMaj c) {
        if (a == c || b == c) {
            throw new IllegalArgumentException("Neither 'a' or 'b' can be the same matrix as 'c'");
        }
        if (a.numRows != b.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        if (a.numCols != c.numRows || b.numRows != c.numCols) {
            throw new MatrixDimensionException("The results matrix does not have the desired dimensions");
        }
        EjmlConcurrency.loopFor((int)0, (int)a.numCols, i -> {
            int indexC = i * b.numRows * 2;
            int indexB = 0;
            for (int j = 0; j < b.numRows; ++j) {
                int indexA = i * 2;
                int end = indexB + b.numCols * 2;
                double realTotal = 0.0;
                double imagTotal = 0.0;
                while (indexB < end) {
                    double realA = a.data[indexA];
                    double imagA = -a.data[indexA + 1];
                    double realB = b.data[indexB++];
                    double imagB = -b.data[indexB++];
                    realTotal += realA * realB - imagA * imagB;
                    imagTotal += realA * imagB + imagA * realB;
                    indexA += a.numCols * 2;
                }
                int n = indexC++;
                c.data[n] = c.data[n] + (realAlpha * realTotal - imagAlpha * imagTotal);
                int n2 = indexC++;
                c.data[n2] = c.data[n2] + (realAlpha * imagTotal + imagAlpha * realTotal);
            }
        });
    }
}

