/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.simple;

import java.io.PrintStream;
import java.io.Serializable;
import org.ejml.data.Complex_F64;
import org.ejml.data.Matrix;
import org.ejml.simple.ConvertToImaginaryException;

public interface SimpleOperations<T extends Matrix>
extends Serializable {
    public void set(T var1, int var2, int var3, double var4);

    public void set(T var1, int var2, int var3, double var4, double var6);

    public double get(T var1, int var2, int var3);

    public void get(T var1, int var2, int var3, Complex_F64 var4);

    public double getReal(T var1, int var2, int var3);

    public double getImaginary(T var1, int var2, int var3);

    public void fill(T var1, double var2);

    public void transpose(T var1, T var2);

    public void mult(T var1, T var2, T var3);

    public void multTransA(T var1, T var2, T var3);

    public void kron(T var1, T var2, T var3);

    public void plus(T var1, T var2, T var3);

    public void minus(T var1, T var2, T var3);

    public void minus(T var1, double var2, T var4);

    default public void minusComplex(T A, double real, double imag, T output) {
        if (imag == 0.0) {
            this.minus(A, real, output);
            return;
        }
        throw new ConvertToImaginaryException();
    }

    public void plus(T var1, double var2, T var4);

    default public void plusComplex(T A, double real, double imag, T output) {
        if (imag == 0.0) {
            this.plus(A, real, output);
            return;
        }
        throw new ConvertToImaginaryException();
    }

    public void plus(T var1, double var2, T var4, T var5);

    public void plus(double var1, T var3, double var4, T var6, T var7);

    public double dot(T var1, T var2);

    public void scale(T var1, double var2, T var4);

    default public void scaleComplex(T A, double real, double imag, T output) {
        if (imag == 0.0) {
            this.scale(A, real, output);
            return;
        }
        throw new ConvertToImaginaryException();
    }

    public void divide(T var1, double var2, T var4);

    public boolean invert(T var1, T var2);

    public void setIdentity(T var1);

    public void pseudoInverse(T var1, T var2);

    public boolean solve(T var1, T var2, T var3);

    public void zero(T var1);

    public double normF(T var1);

    public double conditionP2(T var1);

    public double determinant(T var1);

    default public Complex_F64 determinantComplex(T A) {
        Complex_F64 output = new Complex_F64();
        output.imaginary = 0.0;
        output.real = this.determinant(A);
        return output;
    }

    public double trace(T var1);

    default public Complex_F64 traceComplex(T A) {
        Complex_F64 output = new Complex_F64();
        output.imaginary = 0.0;
        output.real = this.trace(A);
        return output;
    }

    public void setRow(T var1, int var2, int var3, double ... var4);

    public void setColumn(T var1, int var2, int var3, double ... var4);

    public double[] getRow(T var1, int var2, int var3, int var4);

    public double[] getColumn(T var1, int var2, int var3, int var4);

    public void extract(T var1, int var2, int var3, int var4, int var5, T var6, int var7, int var8);

    public T diag(T var1);

    public boolean hasUncountable(T var1);

    public void changeSign(T var1);

    public double elementMax(T var1);

    public double elementMin(T var1);

    public double elementMaxAbs(T var1);

    public double elementMinAbs(T var1);

    public double elementSum(T var1);

    default public void elementSumComplex(T A, Complex_F64 output) {
        output.imaginary = 0.0;
        output.real = this.elementSum(A);
    }

    public void elementMult(T var1, T var2, T var3);

    public void elementDiv(T var1, T var2, T var3);

    public void elementPower(T var1, T var2, T var3);

    public void elementPower(T var1, double var2, T var4);

    public void elementExp(T var1, T var2);

    public void elementLog(T var1, T var2);

    public boolean isIdentical(T var1, T var2, double var3);

    public void print(PrintStream var1, Matrix var2, String var3);

    public void elementOp(T var1, ElementOpReal var2, T var3);

    public void elementOp(T var1, ElementOpComplex var2, T var3);

    @FunctionalInterface
    public static interface ElementOpComplex {
        public void op(int var1, int var2, Complex_F64 var3);
    }

    @FunctionalInterface
    public static interface ElementOpReal {
        public double op(int var1, int var2, double var3);
    }
}

