/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchivedFileSet;
import org.codehaus.plexus.archiver.util.DefaultArchivedFileSet;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.shared.BuildPropertiesImpl;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.eclipse.tycho.model.Feature;

@Component(role=LicenseFeatureHelper.class)
public class LicenseFeatureHelper {
    public File getLicenseFeature(Feature feature, MavenProject mavenProject) {
        String id = feature.getLicenseFeature();
        if (id == null) {
            return null;
        }
        ArtifactDescriptor licenseFeature = TychoProjectUtils.getDependencyArtifacts((MavenProject)mavenProject).getArtifact("eclipse-feature", id, feature.getLicenseFeatureVersion());
        if (licenseFeature == null) {
            throw new IllegalStateException("License feature with id " + id + " is not found among project dependencies");
        }
        ReactorProject licenseProject = licenseFeature.getMavenProject();
        if (licenseProject == null) {
            return licenseFeature.getLocation();
        }
        File artifact = licenseProject.getArtifact();
        if (!artifact.isFile()) {
            throw new IllegalStateException("At least ''package'' phase need to be executed");
        }
        return artifact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchivedFileSet getLicenseFeatureFileSet(File licenseFeature) throws IOException {
        BuildPropertiesImpl buildProperties;
        block4: {
            ZipFile zip = new ZipFile(licenseFeature);
            try {
                ZipEntry entry = zip.getEntry("build.properties");
                if (entry != null) {
                    InputStream is = zip.getInputStream(entry);
                    Properties p = new Properties();
                    p.load(is);
                    buildProperties = new BuildPropertiesImpl(p);
                    break block4;
                }
                throw new IllegalArgumentException("license feature must include build.properties file");
            }
            finally {
                zip.close();
            }
        }
        List includes = buildProperties.getBinIncludes();
        HashSet<String> excludes = new HashSet<String>(buildProperties.getBinExcludes());
        excludes.add("feature.xml");
        excludes.add("feature.properties");
        excludes.add("build.properties");
        DefaultArchivedFileSet result = new DefaultArchivedFileSet();
        result.setArchive(licenseFeature);
        result.setIncludes(includes.toArray(new String[includes.size()]));
        result.setExcludes(excludes.toArray(new String[excludes.size()]));
        return result;
    }
}

