/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.common.resources.strumpf;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.nd4j.common.io.ClassPathResource;
import org.nd4j.common.resources.Resolver;
import org.nd4j.common.resources.strumpf.ResourceFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrumpfResolver
implements Resolver {
    private static final Logger log = LoggerFactory.getLogger(StrumpfResolver.class);
    public static final String DEFAULT_CACHE_DIR = new File(System.getProperty("user.home"), ".cache/nd4j/test_resources").getAbsolutePath();
    public static final String REF = ".resource_reference";
    protected final List<String> localResourceDirs;
    protected final File cacheDir;

    public StrumpfResolver() {
        String localDirs = System.getProperty("org.nd4j.strumpf.resource.dirs", null);
        if (localDirs != null && !localDirs.isEmpty()) {
            String[] split = localDirs.split(",");
            this.localResourceDirs = Arrays.asList(split);
        } else {
            this.localResourceDirs = null;
        }
        String cd = System.getenv("ND4J_RESOURCES_CACHE_DIR");
        if (cd == null || cd.isEmpty()) {
            cd = System.getProperty("org.nd4j.test.resources.cache.dir", DEFAULT_CACHE_DIR);
        }
        this.cacheDir = new File(cd);
        this.cacheDir.mkdirs();
    }

    @Override
    public int priority() {
        return 100;
    }

    @Override
    public boolean exists(@NonNull String resourcePath) {
        ClassPathResource cpr;
        if (resourcePath == null) {
            throw new NullPointerException("resourcePath is marked non-null but is null");
        }
        if (this.localResourceDirs != null && !this.localResourceDirs.isEmpty()) {
            for (String s : this.localResourceDirs) {
                File f1 = new File(s, resourcePath);
                if (f1.exists() && f1.isFile()) {
                    return true;
                }
                File f2 = new File(s, resourcePath + REF);
                if (!f2.exists() || !f2.isFile()) continue;
                return false;
            }
        }
        if ((cpr = new ClassPathResource(resourcePath + REF)).exists()) {
            return true;
        }
        cpr = new ClassPathResource(resourcePath);
        return cpr.exists();
    }

    @Override
    public boolean directoryExists(String dirPath) {
        ClassPathResource cpr;
        if (this.localResourceDirs != null && !this.localResourceDirs.isEmpty()) {
            for (String s : this.localResourceDirs) {
                File f1 = new File(s, dirPath);
                if (!f1.exists() || !f1.isDirectory()) continue;
                return true;
            }
        }
        return (cpr = new ClassPathResource(dirPath)).exists();
    }

    @Override
    public File asFile(String resourcePath) {
        ClassPathResource cpr;
        this.assertExists(resourcePath);
        if (this.localResourceDirs != null && !this.localResourceDirs.isEmpty()) {
            for (String s : this.localResourceDirs) {
                File f1 = new File(s, resourcePath);
                if (f1.exists() && f1.isFile()) {
                    return f1;
                }
                File f2 = new File(s, resourcePath + REF);
                if (!f2.exists() || !f2.isFile()) continue;
                ResourceFile rf = ResourceFile.fromFile(s);
                return rf.localFile(this.cacheDir);
            }
        }
        if ((cpr = new ClassPathResource(resourcePath + REF)).exists()) {
            ResourceFile rf;
            try {
                rf = ResourceFile.fromFile(cpr.getFile());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return rf.localFile(this.cacheDir);
        }
        cpr = new ClassPathResource(resourcePath);
        if (cpr.exists()) {
            try {
                return cpr.getFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Could not find resource file that should exist: " + resourcePath);
    }

    @Override
    public InputStream asStream(String resourcePath) {
        File f = this.asFile(resourcePath);
        log.debug("Resolved resource " + resourcePath + " as file at absolute path " + f.getAbsolutePath());
        try {
            return new BufferedInputStream(new FileInputStream(f));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Error reading file for resource: \"" + resourcePath + "\" resolved to \"" + f + "\"");
        }
    }

    @Override
    public void copyDirectory(String dirPath, File destinationDir) {
        ClassPathResource cpr;
        Iterator<String> iterator;
        boolean resolved = false;
        if (this.localResourceDirs != null && !this.localResourceDirs.isEmpty() && (iterator = this.localResourceDirs.iterator()).hasNext()) {
            String s = iterator.next();
            File f1 = new File(s, dirPath);
            try {
                FileUtils.copyDirectory((File)f1, (File)destinationDir);
                resolved = true;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!resolved && (cpr = new ClassPathResource(dirPath)).exists()) {
            try {
                cpr.copyDirectory(destinationDir);
                resolved = true;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!resolved) {
            throw new RuntimeException("Unable to find resource directory for path: " + dirPath);
        }
        final ArrayList toResolve = new ArrayList();
        try {
            Files.walkFileTree(destinationDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.toString().endsWith(StrumpfResolver.REF)) {
                        toResolve.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (toResolve.size() > 0) {
            for (Path p : toResolve) {
                File localFile = ResourceFile.fromFile(p.toFile()).localFile(this.cacheDir);
                String newPath = p.toFile().getAbsolutePath();
                newPath = newPath.substring(0, newPath.length() - REF.length());
                File destination = new File(newPath);
                try {
                    FileUtils.copyFile((File)localFile, (File)destination);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                try {
                    FileUtils.forceDelete((File)p.toFile());
                }
                catch (IOException e) {
                    throw new RuntimeException("Error deleting temporary reference file", e);
                }
            }
        }
    }

    @Override
    public boolean hasLocalCache() {
        return true;
    }

    @Override
    public File localCacheRoot() {
        return this.cacheDir;
    }

    @Override
    public String normalizePath(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (path.endsWith(REF)) {
            return path.substring(0, path.length() - REF.length());
        }
        return path;
    }

    protected void assertExists(String resourcePath) {
        if (!this.exists(resourcePath)) {
            throw new IllegalStateException("Could not find resource with path \"" + resourcePath + "\" in local directories (" + this.localResourceDirs + ") or in classpath");
        }
    }
}

