/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.common.resources.strumpf;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.nd4j.common.base.Preconditions;
import org.nd4j.shade.guava.io.Files;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.databind.DeserializationFeature;
import org.nd4j.shade.jackson.databind.MapperFeature;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.nd4j.shade.jackson.databind.SerializationFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(value={"filePath"})
public class ResourceFile {
    private static final Logger log = LoggerFactory.getLogger(ResourceFile.class);
    public static final int DEFAULT_CONNECTION_TIMEOUT = 60000;
    public static final int DEFAULT_READ_TIMEOUT = 60000;
    protected static final String PATH_KEY = "full_remote_path";
    protected static final String HASH = "_hash";
    protected static final String COMPRESSED_HASH = "_compressed_hash";
    protected static final int MAX_DOWNLOAD_ATTEMPTS = 3;
    public static final ObjectMapper MAPPER = ResourceFile.newMapper();
    protected int current_version;
    protected Map<String, String> v1;
    protected String filePath;

    public static ResourceFile fromFile(String path) {
        return ResourceFile.fromFile(new File(path));
    }

    public static ResourceFile fromFile(File file) {
        try {
            String s = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            ResourceFile rf = (ResourceFile)MAPPER.readValue(s, ResourceFile.class);
            rf.setFilePath(file.getPath());
            return rf;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String relativePath() {
        String hashKey = null;
        for (String key : this.v1.keySet()) {
            if (!key.endsWith(HASH) || key.endsWith(COMPRESSED_HASH)) continue;
            hashKey = key;
            break;
        }
        if (hashKey == null) {
            throw new IllegalStateException("Could not find <filename>_hash in resource reference file: " + this.filePath);
        }
        String relativePath = hashKey.substring(0, hashKey.length() - 5);
        return relativePath.replaceAll("\\\\", "/");
    }

    public boolean localFileExistsAndValid(File cacheRootDir) {
        File file = this.getLocalFile(cacheRootDir);
        if (!file.exists()) {
            return false;
        }
        String sha256Property = this.relativePath() + HASH;
        String expSha256 = this.v1.get(sha256Property);
        Preconditions.checkState((expSha256 != null ? 1 : 0) != 0, (String)"Expected JSON property %s was not found in resource reference file %s", (Object)sha256Property, (Object)this.filePath);
        String actualSha256 = ResourceFile.sha256(file);
        return expSha256.equals(actualSha256);
    }

    protected File getLocalFile(File cacheRootDir) {
        String relativePath = this.relativePath();
        int lastSlash = Math.max(relativePath.lastIndexOf(47), relativePath.lastIndexOf(92));
        String filename = lastSlash < 0 ? relativePath : relativePath.substring(lastSlash + 1);
        File parentDir = new File(cacheRootDir, relativePath + "__v" + this.current_version);
        File file = new File(parentDir, filename);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File localFile(File cacheRootDir) {
        if (this.localFileExistsAndValid(cacheRootDir)) {
            return this.getLocalFile(cacheRootDir);
        }
        String remotePath = this.v1.get(PATH_KEY);
        Preconditions.checkState((remotePath != null ? 1 : 0) != 0, (String)"No remote path was found in resource reference file %s", (Object)this.filePath);
        File f = this.getLocalFile(cacheRootDir);
        File tempDir = Files.createTempDir();
        File tempFile = new File(tempDir, FilenameUtils.getName((String)remotePath));
        String sha256PropertyCompressed = this.relativePath() + COMPRESSED_HASH;
        String sha256Compressed = this.v1.get(sha256PropertyCompressed);
        Preconditions.checkState((sha256Compressed != null ? 1 : 0) != 0, (String)"Expected JSON property %s was not found in resource reference file %s", (Object)sha256PropertyCompressed, (Object)this.filePath);
        String sha256Property = this.relativePath() + HASH;
        String sha256Uncompressed = this.v1.get(sha256Property);
        String connTimeoutStr = System.getProperty("org.nd4j.resources.download.connectiontimeout");
        String readTimeoutStr = System.getProperty("org.nd4j.resources.download.readtimeout");
        boolean validCTimeout = connTimeoutStr != null && connTimeoutStr.matches("\\d+");
        boolean validRTimeout = readTimeoutStr != null && readTimeoutStr.matches("\\d+");
        int connectTimeout = validCTimeout ? Integer.parseInt(connTimeoutStr) : 60000;
        int readTimeout = validRTimeout ? Integer.parseInt(readTimeoutStr) : 60000;
        try {
            boolean correctHash = false;
            for (int tryCount = 0; tryCount < 3; ++tryCount) {
                try {
                    if (tempFile.exists()) {
                        tempFile.delete();
                    }
                    log.info("Downloading remote resource {} to {}", (Object)remotePath, (Object)tempFile);
                    FileUtils.copyURLToFile((URL)new URL(remotePath), (File)tempFile, (int)connectTimeout, (int)readTimeout);
                    String hash = ResourceFile.sha256(tempFile);
                    correctHash = sha256Compressed.equals(hash);
                    if (!correctHash) {
                        log.warn("Download of file {} failed: expected hash {} vs. actual hash {}", new Object[]{remotePath, sha256Compressed, hash});
                        continue;
                    }
                    log.info("Downloaded {} to temporary file {}", (Object)remotePath, (Object)tempFile);
                    break;
                }
                catch (Throwable t) {
                    if (tryCount == 2) {
                        throw new RuntimeException("Error downloading test resource: " + remotePath, t);
                    }
                    log.warn("Error downloading test resource, retrying... {}", (Object)remotePath, (Object)t);
                }
            }
            if (!correctHash) {
                throw new RuntimeException("Could not successfully download with correct hash file after 3 attempts: " + remotePath);
            }
            f.getParentFile().mkdirs();
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
                 BufferedInputStream is = new BufferedInputStream((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(tempFile)));){
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            catch (IOException e) {
                throw new RuntimeException("Error extracting resource file", e);
            }
            log.info("Extracted {} to {}", (Object)tempFile, (Object)f);
            String extractedHash = ResourceFile.sha256(f);
            if (!extractedHash.equals(sha256Uncompressed)) {
                throw new RuntimeException("Extracted file hash does not match expected hash: " + remotePath + " -> " + f.getAbsolutePath() + " - expected has " + sha256Uncompressed + ", actual hash " + extractedHash);
            }
        }
        finally {
            tempFile.delete();
        }
        return f;
    }

    public static String sha256(File f) {
        String string;
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
        try {
            string = DigestUtils.sha256Hex((InputStream)is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Error when hashing file: " + f.getPath(), e);
            }
        }
        ((InputStream)is).close();
        return string;
    }

    public static final ObjectMapper newMapper() {
        ObjectMapper ret = new ObjectMapper();
        ret.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ret.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        ret.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        ret.enable(SerializationFeature.INDENT_OUTPUT);
        return ret;
    }

    public ResourceFile(int current_version, Map<String, String> v1, String filePath) {
        this.current_version = current_version;
        this.v1 = v1;
        this.filePath = filePath;
    }

    public ResourceFile() {
    }

    public int getCurrent_version() {
        return this.current_version;
    }

    public Map<String, String> getV1() {
        return this.v1;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setCurrent_version(int current_version) {
        this.current_version = current_version;
    }

    public void setV1(Map<String, String> v1) {
        this.v1 = v1;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceFile)) {
            return false;
        }
        ResourceFile other = (ResourceFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCurrent_version() != other.getCurrent_version()) {
            return false;
        }
        Map<String, String> this$v1 = this.getV1();
        Map<String, String> other$v1 = other.getV1();
        if (this$v1 == null ? other$v1 != null : !((Object)this$v1).equals(other$v1)) {
            return false;
        }
        String this$filePath = this.getFilePath();
        String other$filePath = other.getFilePath();
        return !(this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResourceFile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCurrent_version();
        Map<String, String> $v1 = this.getV1();
        result = result * 59 + ($v1 == null ? 43 : ((Object)$v1).hashCode());
        String $filePath = this.getFilePath();
        result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
        return result;
    }

    public String toString() {
        return "ResourceFile(current_version=" + this.getCurrent_version() + ", v1=" + this.getV1() + ", filePath=" + this.getFilePath() + ")";
    }
}

