/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.deeplearning4j.resources;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.io.FileUtils;
import org.eclipse.deeplearning4j.resources.ResourceType;
import org.nd4j.common.resources.Downloader;

public interface DownloadableResource {
    public String fileName();

    public String archiveFileName();

    public String rootUrl();

    public File localCacheDirectory();

    default public File localPath() {
        return new File(this.localCacheDirectory(), this.fileName());
    }

    default public String md5Sum() {
        return "";
    }

    default public void download(boolean archive, int retries, int connectionTimeout, int readTimeout) {
        if (archive) {
            this.localCacheDirectory().mkdirs();
            Downloader.downloadAndExtract(this.archiveFileName(), URI.create(this.rootUrl() + "/" + this.archiveFileName()).toURL(), new File(this.localCacheDirectory(), this.archiveFileName()), this.localPath(), this.md5Sum(), retries, connectionTimeout, readTimeout);
        } else {
            Downloader.download(this.fileName(), URI.create(this.rootUrl() + "/" + this.fileName()).toURL(), this.localPath(), this.md5Sum(), retries, connectionTimeout, readTimeout);
        }
    }

    public ResourceType resourceType();

    default public boolean existsLocally() {
        return this.localPath().exists();
    }

    default public void delete() throws IOException {
        if (this.localPath().isDirectory()) {
            FileUtils.deleteDirectory((File)this.localPath());
        } else {
            FileUtils.forceDelete((File)this.localPath());
        }
    }
}

