/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.recordreader.objdetect.impl;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bytedeco.hdf5.DataSet;
import org.bytedeco.hdf5.DataSpace;
import org.bytedeco.hdf5.DataType;
import org.bytedeco.hdf5.Group;
import org.bytedeco.hdf5.H5File;
import org.bytedeco.hdf5.H5Location;
import org.bytedeco.hdf5.PredType;
import org.bytedeco.hdf5.global.hdf5;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.datavec.image.recordreader.objdetect.ImageObject;
import org.datavec.image.recordreader.objdetect.ImageObjectLabelProvider;

public class SvhnLabelProvider
implements ImageObjectLabelProvider {
    private static DataType refType = new DataType(PredType.STD_REF_OBJ());
    private static DataType charType = new DataType(PredType.NATIVE_CHAR());
    private static DataType intType = new DataType(PredType.NATIVE_INT());
    private Map<String, List<ImageObject>> labelMap = new HashMap<String, List<ImageObject>>();

    public SvhnLabelProvider(File dir) throws IOException {
        H5File file = new H5File(dir.getPath() + "/digitStruct.mat", hdf5.H5F_ACC_RDONLY());
        Group group = file.openGroup("digitStruct");
        DataSet nameDataset = group.openDataSet("name");
        DataSpace nameSpace = nameDataset.getSpace();
        DataSet bboxDataset = group.openDataSet("bbox");
        DataSpace bboxSpace = bboxDataset.getSpace();
        long[] dims = new long[2];
        bboxSpace.getSimpleExtentDims(dims);
        int n = (int)(dims[0] * dims[1]);
        int ptrSize = Loader.sizeof(Pointer.class);
        PointerPointer namePtr = new PointerPointer((long)n);
        PointerPointer bboxPtr = new PointerPointer((long)n);
        nameDataset.read((Pointer)namePtr, refType);
        bboxDataset.read((Pointer)bboxPtr, refType);
        BytePointer bytePtr = new BytePointer(256L);
        PointerPointer topPtr = new PointerPointer(256L);
        PointerPointer leftPtr = new PointerPointer(256L);
        PointerPointer heightPtr = new PointerPointer(256L);
        PointerPointer widthPtr = new PointerPointer(256L);
        PointerPointer labelPtr = new PointerPointer(256L);
        IntPointer intPtr = new IntPointer(256L);
        for (int i = 0; i < n; ++i) {
            boolean isFloat;
            DataSet nameRef = new DataSet((H5Location)file, (Pointer)namePtr.position((long)(i * ptrSize)));
            nameRef.read(bytePtr, charType);
            String filename = bytePtr.getString();
            Group bboxGroup = new Group((H5Location)file, (Pointer)bboxPtr.position((long)(i * ptrSize)));
            DataSet topDataset = bboxGroup.openDataSet("top");
            DataSet leftDataset = bboxGroup.openDataSet("left");
            DataSet heightDataset = bboxGroup.openDataSet("height");
            DataSet widthDataset = bboxGroup.openDataSet("width");
            DataSet labelDataset = bboxGroup.openDataSet("label");
            DataSpace topSpace = topDataset.getSpace();
            topSpace.getSimpleExtentDims(dims);
            int m = (int)(dims[0] * dims[1]);
            ArrayList<ImageObject> list = new ArrayList<ImageObject>(m);
            boolean bl = isFloat = topDataset.asAbstractDs().getTypeClass() == 1;
            if (!isFloat) {
                topDataset.read((Pointer)topPtr.position(0L), refType);
                leftDataset.read((Pointer)leftPtr.position(0L), refType);
                heightDataset.read((Pointer)heightPtr.position(0L), refType);
                widthDataset.read((Pointer)widthPtr.position(0L), refType);
                labelDataset.read((Pointer)labelPtr.position(0L), refType);
            }
            assert (!isFloat || m == 1);
            for (int j = 0; j < m; ++j) {
                DataSet topSet = isFloat ? topDataset : new DataSet((H5Location)file, (Pointer)topPtr.position((long)(j * ptrSize)));
                topSet.read((Pointer)intPtr, intType);
                int top = intPtr.get();
                DataSet leftSet = isFloat ? leftDataset : new DataSet((H5Location)file, (Pointer)leftPtr.position((long)(j * ptrSize)));
                leftSet.read((Pointer)intPtr, intType);
                int left = intPtr.get();
                DataSet heightSet = isFloat ? heightDataset : new DataSet((H5Location)file, (Pointer)heightPtr.position((long)(j * ptrSize)));
                heightSet.read((Pointer)intPtr, intType);
                int height = intPtr.get();
                DataSet widthSet = isFloat ? widthDataset : new DataSet((H5Location)file, (Pointer)widthPtr.position((long)(j * ptrSize)));
                widthSet.read((Pointer)intPtr, intType);
                int width = intPtr.get();
                DataSet labelSet = isFloat ? labelDataset : new DataSet((H5Location)file, (Pointer)labelPtr.position((long)(j * ptrSize)));
                labelSet.read((Pointer)intPtr, intType);
                int label = intPtr.get();
                if (label == 10) {
                    label = 0;
                }
                list.add(new ImageObject(left, top, left + width, top + height, Integer.toString(label)));
                topSet.deallocate();
                leftSet.deallocate();
                heightSet.deallocate();
                widthSet.deallocate();
                labelSet.deallocate();
            }
            topSpace.deallocate();
            if (!isFloat) {
                topDataset.deallocate();
                leftDataset.deallocate();
                heightDataset.deallocate();
                widthDataset.deallocate();
                labelDataset.deallocate();
            }
            nameRef.deallocate();
            bboxGroup.deallocate();
            this.labelMap.put(filename, list);
        }
        nameSpace.deallocate();
        bboxSpace.deallocate();
        nameDataset.deallocate();
        bboxDataset.deallocate();
        group.deallocate();
        file.deallocate();
    }

    @Override
    public List<ImageObject> getImageObjectsForPath(String path) {
        File file = new File(path);
        String filename = file.getName();
        return this.labelMap.get(filename);
    }

    @Override
    public List<ImageObject> getImageObjectsForPath(URI uri) {
        return this.getImageObjectsForPath(uri.toString());
    }
}

