/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.query.expression;

import com.mongodb.BasicDBObject;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.mongodb.query.expression.MongoExpression;
import org.datanucleus.store.mongodb.query.expression.MongoOperator;

public class MongoBooleanExpression
extends MongoExpression {
    BasicDBObject dbObject = null;

    public MongoBooleanExpression(String fieldName, Object value, MongoOperator op) {
        if (op == MongoOperator.OP_EQ) {
            this.dbObject = new BasicDBObject(fieldName, value);
        } else if (op == MongoOperator.OP_NOTEQ || op == MongoOperator.OP_LT || op == MongoOperator.OP_LTEQ || op == MongoOperator.OP_GT || op == MongoOperator.OP_GTEQ) {
            BasicDBObject valObject = new BasicDBObject(op.getValue(), value);
            this.dbObject = new BasicDBObject(fieldName, (Object)valObject);
        } else {
            throw new NucleusException("Cannot create MongoBooleanExpression with operator of " + (Object)((Object)op) + " with this constructor");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MongoBooleanExpression(MongoBooleanExpression expr1, MongoBooleanExpression expr2, MongoOperator op) {
        if (op == MongoOperator.OP_AND) {
            String key2;
            this.dbObject = new BasicDBObject();
            if (expr1.getDBObject().size() != 1 || expr2.getDBObject().size() != 1) throw new NucleusException("BSON doesn't currently have an $and operator!!!");
            String key1 = (String)expr1.getDBObject().keySet().iterator().next();
            if (key1.equals(key2 = (String)expr2.getDBObject().keySet().iterator().next())) {
                BasicDBObject val1 = (BasicDBObject)expr1.getDBObject().get(key1);
                BasicDBObject val2 = (BasicDBObject)expr2.getDBObject().get(key2);
                BasicDBObject multipleObject = new BasicDBObject();
                String op1 = (String)val1.keySet().iterator().next();
                String op2 = (String)val2.keySet().iterator().next();
                multipleObject.put(op1, val1.get(op1));
                multipleObject.put(op2, val2.get(op2));
                this.dbObject.put(key1, (Object)multipleObject);
                return;
            } else {
                this.dbObject.append(key1, expr1.getDBObject().get(key1));
                this.dbObject.append(key2, expr2.getDBObject().get(key2));
            }
            return;
        } else {
            if (op != MongoOperator.OP_OR) throw new NucleusException("Cannot create MongoBooleanExpression with operator of " + (Object)((Object)op) + " with this constructor");
            BasicDBObject[] orOptions = new BasicDBObject[]{expr1.getDBObject(), expr2.getDBObject()};
            this.dbObject = new BasicDBObject(op.getValue(), (Object)orOptions);
        }
    }

    public BasicDBObject getDBObject() {
        return this.dbObject;
    }
}

