/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.api;

import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.sonar.runner.api.Dirs;
import org.sonar.runner.api.RunnerVersion;
import org.sonar.runner.api.SourceEncoding;

public abstract class Runner<T extends Runner> {
    private final Properties properties = new Properties();

    protected Runner() {
    }

    public Properties properties() {
        Properties clone = new Properties();
        clone.putAll((Map<?, ?>)this.properties);
        return clone;
    }

    public T addProperties(Properties p) {
        this.properties.putAll((Map<?, ?>)p);
        return (T)this;
    }

    public T setProperty(String key, String value) {
        this.properties.setProperty(key, value);
        return (T)this;
    }

    public String property(String key, @Nullable String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public T setApp(String app, String version) {
        this.setProperty("sonarRunner.app", app);
        this.setProperty("sonarRunner.appVersion", version);
        return (T)this;
    }

    public String app() {
        return this.property("sonarRunner.app", null);
    }

    public String appVersion() {
        return this.property("sonarRunner.appVersion", null);
    }

    public void execute() {
        this.initDefaultValues();
        new SourceEncoding().init(this);
        new Dirs().init(this);
        this.doExecute();
    }

    protected abstract void doExecute();

    private void initDefaultValues() {
        this.setDefaultValue("sonar.host.url", "http://localhost:9000");
        this.setDefaultValue("sonarRunner.app", "SonarRunner");
        this.setDefaultValue("sonarRunner.appVersion", RunnerVersion.version());
    }

    private void setDefaultValue(String key, String value) {
        if (!this.properties.containsKey(key)) {
            this.setProperty(key, value);
        }
    }
}

