/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.report.pdf;

import com.lowagie.text.ChapterAutoNumber;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Section;
import com.lowagie.text.pdf.PdfPTable;
import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.sonar.report.pdf.ExecutivePDFReporter;
import org.sonar.report.pdf.Style;
import org.sonar.report.pdf.entity.Project;
import org.sonar.report.pdf.entity.Rule;
import org.sonar.report.pdf.entity.Violation;
import org.sonar.report.pdf.entity.exception.ReportException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamWorkbookPDFReporter
extends ExecutivePDFReporter {
    public TeamWorkbookPDFReporter(URL logo, String projectKey, String sonarUrl, Properties configProperties, Properties langProperties) {
        super(logo, projectKey, sonarUrl, configProperties, langProperties);
        reportType = "workbook";
    }

    @Override
    public void printPdfBody(Document document) throws DocumentException, IOException, org.dom4j.DocumentException, ReportException {
        Project project = super.getProject();
        ChapterAutoNumber chapter1 = new ChapterAutoNumber(new Paragraph(project.getName(), Style.CHAPTER_FONT));
        chapter1.add((Object)new Paragraph(this.getTextProperty("main.text.misc.overview"), Style.NORMAL_FONT));
        Section section11 = chapter1.addSection(new Paragraph(this.getTextProperty("general.report_overview"), Style.TITLE_FONT));
        this.printDashboard(project, section11);
        Section section12 = chapter1.addSection(new Paragraph(this.getTextProperty("general.violations_analysis"), Style.TITLE_FONT));
        this.printMostViolatedRules(project, section12);
        this.printMostViolatedFiles(project, section12);
        this.printMostComplexFiles(project, section12);
        this.printMostDuplicatedFiles(project, section12);
        Section section13 = chapter1.addSection(new Paragraph(this.getTextProperty("general.violations_details"), Style.TITLE_FONT));
        this.printMostViolatedRulesDetails(project, section13);
        document.add((Element)chapter1);
        for (Project subproject : project.getSubprojects()) {
            ChapterAutoNumber chapterN = new ChapterAutoNumber(new Paragraph(subproject.getName(), Style.CHAPTER_FONT));
            Section sectionN1 = chapterN.addSection(new Paragraph(this.getTextProperty("general.report_overview"), Style.TITLE_FONT));
            this.printDashboard(subproject, sectionN1);
            Section sectionN2 = chapterN.addSection(new Paragraph(this.getTextProperty("general.violations_analysis"), Style.TITLE_FONT));
            this.printMostViolatedRules(subproject, sectionN2);
            this.printMostViolatedFiles(subproject, sectionN2);
            this.printMostComplexFiles(subproject, sectionN2);
            this.printMostDuplicatedFiles(subproject, sectionN2);
            Section sectionN3 = chapterN.addSection(new Paragraph(this.getTextProperty("general.violations_details"), Style.TITLE_FONT));
            this.printMostViolatedRulesDetails(subproject, sectionN3);
            document.add((Element)chapterN);
        }
    }

    private void printMostViolatedRulesDetails(Project project, Section section13) {
        for (Rule rule : project.getMostViolatedRules()) {
            LinkedList<String> files = new LinkedList<String>();
            LinkedList<String> lines = new LinkedList<String>();
            for (Violation violation : rule.getTopViolations()) {
                String[] components = violation.getResource().split("\\.");
                files.add(components[components.length - 1]);
                lines.add(violation.getLine());
            }
            section13.add((Object)this.createViolationsDetailedTable(rule.getName(), files, lines));
        }
    }

    private PdfPTable createViolationsDetailedTable(String ruleName, List<String> files, List<String> lines) {
        int i;
        PdfPTable table = new PdfPTable(10);
        table.getDefaultCell().setColspan(1);
        table.getDefaultCell().setBackgroundColor(new Color(255, 228, 181));
        table.addCell(new Phrase("Rule", Style.NORMAL_FONT));
        table.getDefaultCell().setColspan(9);
        table.getDefaultCell().setBackgroundColor(Color.WHITE);
        table.addCell(new Phrase(ruleName, Style.NORMAL_FONT));
        table.getDefaultCell().setColspan(10);
        table.getDefaultCell().setBackgroundColor(Color.GRAY);
        table.addCell("");
        table.getDefaultCell().setColspan(7);
        table.getDefaultCell().setBackgroundColor(new Color(255, 228, 181));
        table.addCell(new Phrase("File", Style.NORMAL_FONT));
        table.getDefaultCell().setColspan(3);
        table.addCell(new Phrase("Line", Style.NORMAL_FONT));
        table.getDefaultCell().setBackgroundColor(Color.WHITE);
        String lineNumbers = "";
        if (files.size() > 0) {
            for (i = 0; i < files.size() - 1; ++i) {
                lineNumbers = lineNumbers.equals("") ? lineNumbers + lines.get(i) : lineNumbers + ", " + lines.get(i);
                if (files.get(i).equals(files.get(i + 1))) continue;
                table.getDefaultCell().setColspan(7);
                table.addCell(files.get(i));
                table.getDefaultCell().setColspan(3);
                table.addCell(lineNumbers);
                lineNumbers = "";
            }
        }
        if (files.size() != 0) {
            table.getDefaultCell().setColspan(7);
            table.addCell(files.get(files.size() - 1));
            table.getDefaultCell().setColspan(3);
            lineNumbers = lineNumbers.equals("") ? lineNumbers + lines.get(i) : lineNumbers + ", " + lines.get(lines.size() - 1);
            table.addCell(lineNumbers);
        }
        table.setSpacingBefore(20.0f);
        table.setSpacingAfter(20.0f);
        table.setLockedWidth(false);
        table.setWidthPercentage(90.0f);
        return table;
    }
}

