/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.languages.java.jpms;

import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleDescriptor;
import java.util.LinkedHashSet;
import org.codehaus.plexus.languages.java.jpms.AbstractBinaryModuleInfoParser;
import org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class BinaryModuleInfoParser
extends AbstractBinaryModuleInfoParser {
    BinaryModuleInfoParser() {
    }

    @Override
    JavaModuleDescriptor parse(InputStream in) throws IOException {
        ModuleDescriptor descriptor = ModuleDescriptor.read(in);
        JavaModuleDescriptor.Builder builder = JavaModuleDescriptor.newModule(descriptor.name());
        for (ModuleDescriptor.Requires requires : descriptor.requires()) {
            if (requires.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.STATIC) || requires.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.TRANSITIVE)) {
                LinkedHashSet<JavaModuleDescriptor.JavaRequires.JavaModifier> modifiers = new LinkedHashSet<JavaModuleDescriptor.JavaRequires.JavaModifier>();
                if (requires.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.STATIC)) {
                    modifiers.add(JavaModuleDescriptor.JavaRequires.JavaModifier.STATIC);
                }
                if (requires.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.TRANSITIVE)) {
                    modifiers.add(JavaModuleDescriptor.JavaRequires.JavaModifier.TRANSITIVE);
                }
                builder.requires(modifiers, requires.name());
                continue;
            }
            builder.requires(requires.name());
        }
        for (ModuleDescriptor.Exports exports : descriptor.exports()) {
            if (exports.targets().isEmpty()) {
                builder.exports(exports.source());
                continue;
            }
            builder.exports(exports.source(), exports.targets());
        }
        for (String uses : descriptor.uses()) {
            builder.uses(uses);
        }
        for (ModuleDescriptor.Provides provides : descriptor.provides()) {
            builder.provides(provides.service(), provides.providers());
        }
        return builder.build();
    }
}

