/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.dependency.task;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.webstart.dependency.JnlpDependencyConfig;
import org.codehaus.mojo.webstart.dependency.task.AbstractJnlpTask;
import org.codehaus.mojo.webstart.dependency.task.JnlpDependencyTask;
import org.codehaus.mojo.webstart.dependency.task.JnlpDependencyTaskException;
import org.codehaus.mojo.webstart.util.IOUtil;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=JnlpDependencyTask.class, hint="UpdateManifestTask", instantiationStrategy="per-lookup")
public class UpdateManifestTask
extends AbstractJnlpTask {
    public static final String ROLE_HINT = "UpdateManifestTask";
    @Requirement
    private IOUtil ioUtil;

    @Override
    public void check(JnlpDependencyConfig config) {
        if (config == null) {
            throw new NullPointerException("config can't be null");
        }
        if (config.getArtifact() == null) {
            throw new NullPointerException("config.artifact can't be null");
        }
        if (config.getArtifact().getFile() == null) {
            throw new NullPointerException("config.artifact.file can't be null");
        }
        if (!config.isUpdateManifest()) {
            throw new IllegalStateException("Can't update manifest if config.isUpdateManifest is false");
        }
    }

    @Override
    public File execute(JnlpDependencyConfig config, File file) throws JnlpDependencyTaskException {
        this.verboseLog(config, "Update manifest " + file.getName());
        try {
            File updatedFile = this.updateManifestEntries(file, config.getUpdateManifestEntries());
            return updatedFile;
        }
        catch (MojoExecutionException e) {
            throw new JnlpDependencyTaskException("Could not update manifest of file: " + file, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File updateManifestEntries(File jar, Map<String, String> manifestentries) throws MojoExecutionException {
        Manifest manifest = this.createManifest(jar, manifestentries);
        File updatedUnprocessedJarFile = new File(jar.getParent(), jar.getName() + "_updateManifestEntriesJar");
        ZipFile originalJar = null;
        JarOutputStream targetJar = null;
        try {
            originalJar = new ZipFile(jar);
            targetJar = new JarOutputStream((OutputStream)new FileOutputStream(updatedUnprocessedJarFile), manifest);
            Enumeration<? extends ZipEntry> entries = originalJar.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if ("META-INF/MANIFEST.MF".equals(entry.getName())) continue;
                ZipEntry newEntry = new ZipEntry(entry.getName());
                targetJar.putNextEntry(newEntry);
                if (!entry.isDirectory()) {
                    InputStream inputStream = null;
                    try {
                        inputStream = originalJar.getInputStream(entry);
                        org.codehaus.plexus.util.IOUtil.copy((InputStream)inputStream, (OutputStream)targetJar);
                        inputStream.close();
                    }
                    finally {
                        org.apache.maven.shared.utils.io.IOUtil.close((InputStream)inputStream);
                    }
                }
                targetJar.closeEntry();
            }
            targetJar.close();
            originalJar.close();
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error while updating manifest of " + jar.getName(), (Exception)e);
            }
            catch (Throwable throwable) {
                org.apache.maven.shared.utils.io.IOUtil.close(targetJar);
                this.ioUtil.close(originalJar);
                throw throwable;
            }
        }
        org.apache.maven.shared.utils.io.IOUtil.close((OutputStream)targetJar);
        this.ioUtil.close(originalJar);
        return updatedUnprocessedJarFile;
    }

    private Manifest createManifest(File jar, Map<String, String> manifestentries) throws MojoExecutionException {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jar);
            Manifest manifest = jarFile.getManifest();
            if (manifest == null || manifest.getMainAttributes().isEmpty()) {
                manifest = new Manifest();
                manifest.getMainAttributes().putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
            }
            Set<Map.Entry<String, String>> entrySet = manifestentries.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                manifest.getMainAttributes().putValue(entry.getKey(), entry.getValue());
            }
            Manifest manifest2 = manifest;
            return manifest2;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while reading manifest from " + jar.getAbsolutePath(), (Exception)e);
        }
        finally {
            this.ioUtil.close(jarFile);
        }
    }
}

