/*
 * Decompiled with CFR 0.152.
 */
package jnlp.sample.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import jnlp.sample.util.VersionID;

public class VersionString {
    private List<VersionID> _versionIds = new ArrayList<VersionID>();

    public VersionString(String vs) {
        if (vs != null) {
            StringTokenizer st = new StringTokenizer(vs, " ", false);
            while (st.hasMoreElements()) {
                this._versionIds.add(new VersionID(st.nextToken()));
            }
        }
    }

    public boolean contains(VersionID m) {
        for (VersionID _versionId : this._versionIds) {
            VersionID vi = _versionId;
            boolean check = vi.match(m);
            if (!check) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String versionid) {
        return this.contains(new VersionID(versionid));
    }

    public boolean containsGreaterThan(VersionID m) {
        for (VersionID _versionId : this._versionIds) {
            VersionID vi = _versionId;
            boolean check = vi.isGreaterThan(m);
            if (!check) continue;
            return true;
        }
        return false;
    }

    public boolean containsGreaterThan(String versionid) {
        return this.containsGreaterThan(new VersionID(versionid));
    }

    public static boolean contains(String vs, String vi) {
        return new VersionString(vs).contains(vi);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (VersionID _versionId : this._versionIds) {
            sb.append(((Object)_versionId).toString());
            sb.append(' ');
        }
        return sb.toString();
    }
}

