/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.artifact.versioning.VersionRange;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.api.VersionDetails;
import org.codehaus.mojo.versions.ordering.BoundArtifactVersion;
import org.codehaus.mojo.versions.ordering.InvalidSegmentException;
import org.codehaus.mojo.versions.ordering.VersionComparator;
import org.codehaus.mojo.versions.utils.DefaultArtifactVersionCache;

public abstract class AbstractVersionDetails
implements VersionDetails {
    private static final Pattern PREVIEW_PATTERN = Pattern.compile("(?i)(?:.*[-.](alpha|a|beta|b|milestone|m|preview|rc)[-.]?(\\d{0,2}[a-z]?|\\d{6}\\.\\d{4})|\\d{8}(?:\\.?\\d{6})?)$");
    private ArtifactVersion currentVersion = null;
    private VersionRange currentVersionRange = null;
    protected boolean verboseDetail = true;

    protected AbstractVersionDetails() {
    }

    protected ArtifactVersion getHighestLowerBound(ArtifactVersion lowerBoundVersion) {
        return this.getCurrentVersionRange().getRestrictions().stream().map(Restriction::getLowerBound).filter(Objects::nonNull).max(this.getVersionComparator()).orElse(lowerBoundVersion);
    }

    protected Optional<Restriction> getSelectedRestriction(ArtifactVersion selectedVersion) {
        assert (selectedVersion != null);
        return Optional.ofNullable(this.getCurrentVersionRange()).map(VersionRange::getRestrictions).flatMap(r -> r.stream().filter(rr -> rr.containsVersion(selectedVersion)).findAny());
    }

    @Override
    public Restriction restrictionForSelectedSegment(ArtifactVersion lowerBound, Optional<Segment> selectedSegment) {
        ArtifactVersion highestLowerBound = this.getHighestLowerBound(lowerBound);
        ArtifactVersion nextVersion = selectedSegment.filter(s -> s.isMajorTo(Segment.SUBINCREMENTAL)).map(Segment::minorTo).map(s -> new BoundArtifactVersion(highestLowerBound, (Segment)s)).orElse(highestLowerBound);
        return new Restriction(nextVersion, false, (ArtifactVersion)selectedSegment.filter(Segment.MAJOR::isMajorTo).map(s -> new BoundArtifactVersion(highestLowerBound, (Segment)s)).orElse(null), false);
    }

    @Override
    public Restriction restrictionForUnchangedSegment(ArtifactVersion actualVersion, Optional<Segment> unchangedSegment, boolean allowDowngrade) throws InvalidSegmentException {
        Optional<Object> selectedRestriction = Optional.ofNullable(actualVersion).flatMap(this::getSelectedRestriction);
        ArtifactVersion selectedRestrictionUpperBound = selectedRestriction.map(Restriction::getUpperBound).orElse(actualVersion);
        ArtifactVersion lowerBound = allowDowngrade ? (ArtifactVersion)this.getLowerBound(selectedRestrictionUpperBound, unchangedSegment).map(DefaultArtifactVersionCache::of).orElse(null) : selectedRestrictionUpperBound;
        ArtifactVersion upperBound = unchangedSegment.map(s -> new BoundArtifactVersion(selectedRestrictionUpperBound, s.isMajorTo(Segment.SUBINCREMENTAL) ? Segment.minorTo(s) : s)).orElse(null);
        return new Restriction(lowerBound, allowDowngrade || selectedRestriction.map(Restriction::isUpperBoundInclusive).map(b -> b == false).orElse(false) != false, upperBound, allowDowngrade);
    }

    @Override
    public Restriction restrictionForIgnoreScope(ArtifactVersion lowerBound, Optional<Segment> ignored) {
        ArtifactVersion highestLowerBound = this.getHighestLowerBound(lowerBound);
        ArtifactVersion nextVersion = ignored.map(s -> new BoundArtifactVersion(highestLowerBound, (Segment)s)).orElse(highestLowerBound);
        return new Restriction(nextVersion, false, null, false);
    }

    @Override
    public final ArtifactVersion getCurrentVersion() {
        return this.currentVersion;
    }

    @Override
    public final void setCurrentVersion(ArtifactVersion currentVersion) {
        this.currentVersion = currentVersion;
    }

    @Override
    public final VersionRange getCurrentVersionRange() {
        return this.currentVersionRange;
    }

    @Override
    public final void setCurrentVersionRange(VersionRange versionRange) {
        this.currentVersionRange = versionRange;
    }

    @Override
    public final void setCurrentVersion(String currentVersion) {
        this.setCurrentVersion((ArtifactVersion)(currentVersion == null ? null : DefaultArtifactVersionCache.of(currentVersion)));
    }

    @Override
    public final ArtifactVersion[] getVersions(VersionRange versionRange, boolean includeSnapshots) {
        return this.getVersions(versionRange, null, includeSnapshots);
    }

    @Override
    public final ArtifactVersion getNewestVersion(VersionRange versionRange, Restriction restriction, boolean includeSnapshots) {
        return this.getNewestVersion(versionRange, restriction, includeSnapshots, false);
    }

    @Override
    public final ArtifactVersion getNewestVersion(VersionRange versionRange, Restriction restriction, boolean includeSnapshots, boolean allowDowngrade) {
        return Arrays.stream(this.getVersions(includeSnapshots)).sorted(Collections.reverseOrder()).filter(candidate -> allowDowngrade || versionRange == null || ArtifactVersions.isVersionInRange(candidate, versionRange)).filter(candidate -> restriction == null || this.isVersionInRestriction(restriction, (ArtifactVersion)candidate)).filter(candidate -> includeSnapshots || !ArtifactUtils.isSnapshot((String)candidate.toString())).findAny().orElse(null);
    }

    @Override
    public final ArtifactVersion getNewestVersion(Restriction restriction, boolean includeSnapshots) {
        return this.getNewestVersion(null, restriction, includeSnapshots);
    }

    @Override
    public final ArtifactVersion getNewestVersion(VersionRange versionRange, boolean includeSnapshots) {
        return this.getNewestVersion(versionRange, null, includeSnapshots);
    }

    @Override
    public final boolean containsVersion(String version) {
        for (ArtifactVersion candidate : this.getVersions(true)) {
            if (!version.equals(candidate.toString())) continue;
            return true;
        }
        return false;
    }

    @Override
    public final ArtifactVersion[] getNewerVersions(String versionString, Optional<Segment> unchangedSegment, boolean includeSnapshots, boolean allowDowngrade) throws InvalidSegmentException {
        DefaultArtifactVersion currentVersion = DefaultArtifactVersionCache.of(versionString);
        DefaultArtifactVersion lowerBound = allowDowngrade ? (ArtifactVersion)this.getLowerBound((ArtifactVersion)currentVersion, unchangedSegment).map(DefaultArtifactVersionCache::of).orElse(null) : currentVersion;
        ArtifactVersion upperBound = unchangedSegment.map(arg_0 -> AbstractVersionDetails.lambda$getNewerVersions$11((ArtifactVersion)currentVersion, arg_0)).orElse(null);
        Restriction restriction = new Restriction((ArtifactVersion)lowerBound, allowDowngrade, upperBound, allowDowngrade);
        return this.getVersions(restriction, includeSnapshots);
    }

    @Override
    public Optional<ArtifactVersion> getNewestVersion(String actualVersion, Optional<Segment> unchangedSegment, boolean includeSnapshots, boolean allowDowngrade) throws InvalidSegmentException {
        Restriction segmentRestriction = this.restrictionForUnchangedSegment((ArtifactVersion)DefaultArtifactVersionCache.of(actualVersion), unchangedSegment, allowDowngrade);
        Restriction lookupRestriction = !allowDowngrade && Optional.ofNullable(this.currentVersion).map(v -> v.compareTo((Object)segmentRestriction.getLowerBound()) > 0).orElse(false) != false ? new Restriction(this.currentVersion, false, null, false) : segmentRestriction;
        return Arrays.stream(this.getVersions(includeSnapshots)).filter(candidate -> this.isVersionInRestriction(lookupRestriction, (ArtifactVersion)candidate)).filter(candidate -> includeSnapshots || !ArtifactUtils.isSnapshot((String)candidate.toString())).max(this.getVersionComparator());
    }

    @Override
    public final ArtifactVersion[] getVersions(Restriction restriction, boolean includeSnapshots) {
        return this.getVersions(null, restriction, includeSnapshots);
    }

    @Override
    public final ArtifactVersion[] getVersions(VersionRange versionRange, Restriction restriction, boolean includeSnapshots) {
        return (ArtifactVersion[])Arrays.stream(this.getVersions(includeSnapshots)).filter(candidate -> versionRange == null || ArtifactVersions.isVersionInRange(candidate, versionRange)).filter(candidate -> restriction == null || this.isVersionInRestriction(restriction, (ArtifactVersion)candidate)).filter(candidate -> includeSnapshots || !ArtifactUtils.isSnapshot((String)candidate.toString())).sorted(this.getVersionComparator()).distinct().toArray(ArtifactVersion[]::new);
    }

    @Override
    public final ArtifactVersion getNewestUpdateWithinSegment(ArtifactVersion currentVersion, Optional<Segment> updateScope, boolean includeSnapshots) {
        return this.getNewestVersion(this.restrictionForSelectedSegment(currentVersion, updateScope), includeSnapshots);
    }

    @Override
    public final ArtifactVersion[] getAllUpdates(ArtifactVersion currentVersion, Optional<Segment> updateScope, boolean includeSnapshots) {
        return this.getVersions(this.restrictionForSelectedSegment(currentVersion, updateScope), includeSnapshots);
    }

    @Override
    public final ArtifactVersion getNewestUpdateWithinSegment(Optional<Segment> updateScope, boolean includeSnapshots) {
        if (this.getCurrentVersion() != null) {
            return this.getNewestUpdateWithinSegment(this.getCurrentVersion(), updateScope, includeSnapshots);
        }
        return null;
    }

    @Override
    public final ArtifactVersion[] getAllUpdates(Optional<Segment> updateScope, boolean includeSnapshots) {
        if (this.getCurrentVersion() != null) {
            return this.getAllUpdates(this.getCurrentVersion(), updateScope, includeSnapshots);
        }
        return null;
    }

    @Override
    public final ArtifactVersion[] getAllUpdates(boolean includeSnapshots) {
        return this.getAllUpdates((VersionRange)null, includeSnapshots);
    }

    @Override
    public ArtifactVersion[] getAllUpdates(VersionRange versionRange, boolean includeSnapshots) {
        Restriction restriction = new Restriction(this.getCurrentVersion(), false, null, false);
        return this.getVersions(versionRange, restriction, includeSnapshots);
    }

    protected Optional<String> getLowerBound(ArtifactVersion version, Optional<Segment> unchangedSegment) throws InvalidSegmentException {
        if (!unchangedSegment.isPresent()) {
            return Optional.empty();
        }
        int segmentCount = this.getVersionComparator().getSegmentCount(version);
        if (unchangedSegment.get().value() > segmentCount) {
            throw new InvalidSegmentException(unchangedSegment.get(), segmentCount, version);
        }
        StringBuilder newVersion = new StringBuilder();
        newVersion.append(version.getMajorVersion());
        if (segmentCount > 0) {
            newVersion.append(".").append(unchangedSegment.get().value() >= 1 ? version.getMinorVersion() : 0);
        }
        if (segmentCount > 1) {
            newVersion.append(".").append(unchangedSegment.get().value() >= 2 ? version.getIncrementalVersion() : 0);
        }
        if (segmentCount > 2) {
            if (version.getQualifier() != null) {
                newVersion.append("-").append(unchangedSegment.get().value() >= 3 ? version.getQualifier() : "0");
            } else {
                newVersion.append("-").append(unchangedSegment.get().value() >= 3 ? Integer.valueOf(version.getBuildNumber()) : "0");
            }
        }
        return Optional.of(newVersion.toString());
    }

    public boolean isVersionInRestriction(Restriction restriction, ArtifactVersion candidate) {
        int upper;
        ArtifactVersion lowerBound = restriction.getLowerBound();
        ArtifactVersion upperBound = restriction.getUpperBound();
        boolean includeLower = restriction.isLowerBoundInclusive();
        boolean includeUpper = restriction.isUpperBoundInclusive();
        VersionComparator versionComparator = this.getVersionComparator();
        int lower = lowerBound == null ? -1 : versionComparator.compare(lowerBound, candidate);
        int n = upper = upperBound == null ? 1 : versionComparator.compare(upperBound, candidate);
        if (lower > 0 || upper < 0) {
            return false;
        }
        return !(!includeLower && lower == 0 || !includeUpper && upper == 0);
    }

    public final ArtifactVersion getReportNewestUpdate(Optional<Segment> updateScope, boolean includeSnapshots) {
        return this.getArtifactVersionStream(updateScope, includeSnapshots).min(Collections.reverseOrder(this.getVersionComparator())).orElse(null);
    }

    public final ArtifactVersion[] getReportUpdates(Optional<Segment> updateScope, boolean includeSnapshots) {
        TreeSet versions = this.getArtifactVersionStream(updateScope, includeSnapshots).collect(Collectors.toCollection(() -> new TreeSet<ArtifactVersion>(this.getVersionComparator())));
        if (!this.verboseDetail) {
            int major = 0;
            int minor = 0;
            boolean needOneMore = false;
            Iterator it = versions.descendingIterator();
            while (it.hasNext()) {
                ArtifactVersion version = (ArtifactVersion)it.next();
                boolean isPreview = PREVIEW_PATTERN.matcher(version.toString()).matches();
                if (version.getMajorVersion() == major && version.getMinorVersion() == minor) {
                    if (needOneMore && !isPreview) {
                        needOneMore = false;
                        continue;
                    }
                    it.remove();
                    continue;
                }
                major = version.getMajorVersion();
                minor = version.getMinorVersion();
                needOneMore = isPreview;
            }
        }
        return versions.toArray(new ArtifactVersion[0]);
    }

    private Stream<ArtifactVersion> getArtifactVersionStream(Optional<Segment> updateScope, boolean includeSnapshots) {
        if (this.getCurrentVersion() != null) {
            Restriction restriction = this.restrictionForSelectedSegment(this.getCurrentVersion(), updateScope);
            return Arrays.stream(this.getVersions(includeSnapshots)).filter(candidate -> this.isVersionInRestriction(restriction, (ArtifactVersion)candidate));
        }
        return Stream.empty();
    }

    private static /* synthetic */ ArtifactVersion lambda$getNewerVersions$11(ArtifactVersion currentVersion, Segment s) {
        return new BoundArtifactVersion(currentVersion, s.isMajorTo(Segment.SUBINCREMENTAL) ? Segment.minorTo(s) : s);
    }
}

