/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.ship;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:ship-maven-plugin:1.0-alpha-1", 0);
        this.append(sb, "", 0);
        this.append(sb, "Ship Maven Plugin", 0);
        this.append(sb, "Ship Plugin for Maven. The Ship Plugin provides a means of integrating Continuous Deployment scripts into the Maven release process.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 2 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "ship:help", 0);
            this.append(sb, "Display help information on ship-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0ship:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "ship".equals(this.goal)) {
            this.append(sb, "ship:ship", 0);
            this.append(sb, "Ships the shipVersion of the project artifacts using the Continuous Deployment script.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "selectors", 2);
                this.append(sb, "The project artifacts to ship, if undefined then it will default to the project artifact.", 3);
                this.append(sb, "", 0);
                this.append(sb, "shipScript", 2);
                this.append(sb, "The name of the ship script to execute, the selected artifact files will be passed as the global variable artifacts which is a Map of the artifact files keyed by selector id. Wildcards can be used in which case the order of scripts will be undefined.", 3);
                this.append(sb, "", 0);
                this.append(sb, "shipScriptDirectory (Default: src/ship/script)", 2);
                this.append(sb, "The directory containing the ship scripts.", 3);
                this.append(sb, "", 0);
                this.append(sb, "shipScripts", 2);
                this.append(sb, "The ship scripts to execute in order, defaults to *. The selected artifact files will be passed as the global variable artifacts which is a Map of the artifact files keyed by selector id. If wildcards are used for an entry, then the order of scripts in that entry will be undefined, but the previous entries will be executed first and subsequent entries will be executed afterwards, e.g.\n\u00a0\u00a0\u00a0\u00a0<shipScripts>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<shipScript>foo.groovy</shipScript>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<shipScript>ma*.groovy</shipScript>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<shipScript>bar.groovy</shipScript>\n\u00a0\u00a0\u00a0\u00a0</shipScripts>\nwill execute foo.groovy first, followed by all the scripts matching ma*.groovy in what ever order it finds them, and finally bar.groovy will be executed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "shipSkip (Default: false)", 2);
                this.append(sb, "Whether to bother trying to ship anything at all.", 3);
                this.append(sb, "", 0);
                this.append(sb, "shipSnapshotsAllowed (Default: false)", 2);
                this.append(sb, "Whether to allow shipping -SNAPSHOT versions, if true and the shipVersion is a -SNAPSHOT version then the build will be failed unless shipSnapshotsSkipped is true.", 3);
                this.append(sb, "", 0);
                this.append(sb, "shipSnapshotsSkipped (Default: false)", 2);
                this.append(sb, "Whether to try and ship -SNAPSHOT versions, if true and the shipVersion is a -SNAPSHOT version then an attempt will be made to ship the project artifacts .", 3);
                this.append(sb, "", 0);
                this.append(sb, "shipVersion (Default: ${project.version})", 2);
                this.append(sb, "The version of the project artifacts to ship.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

