/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.codehaus.mojo.rpm.Scriptlet;

public abstract class BaseTrigger
extends Scriptlet {
    private List triggers;

    public List getTriggers() {
        return this.triggers;
    }

    public void setTriggers(List triggers) {
        this.triggers = triggers;
    }

    protected String buildScriptletLine(String directive) {
        StringBuffer builder = new StringBuffer(super.buildScriptletLine(directive));
        builder.append(" -- ");
        int size = this.triggers.size();
        for (int i = 0; i < size; ++i) {
            String trigger = (String)this.triggers.get(i);
            if (i != 0) {
                builder.append(", ");
            }
            builder.append(trigger);
        }
        return builder.toString();
    }

    protected void writeTrigger(PrintWriter writer) throws IOException {
        this.write(writer, this.getDirective());
    }

    protected abstract String getDirective();

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46)));
        buffer.append('[');
        buffer.append("subpackage=");
        buffer.append(this.getSubpackage());
        buffer.append(",program=");
        buffer.append(this.getProgram());
        buffer.append(",script=");
        buffer.append(this.getScript());
        buffer.append(",scriptFile=");
        buffer.append(this.getScriptFile());
        buffer.append(",fileEncoding=");
        buffer.append(this.getFileEncoding());
        buffer.append(",triggers=");
        buffer.append(this.triggers);
        buffer.append("]");
        return buffer.toString();
    }
}

