/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import org.apache.commons.io.FileUtils;
import org.codehaus.mojo.mrm.api.BaseFileSystem;
import org.codehaus.mojo.mrm.api.DefaultDirectoryEntry;
import org.codehaus.mojo.mrm.api.DirectoryEntry;
import org.codehaus.mojo.mrm.api.Entry;
import org.codehaus.mojo.mrm.api.FileEntry;
import org.codehaus.mojo.mrm.api.FileSystem;
import org.codehaus.mojo.mrm.impl.DiskFileEntry;

public class DiskFileSystem
extends BaseFileSystem {
    private final File root;
    private final boolean readOnly;

    public DiskFileSystem(File root, boolean readOnly) {
        this.root = root;
        this.readOnly = readOnly;
    }

    public DiskFileSystem(File root) {
        this(root, true);
    }

    public Entry[] listEntries(DirectoryEntry directory) {
        File file = this.toFile((Entry)directory);
        if (!file.isDirectory()) {
            return null;
        }
        File[] files = file.listFiles();
        Entry[] result = new Entry[files.length];
        for (int i = 0; i < files.length; ++i) {
            result[i] = files[i].isFile() ? new DiskFileEntry((FileSystem)this, directory, files[i]) : new DefaultDirectoryEntry((FileSystem)this, directory, files[i].getName());
        }
        return result;
    }

    public long getLastModified(DirectoryEntry entry) throws IOException {
        return this.toFile((Entry)entry).lastModified();
    }

    private File toFile(Entry entry) {
        Stack<String> stack = new Stack<String>();
        DirectoryEntry entryRoot = entry.getFileSystem().getRoot();
        while (entry != null && !entryRoot.equals(entry)) {
            String name = entry.getName();
            if ("..".equals(name)) {
                if (!stack.isEmpty()) {
                    stack.pop();
                }
            } else if (!".".equals(name)) {
                stack.push(name);
            }
            entry = entry.getParent();
        }
        File file = this.root;
        while (!stack.empty()) {
            file = new File(file, (String)stack.pop());
        }
        return file;
    }

    public DirectoryEntry mkdir(DirectoryEntry parent, String name) {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        File file = new File(this.toFile((Entry)parent), name);
        file.mkdirs();
        return new DefaultDirectoryEntry((FileSystem)this, parent, name);
    }

    public FileEntry put(DirectoryEntry parent, String name, InputStream content) throws IOException {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        File parentFile = this.toFile((Entry)parent);
        parentFile.mkdirs();
        File file = new File(parentFile, name);
        FileUtils.copyInputStreamToFile((InputStream)content, (File)file);
        return new DiskFileEntry((FileSystem)this, parent, file);
    }

    public void remove(Entry entry) {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        File file = this.toFile(entry);
        file.delete();
    }
}

