/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.License;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.mojo.license.FileUtil;
import org.codehaus.mojo.license.MojoHelper;
import org.codehaus.mojo.license.SortedProperties;
import org.codehaus.mojo.license.ThirdPartyTool;
import org.codehaus.mojo.license.ThirdPartyToolException;
import org.codehaus.mojo.license.model.LicenseMap;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultThirdPartyTool
extends AbstractLogEnabled
implements ThirdPartyTool {
    public static final String DESCRIPTOR_CLASSIFIER = "third-party";
    public static final String DESCRIPTOR_TYPE = "properties";
    private ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;
    private MavenProjectBuilder mavenProjectBuilder;
    private MavenProjectHelper projectHelper;
    private final Comparator<MavenProject> projectComparator = MojoHelper.newMavenProjectComparator();
    private final Pattern GAV_PLUS_TYPE_PATTERN = Pattern.compile("(.+)--(.+)--(.+)--(.+)");
    private final Pattern GAV_PLUS_TYPE_AND_CLASSIFIER_PATTERN = Pattern.compile("(.+)--(.+)--(.+)--(.+)--(.+)");

    @Override
    public void attachThirdPartyDescriptor(MavenProject project, File file) {
        this.projectHelper.attachArtifact(project, DESCRIPTOR_TYPE, DESCRIPTOR_CLASSIFIER, file);
    }

    @Override
    public SortedSet<MavenProject> getProjectsWithNoLicense(LicenseMap licenseMap, boolean doLog) {
        Logger log = this.getLogger();
        SortedSet unsafeDependencies = (SortedSet)licenseMap.get(LicenseMap.getUnknownLicenseMessage());
        if (doLog) {
            if (CollectionUtils.isEmpty((Collection)unsafeDependencies)) {
                log.debug("There is no dependency with no license from poms.");
            } else {
                log.debug("There is " + unsafeDependencies.size() + " dependencies with no license from poms : ");
                for (MavenProject dep : unsafeDependencies) {
                    log.debug(" - " + MojoHelper.getArtifactId(dep.getArtifact()));
                }
            }
        }
        return unsafeDependencies;
    }

    @Override
    public SortedProperties loadThirdPartyDescriptorsForUnsafeMapping(String encoding, Collection<MavenProject> projects, SortedSet<MavenProject> unsafeDependencies, LicenseMap licenseMap, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws ThirdPartyToolException, IOException {
        SortedProperties result = new SortedProperties(encoding);
        HashMap<String, MavenProject> unsafeProjects = new HashMap<String, MavenProject>();
        for (MavenProject unsafeDependency : unsafeDependencies) {
            String id = MojoHelper.getArtifactId(unsafeDependency.getArtifact());
            unsafeProjects.put(id, unsafeDependency);
        }
        for (MavenProject mavenProject : projects) {
            if (CollectionUtils.isEmpty(unsafeDependencies)) break;
            File thirdPartyDescriptor = this.resolvThirdPartyDescriptor(mavenProject, localRepository, remoteRepositories);
            if (thirdPartyDescriptor == null || !thirdPartyDescriptor.exists() || thirdPartyDescriptor.length() <= 0L) continue;
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Detects third party descriptor " + thirdPartyDescriptor);
            }
            SortedProperties unsafeMappings = new SortedProperties(encoding);
            if (thirdPartyDescriptor.exists()) {
                this.getLogger().info("Load missing file " + thirdPartyDescriptor);
                unsafeMappings.load(thirdPartyDescriptor);
            }
            for (String id : unsafeProjects.keySet()) {
                String license;
                if (!unsafeMappings.containsKey(id) || StringUtils.isEmpty((String)(license = (String)unsafeMappings.get(id)))) continue;
                MavenProject resolvedProject = (MavenProject)unsafeProjects.get(id);
                unsafeDependencies.remove(resolvedProject);
                result.put(id, license.trim());
                this.addLicense(licenseMap, resolvedProject, license);
            }
        }
        return result;
    }

    @Override
    public File resolvThirdPartyDescriptor(MavenProject project, ArtifactRepository localRepository, List<ArtifactRepository> repositories) throws ThirdPartyToolException {
        if (project == null) {
            throw new IllegalArgumentException("The parameter 'project' can not be null");
        }
        if (localRepository == null) {
            throw new IllegalArgumentException("The parameter 'localRepository' can not be null");
        }
        if (repositories == null) {
            throw new IllegalArgumentException("The parameter 'remoteArtifactRepositories' can not be null");
        }
        try {
            return this.resolveThirdPartyDescriptor(project, localRepository, repositories);
        }
        catch (ArtifactNotFoundException e) {
            this.getLogger().debug("ArtifactNotFoundException: Unable to locate third party descriptor: " + (Object)((Object)e));
            return null;
        }
        catch (ArtifactResolutionException e) {
            throw new ThirdPartyToolException("ArtifactResolutionException: Unable to locate third party descriptor: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new ThirdPartyToolException("IOException: Unable to locate third party descriptor: " + e.getMessage(), e);
        }
    }

    @Override
    public void addLicense(LicenseMap licenseMap, MavenProject project, String licenseName) {
        License license = new License();
        license.setName(licenseName.trim());
        license.setUrl(licenseName.trim());
        this.addLicense(licenseMap, project, license);
    }

    @Override
    public void addLicense(LicenseMap licenseMap, MavenProject project, License license) {
        this.addLicense(licenseMap, project, Arrays.asList(license));
    }

    @Override
    public void addLicense(LicenseMap licenseMap, MavenProject project, List<?> licenses) {
        if ("system".equals(project.getArtifact().getScope())) {
            return;
        }
        if (CollectionUtils.isEmpty(licenses)) {
            licenseMap.put(LicenseMap.getUnknownLicenseMessage(), project);
            return;
        }
        for (Object o : licenses) {
            String id = MojoHelper.getArtifactId(project.getArtifact());
            if (o == null) {
                this.getLogger().warn("could not acquire the license for " + id);
                continue;
            }
            License license = (License)o;
            String licenseKey = license.getName();
            if (StringUtils.isEmpty((String)license.getName())) {
                this.getLogger().warn("No license name defined for " + id);
                licenseKey = license.getUrl();
            }
            if (StringUtils.isEmpty((String)licenseKey)) {
                this.getLogger().warn("No license url defined for " + id);
                licenseKey = LicenseMap.getUnknownLicenseMessage();
            }
            licenseMap.put(licenseKey, project);
        }
    }

    @Override
    public void mergeLicenses(LicenseMap licenseMap, String ... licenses) {
        if (licenses.length == 0) {
            return;
        }
        String mainLicense = licenses[0].trim();
        TreeSet<MavenProject> mainSet = (TreeSet<MavenProject>)licenseMap.get(mainLicense);
        if (mainSet == null) {
            this.getLogger().warn("No license [" + mainLicense + "] found, will create it.");
            mainSet = new TreeSet<MavenProject>(this.projectComparator);
            licenseMap.put(mainLicense, mainSet);
        }
        int size = licenses.length;
        for (int i = 1; i < size; ++i) {
            String license = licenses[i].trim();
            SortedSet set = (SortedSet)licenseMap.get(license);
            if (set == null) {
                this.getLogger().warn("No license [" + license + "] found, skip this merge.");
                continue;
            }
            this.getLogger().info("Merge license [" + license + "] (" + set.size() + " depedencies).");
            mainSet.addAll(set);
            set.clear();
            licenseMap.remove(license);
        }
    }

    @Override
    public SortedProperties loadUnsafeMapping(LicenseMap licenseMap, SortedMap<String, MavenProject> artifactCache, String encoding, File missingFile) throws IOException {
        String id;
        SortedSet<MavenProject> unsafeDependencies = this.getProjectsWithNoLicense(licenseMap, false);
        SortedProperties unsafeMappings = new SortedProperties(encoding);
        if (missingFile.exists()) {
            this.getLogger().info("Load missing file " + missingFile);
            unsafeMappings.load(missingFile);
        }
        ArrayList<String> unknownDependenciesId = new ArrayList<String>();
        Map<String, String> migrateKeys = this.migrateMissingFileKeys(unsafeMappings.keySet());
        for (String string : migrateKeys.keySet()) {
            id = string;
            String migratedId = migrateKeys.get(id);
            MavenProject project = (MavenProject)artifactCache.get(migratedId);
            if (project == null) {
                unknownDependenciesId.add(id);
                continue;
            }
            if (id.equals(migratedId)) continue;
            this.getLogger().info("Migrates [" + id + "] to [" + migratedId + "] in the missing file.");
            Object value = unsafeMappings.get(id);
            unsafeMappings.remove(id);
            unsafeMappings.put(migratedId, value);
        }
        if (!unknownDependenciesId.isEmpty()) {
            for (String string : unknownDependenciesId) {
                this.getLogger().warn("dependency [" + string + "] does not exist in project, remove it from the missing file.");
                unsafeMappings.remove(string);
            }
            unknownDependenciesId.clear();
        }
        for (Object object : unsafeMappings.keySet()) {
            id = (String)object;
            MavenProject project = (MavenProject)artifactCache.get(id);
            if (project == null) {
                this.getLogger().warn("dependency [" + id + "] does not exist in project.");
                continue;
            }
            String license = (String)unsafeMappings.get(id);
            if (StringUtils.isEmpty((String)license)) continue;
            this.addLicense(licenseMap, project, license);
            unsafeDependencies.remove(project);
        }
        if (unsafeDependencies.isEmpty()) {
            licenseMap.remove(LicenseMap.getUnknownLicenseMessage());
        } else {
            for (MavenProject mavenProject : unsafeDependencies) {
                id = MojoHelper.getArtifactId(mavenProject.getArtifact());
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("dependency [" + id + "] has no license, add it in the missing file.");
                }
                unsafeMappings.setProperty(id, "");
            }
        }
        return unsafeMappings;
    }

    private File resolveThirdPartyDescriptor(MavenProject project, ArtifactRepository localRepository, List<ArtifactRepository> repositories) throws IOException, ArtifactResolutionException, ArtifactNotFoundException {
        File result;
        Artifact artifact = this.artifactFactory.createArtifactWithClassifier(project.getGroupId(), project.getArtifactId(), project.getVersion(), DESCRIPTOR_TYPE, DESCRIPTOR_CLASSIFIER);
        try {
            this.artifactResolver.resolve(artifact, repositories, localRepository);
            result = artifact.getFile();
            if (result.length() == 0L) {
                this.getLogger().debug("Skipped third party descriptor");
            }
        }
        catch (ArtifactNotFoundException e) {
            this.getLogger().debug("Unable to locate third party files descriptor : " + (Object)((Object)e));
            result = new File(localRepository.getBasedir(), localRepository.pathOf(artifact));
            FileUtil.createNewFile(result);
        }
        return result;
    }

    private Map<String, String> migrateMissingFileKeys(Set<Object> missingFileKeys) {
        HashMap<String, String> migrateKeys = new HashMap<String, String>();
        for (Object object : missingFileKeys) {
            String id;
            String newId = id = (String)object;
            Matcher matcher = this.GAV_PLUS_TYPE_AND_CLASSIFIER_PATTERN.matcher(id);
            if (matcher.matches()) {
                newId = matcher.group(1) + "--" + matcher.group(2) + "--" + matcher.group(3);
            } else {
                matcher = this.GAV_PLUS_TYPE_PATTERN.matcher(id);
                if (matcher.matches()) {
                    newId = matcher.group(1) + "--" + matcher.group(2) + "--" + matcher.group(3);
                }
            }
            migrateKeys.put(id, newId);
        }
        return migrateKeys;
    }
}

