/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jboss;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class AbstractJBossMojo
extends AbstractMojo {
    protected String jbossHome;
    protected File outputDirectory;
    protected String serverName;

    protected void checkConfig() throws MojoExecutionException {
        if (this.jbossHome == null || this.jbossHome.equals("ENV")) {
            this.jbossHome = System.getenv("JBOSS_HOME");
        }
        if (this.jbossHome == null) {
            throw new MojoExecutionException("Neither JBOSS_HOME nor the jbossHome configuration parameter is set!");
        }
    }

    protected void launch(String fName, String params) throws MojoExecutionException {
        try {
            this.checkConfig();
            String osName = System.getProperty("os.name");
            Runtime runtime = Runtime.getRuntime();
            Process p = null;
            if (osName.startsWith("Windows")) {
                String[] command = new String[]{"cmd.exe", "/C", "cd " + this.outputDirectory.getAbsolutePath() + "\\bin & " + fName + ".bat " + " " + params};
                p = runtime.exec(command);
            } else {
                String[] command = new String[]{"sh", "-c", "cd " + this.outputDirectory.getAbsolutePath() + "/bin; ./" + fName + ".sh " + " " + params};
                p = runtime.exec(command);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Mojo error occurred: " + e.getMessage(), e);
        }
    }
}

