/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer.jbcpd;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;

public final class ShowClassPath {
    public static void main(String[] args) {
        String cp = System.getProperty("sun.boot.class.path");
        if (cp != null) {
            System.out.println(cp);
            return;
        }
        cp = System.getProperty("java.boot.class.path");
        if (cp != null) {
            System.out.println(cp);
            return;
        }
        Enumeration<?> i = System.getProperties().propertyNames();
        String name = null;
        while (i.hasMoreElements()) {
            String temp = (String)i.nextElement();
            if (temp.indexOf(".boot.class.path") == -1) continue;
            if (name == null) {
                name = temp;
                continue;
            }
            System.err.println("Cannot auto-detect boot class path " + System.getProperty("java.version"));
            System.exit(1);
        }
        if (name == null) {
            String version = System.getProperty("java.version");
            if (version.startsWith("1.1.")) {
                cp = System.getProperty("java.class.path");
                cp = ShowClassPath.removeAll(cp, ".");
                cp = ShowClassPath.removeAll(cp, new File(".").getAbsolutePath());
                try {
                    cp = ShowClassPath.removeAll(cp, new File(".").getCanonicalPath());
                }
                catch (IOException e) {
                    // empty catch block
                }
                cp = ShowClassPath.removeAll(cp, new File(".").getAbsolutePath() + System.getProperty("file.separator"));
                try {
                    cp = ShowClassPath.removeAll(cp, new File(".").getCanonicalPath() + System.getProperty("file.separator"));
                }
                catch (IOException e) {
                    // empty catch block
                }
                System.out.println(cp);
                return;
            }
            System.err.println("Cannot auto-detect boot class path " + System.getProperty("java.version") + " " + System.getProperty("java.class.path"));
            System.exit(1);
        }
        System.out.println(System.getProperty(name));
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toUpperCase().startsWith("WINDOWS");
    }

    private static String removeAll(String cp, String prefix) {
        int j;
        String pathSeparator = System.getProperty("path.separator");
        if (cp.startsWith(prefix + pathSeparator)) {
            cp = cp.substring(prefix.length() + pathSeparator.length());
        }
        while (-1 != (j = cp.indexOf(pathSeparator + prefix + pathSeparator))) {
            cp = cp.substring(0, j) + cp.substring(j + prefix.length() + pathSeparator.length());
        }
        if (cp.endsWith(pathSeparator + prefix)) {
            cp = cp.substring(0, cp.length() - prefix.length() + pathSeparator.length());
        }
        if (ShowClassPath.isWindows()) {
            if (cp.toUpperCase().startsWith((prefix + pathSeparator).toUpperCase())) {
                cp = cp.substring(prefix.length() + pathSeparator.length());
            }
            while (-1 != (j = cp.toUpperCase().indexOf((pathSeparator + prefix + pathSeparator).toUpperCase()))) {
                cp = cp.substring(0, j) + cp.substring(j + prefix.length() + pathSeparator.length());
            }
            if (cp.toUpperCase().endsWith((pathSeparator + prefix).toUpperCase())) {
                cp = cp.substring(0, cp.length() - prefix.length() + pathSeparator.length());
            }
        }
        return cp;
    }
}

