/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.idlj;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.idlj.CompilerTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTranslator
implements CompilerTranslator {
    private boolean debug;
    private boolean failOnError;
    private Log log;
    private static ClassLoaderFacade classLoaderFacade = new ClassLoaderFacadeImpl();
    private static boolean fork = true;

    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public Log getLog() {
        return this.log;
    }

    @Override
    public void setLog(Log log) {
        this.log = log;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    @Override
    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    protected static boolean isFork() {
        return fork;
    }

    static void setClassLoaderFacade(ClassLoaderFacade classLoaderFacade) {
        AbstractTranslator.classLoaderFacade = classLoaderFacade;
        fork = false;
    }

    protected ClassLoaderFacade getClassLoaderFacade() {
        return classLoaderFacade;
    }

    protected void invokeCompilerInProcess(Class<?> compilerClass, List<String> args) throws MojoExecutionException {
        String[] arguments = args.toArray(new String[args.size()]);
        this.getLog().debug((CharSequence)this.getCommandLine(compilerClass, arguments));
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int exitCode = this.runCompilerAndRecordOutput(compilerClass, arguments, err, out);
        this.logOutputMessages(err, out);
        if (this.isFailOnError() && this.isCompilationFailed(err, exitCode)) {
            throw new MojoExecutionException("IDL compilation failed");
        }
    }

    private int runCompilerAndRecordOutput(Class<?> compilerClass, String[] arguments, ByteArrayOutputStream err, ByteArrayOutputStream out) throws MojoExecutionException {
        PrintStream stdErr = System.err;
        PrintStream stdOut = System.out;
        System.setErr(new PrintStream(err));
        System.setOut(new PrintStream(out));
        try {
            int n = this.runCompiler(compilerClass, arguments);
            return n;
        }
        catch (NoSuchMethodException e) {
            throw new MojoExecutionException("Error: Compiler had no main method");
        }
        catch (InvocationTargetException e) {
            throw new MojoExecutionException("IDL compilation failed", e.getTargetException());
        }
        catch (Throwable e) {
            throw new MojoExecutionException("IDL compilation failed", e);
        }
        finally {
            System.setErr(stdErr);
            System.setOut(stdOut);
        }
    }

    protected abstract int runCompiler(Class<?> var1, String ... var2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException;

    private boolean isCompilationFailed(ByteArrayOutputStream err, int exitCode) {
        return exitCode != 0 || this.hasErrors(err);
    }

    private boolean hasErrors(ByteArrayOutputStream err) {
        for (String message : err.toString().split("\n")) {
            if (!message.contains("(line ") || message.contains("WARNING")) continue;
            this.getLog().debug((CharSequence)("Failed due to error: <" + message + ">"));
            return true;
        }
        return false;
    }

    private void logOutputMessages(ByteArrayOutputStream err, ByteArrayOutputStream out) {
        if (this.isNotEmpty(out)) {
            this.getLog().info((CharSequence)out.toString());
        }
        if (this.isNotEmpty(err)) {
            this.getLog().error((CharSequence)err.toString());
        }
    }

    private boolean isNotEmpty(ByteArrayOutputStream outputStream) {
        return !"".equals(outputStream.toString());
    }

    private String getCommandLine(Class<?> compilerClass, String[] arguments) {
        String command = compilerClass.getName();
        for (String argument : arguments) {
            command = command + " " + argument;
        }
        return command;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClassLoaderFacadeImpl
    implements ClassLoaderFacade {
        ClassLoader classLoader = this.getClass().getClassLoader();

        ClassLoaderFacadeImpl() {
        }

        @Override
        public void prependUrls(URL ... urls) {
            this.classLoader = new URLClassLoader(urls, this.classLoader);
        }

        @Override
        public Class<?> loadClass(String idlCompilerClass) throws ClassNotFoundException {
            return this.classLoader.loadClass(idlCompilerClass);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ClassLoaderFacade {
        public void prependUrls(URL ... var1);

        public Class<?> loadClass(String var1) throws ClassNotFoundException;
    }
}

