/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class RequireEncoding
implements EnforcerRule {
    private String encoding = "";
    private String includes = "";
    private String excludes = "";
    private boolean useDefaultExcludes = true;
    private boolean failFast = true;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            if (StringUtils.isBlank((String)this.encoding)) {
                this.encoding = (String)helper.evaluate("${project.build.sourceEncoding}");
            }
            Log log = helper.getLog();
            if (this.encoding.equals(StandardCharsets.US_ASCII.name())) {
                log.warn((CharSequence)"Encoding US-ASCII is hard to detect. Use UTF-8 or ISO-8859-1");
            }
            String basedir = (String)helper.evaluate("${basedir}");
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(basedir);
            if (StringUtils.isNotBlank((String)this.includes)) {
                ds.setIncludes(this.includes.split("[,\\|]"));
            }
            if (StringUtils.isNotBlank((String)this.excludes)) {
                ds.setExcludes(this.excludes.split("[,\\|]"));
            }
            if (this.useDefaultExcludes) {
                ds.addDefaultExcludes();
            }
            ds.scan();
            StringBuilder filesInMsg = new StringBuilder();
            for (String file : ds.getIncludedFiles()) {
                String fileEncoding = this.getEncoding(this.encoding, new File(basedir, file), log);
                if (log.isDebugEnabled()) {
                    log.debug((CharSequence)(file + "==>" + fileEncoding));
                }
                if (fileEncoding == null || fileEncoding.equals(this.encoding)) continue;
                filesInMsg.append(file);
                filesInMsg.append("==>");
                filesInMsg.append(fileEncoding);
                filesInMsg.append("\n");
                if (!this.failFast) continue;
                throw new EnforcerRuleException(filesInMsg.toString());
            }
            if (filesInMsg.length() > 0) {
                throw new EnforcerRuleException("Files not encoded in " + this.encoding + ":\n" + filesInMsg);
            }
        }
        catch (IOException ex) {
            throw new EnforcerRuleException("Reading Files", (Exception)ex);
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to lookup an expression " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getEncoding(String requiredEncoding, File file, Log log) throws IOException {
        CharsetMatch[] charsets;
        FileInputStream fis;
        block3: {
            String string;
            fis = null;
            try {
                fis = new FileInputStream(file);
                CharsetDetector detector = new CharsetDetector();
                detector.setDeclaredEncoding(requiredEncoding);
                detector.setText((InputStream)new BufferedInputStream(fis));
                charsets = detector.detectAll();
                if (charsets != null) break block3;
                string = null;
            }
            catch (Throwable throwable) {
                IOUtil.close(fis);
                throw throwable;
            }
            IOUtil.close((InputStream)fis);
            return string;
        }
        String string = charsets[0].getName();
        IOUtil.close((InputStream)fis);
        return string;
    }

    public String getCacheId() {
        return null;
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule cachedRule) {
        return false;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public boolean isUseDefaultExcludes() {
        return this.useDefaultExcludes;
    }

    public void setUseDefaultExcludes(boolean useDefaultExcludes) {
        this.useDefaultExcludes = useDefaultExcludes;
    }
}

