/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.emma;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.emma.AbstractEmmaMojo;
import org.codehaus.mojo.emma.task.InstrumentTask;

public class EmmaInstrumentMojo
extends AbstractEmmaMojo {
    protected List pluginClasspath;
    protected boolean merge;
    protected String[] filters;
    protected File[] instrumentationPaths;
    protected File metadataFile;
    private ArtifactFactory factory;

    protected void checkParameters() throws MojoExecutionException, MojoFailureException {
        super.checkParameters();
        if (this.filters == null) {
            this.filters = new String[0];
        }
        if (this.instrumentationPaths == null) {
            this.instrumentationPaths = new File[]{new File(this.project.getBuild().getOutputDirectory())};
        }
    }

    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        if (this.getLog().isDebugEnabled()) {
            int i;
            if (this.instrumentationPaths != null) {
                this.getLog().debug((CharSequence)"Instrumentation path:");
                for (i = 0; i < this.instrumentationPaths.length; ++i) {
                    this.getLog().debug((CharSequence)(" o " + this.instrumentationPaths[i].getAbsolutePath()));
                }
            }
            if (this.filters != null && this.filters.length > 0) {
                this.getLog().debug((CharSequence)"Filters:");
                for (i = 0; i < this.filters.length; ++i) {
                    this.getLog().debug((CharSequence)(" o " + this.filters[i]));
                }
            }
        }
        InstrumentTask task = new InstrumentTask();
        task.setOutputDirectory(this.outputDirectory);
        task.setFilters(this.filters);
        task.setVerbose(this.verbose);
        task.setInstrumentationPaths(this.instrumentationPaths);
        task.setMerge(this.merge);
        task.setMetadataFile(this.metadataFile);
        this.getLog().info((CharSequence)"Instrumenting classes with EMMA");
        try {
            task.execute();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        this.addEmmaDependenciesToTestClasspath();
        File classesDir = new File(this.outputDirectory, "classes");
        this.project.getBuild().setOutputDirectory(classesDir.getPath());
    }

    private void addEmmaDependenciesToTestClasspath() throws MojoExecutionException {
        Map pluginArtifactMap = ArtifactUtils.artifactMapByVersionlessId((Collection)this.pluginClasspath);
        Artifact emmaArtifact = (Artifact)pluginArtifactMap.get("emma:emma");
        if (emmaArtifact == null) {
            throw new MojoExecutionException("Failed to find 'emma' artifact in plugin dependencies");
        }
        emmaArtifact = this.artifactScopeToTest(emmaArtifact);
        HashSet<Artifact> deps = new HashSet<Artifact>();
        if (this.project.getDependencyArtifacts() != null) {
            deps.addAll(this.project.getDependencyArtifacts());
        }
        deps.add(emmaArtifact);
        this.project.setDependencyArtifacts(deps);
    }

    private Artifact artifactScopeToTest(Artifact artifact) {
        return this.factory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "test", artifact.getType());
    }
}

