/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin.chart.time;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.Date;
import org.codehaus.mojo.dashboard.report.plugin.chart.AbstractChartRenderer;
import org.codehaus.mojo.dashboard.report.plugin.chart.IChartStrategy;
import org.codehaus.mojo.dashboard.report.plugin.chart.time.AbstractTimeChartStrategy;
import org.codehaus.mojo.dashboard.report.plugin.chart.time.DashDateAxis;
import org.codehaus.mojo.dashboard.report.plugin.utils.DateUtils;
import org.codehaus.mojo.dashboard.report.plugin.utils.TimePeriod;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.time.DateRange;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;

public class TimeChartRenderer
extends AbstractChartRenderer {
    public TimeChartRenderer(IChartStrategy strategy) {
        super(strategy);
    }

    public TimeChartRenderer(IChartStrategy strategy, int width, int height) {
        super(strategy, width, height);
    }

    public void createChart() {
        XYDataset dataset = (XYDataset)this.datasetStrategy.getDataset();
        this.report = ChartFactory.createTimeSeriesChart((String)this.datasetStrategy.getTitle(), (String)this.datasetStrategy.getXAxisLabel(), (String)this.datasetStrategy.getYAxisLabel(), (XYDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = this.report.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.lightGray);
        plot.setRangeGridlinePaint((Paint)Color.lightGray);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        XYItemRenderer xyitemrenderer = plot.getRenderer();
        if (xyitemrenderer instanceof XYLineAndShapeRenderer) {
            XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)xyitemrenderer;
            renderer.setBaseShapesVisible(true);
            renderer.setBaseShapesFilled(true);
            renderer.setShapesVisible(true);
            renderer.setDrawOutlines(true);
            renderer.setBaseItemLabelGenerator(((AbstractTimeChartStrategy)this.datasetStrategy).getLabelGenerator());
            renderer.setItemLabelFont(new Font("SansSerif", 1, 10));
            renderer.setBaseItemLabelsVisible(true);
            renderer.setPositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE10, TextAnchor.BASELINE_RIGHT));
        }
        Paint[] paints = this.datasetStrategy.getPaintColor();
        for (int i = 0; i < dataset.getSeriesCount() && i < paints.length; ++i) {
            xyitemrenderer.setSeriesPaint(i, paints[i]);
            xyitemrenderer.setSeriesStroke(i, (Stroke)new BasicStroke(2.0f, 1, 1));
        }
        plot.setRangeAxis((ValueAxis)((AbstractTimeChartStrategy)this.datasetStrategy).getRangeAxis());
        DashDateAxis axisDate = new DashDateAxis();
        axisDate.setDateFormatOverride(((AbstractTimeChartStrategy)this.datasetStrategy).getTimePeriod().getDateFormat());
        axisDate.setLabel(this.datasetStrategy.getXAxisLabel());
        axisDate.setTickUnit(this.getTickUnit(((AbstractTimeChartStrategy)this.datasetStrategy).getTimePeriod()));
        axisDate.setUpperMargin(0.0);
        axisDate.setDateTickLabelAngle(-0.6);
        if (((AbstractTimeChartStrategy)this.datasetStrategy).getStartDate() != null && ((AbstractTimeChartStrategy)this.datasetStrategy).getEndDate() != null) {
            axisDate.setRangeWithMargins((Range)new DateRange(((AbstractTimeChartStrategy)this.datasetStrategy).getStartDate(), ((AbstractTimeChartStrategy)this.datasetStrategy).getEndDate()));
        }
        plot.setDomainAxis((ValueAxis)axisDate);
        Date[] dates = DateUtils.getAllDates(((AbstractTimeChartStrategy)this.datasetStrategy).getStartDate(), ((AbstractTimeChartStrategy)this.datasetStrategy).getEndDate(), ((AbstractTimeChartStrategy)this.datasetStrategy).getTimePeriod());
        int width = dates.length * 60 + 50;
        if (width > 600) {
            this.setWidth(width);
        } else {
            this.setWidth(600);
        }
    }

    private DateTickUnit getTickUnit(TimePeriod timePeriod) {
        DateTickUnit tickUnit = null;
        tickUnit = timePeriod.equals(TimePeriod.MINUTE) ? new DateTickUnit(4, 10) : (timePeriod.equals(TimePeriod.HOUR) ? new DateTickUnit(3, 1) : (timePeriod.equals(TimePeriod.DAY) ? new DateTickUnit(2, 1) : (timePeriod.equals(TimePeriod.WEEK) ? new DateTickUnit(2, 7) : (timePeriod.equals(TimePeriod.MONTH) ? new DateTickUnit(1, 1) : new DateTickUnit(3, 1)))));
        return tickUnit;
    }
}

