/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin.chart.time;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.codehaus.mojo.dashboard.report.plugin.beans.CloverReportBean;
import org.codehaus.mojo.dashboard.report.plugin.chart.time.AbstractTimeChartStrategy;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardXYItemLabelGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.data.time.TimeSeries;

public class CloverTimeChartStrategy
extends AbstractTimeChartStrategy {
    public CloverTimeChartStrategy(ResourceBundle bundle, String title, List results, String timeUnit, Date startDate, Date endDate) {
        super(bundle, title, results, timeUnit, startDate, endDate);
    }

    public void fillDataset() {
        TimeSeries s1 = new TimeSeries(this.bundle.getString("report.clover.label.total"), this.periodClass);
        TimeSeries s2 = new TimeSeries(this.bundle.getString("report.clover.label.conditionals"), this.periodClass);
        TimeSeries s3 = new TimeSeries(this.bundle.getString("report.clover.label.statements"), this.periodClass);
        TimeSeries s4 = new TimeSeries(this.bundle.getString("report.clover.label.methods"), this.periodClass);
        Iterator iter = this.mResults.iterator();
        while (iter.hasNext()) {
            CloverReportBean clover = (CloverReportBean)iter.next();
            Date date = clover.getDateGeneration();
            int total = clover.getElements();
            int covered = clover.getCoveredElements();
            s1.addOrUpdate(this.getChartDate(this.timePeriod.normalize(date)), (double)covered / (double)total);
            int totalCond = clover.getConditionals();
            int coveredCond = clover.getCoveredConditionals();
            s2.addOrUpdate(this.getChartDate(this.timePeriod.normalize(date)), (double)coveredCond / (double)totalCond);
            int totalStat = clover.getStatements();
            int coveredStat = clover.getCoveredStatements();
            s3.addOrUpdate(this.getChartDate(this.timePeriod.normalize(date)), (double)coveredStat / (double)totalStat);
            int totalMeth = clover.getMethods();
            int coveredMeth = clover.getCoveredMethods();
            s4.addOrUpdate(this.getChartDate(this.timePeriod.normalize(date)), (double)coveredMeth / (double)totalMeth);
        }
        this.defaultdataset.addSeries(s1);
        this.defaultdataset.addSeries(s2);
        this.defaultdataset.addSeries(s3);
        this.defaultdataset.addSeries(s4);
    }

    public NumberAxis getRangeAxis() {
        NumberAxis valueaxis = new NumberAxis();
        valueaxis.setLowerMargin(0.0);
        valueaxis.setUpperMargin(0.05);
        valueaxis.setRangeWithMargins(0.0, 1.0);
        valueaxis.setLabel(this.getYAxisLabel());
        valueaxis.setNumberFormatOverride(NumberFormat.getPercentInstance());
        return valueaxis;
    }

    public String getYAxisLabel() {
        return this.bundle.getString("report.clover.label.coverage");
    }

    public XYItemLabelGenerator getLabelGenerator() {
        StandardXYItemLabelGenerator labelgenerator = new StandardXYItemLabelGenerator("{2}", (DateFormat)this.timePeriod.getDateFormat(), NumberFormat.getPercentInstance(Locale.getDefault()));
        return labelgenerator;
    }
}

