/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.apt;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.mojo.apt.EmbeddedURLClassLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AptClassLoader
extends URLClassLoader {
    public static final ClassLoader INSTANCE = new AptClassLoader();
    private Map<String, Class<?>> loadedClasses = new HashMap();

    private AptClassLoader() {
        super(AptClassLoader.getClassPath(), (ClassLoader)null);
    }

    static File getToolsJar() {
        return new File(System.getProperty("java.home"), "../lib/tools.jar");
    }

    private static URL[] getClassPath() {
        File toolsJar = AptClassLoader.getToolsJar();
        if (toolsJar.isFile()) {
            try {
                return new URL[]{toolsJar.toURI().toURL()};
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return new URL[0];
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.startsWith("com.sun.tools.apt.")) {
            Class<?> loadedClass = this.loadedClasses.get(name);
            if (loadedClass == null) {
                try {
                    String classFile = name.replace('.', '/') + ".class";
                    InputStream classStream = this.getClass().getClassLoader().getResourceAsStream(classFile);
                    if (classStream == null) {
                        classStream = this.getResourceAsStream(classFile);
                    }
                    ClassReader classReader = new ClassReader(classStream);
                    ClassWriter classWriter = new ClassWriter(classReader, 0);
                    RemappingClassAdapter classVisitor = new RemappingClassAdapter((ClassVisitor)classWriter, (Remapper)new ClassRemapper());
                    classReader.accept((ClassVisitor)classVisitor, 6);
                    byte[] classBytes = classWriter.toByteArray();
                    loadedClass = this.defineClass(name, classBytes, 0, classBytes.length);
                    this.loadedClasses.put(name, loadedClass);
                }
                catch (IOException e) {
                    throw new ClassNotFoundException(name, e);
                }
            }
            if (resolve) {
                this.resolveClass(loadedClass);
            }
            return loadedClass;
        }
        if (EmbeddedURLClassLoader.class.getName().equals(name)) {
            return this.getClass().getClassLoader().loadClass(name);
        }
        if (name.startsWith("com.sun.")) {
            try {
                return this.getClass().getClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return super.loadClass(name, resolve);
    }

    static class ClassRemapper
    extends Remapper {
        private final String from = URLClassLoader.class.getName().replace('.', '/');
        private final String to = EmbeddedURLClassLoader.class.getName().replace('.', '/');

        ClassRemapper() {
        }

        public String map(String type) {
            if (this.from.equals(type)) {
                return this.to;
            }
            return type;
        }
    }
}

