/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.xsd;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugin.model.ModelClassMetadata;
import org.codehaus.modello.plugin.xsd.metadata.XsdClassMetadata;
import org.codehaus.modello.plugin.xsd.metadata.XsdModelMetadata;
import org.codehaus.modello.plugins.xml.AbstractXmlGenerator;
import org.codehaus.modello.plugins.xml.XmlFieldMetadata;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

public class XsdGenerator
extends AbstractXmlGenerator {
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Properties;

    public void generate(Model model, Properties parameters) throws ModelloException {
        this.initialize(model, parameters);
        try {
            this.generateXsd(parameters);
        }
        catch (IOException ex) {
            throw new ModelloException("Exception while generating xsd.", (Throwable)ex);
        }
    }

    private void generateXsd(Properties parameters) throws IOException {
        Model objectModel = this.getModel();
        File directory = this.getOutputDirectory();
        if (this.isPackageWithVersion()) {
            directory = new File(directory, this.getGeneratedVersion().toString());
        }
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String xsdFileName = parameters.getProperty("modello.output.xsd.file");
        File f = new File(directory, objectModel.getId() + "-" + this.getGeneratedVersion() + ".xsd");
        if (xsdFileName != null) {
            f = new File(directory, xsdFileName);
        }
        XmlStreamWriter writer = WriterFactory.newXmlWriter((File)f);
        PrettyPrintXMLWriter w = new PrettyPrintXMLWriter((Writer)writer);
        writer.write("<?xml version=\"1.0\"?>\n");
        w.startElement("xs:schema");
        w.addAttribute("xmlns:xs", "http://www.w3.org/2001/XMLSchema");
        w.addAttribute("elementFormDefault", "qualified");
        ModelClass root = objectModel.getClass(objectModel.getRoot(this.getGeneratedVersion()), this.getGeneratedVersion());
        XsdModelMetadata modelMetadata = (XsdModelMetadata)root.getModel().getMetadata(XsdModelMetadata.ID);
        if (StringUtils.isNotEmpty((String)modelMetadata.getNamespace())) {
            w.addAttribute("xmlns", modelMetadata.getNamespace());
        } else {
            w.addAttribute("xmlns", "http://maven.apache.org/POM/4.0.0");
        }
        if (StringUtils.isNotEmpty((String)modelMetadata.getTargetNamespace())) {
            w.addAttribute("targetNamespace", modelMetadata.getTargetNamespace());
        } else {
            w.addAttribute("targetNamespace", "http://maven.apache.org/POM/4.0.0");
        }
        w.startElement("xs:element");
        String tagName = XsdGenerator.getTagName(root);
        w.addAttribute("name", tagName);
        w.addAttribute("type", root.getName());
        XsdGenerator.writeClassDocumentation((XMLWriter)w, root);
        w.endElement();
        int initialCapacity = objectModel.getClasses(this.getGeneratedVersion()).size();
        this.writeComplexTypeDescriptor((XMLWriter)w, objectModel, root, new HashSet(initialCapacity));
        w.endElement();
        writer.flush();
        writer.close();
    }

    private static void writeClassDocumentation(XMLWriter w, ModelClass modelClass) {
        XsdGenerator.writeDocumentation(w, modelClass.getVersionRange().toString(), modelClass.getDescription());
    }

    private static void writeFieldDocumentation(XMLWriter w, ModelField field) {
        XsdGenerator.writeDocumentation(w, field.getVersionRange().toString(), field.getDescription());
    }

    private static void writeDocumentation(XMLWriter w, String version, String description) {
        if (version != null || description != null) {
            w.startElement("xs:annotation");
            if (version != null) {
                w.startElement("xs:documentation");
                w.addAttribute("source", "version");
                w.writeText(version);
                w.endElement();
            }
            if (description != null) {
                w.startElement("xs:documentation");
                w.addAttribute("source", "description");
                w.writeText(description);
                w.endElement();
            }
            w.endElement();
        }
    }

    private void writeComplexTypeDescriptor(XMLWriter w, Model objectModel, ModelClass modelClass, Set written) {
        boolean mixedContent;
        written.add(modelClass);
        w.startElement("xs:complexType");
        w.addAttribute("name", modelClass.getName());
        List fields = this.getFieldsForClass(modelClass);
        boolean hasContentField = this.hasContentField(fields);
        List attributeFields = this.getAttributeFieldsForClass(modelClass);
        fields.removeAll(attributeFields);
        boolean bl = mixedContent = hasContentField && fields.size() > 0;
        if (mixedContent) {
            w.addAttribute("mixed", "true");
        } else if (hasContentField) {
            w.startElement("xs:simpleContent");
            w.startElement("xs:extension");
            w.addAttribute("base", "xs:string");
        }
        XsdGenerator.writeClassDocumentation(w, modelClass);
        HashSet<ModelClass> toWrite = new HashSet<ModelClass>();
        if (fields.size() > 0) {
            XsdClassMetadata metadata = (XsdClassMetadata)modelClass.getMetadata(XsdClassMetadata.ID);
            boolean compositorAll = "all".equals(metadata.getCompositor());
            if (mixedContent || !hasContentField) {
                if (compositorAll) {
                    w.startElement("xs:all");
                } else {
                    w.startElement("xs:sequence");
                }
            }
            Iterator j = fields.iterator();
            while (j.hasNext()) {
                String xsdType;
                ModelField field = (ModelField)j.next();
                if (!hasContentField) {
                    w.startElement("xs:element");
                }
                if (!hasContentField) {
                    w.addAttribute("minOccurs", "0");
                }
                if ((xsdType = XsdGenerator.getXsdType(field.getType())) != null) {
                    w.addAttribute("name", this.resolveFieldTagName(field));
                    w.addAttribute("type", xsdType);
                    if (field.getDefaultValue() != null) {
                        w.addAttribute("default", field.getDefaultValue());
                    }
                    XsdGenerator.writeFieldDocumentation(w, field);
                } else if (this.isInnerAssociation(field)) {
                    ModelAssociation association = (ModelAssociation)field;
                    ModelClass fieldModelClass = objectModel.getClass(association.getTo(), this.getGeneratedVersion());
                    toWrite.add(fieldModelClass);
                    if ("*".equals(association.getMultiplicity())) {
                        XmlFieldMetadata fieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
                        if ("wrapped".equals(fieldMetadata.getListStyle())) {
                            w.addAttribute("name", this.resolveFieldTagName(field));
                            XsdGenerator.writeFieldDocumentation(w, field);
                            this.writeListElement(w, field, fieldModelClass.getName());
                        } else {
                            if (compositorAll) {
                                throw new IllegalStateException(field.getName() + " field is declared as xml.listStyle=\"flat\" " + "then class " + modelClass.getName() + " MUST be declared as xsd.compositor=\"sequence\"");
                            }
                            if (mixedContent) {
                                w.startElement("xs:element");
                                w.addAttribute("minOccurs", "0");
                            }
                            if (fieldMetadata != null && fieldMetadata.getAssociationTagName() != null) {
                                w.addAttribute("name", fieldMetadata.getAssociationTagName());
                            } else {
                                w.addAttribute("name", this.singular(association.getName()));
                            }
                            w.addAttribute("type", fieldModelClass.getName());
                            w.addAttribute("maxOccurs", "unbounded");
                            XsdGenerator.writeFieldDocumentation(w, field);
                            if (mixedContent) {
                                w.endElement();
                            }
                        }
                    } else {
                        w.addAttribute("name", this.resolveFieldTagName(field));
                        w.addAttribute("type", fieldModelClass.getName());
                        XsdGenerator.writeFieldDocumentation(w, field);
                    }
                } else if ((class$java$util$List == null ? XsdGenerator.class$("java.util.List") : class$java$util$List).getName().equals(field.getType())) {
                    XsdGenerator.writeFieldDocumentation(w, field);
                    this.writeListElement(w, field, XsdGenerator.getXsdType("String"));
                } else if ((class$java$util$Properties == null ? XsdGenerator.class$("java.util.Properties") : class$java$util$Properties).getName().equals(field.getType()) || "DOM".equals(field.getType())) {
                    XsdGenerator.writeFieldDocumentation(w, field);
                    this.writePropertiesElement(w);
                } else if (!"Content".equals(field.getType())) {
                    throw new IllegalStateException("Non-association field of a non-primitive type '" + field.getType() + "' for '" + field.getName() + "'");
                }
                if (hasContentField) continue;
                w.endElement();
            }
            if (!hasContentField || mixedContent) {
                w.endElement();
            }
        }
        Iterator j = attributeFields.iterator();
        while (j.hasNext()) {
            ModelField field = (ModelField)j.next();
            w.startElement("xs:attribute");
            String xsdType = XsdGenerator.getXsdType(field.getType());
            String tagName = this.resolveFieldTagName(field);
            w.addAttribute("name", tagName);
            if (xsdType != null) {
                w.addAttribute("type", xsdType);
                if (field.getDefaultValue() != null) {
                    w.addAttribute("default", field.getDefaultValue());
                }
            } else {
                throw new IllegalStateException("Attribute field of a non-primitive type '" + field.getType() + "' for '" + field.getName() + "'");
            }
            XsdGenerator.writeFieldDocumentation(w, field);
            w.endElement();
        }
        if (hasContentField && !mixedContent) {
            w.endElement();
            w.endElement();
        }
        w.endElement();
        Iterator iter = toWrite.iterator();
        while (iter.hasNext()) {
            ModelClass fieldModelClass = (ModelClass)iter.next();
            if (written.contains(fieldModelClass)) continue;
            this.writeComplexTypeDescriptor(w, objectModel, fieldModelClass, written);
        }
    }

    private static String getTagName(ModelClass modelClass) {
        ModelClassMetadata metadata = (ModelClassMetadata)modelClass.getMetadata(ModelClassMetadata.ID);
        String tagName = metadata == null || metadata.getTagName() == null ? XsdGenerator.uncapitalise((String)modelClass.getName()) : metadata.getTagName();
        return tagName;
    }

    private void writePropertiesElement(XMLWriter w) {
        w.startElement("xs:complexType");
        w.startElement("xs:sequence");
        w.startElement("xs:any");
        w.addAttribute("minOccurs", "0");
        w.addAttribute("maxOccurs", "unbounded");
        w.addAttribute("processContents", "skip");
        w.endElement();
        w.endElement();
        w.endElement();
    }

    private void writeListElement(XMLWriter w, ModelField field, String type) {
        w.startElement("xs:complexType");
        w.startElement("xs:sequence");
        w.startElement("xs:element");
        w.addAttribute("name", this.singular(field.getName()));
        w.addAttribute("minOccurs", "0");
        w.addAttribute("maxOccurs", "unbounded");
        w.addAttribute("type", type);
        w.endElement();
        w.endElement();
        w.endElement();
    }

    private static String getXsdType(String type) {
        if ("String".equals(type)) {
            return "xs:string";
        }
        if ("int".equals(type)) {
            return "xs:int";
        }
        if ("boolean".equals(type)) {
            return "xs:boolean";
        }
        if ("long".equals(type)) {
            return "xs:long";
        }
        if ("Date".equals(type)) {
            return "xs:date";
        }
        if ("float".equals(type)) {
            return "xs:float";
        }
        if ("double".equals(type)) {
            return "xs:double";
        }
        return null;
    }
}

