/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.jpox.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.metadata.AbstractMetadataPlugin;
import org.codehaus.modello.metadata.AssociationMetadata;
import org.codehaus.modello.metadata.ClassMetadata;
import org.codehaus.modello.metadata.FieldMetadata;
import org.codehaus.modello.metadata.ModelMetadata;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugin.jpox.metadata.JPoxAssociationMetadata;
import org.codehaus.modello.plugin.jpox.metadata.JPoxClassMetadata;
import org.codehaus.modello.plugin.jpox.metadata.JPoxFieldMetadata;
import org.codehaus.modello.plugin.jpox.metadata.JPoxModelMetadata;
import org.codehaus.plexus.util.StringUtils;

public class JPoxMetadataPlugin
extends AbstractMetadataPlugin {
    public static final String ENABLED = "jpox.enabled";
    public static final String DEPENDENT = "jpox.dependent";
    public static final String DETACHABLE = "jpox.detachable";
    public static final String FETCH_GROUPS = "jpox.fetch-groups";
    public static final String NOT_PERSISTED_FIELDS = "jpox.not-persisted-fields";
    public static final String JOIN = "jpox.join";
    public static final String MAPPED_BY = "jpox.mapped-by";
    public static final String NULL_VALUE = "jpox.null-value";
    public static final String TABLE = "jpox.table";
    public static final String TABLE_PREFIX = "jpox.table-prefix";
    public static final String COLUMN = "jpox.column";
    public static final String COLUMN_PREFIX = "jpox.column-prefix";
    public static final String RESERVED_WORD_STRICTNESS = "jpox.reserved-word-strictness";
    public static final String MAPPING_IN_PACKAGE = "jpox.mapping-in-package";
    public static final String JOIN_TABLE = "jpox.join-table";
    public static final String INDEXED = "jpox.indexed";
    public static final String PRIMARY_KEY = "jpox.primary-key";
    public static final String UNIQUE = "jpox.unique";
    public static final String FOREIGN_KEY_DEFERRED = "jpox.foreign-key-deferred";
    public static final String FOREIGN_KEY_DELETE_ACTION = "jpox.foreign-key-delete-action";
    public static final String FOREIGN_KEY_UPDATE_ACTION = "jpox.foreign-key-update-action";
    public static final String VALUE_STRATEGY = "jpox.value-strategy";
    public static final String PERSISTENCE_MODIFIER = "jpox.persistence-modifier";
    public static final String IDENTITY_TYPE = "jpox.identity-type";
    public static final String IDENTITY_CLASS = "jpox.identity-class";
    public static final String USE_IDENTIFIERS = "jpox.use-identifiers-as-primary-key";

    public ModelMetadata getModelMetadata(Model model, Map data) {
        String tablePrefix;
        JPoxModelMetadata metadata = new JPoxModelMetadata();
        String columnPrefix = (String)data.get(COLUMN_PREFIX);
        if (StringUtils.isNotEmpty((String)columnPrefix)) {
            metadata.setColumnPrefix(columnPrefix);
        }
        if (StringUtils.isNotEmpty((String)(tablePrefix = (String)data.get(TABLE_PREFIX)))) {
            metadata.setTablePrefix(tablePrefix);
        }
        metadata.setMappingInPackage(this.getBoolean(data, MAPPING_IN_PACKAGE, false));
        String reservedWordStrictness = (String)data.get(RESERVED_WORD_STRICTNESS);
        metadata.setReservedWordStrictness("warning");
        if (StringUtils.isNotEmpty((String)reservedWordStrictness)) {
            if ("error".equalsIgnoreCase(reservedWordStrictness)) {
                metadata.setReservedWordStrictness("error");
            } else if ("warning".equalsIgnoreCase(reservedWordStrictness)) {
                metadata.setReservedWordStrictness("warning");
            } else {
                this.getLogger().warn("Unknown reserved word strictness value: '" + reservedWordStrictness + "'.  " + "Only '" + "error" + "' and '" + "warning" + "' are acceptable inputs.  Defaulting to 'warning'.");
            }
        }
        return metadata;
    }

    public ClassMetadata getClassMetadata(ModelClass clazz, Map data) throws ModelloException {
        String identityClass;
        String identityType;
        String columnPrefix;
        String table;
        JPoxClassMetadata metadata = new JPoxClassMetadata();
        metadata.setEnabled(this.getBoolean(data, ENABLED, true));
        metadata.setDetachable(this.getBoolean(data, DETACHABLE, true));
        String notPersistedFields = (String)data.get(NOT_PERSISTED_FIELDS);
        if (!StringUtils.isEmpty((String)notPersistedFields)) {
            List<String> ignoredFields = Arrays.asList(StringUtils.split((String)notPersistedFields));
            metadata.setNotPersisted(ignoredFields);
        }
        if (!StringUtils.isEmpty((String)(table = (String)data.get(TABLE)))) {
            metadata.setTable(table);
        }
        if (!StringUtils.isEmpty((String)(columnPrefix = (String)data.get(COLUMN_PREFIX)))) {
            metadata.setColumnPrefix(columnPrefix);
        }
        if (StringUtils.isNotEmpty((String)(identityType = (String)data.get(IDENTITY_TYPE)))) {
            metadata.setIdentityType(identityType);
        }
        if (StringUtils.isNotEmpty((String)(identityClass = (String)data.get(IDENTITY_CLASS)))) {
            metadata.setIdentityClass(identityClass);
        }
        metadata.setUseIdentifiersAsPrimaryKey(this.getBoolean(data, USE_IDENTIFIERS, true));
        return metadata;
    }

    public FieldMetadata getFieldMetadata(ModelField field, Map data) throws ModelloException {
        String persistenceModifier;
        String indexed;
        String joinTable;
        String column;
        String nullValue;
        String mappedBy;
        JPoxFieldMetadata metadata = new JPoxFieldMetadata();
        JPoxClassMetadata classMetadata = (JPoxClassMetadata)field.getModelClass().getMetadata(JPoxClassMetadata.ID);
        boolean useIdentifiersAsPrimaryKey = classMetadata.useIdentifiersAsPrimaryKey();
        metadata.setPrimaryKey(this.getBoolean(data, PRIMARY_KEY, field.isIdentifier() && useIdentifiersAsPrimaryKey));
        String fetchGroupNames = (String)data.get("jpox.fetchGroupNames");
        if (fetchGroupNames != null) {
            this.getLogger().warn("You are using the <field jpox.fetchGroupNames=\"\"> attribute syntax.  It has been deprecated in favor of the <field jpox.fetch-groups=\"\"> syntax instead.");
        } else {
            fetchGroupNames = (String)data.get(FETCH_GROUPS);
        }
        if (!StringUtils.isEmpty((String)fetchGroupNames)) {
            List<String> fetchGroups = Arrays.asList(StringUtils.split((String)fetchGroupNames));
            metadata.setFetchGroupNames(fetchGroups);
        }
        if ((mappedBy = (String)data.get("jpox.mappedBy")) != null) {
            this.getLogger().warn("You are using the <field jpox.mappedBy=\"\"> attribute syntax.  It has been deprecated in favor of the <field jpox.mapped-by=\"\"> syntax instead.");
        } else {
            mappedBy = (String)data.get(MAPPED_BY);
        }
        if (!StringUtils.isEmpty((String)mappedBy)) {
            metadata.setMappedBy(mappedBy);
        }
        if ((nullValue = (String)data.get("jpox.nullValue")) != null) {
            this.getLogger().warn("You are using the <field jpox.nullValue=\"\"> attribute syntax.  It has been deprecated in favor of the <field jpox.null-value=\"\"> syntax instead.");
        } else {
            nullValue = (String)data.get(NULL_VALUE);
        }
        if (!StringUtils.isEmpty((String)nullValue)) {
            metadata.setNullValue(nullValue);
        }
        if (StringUtils.isNotEmpty((String)(column = (String)data.get(COLUMN)))) {
            metadata.setColumnName(column);
        }
        if (StringUtils.isNotEmpty((String)(joinTable = (String)data.get(JOIN_TABLE)))) {
            metadata.setJoinTableName(joinTable);
        }
        if (StringUtils.isNotEmpty((String)(indexed = (String)data.get(INDEXED)))) {
            metadata.setIndexed(indexed);
        }
        if (StringUtils.isNotEmpty((String)(persistenceModifier = (String)data.get(PERSISTENCE_MODIFIER)))) {
            metadata.setPersistenceModifier(persistenceModifier);
        }
        metadata.setValueStrategy("native");
        if (StringUtils.isNotEmpty((String)((String)data.get(VALUE_STRATEGY)))) {
            String valueStrategy = (String)data.get(VALUE_STRATEGY);
            if (StringUtils.equals((String)valueStrategy, (String)"off")) {
                metadata.setValueStrategy(null);
            } else {
                metadata.setValueStrategy(valueStrategy);
            }
        }
        metadata.setUnique(this.getBoolean(data, UNIQUE, false));
        metadata.setForeignKey(this.getBoolean(data, FOREIGN_KEY_DEFERRED, false));
        metadata.setForeignKeyDeferred(this.getEnumString(data, FOREIGN_KEY_DEFERRED, JPoxFieldMetadata.BOOLEANS, null));
        metadata.setForeignKeyDeleteAction(this.getEnumString(data, FOREIGN_KEY_DELETE_ACTION, JPoxFieldMetadata.FOREIGN_KEY_ACTIONS, null));
        metadata.setForeignKeyUpdateAction(this.getEnumString(data, FOREIGN_KEY_UPDATE_ACTION, JPoxFieldMetadata.FOREIGN_KEY_ACTIONS, null));
        return metadata;
    }

    public AssociationMetadata getAssociationMetadata(ModelAssociation association, Map data) throws ModelloException {
        JPoxAssociationMetadata metadata = new JPoxAssociationMetadata();
        metadata.setDependent(this.getBoolean(data, DEPENDENT, true));
        metadata.setJoin(this.getBoolean(data, JOIN, true));
        return metadata;
    }

    protected String getString(Map data, String key, String defaultValue) {
        String value = (String)data.get(key);
        if (StringUtils.isEmpty((String)value)) {
            return defaultValue;
        }
        return value;
    }

    protected String getEnumString(Map data, String key, String[] legalValues, String defaultValue) throws ModelloException {
        String value = (String)data.get(key);
        if (StringUtils.isEmpty((String)value)) {
            return defaultValue;
        }
        for (int i = 0; i < legalValues.length; ++i) {
            String enumString = legalValues[i];
            if (!StringUtils.equals((String)enumString, (String)value)) continue;
            return value;
        }
        String emsg = "Unknown " + key + " value: '" + value + "'.  " + "(Allowed values: " + legalValues + ")";
        throw new ModelloException(emsg);
    }

    public Map getFieldMap(ModelField field, FieldMetadata metadata) {
        return Collections.EMPTY_MAP;
    }
}

