/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.java;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.ModelloRuntimeException;
import org.codehaus.modello.metadata.Metadata;
import org.codehaus.modello.model.BaseElement;
import org.codehaus.modello.model.CodeSegment;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelDefault;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.model.ModelInterface;
import org.codehaus.modello.plugin.java.AbstractJavaModelloGenerator;
import org.codehaus.modello.plugin.java.javasource.JArrayType;
import org.codehaus.modello.plugin.java.javasource.JClass;
import org.codehaus.modello.plugin.java.javasource.JCollectionType;
import org.codehaus.modello.plugin.java.javasource.JConstructor;
import org.codehaus.modello.plugin.java.javasource.JDocDescriptor;
import org.codehaus.modello.plugin.java.javasource.JField;
import org.codehaus.modello.plugin.java.javasource.JInterface;
import org.codehaus.modello.plugin.java.javasource.JMapType;
import org.codehaus.modello.plugin.java.javasource.JMethod;
import org.codehaus.modello.plugin.java.javasource.JMethodSignature;
import org.codehaus.modello.plugin.java.javasource.JParameter;
import org.codehaus.modello.plugin.java.javasource.JSourceCode;
import org.codehaus.modello.plugin.java.javasource.JSourceWriter;
import org.codehaus.modello.plugin.java.javasource.JType;
import org.codehaus.modello.plugin.java.metadata.JavaAssociationMetadata;
import org.codehaus.modello.plugin.java.metadata.JavaClassMetadata;
import org.codehaus.modello.plugin.java.metadata.JavaFieldMetadata;
import org.codehaus.modello.plugin.model.ModelClassMetadata;
import org.codehaus.plexus.util.StringUtils;

public class JavaModelloGenerator
extends AbstractJavaModelloGenerator {
    private Collection<String> immutableTypes = new HashSet<String>(Arrays.asList("boolean", "Boolean", "byte", "Byte", "char", "Character", "short", "Short", "int", "Integer", "long", "Long", "float", "Float", "double", "Double", "String"));

    public void generate(Model model, Properties parameters) throws ModelloException {
        this.initialize(model, parameters);
        try {
            this.generateJava();
        }
        catch (IOException ex) {
            throw new ModelloException("Exception while generating Java.", (Throwable)ex);
        }
    }

    private void generateJava() throws ModelloException, IOException {
        Model objectModel = this.getModel();
        ModelClass locationTrackerClass = objectModel.getLocationTracker(this.getGeneratedVersion());
        ModelClass sourceTrackerClass = objectModel.getSourceTracker(this.getGeneratedVersion());
        for (ModelInterface modelInterface : objectModel.getInterfaces(this.getGeneratedVersion())) {
            this.generateInterface(modelInterface);
        }
        String locationTrackerInterface = this.generateLocationTracker(objectModel, locationTrackerClass);
        for (ModelClass modelClass : objectModel.getClasses(this.getGeneratedVersion())) {
            ModelClassMetadata modelClassMetadata;
            boolean cloneLocations;
            JMethod[] cloneMethods;
            List identifierFields;
            Object annotation2;
            JavaClassMetadata javaClassMetadata = (JavaClassMetadata)modelClass.getMetadata(JavaClassMetadata.ID);
            if (!javaClassMetadata.isEnabled()) continue;
            String packageName = modelClass.getPackageName(this.isPackageWithVersion(), this.getGeneratedVersion());
            JSourceWriter sourceWriter = this.newJSourceWriter(packageName, modelClass.getName());
            JClass jClass = new JClass(packageName + '.' + modelClass.getName());
            this.initHeader(jClass);
            this.suppressAllWarnings(objectModel, jClass);
            if (StringUtils.isNotEmpty((String)modelClass.getDescription())) {
                jClass.getJDocComment().setComment(this.appendPeriod(modelClass.getDescription()));
            }
            this.addModelImports(jClass, (BaseElement)modelClass);
            jClass.getModifiers().setAbstract(javaClassMetadata.isAbstract());
            boolean superClassInModel = false;
            if (modelClass.getSuperClass() != null) {
                jClass.setSuperClass(modelClass.getSuperClass());
                superClassInModel = this.isClassInModel(modelClass.getSuperClass(), objectModel);
            }
            for (String implementedInterface : modelClass.getInterfaces()) {
                jClass.addInterface(implementedInterface);
            }
            jClass.addInterface(Serializable.class.getName());
            if (this.hasJavaSourceSupport(5) && !modelClass.getAnnotations().isEmpty()) {
                for (Object annotation2 : modelClass.getAnnotations()) {
                    jClass.appendAnnotation((String)annotation2);
                }
            }
            JSourceCode jConstructorSource = new JSourceCode();
            annotation2 = modelClass.getFields(this.getGeneratedVersion()).iterator();
            while (annotation2.hasNext()) {
                ModelField modelField = (ModelField)annotation2.next();
                if (modelField instanceof ModelAssociation) {
                    this.createAssociation(jClass, (ModelAssociation)modelField, jConstructorSource);
                    continue;
                }
                this.createField(jClass, modelField);
            }
            JConstructor jConstructor = null;
            if (!jConstructorSource.isEmpty()) {
                jConstructor = jClass.createConstructor();
                jConstructor.setSourceCode(jConstructorSource);
                jClass.addConstructor(jConstructor);
            }
            if ((identifierFields = modelClass.getIdentifierFields(this.getGeneratedVersion())).size() != 0) {
                JMethod equals = this.generateEquals(modelClass);
                jClass.addMethod(equals);
                JMethod hashCode = this.generateHashCode(modelClass);
                jClass.addMethod(hashCode);
                if (!javaClassMetadata.isGenerateToString()) {
                    JMethod toString = this.generateToString(modelClass, true);
                    jClass.addMethod(toString);
                }
            }
            if (javaClassMetadata.isGenerateToString()) {
                JMethod toString = this.generateToString(modelClass, false);
                jClass.addMethod(toString);
            }
            if (javaClassMetadata.isGenerateBuilder()) {
                this.generateBuilder(modelClass, jClass.createInnerClass("Builder"), jConstructor);
            }
            if (javaClassMetadata.isGenerateStaticCreators()) {
                this.generateStaticCreator(modelClass, jClass, jConstructor);
            }
            if ((cloneMethods = this.generateClone(modelClass, (ModelClass)((cloneLocations = !superClassInModel && modelClass != sourceTrackerClass) ? locationTrackerClass : null))).length > 0) {
                jClass.addInterface(Cloneable.class.getName());
                jClass.addMethods(cloneMethods);
            }
            if (modelClass.getCodeSegments(this.getGeneratedVersion()) != null) {
                for (CodeSegment codeSegment : modelClass.getCodeSegments(this.getGeneratedVersion())) {
                    jClass.addSourceCode(codeSegment.getCode());
                }
            }
            if ((modelClassMetadata = (ModelClassMetadata)modelClass.getMetadata(ModelClassMetadata.ID)) != null && modelClassMetadata.isRootElement()) {
                ModelField modelEncoding = new ModelField(modelClass, "modelEncoding");
                modelEncoding.setType("String");
                modelEncoding.setDefaultValue("UTF-8");
                modelEncoding.addMetadata((Metadata)new JavaFieldMetadata());
                this.createField(jClass, modelEncoding);
            }
            if (modelClass == locationTrackerClass) {
                jClass.addInterface(locationTrackerInterface);
                this.generateLocationBean(jClass, modelClass, sourceTrackerClass);
                this.generateLocationTracking(jClass, modelClass, locationTrackerClass);
            } else if (locationTrackerClass != null && modelClass != sourceTrackerClass && !superClassInModel) {
                jClass.addInterface(locationTrackerInterface);
                this.generateLocationTracking(jClass, modelClass, locationTrackerClass);
            }
            jClass.print(sourceWriter);
            sourceWriter.close();
        }
    }

    private void generateInterface(ModelInterface modelInterface) throws ModelloException, IOException {
        Model objectModel = modelInterface.getModel();
        String packageName = modelInterface.getPackageName(this.isPackageWithVersion(), this.getGeneratedVersion());
        JSourceWriter sourceWriter = this.newJSourceWriter(packageName, modelInterface.getName());
        JInterface jInterface = new JInterface(packageName + '.' + modelInterface.getName());
        this.initHeader(jInterface);
        this.suppressAllWarnings(objectModel, jInterface);
        if (modelInterface.getSuperInterface() != null) {
            try {
                ModelInterface superInterface = objectModel.getInterface(modelInterface.getSuperInterface(), this.getGeneratedVersion());
                String superPackageName = superInterface.getPackageName(this.isPackageWithVersion(), this.getGeneratedVersion());
                if (!packageName.equals(superPackageName)) {
                    jInterface.addImport(superPackageName + '.' + superInterface.getName());
                }
            }
            catch (ModelloRuntimeException modelloRuntimeException) {
                // empty catch block
            }
            jInterface.addInterface(modelInterface.getSuperInterface());
        }
        if (modelInterface.getCodeSegments(this.getGeneratedVersion()) != null) {
            for (CodeSegment codeSegment : modelInterface.getCodeSegments(this.getGeneratedVersion())) {
                jInterface.addSourceCode(codeSegment.getCode());
            }
        }
        if (this.hasJavaSourceSupport(5) && !modelInterface.getAnnotations().isEmpty()) {
            for (String annotation : modelInterface.getAnnotations()) {
                jInterface.appendAnnotation(annotation);
            }
        }
        jInterface.print(sourceWriter);
        sourceWriter.close();
    }

    private JMethod generateEquals(ModelClass modelClass) {
        JMethod equals = new JMethod("equals", JType.BOOLEAN, null);
        equals.addParameter(new JParameter(new JClass("Object"), "other"));
        JSourceCode sc = equals.getSourceCode();
        sc.add("if ( this == other )");
        sc.add("{");
        sc.addIndented("return true;");
        sc.add("}");
        sc.add("");
        sc.add("if ( !( other instanceof " + modelClass.getName() + " ) )");
        sc.add("{");
        sc.addIndented("return false;");
        sc.add("}");
        sc.add("");
        sc.add(modelClass.getName() + " that = (" + modelClass.getName() + ") other;");
        sc.add("boolean result = true;");
        sc.add("");
        for (ModelField identifier : modelClass.getIdentifierFields(this.getGeneratedVersion())) {
            String name = identifier.getName();
            if ("boolean".equals(identifier.getType()) || "byte".equals(identifier.getType()) || "char".equals(identifier.getType()) || "double".equals(identifier.getType()) || "float".equals(identifier.getType()) || "int".equals(identifier.getType()) || "short".equals(identifier.getType()) || "long".equals(identifier.getType())) {
                sc.add("result = result && " + name + " == that." + name + ";");
                continue;
            }
            name = "get" + this.capitalise(name) + "()";
            sc.add("result = result && ( " + name + " == null ? that." + name + " == null : " + name + ".equals( that." + name + " ) );");
        }
        if (modelClass.getSuperClass() != null) {
            sc.add("result = result && ( super.equals( other ) );");
        }
        sc.add("");
        sc.add("return result;");
        return equals;
    }

    private JMethod generateToString(ModelClass modelClass, boolean onlyIdentifierFields) {
        JMethod toString = new JMethod("toString", new JType(String.class.getName()), null);
        List fields = onlyIdentifierFields ? modelClass.getIdentifierFields(this.getGeneratedVersion()) : modelClass.getFields(this.getGeneratedVersion());
        JSourceCode sc = toString.getSourceCode();
        if (fields.size() == 0) {
            sc.add("return super.toString();");
            return toString;
        }
        sc.add("StringBuilder buf = new StringBuilder( 128 );");
        sc.add("");
        Iterator j = fields.iterator();
        while (j.hasNext()) {
            ModelField identifier = (ModelField)j.next();
            String getter = "boolean".equals(identifier.getType()) ? "is" : "get";
            sc.add("buf.append( \"" + identifier.getName() + " = '\" );");
            sc.add("buf.append( " + getter + this.capitalise(identifier.getName()) + "() );");
            sc.add("buf.append( \"'\" );");
            if (!j.hasNext()) continue;
            sc.add("buf.append( \"\\n\" ); ");
        }
        if (modelClass.getSuperClass() != null) {
            sc.add("buf.append( \"\\n\" );");
            sc.add("buf.append( super.toString() );");
        }
        sc.add("");
        sc.add("return buf.toString();");
        return toString;
    }

    private JMethod generateHashCode(ModelClass modelClass) {
        JMethod hashCode = new JMethod("hashCode", JType.INT, null);
        List identifierFields = modelClass.getIdentifierFields(this.getGeneratedVersion());
        JSourceCode sc = hashCode.getSourceCode();
        if (identifierFields.size() == 0) {
            sc.add("return super.hashCode();");
            return hashCode;
        }
        sc.add("int result = 17;");
        sc.add("");
        for (ModelField identifier : identifierFields) {
            sc.add("result = 37 * result + " + this.createHashCodeForField(identifier) + ";");
        }
        if (modelClass.getSuperClass() != null) {
            sc.add("result = 37 * result + super.hashCode();");
        }
        sc.add("");
        sc.add("return result;");
        return hashCode;
    }

    private JMethod[] generateClone(ModelClass modelClass, ModelClass locationClass) throws ModelloException {
        String cloneHook;
        String cloneModeClass = this.getCloneMode(modelClass);
        if ("none".equals(cloneModeClass)) {
            return new JMethod[0];
        }
        boolean useJava5 = this.hasJavaSourceSupport(5);
        JClass returnType = useJava5 ? new JClass(modelClass.getName()) : new JClass("Object");
        JMethod cloneMethod = new JMethod("clone", returnType, null);
        JSourceCode sc = cloneMethod.getSourceCode();
        sc.add("try");
        sc.add("{");
        sc.indent();
        sc.add(modelClass.getName() + " copy = (" + modelClass.getName() + ") super.clone();");
        sc.add("");
        for (ModelField modelField : modelClass.getFields(this.getGeneratedVersion())) {
            boolean deepClone;
            String thisField = "this." + modelField.getName();
            String copyField = "copy." + modelField.getName();
            if ("DOM".equals(modelField.getType())) {
                sc.add("if ( " + thisField + " != null )");
                sc.add("{");
                if (this.domAsXpp3) {
                    sc.addIndented(copyField + " = new org.codehaus.plexus.util.xml.Xpp3Dom( (org.codehaus.plexus.util.xml.Xpp3Dom) " + thisField + " );");
                } else {
                    sc.addIndented(copyField + " = ( (org.w3c.dom.Node) " + thisField + ").cloneNode( true );");
                }
                sc.add("}");
                sc.add("");
                continue;
            }
            if ("Date".equalsIgnoreCase(modelField.getType()) || "java.util.Date".equals(modelField.getType())) {
                sc.add("if ( " + thisField + " != null )");
                sc.add("{");
                sc.addIndented(copyField + " = (java.util.Date) " + thisField + ".clone();");
                sc.add("}");
                sc.add("");
                continue;
            }
            if ("java.util.Properties".equals(modelField.getType())) {
                sc.add("if ( " + thisField + " != null )");
                sc.add("{");
                sc.addIndented(copyField + " = (" + "java.util.Properties" + ") " + thisField + ".clone();");
                sc.add("}");
                sc.add("");
                continue;
            }
            if (!(modelField instanceof ModelAssociation)) continue;
            ModelAssociation modelAssociation = (ModelAssociation)modelField;
            String cloneModeAssoc = this.getCloneMode(modelAssociation, cloneModeClass);
            boolean bl = deepClone = "deep".equals(cloneModeAssoc) && !this.immutableTypes.contains(modelAssociation.getTo());
            if (modelAssociation.isOneMultiplicity()) {
                if (!deepClone) continue;
                sc.add("if ( " + thisField + " != null )");
                sc.add("{");
                sc.addIndented(copyField + " = (" + modelAssociation.getTo() + ") " + thisField + ".clone();");
                sc.add("}");
                sc.add("");
                continue;
            }
            sc.add("if ( " + thisField + " != null )");
            sc.add("{");
            sc.indent();
            JavaAssociationMetadata javaAssociationMetadata = this.getJavaAssociationMetadata(modelAssociation);
            JType componentType = this.getComponentType(modelAssociation, javaAssociationMetadata);
            sc.add(copyField + " = " + this.getDefaultValue(modelAssociation, componentType) + ";");
            if (this.isCollection(modelField.getType())) {
                if (deepClone) {
                    if (useJava5) {
                        sc.add("for ( " + componentType.getName() + " item : " + thisField + " )");
                    } else {
                        sc.add("for ( java.util.Iterator it = " + thisField + ".iterator(); it.hasNext(); )");
                    }
                    sc.add("{");
                    sc.indent();
                    if (useJava5) {
                        sc.add(copyField + ".add( ( (" + modelAssociation.getTo() + ") item).clone() );");
                    } else {
                        sc.add(copyField + ".add( ( (" + modelAssociation.getTo() + ") it.next() ).clone() );");
                    }
                    sc.unindent();
                    sc.add("}");
                } else {
                    sc.add(copyField + ".addAll( " + thisField + " );");
                }
            } else if (this.isMap(modelField.getType())) {
                sc.add(copyField + ".clear();");
                sc.add(copyField + ".putAll( " + thisField + " );");
            }
            sc.unindent();
            sc.add("}");
            sc.add("");
        }
        if (locationClass != null) {
            String locationField = ((ModelClassMetadata)locationClass.getMetadata(ModelClassMetadata.ID)).getLocationTracker();
            sc.add("if ( copy." + locationField + " != null )");
            sc.add("{");
            sc.indent();
            sc.add("copy." + locationField + " = new java.util.LinkedHashMap( copy." + locationField + " );");
            sc.unindent();
            sc.add("}");
            sc.add("");
        }
        if (StringUtils.isNotEmpty((String)(cloneHook = this.getCloneHook(modelClass))) && !"false".equalsIgnoreCase(cloneHook)) {
            if ("true".equalsIgnoreCase(cloneHook)) {
                cloneHook = "cloneHook";
            }
            sc.add(cloneHook + "( copy );");
            sc.add("");
        }
        sc.add("return copy;");
        sc.unindent();
        sc.add("}");
        sc.add("catch ( " + Exception.class.getName() + " ex )");
        sc.add("{");
        sc.indent();
        sc.add("throw (" + RuntimeException.class.getName() + ") new " + UnsupportedOperationException.class.getName() + "( getClass().getName()");
        sc.addIndented("+ \" does not support clone()\" ).initCause( ex );");
        sc.unindent();
        sc.add("}");
        return new JMethod[]{cloneMethod};
    }

    private String getCloneMode(ModelClass modelClass) throws ModelloException {
        String superClass;
        JavaClassMetadata javaClassMetadata;
        String cloneMode = null;
        ModelClass currentClass = modelClass;
        while ((cloneMode = (javaClassMetadata = (JavaClassMetadata)currentClass.getMetadata(JavaClassMetadata.ID)).getCloneMode()) == null && !StringUtils.isEmpty((String)(superClass = currentClass.getSuperClass())) && this.isClassInModel(superClass, this.getModel())) {
            currentClass = this.getModel().getClass(superClass, this.getGeneratedVersion());
        }
        if (cloneMode == null) {
            cloneMode = "none";
        } else if (!JavaClassMetadata.CLONE_MODES.contains(cloneMode)) {
            throw new ModelloException("The Java Modello Generator cannot use '" + cloneMode + "' as a value for <class java.clone=\"...\">, only the following values are acceptable " + JavaClassMetadata.CLONE_MODES);
        }
        return cloneMode;
    }

    private String getCloneMode(ModelAssociation modelAssociation, String cloneModeClass) throws ModelloException {
        JavaAssociationMetadata javaAssociationMetadata = (JavaAssociationMetadata)modelAssociation.getAssociationMetadata(JavaAssociationMetadata.ID);
        String cloneModeAssoc = javaAssociationMetadata.getCloneMode();
        if (cloneModeAssoc == null) {
            cloneModeAssoc = cloneModeClass;
        } else if (!JavaAssociationMetadata.CLONE_MODES.contains(cloneModeAssoc)) {
            throw new ModelloException("The Java Modello Generator cannot use '" + cloneModeAssoc + "' as a value for <association java.clone=\"...\">, only the following values are acceptable " + JavaAssociationMetadata.CLONE_MODES);
        }
        return cloneModeAssoc;
    }

    private String getCloneHook(ModelClass modelClass) throws ModelloException {
        JavaClassMetadata javaClassMetadata = (JavaClassMetadata)modelClass.getMetadata(JavaClassMetadata.ID);
        return javaClassMetadata.getCloneHook();
    }

    private String generateLocationTracker(Model objectModel, ModelClass locationClass) throws ModelloException, IOException {
        if (locationClass == null) {
            return null;
        }
        String locationField = ((ModelClassMetadata)locationClass.getMetadata(ModelClassMetadata.ID)).getLocationTracker();
        String propertyName = this.capitalise(JavaModelloGenerator.singular((String)locationField));
        String interfaceName = locationClass.getName() + "Tracker";
        String packageName = locationClass.getPackageName(this.isPackageWithVersion(), this.getGeneratedVersion());
        JSourceWriter sourceWriter = this.newJSourceWriter(packageName, interfaceName);
        JInterface jInterface = new JInterface(packageName + '.' + interfaceName);
        this.initHeader(jInterface);
        this.suppressAllWarnings(objectModel, jInterface);
        JMethodSignature jMethod = new JMethodSignature("get" + propertyName, new JType(locationClass.getName()));
        jMethod.setComment("Gets the location of the specified field in the input source.");
        this.addParameter(jMethod, "Object", "field", "The key of the field, must not be <code>null</code>.");
        String returnDoc = "The location of the field in the input source or <code>null</code> if unknown.";
        jMethod.getJDocComment().addDescriptor(JDocDescriptor.createReturnDesc(returnDoc));
        jInterface.addMethod(jMethod);
        jMethod = new JMethodSignature("set" + propertyName, null);
        jMethod.setComment("Sets the location of the specified field.");
        this.addParameter(jMethod, "Object", "field", "The key of the field, must not be <code>null</code>.");
        this.addParameter(jMethod, locationClass.getName(), JavaModelloGenerator.singular((String)locationField), "The location of the field, may be <code>null</code>.");
        jInterface.addMethod(jMethod);
        jInterface.print(sourceWriter);
        sourceWriter.close();
        return jInterface.getName();
    }

    private void generateLocationTracking(JClass jClass, ModelClass modelClass, ModelClass locationClass) throws ModelloException {
        boolean hasModeSuperClass;
        if (locationClass == null) {
            return;
        }
        String superClass = modelClass.getSuperClass();
        ModelClassMetadata metadata = (ModelClassMetadata)locationClass.getMetadata(ModelClassMetadata.ID);
        String locationField = metadata.getLocationTracker();
        boolean bl = hasModeSuperClass = StringUtils.isNotEmpty((String)superClass) && this.isClassInModel(superClass, this.getModel());
        if (!hasModeSuperClass) {
            boolean useJava5 = this.hasJavaSourceSupport(5);
            String fieldType = "java.util.Map" + (useJava5 ? "<Object, " + locationClass.getName() + ">" : "");
            String fieldImpl = "java.util.LinkedHashMap" + (useJava5 ? "<Object, " + locationClass.getName() + ">" : "");
            JField jField = new JField(new JType(fieldType), locationField);
            jClass.addField(jField);
            JMethod getter = new JMethod("getOther" + this.capitalise(JavaModelloGenerator.singular((String)locationField)), new JType(locationClass.getName()), null);
            getter.addParameter(new JParameter(new JType("Object"), "key"));
            getter.getModifiers().makePrivate();
            JSourceCode getterSc = getter.getSourceCode();
            getterSc.add("return ( " + locationField + " != null ) ? " + locationField + ".get( key ) : null;");
            getter.setComment("");
            jClass.addMethod(getter);
            JMethod setter = new JMethod("setOther" + this.capitalise(JavaModelloGenerator.singular((String)locationField)));
            setter.addParameter(new JParameter(new JType("Object"), "key"));
            setter.addParameter(new JParameter(new JType(locationClass.getName()), JavaModelloGenerator.singular((String)locationField)));
            JSourceCode setterSc = setter.getSourceCode();
            setterSc.add("if ( " + JavaModelloGenerator.singular((String)locationField) + " != null )");
            setterSc.add("{");
            setterSc.indent();
            setterSc.add("if ( this." + locationField + " == null )");
            setterSc.add("{");
            setterSc.addIndented("this." + locationField + " = new " + fieldImpl + "();");
            setterSc.add("}");
            setterSc.add("this." + locationField + ".put( key, " + JavaModelloGenerator.singular((String)locationField) + " );");
            setterSc.unindent();
            setterSc.add("}");
            setter.setComment("");
            jClass.addMethod(setter);
        }
        JField ownLocation = new JField(new JType(locationClass.getName()), JavaModelloGenerator.singular((String)locationField));
        jClass.addField(ownLocation);
        for (ModelField field : modelClass.getAllFields()) {
            Iterator fieldLocation = new JField(new JType(locationClass.getName()), field.getName() + this.capitalise(JavaModelloGenerator.singular((String)locationField)));
            jClass.addField((JField)((Object)fieldLocation));
        }
        JMethod getter = new JMethod("get" + this.capitalise(JavaModelloGenerator.singular((String)locationField)), new JType(locationClass.getName()), null);
        getter.addParameter(new JParameter(new JType("Object"), "key"));
        JSourceCode getterSc = getter.getSourceCode();
        getterSc.add("if ( key instanceof String )");
        getterSc.add("{");
        getterSc.indent();
        if (this.hasJavaSourceSupport(7)) {
            getterSc.add("switch ( ( String ) key )");
            getterSc.add("{");
            getterSc.indent();
            getterSc.add("case \"\" :");
            getterSc.add("{");
            getterSc.indent();
            getterSc.add("return this." + JavaModelloGenerator.singular((String)locationField) + ";");
            getterSc.unindent();
            getterSc.add("}");
            for (ModelField field : modelClass.getAllFields()) {
                getterSc.add("case \"" + field.getName() + "\" :");
                getterSc.add("{");
                getterSc.indent();
                getterSc.add("return " + field.getName() + this.capitalise(JavaModelloGenerator.singular((String)locationField)) + ";");
                getterSc.unindent();
                getterSc.add("}");
            }
            getterSc.add("default :");
            getterSc.add("{");
            getterSc.indent();
            if (hasModeSuperClass) {
                getterSc.add("return super.get" + this.capitalise(JavaModelloGenerator.singular((String)locationField)) + "( key );");
            } else {
                getterSc.add("return getOther" + this.capitalise(JavaModelloGenerator.singular((String)locationField)) + "( key );");
            }
            getterSc.unindent();
            getterSc.add("}");
            getterSc.add("}");
        } else {
            getterSc.add("if ( \"\".equals( key ) )");
            getterSc.add("{");
            getterSc.indent();
            getterSc.add("return this." + JavaModelloGenerator.singular((String)locationField) + ";");
            getterSc.unindent();
            getterSc.add("}");
            for (ModelField field : modelClass.getAllFields()) {
                getterSc.add("else if ( \"" + field.getName() + "\".equals( key ) )");
                getterSc.add("{");
                getterSc.indent();
                getterSc.add("return " + field.getName() + this.capitalise(JavaModelloGenerator.singular((String)locationField)) + ";");
                getterSc.unindent();
                getterSc.add("}");
            }
            getterSc.add("else");
            getterSc.add("{");
            getterSc.indent();
            if (hasModeSuperClass) {
                getterSc.add("return super.get" + this.capitalise(JavaModelloGenerator.singular((String)locationField)) + "( key );");
            } else {
                getterSc.add("return getOther" + this.capitalise(JavaModelloGenerator.singular((String)locationField)) + "( key );");
            }
            getterSc.unindent();
            getterSc.add("}");
        }
        getterSc.unindent();
        getterSc.add("}");
        getterSc.add("else");
        getterSc.add("{");
        getterSc.indent();
        if (hasModeSuperClass) {
            getterSc.add("return super.get" + this.capitalise(JavaModelloGenerator.singular((String)locationField)) + "( key );");
        } else {
            getterSc.add("return getOther" + this.capitalise(JavaModelloGenerator.singular((String)locationField)) + "( key );");
        }
        getterSc.unindent();
        getterSc.add("}");
        getter.setComment("");
        jClass.addMethod(getter);
        JMethod setter = new JMethod("set" + this.capitalise(JavaModelloGenerator.singular((String)locationField)));
        setter.addParameter(new JParameter(new JType("Object"), "key"));
        setter.addParameter(new JParameter(new JType(locationClass.getName()), JavaModelloGenerator.singular((String)locationField)));
        JSourceCode setterSc = setter.getSourceCode();
        setterSc.add("if ( key instanceof String )");
        setterSc.add("{");
        setterSc.indent();
        if (this.hasJavaSourceSupport(7)) {
            setterSc.add("switch ( ( String ) key )");
            setterSc.add("{");
            setterSc.indent();
            setterSc.add("case \"\" :");
            setterSc.add("{");
            setterSc.indent();
            setterSc.add("this." + JavaModelloGenerator.singular((String)locationField) + " = " + JavaModelloGenerator.singular((String)locationField) + ";");
            setterSc.add("return;");
            setterSc.unindent();
            setterSc.add("}");
            for (ModelField field : modelClass.getAllFields()) {
                setterSc.add("case \"" + field.getName() + "\" :");
                setterSc.add("{");
                setterSc.indent();
                setterSc.add(field.getName() + this.capitalise(JavaModelloGenerator.singular((String)locationField)) + " = " + JavaModelloGenerator.singular((String)locationField) + ";");
                setterSc.add("return;");
                setterSc.unindent();
                setterSc.add("}");
            }
            setterSc.add("default :");
            setterSc.add("{");
            setterSc.indent();
            if (hasModeSuperClass) {
                setterSc.add("super.set" + this.capitalise(JavaModelloGenerator.singular((String)locationField)) + "( key, " + JavaModelloGenerator.singular((String)locationField) + " );");
            } else {
                setterSc.add("setOther" + this.capitalise(JavaModelloGenerator.singular((String)locationField)) + "( key, " + JavaModelloGenerator.singular((String)locationField) + " );");
            }
            setterSc.add("return;");
            setterSc.unindent();
            setterSc.add("}");
            setterSc.unindent();
            setterSc.add("}");
        } else {
            setterSc.add("if ( \"\".equals( key ) )");
            setterSc.add("{");
            setterSc.indent();
            setterSc.add("this." + JavaModelloGenerator.singular((String)locationField) + " = " + JavaModelloGenerator.singular((String)locationField) + ";");
            setterSc.add("return;");
            setterSc.unindent();
            setterSc.add("}");
            for (ModelField field : modelClass.getAllFields()) {
                setterSc.add("else if ( \"" + field.getName() + "\".equals( key ) )");
                setterSc.add("{");
                setterSc.indent();
                setterSc.add(field.getName() + this.capitalise(JavaModelloGenerator.singular((String)locationField)) + " = " + JavaModelloGenerator.singular((String)locationField) + ";");
                setterSc.add("return;");
                setterSc.unindent();
                setterSc.add("}");
            }
            setterSc.add("else");
            setterSc.add("{");
            setterSc.indent();
            if (hasModeSuperClass) {
                setterSc.add("super.set" + this.capitalise(JavaModelloGenerator.singular((String)locationField)) + "( key, " + JavaModelloGenerator.singular((String)locationField) + " );");
            } else {
                setterSc.add("setOther" + this.capitalise(JavaModelloGenerator.singular((String)locationField)) + "( key, " + JavaModelloGenerator.singular((String)locationField) + " );");
            }
            setterSc.add("return;");
            setterSc.unindent();
            setterSc.add("}");
        }
        setterSc.unindent();
        setterSc.add("}");
        setterSc.add("else");
        setterSc.add("{");
        setterSc.indent();
        if (hasModeSuperClass) {
            setterSc.add("super.set" + this.capitalise(JavaModelloGenerator.singular((String)locationField)) + "( key, " + JavaModelloGenerator.singular((String)locationField) + " );");
        } else {
            setterSc.add("setOther" + this.capitalise(JavaModelloGenerator.singular((String)locationField)) + "( key, " + JavaModelloGenerator.singular((String)locationField) + " );");
        }
        setterSc.unindent();
        setterSc.add("}");
        setter.setComment("");
        jClass.addMethod(setter);
    }

    private void generateLocationBean(JClass jClass, ModelClass locationClass, ModelClass sourceClass) throws ModelloException {
        jClass.getModifiers().setFinal(true);
        String locationsField = ((ModelClassMetadata)locationClass.getMetadata(ModelClassMetadata.ID)).getLocationTracker();
        JavaFieldMetadata readOnlyField = new JavaFieldMetadata();
        readOnlyField.setSetter(false);
        ModelField lineNumber = new ModelField(locationClass, "lineNumber");
        lineNumber.setDescription("The one-based line number. The value will be non-positive if unknown.");
        lineNumber.setType("int");
        lineNumber.setDefaultValue("-1");
        lineNumber.addMetadata((Metadata)readOnlyField);
        this.createField(jClass, lineNumber);
        ModelField columnNumber = new ModelField(locationClass, "columnNumber");
        columnNumber.setDescription("The one-based column number. The value will be non-positive if unknown.");
        columnNumber.setType("int");
        columnNumber.setDefaultValue("-1");
        columnNumber.addMetadata((Metadata)readOnlyField);
        this.createField(jClass, columnNumber);
        ModelField source = null;
        if (sourceClass != null) {
            ModelClassMetadata metadata = (ModelClassMetadata)sourceClass.getMetadata(ModelClassMetadata.ID);
            String sourceField = metadata.getSourceTracker();
            source = new ModelField(locationClass, sourceField);
            source.setType(sourceClass.getName());
            source.addMetadata((Metadata)readOnlyField);
            this.createField(jClass, source);
        }
        JConstructor jConstructor = jClass.createConstructor();
        JSourceCode sc = jConstructor.getSourceCode();
        jConstructor.addParameter(new JParameter(JType.INT, lineNumber.getName()));
        sc.add("this." + lineNumber.getName() + " = " + lineNumber.getName() + ";");
        jConstructor.addParameter(new JParameter(JType.INT, columnNumber.getName()));
        sc.add("this." + columnNumber.getName() + " = " + columnNumber.getName() + ";");
        if (sourceClass != null) {
            jConstructor = jClass.createConstructor(jConstructor.getParameters());
            sc.copyInto(jConstructor.getSourceCode());
            sc = jConstructor.getSourceCode();
            jConstructor.addParameter(new JParameter(new JType(sourceClass.getName()), source.getName()));
            sc.add("this." + source.getName() + " = " + source.getName() + ";");
        }
        boolean useJava5 = this.hasJavaSourceSupport(5);
        JMapType fieldType = new JMapType("java.util.Map", new JType(locationClass.getName()), useJava5);
        JMapType fieldImpl = new JMapType("java.util.LinkedHashMap", new JType(locationClass.getName()), useJava5);
        JMethod jMethod = new JMethod("get" + this.capitalise(locationsField), fieldType, null);
        sc = jMethod.getSourceCode();
        sc.add("return " + locationsField + ";");
        jMethod.setComment("");
        jClass.addMethod(jMethod);
        jMethod = new JMethod("set" + this.capitalise(locationsField));
        jMethod.addParameter(new JParameter(fieldType, locationsField));
        sc = jMethod.getSourceCode();
        sc.add("this." + locationsField + " = " + locationsField + ";");
        jMethod.setComment("");
        jClass.addMethod(jMethod);
        jMethod = new JMethod("merge", new JType(locationClass.getName()), null);
        jMethod.getModifiers().setStatic(true);
        jMethod.addParameter(new JParameter(new JType(locationClass.getName()), "target"));
        jMethod.addParameter(new JParameter(new JType(locationClass.getName()), "source"));
        jMethod.addParameter(new JParameter(JType.BOOLEAN, "sourceDominant"));
        sc = jMethod.getSourceCode();
        sc.add("if ( source == null )");
        sc.add("{");
        sc.addIndented("return target;");
        sc.add("}");
        sc.add("else if ( target == null )");
        sc.add("{");
        sc.addIndented("return source;");
        sc.add("}");
        sc.add("");
        sc.add(locationClass.getName() + " result =");
        sc.add("    new " + locationClass.getName() + "( target.getLineNumber(), target.getColumnNumber()" + (sourceClass != null ? ", target.get" + this.capitalise(source.getName()) + "()" : "") + " );");
        sc.add("");
        sc.add(fieldType + " locations;");
        sc.add(fieldType + " sourceLocations = source.get" + this.capitalise(locationsField) + "();");
        sc.add(fieldType + " targetLocations = target.get" + this.capitalise(locationsField) + "();");
        sc.add("if ( sourceLocations == null )");
        sc.add("{");
        sc.addIndented("locations = targetLocations;");
        sc.add("}");
        sc.add("else if ( targetLocations == null )");
        sc.add("{");
        sc.addIndented("locations = sourceLocations;");
        sc.add("}");
        sc.add("else");
        sc.add("{");
        sc.addIndented("locations = new " + fieldImpl.getName() + "();");
        sc.addIndented("locations.putAll( sourceDominant ? targetLocations : sourceLocations );");
        sc.addIndented("locations.putAll( sourceDominant ? sourceLocations : targetLocations );");
        sc.add("}");
        sc.add("result.set" + this.capitalise(locationsField) + "( locations );");
        sc.add("");
        sc.add("return result;");
        jClass.addMethod(jMethod);
        jMethod = new JMethod("merge", new JType(locationClass.getName()), null);
        jMethod.getModifiers().setStatic(true);
        jMethod.addParameter(new JParameter(new JType(locationClass.getName()), "target"));
        jMethod.addParameter(new JParameter(new JType(locationClass.getName()), "source"));
        jMethod.addParameter(new JParameter(new JCollectionType("java.util.Collection", new JType("Integer"), useJava5), "indices"));
        String intWrap = useJava5 ? "Integer.valueOf" : "new Integer";
        sc = jMethod.getSourceCode();
        sc.add("if ( source == null )");
        sc.add("{");
        sc.addIndented("return target;");
        sc.add("}");
        sc.add("else if ( target == null )");
        sc.add("{");
        sc.addIndented("return source;");
        sc.add("}");
        sc.add("");
        sc.add(locationClass.getName() + " result =");
        sc.add("    new " + locationClass.getName() + "( target.getLineNumber(), target.getColumnNumber()" + (sourceClass != null ? ", target.get" + this.capitalise(source.getName()) + "()" : "") + " );");
        sc.add("");
        sc.add(fieldType + " locations;");
        sc.add(fieldType + " sourceLocations = source.get" + this.capitalise(locationsField) + "();");
        sc.add(fieldType + " targetLocations = target.get" + this.capitalise(locationsField) + "();");
        sc.add("if ( sourceLocations == null )");
        sc.add("{");
        sc.addIndented("locations = targetLocations;");
        sc.add("}");
        sc.add("else if ( targetLocations == null )");
        sc.add("{");
        sc.addIndented("locations = sourceLocations;");
        sc.add("}");
        sc.add("else");
        sc.add("{");
        sc.indent();
        sc.add("locations = new " + fieldImpl + "();");
        sc.add("for ( java.util.Iterator" + (useJava5 ? "<Integer>" : "") + " it = indices.iterator(); it.hasNext(); )");
        sc.add("{");
        sc.indent();
        sc.add(locationClass.getName() + " location;");
        sc.add("Integer index = " + (useJava5 ? "" : "(Integer) ") + "it.next();");
        sc.add("if ( index.intValue() < 0 )");
        sc.add("{");
        sc.addIndented("location = sourceLocations.get( " + intWrap + "( ~index.intValue() ) );");
        sc.add("}");
        sc.add("else");
        sc.add("{");
        sc.addIndented("location = targetLocations.get( index );");
        sc.add("}");
        sc.add("locations.put( " + intWrap + "( locations.size() ), location );");
        sc.unindent();
        sc.add("}");
        sc.unindent();
        sc.add("}");
        sc.add("result.set" + this.capitalise(locationsField) + "( locations );");
        sc.add("");
        sc.add("return result;");
        jClass.addMethod(jMethod);
        JClass stringFormatterClass = jClass.createInnerClass("StringFormatter");
        stringFormatterClass.getModifiers().setStatic(true);
        stringFormatterClass.getModifiers().setAbstract(true);
        jMethod = new JMethod("toString", new JType("String"), null);
        jMethod.getModifiers().setAbstract(true);
        jMethod.addParameter(new JParameter(new JType(locationClass.getName()), "location"));
        stringFormatterClass.addMethod(jMethod);
    }

    private String appendPeriod(String string) {
        if (string == null) {
            return string;
        }
        String trimmedString = string.trim();
        if (trimmedString.endsWith(".") || trimmedString.endsWith("!") || trimmedString.endsWith("?") || trimmedString.endsWith(">")) {
            return string;
        }
        return string + ".";
    }

    private String createHashCodeForField(ModelField identifier) {
        String name = identifier.getName();
        String type = identifier.getType();
        if ("boolean".equals(type)) {
            return "( " + name + " ? 0 : 1 )";
        }
        if ("byte".equals(type) || "char".equals(type) || "short".equals(type) || "int".equals(type)) {
            return "(int) " + name;
        }
        if ("long".equals(type)) {
            return "(int) ( " + name + " ^ ( " + name + " >>> 32 ) )";
        }
        if ("float".equals(type)) {
            return "Float.floatToIntBits( " + name + " )";
        }
        if ("double".equals(type)) {
            return "(int) ( Double.doubleToLongBits( " + identifier.getName() + " ) ^ ( Double.doubleToLongBits( " + identifier.getName() + " ) >>> 32 ) )";
        }
        return "( " + name + " != null ? " + name + ".hashCode() : 0 )";
    }

    private JField createField(ModelField modelField) throws ModelloException {
        String baseType = modelField.getType();
        if (modelField.isArray()) {
            baseType = baseType.substring(0, baseType.length() - 2);
        }
        JType type = "boolean".equals(baseType) ? JType.BOOLEAN : ("byte".equals(baseType) ? JType.BYTE : ("char".equals(baseType) ? JType.CHAR : ("double".equals(baseType) ? JType.DOUBLE : ("float".equals(baseType) ? JType.FLOAT : ("int".equals(baseType) ? JType.INT : ("short".equals(baseType) ? JType.SHORT : ("long".equals(baseType) ? JType.LONG : ("Date".equals(baseType) ? new JClass("java.util.Date") : ("DOM".equals(baseType) ? new JClass("Object") : new JClass(baseType))))))))));
        boolean useJava5 = this.hasJavaSourceSupport(5);
        if (modelField.isArray()) {
            type = new JArrayType(type, useJava5);
        }
        JField field = new JField(type, modelField.getName());
        if (modelField.isModelVersionField()) {
            field.setInitString("\"" + this.getGeneratedVersion() + "\"");
        }
        if (modelField.getDefaultValue() != null) {
            field.setInitString(this.getJavaDefaultValue(modelField));
        }
        if (StringUtils.isNotEmpty((String)modelField.getDescription())) {
            field.setComment(this.appendPeriod(modelField.getDescription()));
        }
        if (useJava5 && !modelField.getAnnotations().isEmpty()) {
            for (String annotation : modelField.getAnnotations()) {
                field.appendAnnotation(annotation);
            }
        }
        return field;
    }

    private void createField(JClass jClass, ModelField modelField) throws ModelloException {
        JavaFieldMetadata javaFieldMetadata = (JavaFieldMetadata)modelField.getMetadata(JavaFieldMetadata.ID);
        JField field = this.createField(modelField);
        jClass.addField(field);
        if (javaFieldMetadata.isGetter()) {
            jClass.addMethod(this.createGetter(field, modelField));
        }
        if (javaFieldMetadata.isSetter()) {
            jClass.addMethod(this.createSetter(field, modelField));
        }
    }

    private JMethod createGetter(JField field, ModelField modelField) {
        ModelAssociation modelAssociation;
        JavaAssociationMetadata javaAssociationMetadata;
        String propertyName = this.capitalise(field.getName());
        JavaFieldMetadata javaFieldMetadata = (JavaFieldMetadata)modelField.getMetadata(JavaFieldMetadata.ID);
        String prefix = javaFieldMetadata.isBooleanGetter() ? "is" : "get";
        JType returnType = field.getType();
        String interfaceCast = "";
        if (modelField instanceof ModelAssociation && StringUtils.isNotEmpty((String)(javaAssociationMetadata = (JavaAssociationMetadata)(modelAssociation = (ModelAssociation)modelField).getAssociationMetadata(JavaAssociationMetadata.ID)).getInterfaceName()) && !javaFieldMetadata.isBooleanGetter()) {
            returnType = new JClass(javaAssociationMetadata.getInterfaceName());
            interfaceCast = "(" + javaAssociationMetadata.getInterfaceName() + ") ";
        }
        JMethod getter = new JMethod(prefix + propertyName, returnType, null);
        StringBuilder comment = new StringBuilder("Get ");
        if (StringUtils.isEmpty((String)modelField.getDescription())) {
            comment.append("the ");
            comment.append(field.getName());
            comment.append(" field");
        } else {
            comment.append(StringUtils.lowercaseFirstLetter((String)modelField.getDescription().trim()));
        }
        getter.getJDocComment().setComment(this.appendPeriod(comment.toString()));
        getter.getSourceCode().add("return " + interfaceCast + "this." + field.getName() + ";");
        return getter;
    }

    private JMethod createSetter(JField field, ModelField modelField) throws ModelloException {
        return this.createSetter(field, modelField, false);
    }

    private JMethod createSetter(JField field, ModelField modelField, boolean isBuilderMethod) throws ModelloException {
        String propertyName = this.capitalise(field.getName());
        JMethod setter = isBuilderMethod ? new JMethod("set" + propertyName, new JClass("Builder"), "this builder instance") : new JMethod("set" + propertyName);
        StringBuilder comment = new StringBuilder("Set ");
        if (StringUtils.isEmpty((String)modelField.getDescription())) {
            comment.append("the ");
            comment.append(field.getName());
            comment.append(" field");
        } else {
            comment.append(StringUtils.lowercaseFirstLetter((String)modelField.getDescription().trim()));
        }
        setter.getJDocComment().setComment(this.appendPeriod(comment.toString()));
        JType parameterType = this.getDesiredType(modelField, false);
        setter.addParameter(new JParameter(parameterType, field.getName()));
        JSourceCode sc = setter.getSourceCode();
        if (modelField instanceof ModelAssociation) {
            boolean isOneMultiplicity;
            ModelAssociation modelAssociation = (ModelAssociation)modelField;
            JavaAssociationMetadata javaAssociationMetadata = (JavaAssociationMetadata)modelAssociation.getAssociationMetadata(JavaAssociationMetadata.ID);
            boolean bl = isOneMultiplicity = this.isBidirectionalAssociation(modelAssociation) && modelAssociation.isOneMultiplicity();
            if (isOneMultiplicity && javaAssociationMetadata.isBidi()) {
                sc.add("if ( this." + field.getName() + " != null )");
                sc.add("{");
                sc.indent();
                sc.add("this." + field.getName() + ".break" + modelAssociation.getModelClass().getName() + "Association( this );");
                sc.unindent();
                sc.add("}");
                sc.add("");
            }
            String interfaceCast = "";
            if (StringUtils.isNotEmpty((String)javaAssociationMetadata.getInterfaceName()) && modelAssociation.isOneMultiplicity()) {
                interfaceCast = "(" + field.getType().getName() + ") ";
                this.createClassCastAssertion(sc, modelAssociation, "set");
            }
            sc.add("this." + field.getName() + " = " + interfaceCast + field.getName() + ";");
            if (isOneMultiplicity && javaAssociationMetadata.isBidi()) {
                sc.add("");
                sc.add("if ( " + field.getName() + " != null )");
                sc.add("{");
                sc.indent();
                sc.add("this." + field.getName() + ".create" + modelAssociation.getModelClass().getName() + "Association( this );");
                sc.unindent();
                sc.add("}");
            }
        } else {
            sc.add("this." + field.getName() + " = " + field.getName() + ";");
        }
        if (isBuilderMethod) {
            sc.add("return this;");
        }
        return setter;
    }

    private void createClassCastAssertion(JSourceCode sc, ModelAssociation modelAssociation, String crudModifier) throws ModelloException {
        JavaAssociationMetadata javaAssociationMetadata = (JavaAssociationMetadata)modelAssociation.getAssociationMetadata(JavaAssociationMetadata.ID);
        if (StringUtils.isEmpty((String)javaAssociationMetadata.getInterfaceName())) {
            return;
        }
        String propertyName = this.capitalise(modelAssociation.getName());
        JField field = this.createField((ModelField)modelAssociation);
        String fieldName = field.getName();
        JClass type = new JClass(modelAssociation.getTo());
        if (modelAssociation.isManyMultiplicity()) {
            fieldName = JavaModelloGenerator.uncapitalise((String)modelAssociation.getTo());
        }
        String instanceName = type.getName();
        sc.add("if ( " + fieldName + " != null && !( " + fieldName + " instanceof " + instanceName + " ) )");
        sc.add("{");
        sc.indent();
        sc.add("throw new ClassCastException( \"" + modelAssociation.getModelClass().getName() + "." + crudModifier + propertyName + "( " + fieldName + " ) parameter must be instanceof \" + " + instanceName + ".class.getName() );");
        sc.unindent();
        sc.add("}");
    }

    private void createAssociation(JClass jClass, ModelAssociation modelAssociation, JSourceCode jConstructorSource) throws ModelloException {
        JavaFieldMetadata javaFieldMetadata = (JavaFieldMetadata)modelAssociation.getMetadata(JavaFieldMetadata.ID);
        JavaAssociationMetadata javaAssociationMetadata = this.getJavaAssociationMetadata(modelAssociation);
        boolean useJava5 = this.hasJavaSourceSupport(5);
        if (modelAssociation.isManyMultiplicity()) {
            JType type;
            JType componentType = this.getComponentType(modelAssociation, javaAssociationMetadata);
            String defaultValue = this.getDefaultValue(modelAssociation, componentType);
            if (modelAssociation.isGenericType()) {
                type = new JCollectionType(modelAssociation.getType(), componentType, useJava5);
            } else if ("java.util.Map".equals(modelAssociation.getType())) {
                JMapType mapType = new JMapType(modelAssociation.getType(), defaultValue, componentType, useJava5);
                defaultValue = mapType.getInstanceName();
                type = mapType;
            } else {
                type = new JClass(modelAssociation.getType());
            }
            JField jField = new JField(type, modelAssociation.getName());
            if (!this.isEmpty(modelAssociation.getComment())) {
                jField.setComment(modelAssociation.getComment());
            }
            if (useJava5 && !modelAssociation.getAnnotations().isEmpty()) {
                for (String annotation : modelAssociation.getAnnotations()) {
                    jField.appendAnnotation(annotation);
                }
            }
            if (StringUtils.equals((String)javaAssociationMetadata.getInitializationMode(), (String)"field")) {
                jField.setInitString(defaultValue);
            }
            if (StringUtils.equals((String)javaAssociationMetadata.getInitializationMode(), (String)"constructor")) {
                jConstructorSource.add("this." + jField.getName() + " = " + defaultValue + ";");
            }
            jClass.addField(jField);
            if (javaFieldMetadata.isGetter()) {
                String propertyName = this.capitalise(jField.getName());
                JMethod getter = new JMethod("get" + propertyName, jField.getType(), null);
                JSourceCode sc = getter.getSourceCode();
                if (StringUtils.equals((String)javaAssociationMetadata.getInitializationMode(), (String)"lazy")) {
                    sc.add("if ( this." + jField.getName() + " == null )");
                    sc.add("{");
                    sc.indent();
                    sc.add("this." + jField.getName() + " = " + defaultValue + ";");
                    sc.unindent();
                    sc.add("}");
                    sc.add("");
                }
                sc.add("return this." + jField.getName() + ";");
                jClass.addMethod(getter);
            }
            if (javaFieldMetadata.isSetter()) {
                jClass.addMethod(this.createSetter(jField, (ModelField)modelAssociation));
            }
            if (javaAssociationMetadata.isAdder()) {
                this.createAdder(modelAssociation, jClass);
            }
        } else {
            this.createField(jClass, (ModelField)modelAssociation);
        }
        if (this.isBidirectionalAssociation(modelAssociation) && javaAssociationMetadata.isBidi()) {
            this.createCreateAssociation(jClass, modelAssociation);
            this.createBreakAssociation(jClass, modelAssociation);
        }
    }

    private String getDefaultValue(ModelAssociation modelAssociation, JType componentType) {
        String defaultValue = this.getDefaultValue(modelAssociation);
        if (modelAssociation.isGenericType()) {
            ModelDefault modelDefault = this.getModel().getDefault(modelAssociation.getType());
            defaultValue = this.hasJavaSourceSupport(5) ? StringUtils.replace((String)modelDefault.getValue(), (String)"<?>", (String)("<" + componentType.getName() + ">")) : StringUtils.replace((String)modelDefault.getValue(), (String)"<?>", (String)("/*<" + componentType.getName() + ">*/"));
        }
        return defaultValue;
    }

    private JavaAssociationMetadata getJavaAssociationMetadata(ModelAssociation modelAssociation) throws ModelloException {
        JavaAssociationMetadata javaAssociationMetadata = (JavaAssociationMetadata)modelAssociation.getAssociationMetadata(JavaAssociationMetadata.ID);
        if (!JavaAssociationMetadata.INIT_TYPES.contains(javaAssociationMetadata.getInitializationMode())) {
            throw new ModelloException("The Java Modello Generator cannot use '" + javaAssociationMetadata.getInitializationMode() + "' as a <association java.init=\"" + javaAssociationMetadata.getInitializationMode() + "\"> value, the only the following are acceptable " + JavaAssociationMetadata.INIT_TYPES);
        }
        return javaAssociationMetadata;
    }

    private JType getComponentType(ModelAssociation modelAssociation, JavaAssociationMetadata javaAssociationMetadata) {
        JClass componentType = javaAssociationMetadata.getInterfaceName() != null ? new JClass(javaAssociationMetadata.getInterfaceName()) : new JClass(modelAssociation.getTo());
        return componentType;
    }

    private void createCreateAssociation(JClass jClass, ModelAssociation modelAssociation) {
        JMethod createMethod = new JMethod("create" + modelAssociation.getTo() + "Association");
        JavaAssociationMetadata javaAssociationMetadata = (JavaAssociationMetadata)modelAssociation.getAssociationMetadata(JavaAssociationMetadata.ID);
        createMethod.addParameter(new JParameter(new JClass(modelAssociation.getTo()), JavaModelloGenerator.uncapitalise((String)modelAssociation.getTo())));
        JSourceCode sc = createMethod.getSourceCode();
        if (modelAssociation.isOneMultiplicity()) {
            if (javaAssociationMetadata.isBidi()) {
                sc.add("if ( this." + modelAssociation.getName() + " != null )");
                sc.add("{");
                sc.indent();
                sc.add("break" + modelAssociation.getTo() + "Association( this." + modelAssociation.getName() + " );");
                sc.unindent();
                sc.add("}");
                sc.add("");
            }
            sc.add("this." + modelAssociation.getName() + " = " + JavaModelloGenerator.uncapitalise((String)modelAssociation.getTo()) + ";");
        } else {
            jClass.addImport("java.util.Collection");
            sc.add("Collection " + modelAssociation.getName() + " = get" + this.capitalise(modelAssociation.getName()) + "();");
            sc.add("");
            sc.add("if ( " + modelAssociation.getName() + ".contains( " + JavaModelloGenerator.uncapitalise((String)modelAssociation.getTo()) + " ) )");
            sc.add("{");
            sc.indent();
            sc.add("throw new IllegalStateException( \"" + JavaModelloGenerator.uncapitalise((String)modelAssociation.getTo()) + " is already assigned.\" );");
            sc.unindent();
            sc.add("}");
            sc.add("");
            sc.add(modelAssociation.getName() + ".add( " + JavaModelloGenerator.uncapitalise((String)modelAssociation.getTo()) + " );");
        }
        jClass.addMethod(createMethod);
    }

    private void createBreakAssociation(JClass jClass, ModelAssociation modelAssociation) {
        JMethod breakMethod = new JMethod("break" + modelAssociation.getTo() + "Association");
        breakMethod.addParameter(new JParameter(new JClass(modelAssociation.getTo()), JavaModelloGenerator.uncapitalise((String)modelAssociation.getTo())));
        JSourceCode sc = breakMethod.getSourceCode();
        if (modelAssociation.isOneMultiplicity()) {
            sc.add("if ( this." + modelAssociation.getName() + " != " + JavaModelloGenerator.uncapitalise((String)modelAssociation.getTo()) + " )");
            sc.add("{");
            sc.indent();
            sc.add("throw new IllegalStateException( \"" + JavaModelloGenerator.uncapitalise((String)modelAssociation.getTo()) + " isn't associated.\" );");
            sc.unindent();
            sc.add("}");
            sc.add("");
            sc.add("this." + modelAssociation.getName() + " = null;");
        } else {
            JavaAssociationMetadata javaAssociationMetadata = (JavaAssociationMetadata)modelAssociation.getAssociationMetadata(JavaAssociationMetadata.ID);
            String reference = "lazy".equals(javaAssociationMetadata.getInitializationMode()) ? "get" + this.capitalise(modelAssociation.getName()) + "()" : modelAssociation.getName();
            sc.add("if ( !" + reference + ".contains( " + JavaModelloGenerator.uncapitalise((String)modelAssociation.getTo()) + " ) )");
            sc.add("{");
            sc.indent();
            sc.add("throw new IllegalStateException( \"" + JavaModelloGenerator.uncapitalise((String)modelAssociation.getTo()) + " isn't associated.\" );");
            sc.unindent();
            sc.add("}");
            sc.add("");
            sc.add(reference + ".remove( " + JavaModelloGenerator.uncapitalise((String)modelAssociation.getTo()) + " );");
        }
        jClass.addMethod(breakMethod);
    }

    private void createAdder(ModelAssociation modelAssociation, JClass jClass) throws ModelloException {
        this.createAdder(modelAssociation, jClass, false);
    }

    private void createAdder(ModelAssociation modelAssociation, JClass jClass, boolean isBuilderMethod) throws ModelloException {
        JClass addType;
        String parameterName;
        String fieldName = modelAssociation.getName();
        JavaAssociationMetadata javaAssociationMetadata = (JavaAssociationMetadata)modelAssociation.getAssociationMetadata(JavaAssociationMetadata.ID);
        String implementationParameterName = parameterName = JavaModelloGenerator.uncapitalise((String)modelAssociation.getTo());
        boolean bidirectionalAssociation = this.isBidirectionalAssociation(modelAssociation);
        if (StringUtils.isNotEmpty((String)javaAssociationMetadata.getInterfaceName())) {
            addType = new JClass(javaAssociationMetadata.getInterfaceName());
            implementationParameterName = "( (" + modelAssociation.getTo() + ") " + parameterName + " )";
        } else {
            addType = modelAssociation.getToClass() != null ? new JClass(modelAssociation.getToClass().getName()) : new JClass("String");
        }
        if (modelAssociation.getType().equals("java.util.Properties") || modelAssociation.getType().equals("java.util.Map")) {
            String adderName = "add" + this.capitalise(JavaModelloGenerator.singular((String)fieldName));
            JMethod adder = isBuilderMethod ? new JMethod(adderName, new JClass("Builder"), "this builder instance") : new JMethod(adderName);
            if (modelAssociation.getType().equals("java.util.Map")) {
                adder.addParameter(new JParameter(new JClass("Object"), "key"));
            } else {
                adder.addParameter(new JParameter(new JClass("String"), "key"));
            }
            adder.addParameter(new JParameter(new JClass(modelAssociation.getTo()), "value"));
            StringBuilder adderCode = new StringBuilder();
            if ("lazy".equals(javaAssociationMetadata.getInitializationMode()) && !isBuilderMethod) {
                adderCode.append("get").append(this.capitalise(fieldName)).append("()");
            } else {
                adderCode.append(fieldName);
            }
            adderCode.append(".put( key, value );");
            adder.getSourceCode().add(adderCode.toString());
            if (isBuilderMethod) {
                adder.getSourceCode().add("return this;");
            }
            jClass.addMethod(adder);
        } else {
            String adderName = "add" + JavaModelloGenerator.singular((String)this.capitalise(JavaModelloGenerator.singular((String)fieldName)));
            JMethod adder = isBuilderMethod ? new JMethod(adderName, new JClass("Builder"), "this builder instance") : new JMethod(adderName);
            adder.addParameter(new JParameter(addType, parameterName));
            this.createClassCastAssertion(adder.getSourceCode(), modelAssociation, "add");
            StringBuilder adderCode = new StringBuilder();
            if ("lazy".equals(javaAssociationMetadata.getInitializationMode()) && !isBuilderMethod) {
                adderCode.append("get").append(this.capitalise(fieldName)).append("()");
            } else {
                adderCode.append(fieldName);
            }
            adderCode.append(".add( ").append(implementationParameterName).append(" );");
            adder.getSourceCode().add(adderCode.toString());
            if (bidirectionalAssociation && javaAssociationMetadata.isBidi() && !isBuilderMethod) {
                adder.getSourceCode().add(implementationParameterName + ".create" + modelAssociation.getModelClass().getName() + "Association( this );");
            }
            if (isBuilderMethod) {
                adder.getSourceCode().add("return this;");
            }
            jClass.addMethod(adder);
            if (isBuilderMethod) {
                return;
            }
            JMethod remover = new JMethod("remove" + JavaModelloGenerator.singular((String)this.capitalise(fieldName)));
            remover.addParameter(new JParameter(addType, parameterName));
            this.createClassCastAssertion(remover.getSourceCode(), modelAssociation, "remove");
            if (bidirectionalAssociation && javaAssociationMetadata.isBidi()) {
                remover.getSourceCode().add(parameterName + ".break" + modelAssociation.getModelClass().getName() + "Association( this );");
            }
            String reference = "lazy".equals(javaAssociationMetadata.getInitializationMode()) ? "get" + this.capitalise(fieldName) + "()" : fieldName;
            remover.getSourceCode().add(reference + ".remove( " + implementationParameterName + " );");
            jClass.addMethod(remover);
        }
    }

    private boolean isBidirectionalAssociation(ModelAssociation association) {
        Model model = association.getModelClass().getModel();
        if (!this.isClassInModel(association.getTo(), model)) {
            return false;
        }
        ModelClass toClass = association.getToClass();
        for (ModelField modelField : toClass.getFields(this.getGeneratedVersion())) {
            ModelAssociation modelAssociation;
            if (!(modelField instanceof ModelAssociation) || association == (modelAssociation = (ModelAssociation)modelField) || !this.isClassInModel(modelAssociation.getTo(), model)) continue;
            ModelClass totoClass = modelAssociation.getToClass();
            if (!association.getModelClass().equals((Object)totoClass)) continue;
            return true;
        }
        return false;
    }

    private JType getDesiredType(ModelField modelField, boolean useTo) throws ModelloException {
        JField field = this.createField(modelField);
        JType type = field.getType();
        if (modelField instanceof ModelAssociation) {
            ModelAssociation modelAssociation = (ModelAssociation)modelField;
            JavaAssociationMetadata javaAssociationMetadata = (JavaAssociationMetadata)modelAssociation.getAssociationMetadata(JavaAssociationMetadata.ID);
            if (StringUtils.isNotEmpty((String)javaAssociationMetadata.getInterfaceName()) && !modelAssociation.isManyMultiplicity()) {
                type = new JClass(javaAssociationMetadata.getInterfaceName());
            } else if (modelAssociation.isManyMultiplicity() && modelAssociation.isGenericType()) {
                JType componentType = this.getComponentType(modelAssociation, javaAssociationMetadata);
                type = new JCollectionType(modelAssociation.getType(), componentType, this.hasJavaSourceSupport(5));
            } else if (useTo) {
                type = new JClass(modelAssociation.getTo());
            }
        }
        return type;
    }

    private void addParameter(JMethodSignature jMethod, String type, String name, String comment) {
        jMethod.addParameter(new JParameter(new JType(type), name));
        jMethod.getJDocComment().getParamDescriptor(name).setDescription(comment);
    }

    private void generateBuilder(ModelClass modelClass, JClass builderClass, JConstructor outherClassConstructor) throws ModelloException {
        builderClass.getModifiers().setStatic(true);
        builderClass.getModifiers().setFinal(true);
        ModelClass reference = modelClass;
        while (reference != null) {
            for (ModelField modelField : reference.getFields(this.getGeneratedVersion())) {
                if (modelField instanceof ModelAssociation) {
                    this.createBuilderAssociation(builderClass, (ModelAssociation)modelField);
                    continue;
                }
                this.createBuilderField(builderClass, modelField);
            }
            if (reference.hasSuperClass()) {
                reference = reference.getModel().getClass(reference.getSuperClass(), this.getGeneratedVersion());
                continue;
            }
            reference = null;
        }
        JMethod build = new JMethod("build", new JClass(modelClass.getName()), "A new <code>" + modelClass.getName() + "</code> instance");
        build.getJDocComment().setComment("Creates a new <code>" + modelClass.getName() + "</code> instance.");
        JSourceCode sc = build.getSourceCode();
        this.createInstanceAndSetProperties(modelClass, outherClassConstructor, sc);
        builderClass.addMethod(build);
    }

    private void createInstanceAndSetProperties(ModelClass modelClass, JConstructor constructor, JSourceCode sc) throws ModelloException {
        HashSet<String> ctorArgs = new HashSet<String>();
        StringBuilder ctor = new StringBuilder(modelClass.getName()).append(" instance = new ").append(modelClass.getName()).append('(');
        if (constructor != null) {
            JParameter[] parameters = constructor.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                if (i > 0) {
                    ctor.append(',');
                }
                JParameter parameter = parameters[i];
                ctor.append(' ').append(parameter.getName()).append(' ');
                ctorArgs.add(parameter.getName());
            }
        }
        ctor.append(");");
        sc.add(ctor.toString());
        ModelClass reference = modelClass;
        while (reference != null) {
            for (ModelField modelField : reference.getFields(this.getGeneratedVersion())) {
                if (modelField instanceof ModelAssociation) {
                    ModelAssociation modelAssociation = (ModelAssociation)modelField;
                    JavaFieldMetadata javaFieldMetadata = (JavaFieldMetadata)modelField.getMetadata(JavaFieldMetadata.ID);
                    JavaAssociationMetadata javaAssociationMetadata = this.getJavaAssociationMetadata(modelAssociation);
                    if (modelAssociation.isManyMultiplicity() && !javaFieldMetadata.isGetter() && !javaFieldMetadata.isSetter() && !javaAssociationMetadata.isAdder()) {
                        throw new ModelloException("Exception while generating Java, Model inconsistency found: impossible to generate '" + modelClass.getName() + ".Builder#build()' method, '" + modelClass.getName() + "." + modelAssociation.getName() + "' field (" + modelAssociation.getType() + ") cannot be set, no getter/setter/adder method available.");
                    }
                    this.createSetBuilderAssociationToInstance(ctorArgs, modelAssociation, sc);
                    continue;
                }
                this.createSetBuilderFieldToInstance(ctorArgs, modelField, sc);
            }
            if (reference.hasSuperClass()) {
                reference = reference.getModel().getClass(reference.getSuperClass(), this.getGeneratedVersion());
                continue;
            }
            reference = null;
        }
        sc.add("return instance;");
    }

    private void createBuilderField(JClass jClass, ModelField modelField) throws ModelloException {
        JField field = this.createField(modelField);
        jClass.addField(field);
        jClass.addMethod(this.createSetter(field, modelField, true));
    }

    private boolean createSetBuilderFieldToInstance(Set<String> ctorArgs, ModelField modelField, JSourceCode sc) throws ModelloException {
        JavaFieldMetadata javaFieldMetadata = (JavaFieldMetadata)modelField.getMetadata(JavaFieldMetadata.ID);
        if (!ctorArgs.contains(modelField.getName()) && javaFieldMetadata.isSetter()) {
            sc.add("instance.set" + this.capitalise(modelField.getName()) + "( " + modelField.getName() + " );");
            return true;
        }
        return false;
    }

    private void createBuilderAssociation(JClass jClass, ModelAssociation modelAssociation) throws ModelloException {
        JavaAssociationMetadata javaAssociationMetadata = this.getJavaAssociationMetadata(modelAssociation);
        if (modelAssociation.isManyMultiplicity()) {
            JType type;
            JType componentType = this.getComponentType(modelAssociation, javaAssociationMetadata);
            boolean useJava5 = this.hasJavaSourceSupport(5);
            String defaultValue = this.getDefaultValue(modelAssociation, componentType);
            if (modelAssociation.isGenericType()) {
                type = new JCollectionType(modelAssociation.getType(), componentType, useJava5);
            } else if ("java.util.Map".equals(modelAssociation.getType())) {
                JMapType mapType = new JMapType(modelAssociation.getType(), defaultValue, componentType, useJava5);
                defaultValue = mapType.getInstanceName();
                type = mapType;
            } else {
                type = new JClass(modelAssociation.getType());
            }
            JField jField = new JField(type, modelAssociation.getName());
            jField.getModifiers().setFinal(true);
            if (!this.isEmpty(modelAssociation.getComment())) {
                jField.setComment(modelAssociation.getComment());
            }
            if (useJava5 && !modelAssociation.getAnnotations().isEmpty()) {
                for (String annotation : modelAssociation.getAnnotations()) {
                    jField.appendAnnotation(annotation);
                }
            }
            jField.setInitString(defaultValue);
            jClass.addField(jField);
            this.createAdder(modelAssociation, jClass, true);
        } else {
            this.createBuilderField(jClass, (ModelField)modelAssociation);
        }
    }

    private void createSetBuilderAssociationToInstance(Set<String> ctorArgs, ModelAssociation modelAssociation, JSourceCode sc) throws ModelloException {
        if (modelAssociation.isManyMultiplicity()) {
            String itemType;
            if ((modelAssociation.getType().equals("java.util.Properties") || modelAssociation.getType().equals("java.util.Map")) && this.createSetBuilderFieldToInstance(ctorArgs, (ModelField)modelAssociation, sc)) {
                return;
            }
            JavaAssociationMetadata javaAssociationMetadata = this.getJavaAssociationMetadata(modelAssociation);
            boolean bidirectionalAssociation = this.isBidirectionalAssociation(modelAssociation);
            if (!bidirectionalAssociation || !javaAssociationMetadata.isBidi()) {
                JavaFieldMetadata javaFieldMetadata = (JavaFieldMetadata)modelAssociation.getMetadata(JavaFieldMetadata.ID);
                if (this.createSetBuilderFieldToInstance(ctorArgs, (ModelField)modelAssociation, sc)) {
                    return;
                }
                if (javaFieldMetadata.isGetter()) {
                    String action = this.isMap(modelAssociation.getType()) ? "put" : "add";
                    sc.add("instance.get" + this.capitalise(modelAssociation.getName()) + "()." + action + "All( " + modelAssociation.getName() + " );");
                    return;
                }
            }
            String targetField = modelAssociation.getName();
            boolean useJava5 = this.hasJavaSourceSupport(5);
            if (StringUtils.isNotEmpty((String)javaAssociationMetadata.getInterfaceName())) {
                itemType = javaAssociationMetadata.getInterfaceName();
            } else if (modelAssociation.getToClass() != null) {
                itemType = modelAssociation.getToClass().getName();
            } else if (modelAssociation.getType().equals("java.util.Properties") || modelAssociation.getType().equals("java.util.Map")) {
                StringBuilder itemTypeBuilder = new StringBuilder("java.util.Map.Entry");
                if (useJava5) {
                    itemTypeBuilder.append('<');
                    if (modelAssociation.getType().equals("java.util.Properties")) {
                        itemTypeBuilder.append("Object, Object");
                    } else {
                        itemTypeBuilder.append("String, ").append(modelAssociation.getTo());
                    }
                    itemTypeBuilder.append('>');
                }
                itemType = itemTypeBuilder.toString();
                targetField = targetField + ".entrySet()";
            } else {
                itemType = "String";
            }
            if (useJava5) {
                sc.add("for ( " + itemType + " item : " + targetField + " )");
            } else {
                sc.add("for ( java.util.Iterator it = " + targetField + ".iterator(); it.hasNext(); )");
            }
            sc.add("{");
            sc.indent();
            if (!useJava5) {
                sc.add(itemType + " item = (" + itemType + ") it.next();");
            }
            StringBuilder adder = new StringBuilder("instance.add").append(this.capitalise(JavaModelloGenerator.singular((String)modelAssociation.getName()))).append("( ");
            if (modelAssociation.getType().equals("java.util.Properties") || modelAssociation.getType().equals("java.util.Map")) {
                this.appendEntryMethod("String", "getKey()", adder, modelAssociation);
                adder.append(", ");
                this.appendEntryMethod(modelAssociation.getTo(), "getValue()", adder, modelAssociation);
            } else {
                adder.append("item");
            }
            adder.append(" );");
            sc.add(adder.toString());
            sc.unindent();
            sc.add("}");
        } else {
            this.createSetBuilderFieldToInstance(ctorArgs, (ModelField)modelAssociation, sc);
        }
    }

    private void appendEntryMethod(String type, String method, StringBuilder target, ModelAssociation modelAssociation) {
        if (!this.hasJavaSourceSupport(5) || modelAssociation.getType().equals("java.util.Properties")) {
            target.append('(').append(type).append(") ");
        }
        target.append("item.").append(method);
    }

    private void generateStaticCreator(ModelClass modelClass, JClass jClass, JConstructor constructor) throws ModelloException {
        JMethod creatorMethod = new JMethod("new" + modelClass.getName() + "Instance", new JClass(modelClass.getName()), "a new <code>" + modelClass.getName() + "</code> instance.");
        creatorMethod.getModifiers().setStatic(true);
        creatorMethod.getJDocComment().setComment("Creates a new <code>" + modelClass.getName() + "</code> instance.");
        ModelClass reference = modelClass;
        boolean hasDefaults = false;
        while (reference != null) {
            for (ModelField modelField : reference.getFields(this.getGeneratedVersion())) {
                JField field = this.createField(modelField);
                creatorMethod.addParameter(new JParameter(field.getType(), field.getName()));
                if (StringUtils.isEmpty((String)modelField.getDefaultValue())) continue;
                hasDefaults = true;
            }
            if (reference.hasSuperClass()) {
                reference = reference.getModel().getClass(reference.getSuperClass(), this.getGeneratedVersion());
                continue;
            }
            reference = null;
        }
        JSourceCode sc = creatorMethod.getSourceCode();
        this.createInstanceAndSetProperties(modelClass, constructor, sc);
        jClass.addMethod(creatorMethod);
        if (!hasDefaults) {
            return;
        }
        creatorMethod = new JMethod("new" + modelClass.getName() + "Instance", new JClass(modelClass.getName()), "a new <code>" + modelClass.getName() + "</code> instance.");
        creatorMethod.getModifiers().setStatic(true);
        creatorMethod.getJDocComment().setComment("Creates a new <code>" + modelClass.getName() + "</code> instance.");
        StringBuilder shortcutArgs = new StringBuilder();
        reference = modelClass;
        while (reference != null) {
            for (ModelField modelField : reference.getFields(this.getGeneratedVersion())) {
                if (shortcutArgs.length() > 0) {
                    shortcutArgs.append(',');
                }
                shortcutArgs.append(' ');
                if (StringUtils.isEmpty((String)modelField.getDefaultValue())) {
                    JField field = this.createField(modelField);
                    creatorMethod.addParameter(new JParameter(field.getType(), field.getName()));
                    shortcutArgs.append(modelField.getName());
                } else {
                    shortcutArgs.append(this.getJavaDefaultValue(modelField));
                }
                shortcutArgs.append(' ');
            }
            if (reference.hasSuperClass()) {
                reference = reference.getModel().getClass(reference.getSuperClass(), this.getGeneratedVersion());
                continue;
            }
            reference = null;
        }
        sc = creatorMethod.getSourceCode();
        sc.add("return new" + modelClass.getName() + "Instance(" + shortcutArgs + ");");
        jClass.addMethod(creatorMethod);
    }
}

