/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.shortcut;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.installer.console.AbstractConsolePanel;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.event.InstallerListeners;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.panels.shortcut.ShortcutPanelAutomationHelper;
import com.izforge.izpack.panels.shortcut.ShortcutPanelLogic;
import com.izforge.izpack.util.Console;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.PlatformModelMatcher;
import com.izforge.izpack.util.TargetFactory;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ShortcutConsolePanel
extends AbstractConsolePanel {
    private final Prompt prompt;
    private final InstallData installData;
    private final ShortcutPanelLogic shortcutPanelLogic;
    private static final Logger logger = Logger.getLogger(ShortcutConsolePanel.class.getName());

    public ShortcutConsolePanel(InstallData installData, Resources resources, UninstallData uninstallData, Housekeeper housekeeper, TargetFactory factory, InstallerListeners listeners, PlatformModelMatcher matcher, Prompt prompt, PanelView<ConsolePanel> panel) {
        super(panel);
        ShortcutPanelLogic shortcutPanelLogic = null;
        try {
            shortcutPanelLogic = new ShortcutPanelLogic(installData, resources, uninstallData, housekeeper, factory, listeners, matcher);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Failed to initialise shortcuts: " + exception.getMessage(), exception);
        }
        this.prompt = prompt;
        this.installData = installData;
        this.shortcutPanelLogic = shortcutPanelLogic;
    }

    public boolean run(InstallData installData, Properties properties) {
        boolean result = false;
        if (this.shortcutPanelLogic != null) {
            if (this.shortcutPanelLogic.isSupported()) {
                result = true;
            } else if (this.shortcutPanelLogic.skipIfNotSupported()) {
                result = true;
            }
        }
        return result;
    }

    public boolean run(InstallData installData, Console console) {
        this.printHeadLine(installData, console);
        boolean result = true;
        try {
            this.shortcutPanelLogic.refreshShortcutData();
        }
        catch (Exception e) {
            return result;
        }
        if (this.shortcutPanelLogic != null && this.shortcutPanelLogic.canCreateShortcuts()) {
            if (this.shortcutPanelLogic.isSupported()) {
                this.chooseShortcutLocations();
                this.chooseEffectedUsers();
                this.chooseProgramGroup(console);
                if (this.shortcutPanelLogic.isCreateShortcutsImmediately()) {
                    try {
                        this.shortcutPanelLogic.createAndRegisterShortcuts();
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, e.getMessage(), e);
                    }
                }
                return true;
            }
            if (!this.shortcutPanelLogic.skipIfNotSupported()) {
                Messages messages = installData.getMessages();
                String message = messages.get("ShortcutPanel.alternate.apology", new Object[0]);
                this.prompt.message(Prompt.Type.INFORMATION, message);
            }
        }
        return result;
    }

    private void chooseShortcutLocations() {
        boolean selected;
        Prompt.Option createMenuShortcuts = this.prompt.confirm(Prompt.Type.QUESTION, this.shortcutPanelLogic.getCreateShortcutsPrompt(), Prompt.Options.YES_NO);
        this.shortcutPanelLogic.setCreateMenuShortcuts(createMenuShortcuts == Prompt.Option.YES);
        if (this.shortcutPanelLogic.hasDesktopShortcuts()) {
            selected = this.shortcutPanelLogic.isDesktopShortcutCheckboxSelected();
            Prompt.Option createDesktopShortcuts = this.prompt.confirm(Prompt.Type.QUESTION, this.shortcutPanelLogic.getCreateDesktopShortcutsPrompt(), Prompt.Options.YES_NO, selected ? Prompt.Option.YES : Prompt.Option.NO);
            this.shortcutPanelLogic.setCreateDesktopShortcuts(createDesktopShortcuts == Prompt.Option.YES);
        }
        if (this.shortcutPanelLogic.hasStartupShortcuts()) {
            selected = this.shortcutPanelLogic.isStartupShortcutCheckboxSelected();
            Prompt.Option createStartupShortcuts = this.prompt.confirm(Prompt.Type.QUESTION, this.shortcutPanelLogic.getCreateStartupShortcutsPrompt(), Prompt.Options.YES_NO, selected ? Prompt.Option.YES : Prompt.Option.NO);
            this.shortcutPanelLogic.setCreateStartupShortcuts(createStartupShortcuts == Prompt.Option.YES);
        }
    }

    private void chooseEffectedUsers() {
        boolean isAdmin = this.shortcutPanelLogic.initUserType();
        if (isAdmin && this.shortcutPanelLogic.isSupportingMultipleUsers()) {
            boolean selected = !this.shortcutPanelLogic.isDefaultCurrentUserFlag();
            String message = this.shortcutPanelLogic.getCreateForUserPrompt() + " " + this.shortcutPanelLogic.getCreateForAllUsersPrompt();
            Prompt.Option allUsers = this.prompt.confirm(Prompt.Type.QUESTION, message, Prompt.Options.YES_NO, selected ? Prompt.Option.YES : Prompt.Option.NO);
            this.shortcutPanelLogic.setUserType(allUsers == Prompt.Option.YES ? 2 : 1);
        }
    }

    private void chooseProgramGroup(Console console) {
        String programGroup = this.shortcutPanelLogic.getSuggestedProgramGroup();
        if (programGroup != null && "".equals(programGroup)) {
            programGroup = console.prompt(this.installData.getMessages().get("ShortcutPanel.regular.list", new Object[0]), "");
        }
        this.shortcutPanelLogic.setGroupName(programGroup);
    }

    public void createInstallationRecord(IXMLElement panelRoot) {
        try {
            new ShortcutPanelAutomationHelper(this.shortcutPanelLogic).createInstallationRecord(this.installData, panelRoot);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could generate automatic installer description for shortcuts.");
        }
    }
}

