/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.packs;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.factory.ObjectFactory;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.debugger.Debugger;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.installer.util.PackHelper;
import com.izforge.izpack.panels.packs.PacksModel;
import com.izforge.izpack.panels.packs.PacksModelGUI;
import com.izforge.izpack.panels.packs.PacksPanelAutomationHelper;
import com.izforge.izpack.panels.packs.PacksPanelInterface;
import com.izforge.izpack.panels.treepacks.PackValidator;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsVersion;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public abstract class PacksPanelBase
extends IzPanel
implements PacksPanelInterface,
ListSelectionListener {
    private static final long serialVersionUID = -727171695900867059L;
    private static final String ACTIONKEY_TOGGLE = "togglePack";
    private static final String ACTIONKEY_NEXTCOLUMNCELL = "selectNextColumnCell";
    private static final String ACTIONKEY_PREVIOUSCOLUMNCELL = "selectPreviousColumnCell";
    private static final transient Logger logger = Logger.getLogger(PacksPanelBase.class.getName());
    protected JLabel freeSpaceLabel;
    protected JLabel spaceLabel;
    protected JTextArea descriptionArea;
    protected JTextArea dependencyArea;
    protected JTable packsTable;
    protected PacksModel packsModel;
    protected JScrollPane tableScroller;
    private Map<String, Pack> names;
    protected long bytes = 0L;
    protected long freeBytes = 0L;
    protected boolean dependenciesExist = false;
    private Messages messages = null;
    private Debugger debugger;
    private final transient ObjectFactory factory;
    private RulesEngine rules;

    public PacksPanelBase(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, ObjectFactory factory, RulesEngine rules) {
        super(panel, parent, installData, resources);
        this.rules = rules;
        this.factory = factory;
        if (Debug.isTRACE()) {
            this.debugger = parent.getDebugger();
        }
        try {
            this.messages = installData.getMessages().newMessages("packsLang.xml");
        }
        catch (ResourceNotFoundException exception) {
            logger.info(exception.getMessage());
            this.messages = installData.getMessages();
        }
        this.computePacks(installData.getAvailablePacks());
        this.createNormalLayout();
        this.packsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                int row = PacksPanelBase.this.packsTable.rowAtPoint(event.getPoint());
                int col = PacksPanelBase.this.packsTable.columnAtPoint(event.getPoint());
                if (col == 0) {
                    PacksPanelBase.this.togglePack(row);
                }
            }
        });
    }

    protected abstract void createNormalLayout();

    @Override
    public Messages getMessages() {
        return this.messages;
    }

    @Override
    public long getBytes() {
        return this.bytes;
    }

    @Override
    public void setBytes(long bytes) {
        this.bytes = bytes;
    }

    @Override
    public void showSpaceRequired() {
        if (this.spaceLabel != null) {
            this.spaceLabel.setText(Pack.toByteUnitsString((long)this.bytes));
        }
    }

    @Override
    public void showFreeSpace() {
        if (IoHelper.supported((String)"getFreeSpace") && this.freeSpaceLabel != null) {
            this.freeBytes = IoHelper.getFreeSpace((String)IoHelper.existingParent((File)new File(this.installData.getInstallPath())).getAbsolutePath());
            String msg = this.freeBytes < 0L ? this.getString("PacksPanel.notAscertainable") : Pack.toByteUnitsString((long)this.freeBytes);
            this.freeSpaceLabel.setText(msg);
        }
    }

    public boolean isValidated() {
        if (IoHelper.supported((String)"getFreeSpace") && this.freeBytes >= 0L && this.freeBytes <= this.bytes) {
            JOptionPane.showMessageDialog((Component)((Object)this), this.getString("PacksPanel.notEnoughSpace"), this.getString("installer.error"), 0);
            return false;
        }
        for (Pack pack : this.installData.getAvailablePacks()) {
            for (String validator : pack.getValidators()) {
                boolean selected = this.installData.getSelectedPacks().indexOf(pack) > -1;
                try {
                    PackValidator validatorInst = (PackValidator)this.factory.create(validator, PackValidator.class, new Object[0]);
                    if (validatorInst.validate((AbstractUIHandler)this, this.installData, pack.getName(), selected)) continue;
                    return false;
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Validator threw exception for pack " + pack.getName() + ": " + e.getMessage(), e);
                    return false;
                }
            }
        }
        return true;
    }

    public void createInstallationRecord(IXMLElement panelRoot) {
        new PacksPanelAutomationHelper().createInstallationRecord((InstallData)this.installData, panelRoot);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Pack pack;
        int selectedRow = this.packsTable.getSelectedRow();
        if (this.descriptionArea != null && selectedRow != -1) {
            pack = this.packsModel.getPackAtRow(selectedRow);
            String desc = PackHelper.getPackDescription((Pack)pack, (Messages)this.messages);
            desc = this.installData.getVariables().replace(desc);
            this.descriptionArea.setText(desc);
        }
        if (this.dependencyArea != null && selectedRow != -1) {
            pack = this.packsModel.getPackAtRow(selectedRow);
            List dep = pack.getDependencies();
            String list = "";
            if (dep != null) {
                list = list + (this.messages == null ? "Dependencies: " : this.messages.get("PacksPanel.dependencies", new Object[0]));
            }
            for (int j = 0; dep != null && j < dep.size(); ++j) {
                String name = (String)dep.get(j);
                list = list + this.getI18NPackName(this.names.get(name));
                if (j == dep.size() - 1) continue;
                list = list + ", ";
            }
            String excludeslist = this.messages == null ? "Excludes: " : this.messages.get("PacksPanel.excludes", new Object[0]);
            int numexcludes = 0;
            if (pack.getExcludeGroup() != null) {
                for (int q = 0; q < this.installData.getAvailablePacks().size(); ++q) {
                    Pack otherpack = (Pack)this.installData.getAvailablePacks().get(q);
                    String exgroup = otherpack.getExcludeGroup();
                    if (exgroup == null || q == selectedRow || !pack.getExcludeGroup().equals(exgroup)) continue;
                    excludeslist = excludeslist + this.getI18NPackName(otherpack) + ", ";
                    ++numexcludes;
                }
            }
            if (dep != null) {
                excludeslist = "    " + excludeslist;
            }
            if (numexcludes > 0) {
                list = list + excludeslist;
            }
            if (list.endsWith(", ")) {
                list = list.substring(0, list.length() - 2);
            }
            this.dependencyArea.setText(list);
        }
    }

    private String getI18NPackName(Pack pack) {
        return PackHelper.getPackName((Pack)pack, (Messages)this.messages);
    }

    protected JLabel createLabel(String msgId, String iconId, GridBagLayout layout, GridBagConstraints constraints) {
        JLabel label = LabelFactory.create((String)this.getString(msgId), (Icon)((Icon)this.parent.getIcons().get((Object)iconId)), (int)11);
        if (layout != null && constraints != null) {
            layout.addLayoutComponent(label, constraints);
        }
        this.add(label);
        return label;
    }

    protected JLabel createPanelWithLabel(String msgId, GridBagLayout layout, GridBagConstraints constraints) {
        JPanel panel = new JPanel();
        JLabel label = new JLabel();
        panel.setAlignmentX(0.0f);
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(LabelFactory.create((String)this.getString(msgId)));
        panel.add(Box.createHorizontalGlue());
        panel.add(label);
        if (layout != null && constraints != null) {
            layout.addLayoutComponent(panel, constraints);
        }
        this.add(panel);
        boolean doNotShowRequiredSize = Boolean.parseBoolean((String)this.installData.guiPrefs.modifier.get("doNotShowRequiredSize"));
        panel.setVisible(!doNotShowRequiredSize);
        return label;
    }

    protected JTextArea createTextArea(String msgId, JScrollPane scroller, GridBagLayout layout, GridBagConstraints constraints) {
        JTextArea area = new JTextArea();
        area.setAlignmentX(0.0f);
        area.setCaretPosition(0);
        area.setEditable(false);
        area.setFocusable(false);
        area.setOpaque(false);
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        area.setBorder(BorderFactory.createTitledBorder(this.getString(msgId)));
        area.setFont(this.getControlTextFont());
        if (layout != null && constraints != null) {
            if (scroller != null) {
                layout.addLayoutComponent(scroller, constraints);
            } else {
                layout.addLayoutComponent(area, constraints);
            }
        }
        if (scroller != null) {
            scroller.setViewportView(area);
            this.add(scroller);
        } else {
            this.add(area);
        }
        return area;
    }

    protected JTable createPacksTable(int width, JScrollPane scroller, GridBagLayout layout, GridBagConstraints constraints) {
        final JTable table = new JTable();
        table.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        table.setIntercellSpacing(new Dimension(0, 0));
        table.setBackground(Color.white);
        table.setSelectionMode(0);
        table.getSelectionModel().addListSelectionListener(this);
        table.setShowGrid(false);
        table.getInputMap().put(KeyStroke.getKeyStroke(32, 0), ACTIONKEY_TOGGLE);
        table.getActionMap().put(ACTIONKEY_TOGGLE, new AbstractAction(){
            private static final long serialVersionUID = -2367549964368751438L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = table.getSelectedRow();
                PacksPanelBase.this.togglePack(row);
            }
        });
        table.getActionMap().put(ACTIONKEY_NEXTCOLUMNCELL, new AbstractAction(){
            private static final long serialVersionUID = -8459710483408176528L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = table.getSelectedRow();
                if (row < table.getRowCount() - 1) {
                    table.changeSelection(row + 1, 0, false, false);
                } else {
                    table.clearSelection();
                    table.transferFocus();
                }
            }
        });
        table.getActionMap().put(ACTIONKEY_PREVIOUSCOLUMNCELL, new AbstractAction(){
            private static final long serialVersionUID = 5846709935309245963L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = table.getSelectedRow();
                if (row == -1) {
                    row = table.getRowCount();
                }
                if (row > 0) {
                    table.changeSelection(row - 1, 0, false, false);
                } else {
                    table.clearSelection();
                    table.transferFocusBackward();
                }
            }
        });
        scroller.setViewportView(table);
        scroller.setAlignmentX(0.0f);
        scroller.getViewport().setBackground(Color.white);
        scroller.setPreferredSize(new Dimension(width, this.installData.guiPrefs.height / 3 + 30));
        if (layout != null && constraints != null) {
            layout.addLayoutComponent(scroller, constraints);
        }
        this.add(scroller);
        return table;
    }

    private void computePacks(List<Pack> packs) {
        this.names = new HashMap<String, Pack>();
        this.dependenciesExist = false;
        for (Pack pack : packs) {
            this.names.put(pack.getName(), pack);
            if (pack.getDependencies() == null && pack.getExcludeGroup() == null) continue;
            this.dependenciesExist = true;
        }
    }

    public void panelActivate() {
        this.parent.lockNextButton();
        try {
            this.packsModel = new PacksModelGUI(this, this.installData, this.rules){
                private static final long serialVersionUID = -8566131431416593277L;

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return false;
                }
            };
            this.packsTable.setModel(this.packsModel);
            CheckBoxRenderer packSelectedRenderer = new CheckBoxRenderer();
            this.packsTable.getColumnModel().getColumn(0).setCellRenderer(packSelectedRenderer);
            this.packsTable.getColumnModel().getColumn(0).setMaxWidth(40);
            this.packsTable.getColumnModel().getColumn(1).setCellRenderer(new PacksPanelTableCellRenderer());
            PacksPanelTableCellRenderer packTextColumnRenderer = new PacksPanelTableCellRenderer();
            packTextColumnRenderer.setHorizontalAlignment(4);
            if (this.packsTable.getColumnCount() > 2) {
                this.packsTable.getColumnModel().getColumn(2).setCellRenderer(packTextColumnRenderer);
                this.packsTable.getColumnModel().getColumn(2).setMaxWidth(100);
            }
            this.tableScroller.remove(this.packsTable.getTableHeader());
            this.tableScroller.setColumnHeaderView(null);
            this.tableScroller.setColumnHeader(null);
            this.bytes = 0L;
            for (Pack p : this.installData.getAvailablePacks()) {
                if (p.isRequired()) {
                    this.bytes += p.getSize();
                    continue;
                }
                if (!this.installData.getSelectedPacks().contains(p)) continue;
                this.bytes += p.getSize();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.showSpaceRequired();
        this.showFreeSpace();
        this.packsTable.setRowSelectionInterval(0, 0);
        this.updateButtons();
    }

    public String getSummaryBody() {
        StringBuilder retval = new StringBuilder(256);
        boolean first = true;
        for (Pack pack : this.installData.getSelectedPacks()) {
            if (!first) {
                retval.append("<br>");
            }
            first = false;
            retval.append(this.getI18NPackName(pack));
        }
        if (this.packsModel.isModifyInstallation()) {
            Map<String, Pack> installedpacks = this.packsModel.getInstalledPacks();
            retval.append("<br><b>");
            retval.append(this.messages.get("PacksPanel.installedpacks.summarycaption", new Object[0]));
            retval.append("</b>");
            retval.append("<br>");
            for (String key : installedpacks.keySet()) {
                Pack pack = installedpacks.get(key);
                retval.append(this.getI18NPackName(pack));
                retval.append("<br>");
            }
        }
        return retval.toString();
    }

    @Override
    public Debugger getDebugger() {
        return this.debugger;
    }

    private void togglePack(int row) {
        PacksModel.CbSelectionState checked = (PacksModel.CbSelectionState)((Object)this.packsModel.getValueAt(row, 0));
        checked = checked != null && checked.isFullyOrPartiallySelected() ? PacksModel.CbSelectionState.DESELECTED : PacksModel.CbSelectionState.SELECTED;
        this.packsModel.setValueAt((Object)checked, row, 0);
        this.packsTable.repaint();
        this.packsTable.changeSelection(row, 0, false, false);
        this.updateButtons();
    }

    private void updateButtons() {
        if (this.installData.getSelectedPacks().isEmpty()) {
            this.parent.lockNextButton();
        } else {
            this.parent.unlockNextButton();
        }
    }

    static class PacksPanelTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -9089892183236584242L;

        PacksPanelTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            PacksModel.CbSelectionState state = (PacksModel.CbSelectionState)((Object)table.getModel().getValueAt(row, 0));
            if (state == PacksModel.CbSelectionState.DEPENDENT_DESELECTED) {
                renderer.setForeground(Color.GRAY);
                if (isSelected) {
                    renderer.setBackground(table.getSelectionBackground());
                } else {
                    renderer.setBackground(table.getBackground());
                }
            } else if (isSelected) {
                renderer.setForeground(table.getSelectionForeground());
                renderer.setBackground(table.getSelectionBackground());
            } else {
                renderer.setForeground(table.getForeground());
                renderer.setBackground(table.getBackground());
            }
            return renderer;
        }
    }

    public static class LFIndependentIcon
    implements Icon {
        ButtonModel buttonModel = null;

        protected int getControlSize() {
            return 13;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int x, int y) {
            ButtonModel model;
            this.buttonModel = model = ((JCheckBox)component).getModel();
            int controlSize = this.getControlSize();
            if (model.isPressed() && model.isArmed()) {
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                if (model.isEnabled()) {
                    graphics.setColor(Color.green);
                } else {
                    graphics.setColor(Color.gray);
                }
                graphics.fillRect(x, y, controlSize - 1, controlSize - 1);
                this.drawPressedBorder(graphics, x, y, controlSize, controlSize, model);
            } else {
                this.drawBorder(graphics, x, y, controlSize, controlSize, model);
            }
            graphics.setColor(Color.green);
            if (model.isSelected()) {
                this.drawCheck(graphics, x, y);
            }
        }

        private void drawBorder(Graphics graphics, int x, int y, int width, int height, ButtonModel model) {
            graphics.translate(x, y);
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            if (!model.isEnabled()) {
                graphics.setColor(new Color(0.4f, 0.4f, 0.4f));
            }
            graphics.drawRect(0, 0, width - 2, height - 2);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            if (!model.isEnabled()) {
                graphics.setColor(new Color(0.6f, 0.6f, 0.6f));
            }
            graphics.drawRect(1, 1, width - 2, height - 2);
            if (model.isEnabled()) {
                graphics.setColor(Color.white);
            } else {
                graphics.setColor(new Color(0.8f, 0.8f, 0.8f));
            }
            graphics.fillRect(2, 2, width - 3, height - 3);
            graphics.setColor(MetalLookAndFeel.getControl());
            graphics.drawLine(0, height - 1, 1, height - 2);
            graphics.drawLine(width - 1, 0, width - 2, 1);
            graphics.translate(-x, -y);
        }

        private void drawPressedBorder(Graphics graphics, int x, int y, int width, int height, ButtonModel model) {
            graphics.translate(x, y);
            this.drawBorder(graphics, 0, 0, width, height, model);
            graphics.setColor(MetalLookAndFeel.getControlShadow());
            graphics.drawLine(1, 1, 1, height - 2);
            graphics.drawLine(1, 1, width - 2, 1);
            graphics.drawLine(2, 2, 2, height - 3);
            graphics.drawLine(2, 2, width - 3, 2);
            graphics.translate(-x, -y);
        }

        protected void drawCheck(Graphics graphics, int x, int y) {
            int controlSize = this.getControlSize();
            if (this.buttonModel != null) {
                if (this.buttonModel.isEnabled()) {
                    graphics.setColor(new Color(0.0f, 0.6f, 0.0f));
                } else {
                    graphics.setColor(new Color(0.1f, 0.1f, 0.1f));
                }
            }
            graphics.drawLine(x + (controlSize - 4), y + 2, x + (controlSize - 4) - 4, y + 2 + 4);
            graphics.drawLine(x + (controlSize - 4), y + 3, x + (controlSize - 4) - 4, y + 3 + 4);
            graphics.drawLine(x + (controlSize - 4), y + 4, x + (controlSize - 4) - 4, y + 4 + 4);
            graphics.drawLine(x + (controlSize - 4) - 4, y + 2 + 4, x + (controlSize - 4) - 4 - 2, y + 2 + 4 - 2);
            graphics.drawLine(x + (controlSize - 4) - 4, y + 3 + 4, x + (controlSize - 4) - 4 - 2, y + 3 + 4 - 2);
            graphics.drawLine(x + (controlSize - 4) - 4, y + 4 + 4, x + (controlSize - 4) - 4 - 2, y + 4 + 4 - 2);
        }

        @Override
        public int getIconWidth() {
            return this.getControlSize();
        }

        @Override
        public int getIconHeight() {
            return this.getControlSize();
        }
    }

    static class CheckBoxRenderer
    implements TableCellRenderer {
        JCheckBox checkbox = new JCheckBox();

        CheckBoxRenderer() {
            if (OsVersion.IS_UNIX && !OsVersion.IS_OSX) {
                this.checkbox.setIcon(new LFIndependentIcon());
                this.checkbox.setDisabledIcon(new LFIndependentIcon());
                this.checkbox.setSelectedIcon(new LFIndependentIcon());
                this.checkbox.setDisabledSelectedIcon(new LFIndependentIcon());
            }
            this.checkbox.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.checkbox.setForeground(table.getSelectionForeground());
                this.checkbox.setBackground(table.getSelectionBackground());
            } else {
                this.checkbox.setForeground(table.getForeground());
                this.checkbox.setBackground(table.getBackground());
            }
            PacksModel.CbSelectionState state = (PacksModel.CbSelectionState)((Object)value);
            if (state == PacksModel.CbSelectionState.DEPENDENT_DESELECTED) {
                this.checkbox.setForeground(Color.GRAY);
            }
            if (state == PacksModel.CbSelectionState.REQUIRED_PARTIAL_SELECTED) {
                this.checkbox.setForeground(Color.RED);
                this.checkbox.setSelected(true);
            }
            if (state != null) {
                this.checkbox.setEnabled(state.isSelectable());
                this.checkbox.setSelected(value != null && state.isSelectedOrRequiredSelected());
            }
            return this.checkbox;
        }
    }
}

