/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.installationtype;

import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JRadioButton;

public class InstallationTypePanel
extends IzPanel
implements ActionListener {
    private static final long serialVersionUID = -8178770882900584122L;
    private static final transient Logger logger = Logger.getLogger(InstallationTypePanel.class.getName());
    private JRadioButton normalinstall;
    private JRadioButton modifyinstall;

    public InstallationTypePanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, Log log) {
        super(panel, parent, installData, (LayoutManager2)new IzPanelLayout(log), resources);
        this.buildGUI();
    }

    private void buildGUI() {
        this.add(LabelFactory.create((String)this.getString("InstallationTypePanel.info"), (Icon)((Icon)this.parent.getIcons().get((Object)"history")), (int)10), "nextLine");
        ButtonGroup group = new ButtonGroup();
        boolean modifyinstallation = Boolean.valueOf(this.installData.getVariable("modify.izpack.install"));
        this.normalinstall = new JRadioButton(this.getString("InstallationTypePanel.normal"), !modifyinstallation);
        this.normalinstall.addActionListener(this);
        group.add(this.normalinstall);
        this.add(this.normalinstall, "nextLine");
        this.modifyinstall = new JRadioButton(this.getString("InstallationTypePanel.modify"), modifyinstallation);
        this.modifyinstall.addActionListener(this);
        group.add(this.modifyinstall);
        this.add(this.modifyinstall, "nextLine");
        this.setInitialFocus(this.normalinstall);
        this.getLayoutHelper().completeLayout();
    }

    public void panelActivate() {
        boolean modifyinstallation = Boolean.valueOf(this.installData.getVariable("modify.izpack.install"));
        if (modifyinstallation) {
            this.modifyinstall.setSelected(true);
        } else {
            this.normalinstall.setSelected(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.normalinstall) {
            logger.fine("Installation type: Normal installation");
            this.installData.setVariable("modify.izpack.install", "false");
        } else {
            logger.fine("Installation type: Modification installation");
            this.installData.setVariable("modify.izpack.install", "true");
        }
    }
}

