/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.compile;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Overrides;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.installer.automation.PanelAutomation;
import com.izforge.izpack.installer.automation.PanelAutomationHelper;
import com.izforge.izpack.panels.compile.CompileHandler;
import com.izforge.izpack.panels.compile.CompileResult;
import com.izforge.izpack.panels.compile.CompileWorker;
import com.izforge.izpack.util.PlatformModelMatcher;
import java.io.IOException;
import java.io.PrintStream;

public class CompilePanelAutomationHelper
extends PanelAutomationHelper
implements PanelAutomation,
CompileHandler {
    private CompileWorker worker = null;
    private int job_max = 0;
    private String job_name = null;
    private int last_line_len = 0;
    private PrintStream stdout;
    private PrintStream stderr;
    private VariableSubstitutor variableSubstitutor;
    private final Resources resources;
    private final PlatformModelMatcher matcher;

    public CompilePanelAutomationHelper(VariableSubstitutor variableSubstitutor, Resources resources, PlatformModelMatcher matcher) {
        this.variableSubstitutor = variableSubstitutor;
        this.resources = resources;
        this.matcher = matcher;
    }

    public void makeXMLData(InstallData installData, IXMLElement panelRoot) {
    }

    public void runAutomated(InstallData idata, IXMLElement panelRoot) throws InstallerException {
        IXMLElement compiler_xml = panelRoot.getFirstChildNamed("compiler");
        String compiler = null;
        if (compiler_xml != null) {
            compiler = compiler_xml.getContent();
        }
        if (compiler == null) {
            throw new InstallerException("invalid automation installDataGUI: could not find compiler");
        }
        IXMLElement args_xml = panelRoot.getFirstChildNamed("arguments");
        String args = null;
        if (args_xml != null) {
            args = args_xml.getContent();
        }
        if (args_xml == null) {
            throw new InstallerException("invalid automation installDataGUI: could not find compiler arguments");
        }
        try {
            this.worker = new CompileWorker(idata, this, this.variableSubstitutor, this.resources, this.matcher);
            this.worker.setCompiler(compiler);
            this.worker.setCompilerArguments(args);
            this.stdout = System.out;
            this.stderr = System.err;
            this.worker.run();
            if (this.worker.getResult().isSuccess()) {
                throw new InstallerException("Compilation failed (xml line " + panelRoot.getLineNr() + ")");
            }
        }
        catch (IOException e) {
            throw new InstallerException((Throwable)e);
        }
    }

    public void processOptions(InstallData installData, Overrides overrides) {
    }

    public void startAction(String name, int noOfJobs) {
        this.stdout.println("[ Starting compilation ]");
        this.job_name = "";
    }

    @Override
    public void handleCompileError(CompileResult error) {
        this.stdout.println();
        this.stdout.println("[ Compilation failed ]");
        this.stderr.println("Command line: " + error.getCmdline());
        this.stderr.println();
        this.stderr.println("stdout of compiler:");
        this.stderr.println(error.getStdout());
        this.stderr.println("stderr of compiler:");
        this.stderr.println(error.getStderr());
        error.setAction(27);
    }

    public void stopAction() {
        if (this.job_name != null && this.last_line_len > 0) {
            String line = this.job_name + ": done.";
            this.stdout.print("\r" + line);
            for (int i = line.length(); i < this.last_line_len; ++i) {
                this.stdout.print(' ');
            }
            this.stdout.println();
        }
        if (this.worker.getResult().isSuccess()) {
            this.stdout.println("[ Compilation successful ]");
        }
    }

    public void progress(int val, String msg) {
        double percentage = (double)val * 100.0 / (double)this.job_max;
        String percent = new Integer((int)percentage).toString() + '%';
        String line = this.job_name + ": " + percent;
        int line_len = line.length();
        this.stdout.print("\r" + line);
        for (int i = line_len; i < this.last_line_len; ++i) {
            this.stdout.print(' ');
        }
        this.last_line_len = line_len;
    }

    public void nextStep(String jobName, int max, int jobNo) {
        if (this.job_name != null && this.last_line_len > 0) {
            String line = this.job_name + ": done.";
            this.stdout.print("\r" + line);
            for (int i = line.length(); i < this.last_line_len; ++i) {
                this.stdout.print(' ');
            }
            this.stdout.println();
        }
        this.job_max = max;
        this.job_name = jobName;
        this.last_line_len = 0;
    }

    public void setSubStepNo(int no_of_substeps) {
        this.job_max = no_of_substeps;
    }

    public void progress(String message) {
    }

    public void restartAction(String name, String overallMessage, String tip, int steps) {
    }

    public void createInstallationRecord(InstallData installData, IXMLElement rootElement) {
    }
}

