/*
 * Decompiled with CFR 0.152.
 */
package jsr166y.forkjoin;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.concurrent.atomic.AtomicInteger;
import jsr166y.forkjoin.ForkJoinExecutor;
import jsr166y.forkjoin.Ops;
import jsr166y.forkjoin.PAS;
import jsr166y.forkjoin.ParallelArray;
import jsr166y.forkjoin.ParallelLongArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelDoubleArray {
    double[] array;
    final ForkJoinExecutor ex;
    int limit;
    AsList listView;

    public static ForkJoinExecutor defaultExecutor() {
        return PAS.defaultExecutor();
    }

    protected ParallelDoubleArray(ForkJoinExecutor executor, double[] array, int limit) {
        if (executor == null || array == null) {
            throw new NullPointerException();
        }
        if (limit < 0 || limit > array.length) {
            throw new IllegalArgumentException();
        }
        this.ex = executor;
        this.array = array;
        this.limit = limit;
    }

    ParallelDoubleArray(ForkJoinExecutor executor, double[] array) {
        this.ex = executor;
        this.array = array;
        this.limit = array.length;
    }

    public static ParallelDoubleArray create(int size, ForkJoinExecutor executor) {
        double[] array = new double[size];
        return new ParallelDoubleArray(executor, array, size);
    }

    public static ParallelDoubleArray createUsingHandoff(double[] handoff, ForkJoinExecutor executor) {
        return new ParallelDoubleArray(executor, handoff, handoff.length);
    }

    public static ParallelDoubleArray createFromCopy(double[] source, ForkJoinExecutor executor) {
        int size = source.length;
        double[] array = new double[size];
        System.arraycopy(source, 0, array, 0, size);
        return new ParallelDoubleArray(executor, array, size);
    }

    public static ParallelDoubleArray createFromCopy(int size, double[] source, ForkJoinExecutor executor) {
        double[] array = new double[size];
        System.arraycopy(source, 0, array, 0, Math.min(source.length, size));
        return new ParallelDoubleArray(executor, array, size);
    }

    public static ParallelDoubleArray createEmpty(int size, ForkJoinExecutor executor) {
        double[] array = new double[size];
        return new ParallelDoubleArray(executor, array, 0);
    }

    public ForkJoinExecutor getExecutor() {
        return this.ex;
    }

    public void apply(Ops.DoubleProcedure procedure) {
        new WithBounds(this).apply(procedure);
    }

    public double reduce(Ops.DoubleReducer reducer, double base) {
        return new WithBounds(this).reduce(reducer, base);
    }

    public ParallelDoubleArray all() {
        return new WithBounds(this).all();
    }

    public ParallelDoubleArray combine(double[] other, Ops.DoubleReducer combiner) {
        return new WithBounds(this).combine(other, combiner);
    }

    public <U, V> ParallelDoubleArray combine(ParallelDoubleArray other, Ops.DoubleReducer combiner) {
        return new WithBounds(this).combine(other, combiner);
    }

    public <U, V> ParallelDoubleArray combine(WithBounds other, Ops.DoubleReducer combiner) {
        return new WithBounds(this).combine(other, combiner);
    }

    public void replaceWithTransform(Ops.DoubleMapper mapper) {
        new WithBounds(this).replaceWithTransform(mapper);
    }

    public void replaceWithMappedIndex(Ops.MapperFromIntToDouble mapper) {
        new WithBounds(this).replaceWithMappedIndex(mapper);
    }

    public void replaceWithGeneratedValue(Ops.DoubleGenerator generator) {
        new WithBounds(this).replaceWithGeneratedValue(generator);
    }

    public void replaceWithValue(double value) {
        new WithBounds(this).replaceWithValue(value);
    }

    public void replaceWithCombination(ParallelDoubleArray other, Ops.DoubleReducer combiner) {
        new WithBounds(this).replaceWithCombination(other.array, combiner);
    }

    public void replaceWithCombination(double[] other, Ops.DoubleReducer combiner) {
        new WithBounds(this).replaceWithCombination(other, combiner);
    }

    public void replaceWithCombination(WithBounds other, Ops.DoubleReducer combiner) {
        new WithBounds(this).replaceWithCombination(other, combiner);
    }

    public int indexOf(double target) {
        return new WithBounds(this).indexOf(target);
    }

    public int binarySearch(double target) {
        int lo = 0;
        int hi = this.limit - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            double m = this.array[mid];
            if (target == m) {
                return mid;
            }
            if (target < m) {
                hi = mid - 1;
                continue;
            }
            lo = mid + 1;
        }
        return -1;
    }

    public int binarySearch(double target, Ops.DoubleComparator comparator) {
        int lo = 0;
        int hi = this.limit - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            int c = comparator.compare(target, this.array[mid]);
            if (c == 0) {
                return mid;
            }
            if (c < 0) {
                hi = mid - 1;
                continue;
            }
            lo = mid + 1;
        }
        return -1;
    }

    public SummaryStatistics summary(Ops.DoubleComparator comparator) {
        return new WithBounds(this).summary(comparator);
    }

    public SummaryStatistics summary() {
        return new WithBounds(this).summary();
    }

    public double min(Ops.DoubleComparator comparator) {
        return new WithBounds(this).min(comparator);
    }

    public double min() {
        return new WithBounds(this).min();
    }

    public double max(Ops.DoubleComparator comparator) {
        return new WithBounds(this).max(comparator);
    }

    public double max() {
        return new WithBounds(this).max();
    }

    public void cumulate(Ops.DoubleReducer reducer, double base) {
        new WithBounds(this).cumulate(reducer, base);
    }

    public double precumulate(Ops.DoubleReducer reducer, double base) {
        return new WithBounds(this).precumulate(reducer, base);
    }

    public void sort(Ops.DoubleComparator comparator) {
        new WithBounds(this).sort(comparator);
    }

    public void sort() {
        new WithBounds(this).sort();
    }

    public void removeConsecutiveDuplicates() {
        new WithBounds(this).removeConsecutiveDuplicates();
    }

    public ParallelDoubleArray allUniqueElements() {
        return new WithBounds(this).allUniqueElements();
    }

    public double sum() {
        return new WithBounds(this).sum();
    }

    public void cumulateSum() {
        new WithBounds(this).cumulateSum();
    }

    public double precumulateSum() {
        return new WithBounds(this).precumulateSum();
    }

    public WithBounds withBounds(int firstIndex, int upperBound) {
        if (firstIndex > upperBound) {
            throw new IllegalArgumentException("firstIndex(" + firstIndex + ") > upperBound(" + upperBound + ")");
        }
        if (firstIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(firstIndex);
        }
        if (upperBound > this.limit) {
            throw new ArrayIndexOutOfBoundsException(upperBound);
        }
        return new WithBounds(this, firstIndex, upperBound);
    }

    public WithFilter withFilter(Ops.DoublePredicate selector) {
        return new WithBoundedFilter(this, 0, this.limit, selector);
    }

    public <U> WithMapping<U> withMapping(Ops.MapperFromDouble<? extends U> mapper) {
        return new WithBoundedMapping<U>(this, 0, this.limit, mapper);
    }

    public WithDoubleMapping withMapping(Ops.DoubleMapper mapper) {
        return new WithBoundedDoubleMapping(this, 0, this.limit, mapper);
    }

    public WithLongMapping withMapping(Ops.MapperFromDoubleToLong mapper) {
        return new WithBoundedLongMapping(this, 0, this.limit, mapper);
    }

    public Iterator<Double> iterator() {
        return new ParallelDoubleArrayIterator(this.array, this.limit);
    }

    public List<Double> asList() {
        AsList lv = this.listView;
        if (lv == null) {
            this.listView = lv = new AsList();
        }
        return lv;
    }

    public int size() {
        return this.limit;
    }

    public double[] getArray() {
        return this.array;
    }

    public double get(int i) {
        return this.array[i];
    }

    public void set(int i, double x) {
        this.array[i] = x;
    }

    public String toString() {
        return this.asList().toString();
    }

    public void addAll(double[] other) {
        int csize = other.length;
        int end = this.limit;
        this.insertSlotsAt(end, csize);
        System.arraycopy(other, 0, this.array, end, csize);
    }

    public void addAll(ParallelDoubleArray other) {
        int csize = other.size();
        int end = this.limit;
        this.insertSlotsAt(end, csize);
        System.arraycopy(other.array, 0, this.array, end, csize);
    }

    public void addAll(WithBounds other) {
        int csize = other.size();
        int end = this.limit;
        this.insertSlotsAt(end, csize);
        System.arraycopy(other.pa.array, other.firstIndex, this.array, end, csize);
    }

    public final void setLimit(int newLimit) {
        if (newLimit < 0) {
            throw new IllegalArgumentException();
        }
        int cap = this.array.length;
        if (newLimit > cap) {
            this.resizeArray(newLimit);
        }
        this.limit = newLimit;
    }

    final void replaceElementsWith(double[] a) {
        System.arraycopy(a, 0, this.array, 0, a.length);
        this.limit = a.length;
    }

    final void resizeArray(int newCap) {
        int cap = this.array.length;
        if (newCap > cap) {
            double[] a = new double[newCap];
            System.arraycopy(this.array, 0, a, 0, cap);
            this.array = a;
        }
    }

    final void insertElementAt(int index, double e) {
        int hi;
        if ((hi = this.limit++) >= this.array.length) {
            this.resizeArray(hi * 3 / 2 + 1);
        }
        if (hi > index) {
            System.arraycopy(this.array, index, this.array, index + 1, hi - index);
        }
        this.array[index] = e;
    }

    final void appendElement(double e) {
        int hi;
        if ((hi = this.limit++) >= this.array.length) {
            this.resizeArray(hi * 3 / 2 + 1);
        }
        this.array[hi] = e;
    }

    final void insertSlotsAt(int index, int len) {
        if (len <= 0) {
            return;
        }
        int cap = this.array.length;
        int newSize = this.limit + len;
        if (cap < newSize) {
            if ((cap = cap * 3 / 2 + 1) < newSize) {
                cap = newSize;
            }
            this.resizeArray(cap);
        }
        if (index < this.limit) {
            System.arraycopy(this.array, index, this.array, index + len, this.limit - index);
        }
        this.limit = newSize;
    }

    final void removeSlotAt(int index) {
        System.arraycopy(this.array, index + 1, this.array, index, this.limit - index - 1);
        --this.limit;
    }

    final void removeSlotsAt(int fromIndex, int toIndex) {
        if (fromIndex < toIndex) {
            int newSize;
            int size = this.limit;
            System.arraycopy(this.array, toIndex, this.array, fromIndex, size - toIndex);
            this.limit = newSize = size - (toIndex - fromIndex);
        }
    }

    final int seqIndexOf(double target) {
        double[] arr = this.array;
        int fence = this.limit;
        for (int i = 0; i < fence; ++i) {
            if (target != arr[i]) continue;
            return i;
        }
        return -1;
    }

    final int seqLastIndexOf(double target) {
        double[] arr = this.array;
        for (int i = this.limit - 1; i >= 0; --i) {
            if (target != arr[i]) continue;
            return i;
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class AsList
    extends AbstractList<Double>
    implements RandomAccess {
        AsList() {
        }

        @Override
        public Double get(int i) {
            if (i >= ParallelDoubleArray.this.limit) {
                throw new IndexOutOfBoundsException();
            }
            return ParallelDoubleArray.this.array[i];
        }

        @Override
        public Double set(int i, Double x) {
            if (i >= ParallelDoubleArray.this.limit) {
                throw new IndexOutOfBoundsException();
            }
            double[] arr = ParallelDoubleArray.this.array;
            Double t = arr[i];
            arr[i] = x;
            return t;
        }

        @Override
        public boolean isEmpty() {
            return ParallelDoubleArray.this.limit == 0;
        }

        @Override
        public int size() {
            return ParallelDoubleArray.this.limit;
        }

        @Override
        public Iterator<Double> iterator() {
            return new ListIter(0);
        }

        @Override
        public ListIterator<Double> listIterator() {
            return new ListIter(0);
        }

        @Override
        public ListIterator<Double> listIterator(int index) {
            if (index < 0 || index > ParallelDoubleArray.this.limit) {
                throw new IndexOutOfBoundsException();
            }
            return new ListIter(index);
        }

        @Override
        public boolean add(Double e) {
            ParallelDoubleArray.this.appendElement(e);
            return true;
        }

        @Override
        public void add(int index, Double e) {
            if (index < 0 || index > ParallelDoubleArray.this.limit) {
                throw new IndexOutOfBoundsException();
            }
            ParallelDoubleArray.this.insertElementAt(index, e);
        }

        @Override
        public boolean addAll(Collection<? extends Double> c) {
            int csize = c.size();
            if (csize == 0) {
                return false;
            }
            int hi = ParallelDoubleArray.this.limit;
            ParallelDoubleArray.this.setLimit(hi + csize);
            double[] arr = ParallelDoubleArray.this.array;
            for (Double d : c) {
                arr[hi++] = d;
            }
            return true;
        }

        @Override
        public boolean addAll(int index, Collection<? extends Double> c) {
            if (index < 0 || index > ParallelDoubleArray.this.limit) {
                throw new IndexOutOfBoundsException();
            }
            int csize = c.size();
            if (csize == 0) {
                return false;
            }
            ParallelDoubleArray.this.insertSlotsAt(index, csize);
            double[] arr = ParallelDoubleArray.this.array;
            for (Double d : c) {
                arr[index++] = d;
            }
            return true;
        }

        @Override
        public void clear() {
            ParallelDoubleArray.this.limit = 0;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Double)) {
                return false;
            }
            int idx = ParallelDoubleArray.this.seqIndexOf((Double)o);
            if (idx < 0) {
                return false;
            }
            ParallelDoubleArray.this.removeSlotAt(idx);
            return true;
        }

        @Override
        public Double remove(int index) {
            Double oldValue = this.get(index);
            ParallelDoubleArray.this.removeSlotAt(index);
            return oldValue;
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            ParallelDoubleArray.this.removeSlotsAt(fromIndex, toIndex);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Double)) {
                return false;
            }
            return ParallelDoubleArray.this.seqIndexOf((Double)o) >= 0;
        }

        @Override
        public int indexOf(Object o) {
            if (!(o instanceof Double)) {
                return -1;
            }
            return ParallelDoubleArray.this.seqIndexOf((Double)o);
        }

        @Override
        public int lastIndexOf(Object o) {
            if (!(o instanceof Double)) {
                return -1;
            }
            return ParallelDoubleArray.this.seqLastIndexOf((Double)o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ListIter
    implements ListIterator<Double> {
        int cursor;
        int lastRet;
        double[] arr;
        int hi;

        ListIter(int lo) {
            this.cursor = lo;
            this.lastRet = -1;
            this.arr = ParallelDoubleArray.this.array;
            this.hi = ParallelDoubleArray.this.limit;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.hi;
        }

        @Override
        public Double next() {
            int i = this.cursor;
            if (i < 0 || i >= this.hi) {
                throw new NoSuchElementException();
            }
            double next = this.arr[i];
            this.lastRet = i;
            this.cursor = i + 1;
            return next;
        }

        @Override
        public void remove() {
            int k = this.lastRet;
            if (k < 0) {
                throw new IllegalStateException();
            }
            ParallelDoubleArray.this.removeSlotAt(k);
            this.hi = ParallelDoubleArray.this.limit;
            if (this.lastRet < this.cursor) {
                --this.cursor;
            }
            this.lastRet = -1;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public Double previous() {
            int i = this.cursor - 1;
            if (i < 0 || i >= this.hi) {
                throw new NoSuchElementException();
            }
            double previous = this.arr[i];
            this.lastRet = this.cursor = i;
            return previous;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(Double e) {
            int i = this.lastRet;
            if (i < 0 || i >= this.hi) {
                throw new NoSuchElementException();
            }
            this.arr[i] = e;
        }

        @Override
        public void add(Double e) {
            int i = this.cursor;
            ParallelDoubleArray.this.insertElementAt(i, e);
            this.arr = ParallelDoubleArray.this.array;
            this.hi = ParallelDoubleArray.this.limit;
            this.lastRet = -1;
            this.cursor = i + 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ParallelDoubleArrayIterator
    implements Iterator<Double> {
        int cursor;
        final double[] arr;
        final int hi;

        ParallelDoubleArrayIterator(double[] a, int limit) {
            this.arr = a;
            this.hi = limit;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.hi;
        }

        @Override
        public Double next() {
            if (this.cursor >= this.hi) {
                throw new NoSuchElementException();
            }
            return this.arr[this.cursor++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class WithBoundedFilteredLongMapping
    extends WithLongMapping {
        final Ops.DoublePredicate selector;

        WithBoundedFilteredLongMapping(ParallelDoubleArray pa, int firstIndex, int upperBound, Ops.DoublePredicate selector, Ops.MapperFromDoubleToLong mapper) {
            super(pa, firstIndex, upperBound, mapper);
            this.selector = selector;
        }

        @Override
        public ParallelLongArray all() {
            PAS.FJLSelectAllDriver r = new PAS.FJLSelectAllDriver(this);
            this.ex.invoke(r);
            return new ParallelLongArray(this.ex, r.results);
        }

        @Override
        public int size() {
            PAS.FJDCountSelected f = new PAS.FJDCountSelected(this, this.firstIndex, this.upperBound, null, this.selector);
            this.ex.invoke(f);
            return f.count;
        }

        @Override
        public int anyIndex() {
            AtomicInteger result = new AtomicInteger(-1);
            PAS.FJDSelectAny f = new PAS.FJDSelectAny(this, this.firstIndex, this.upperBound, null, result, this.selector);
            this.ex.invoke(f);
            return result.get();
        }

        @Override
        public WithDoubleMapping withMapping(Ops.MapperFromLongToDouble mapper) {
            return new WithBoundedFilteredDoubleMapping(this.pa, this.firstIndex, this.upperBound, this.selector, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public WithLongMapping withMapping(Ops.LongMapper mapper) {
            return new WithBoundedFilteredLongMapping(this.pa, this.firstIndex, this.upperBound, this.selector, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public <U> WithMapping<U> withMapping(Ops.MapperFromLong<? extends U> mapper) {
            return new WithBoundedFilteredMapping<U>(this.pa, this.firstIndex, this.upperBound, this.selector, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
            Ops.DoublePredicate sel = this.selector;
            Ops.MapperFromDoubleToLong mpr = this.mapper;
            double[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                double x = array[i];
                if (!sel.evaluate(x)) continue;
                procedure.apply(mpr.map(x));
            }
        }

        @Override
        long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
            boolean gotFirst = false;
            long r = base;
            double[] array = this.pa.array;
            Ops.DoublePredicate sel = this.selector;
            Ops.MapperFromDoubleToLong mpr = this.mapper;
            for (int i = lo; i < hi; ++i) {
                double t = array[i];
                if (!sel.evaluate(t)) continue;
                long y = mpr.map(t);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.combine(r, y);
            }
            return r;
        }

        @Override
        void leafStats(int lo, int hi, PAS.FJLStats task) {
            double[] array = this.pa.array;
            Ops.DoublePredicate sel = this.selector;
            Ops.MapperFromDoubleToLong mpr = this.mapper;
            int count = 0;
            for (int i = lo; i < hi; ++i) {
                double t = array[i];
                if (!sel.evaluate(t)) continue;
                ++count;
                long x = mpr.map(t);
                task.sum += x;
                task.updateMin(i, x);
                task.updateMax(i, x);
            }
            task.size = count;
        }

        @Override
        int leafIndexSelected(int lo, int hi, boolean positive, int[] indices) {
            Ops.DoublePredicate sel = this.selector;
            double[] array = this.pa.array;
            int k = 0;
            for (int i = lo; i < hi; ++i) {
                if (sel.evaluate(array[i]) != positive) continue;
                indices[lo + k++] = i;
            }
            return k;
        }

        @Override
        int leafMoveSelected(int lo, int hi, int offset, boolean positive) {
            Ops.DoublePredicate sel = this.selector;
            double[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                double t = array[i];
                if (sel.evaluate(t) != positive) continue;
                array[offset++] = t;
            }
            return offset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class WithBoundedLongMapping
    extends WithLongMapping {
        WithBoundedLongMapping(ParallelDoubleArray pa, int firstIndex, int upperBound, Ops.MapperFromDoubleToLong mapper) {
            super(pa, firstIndex, upperBound, mapper);
        }

        @Override
        public ParallelLongArray all() {
            long[] dest = new long[this.upperBound - this.firstIndex];
            PAS.FJLMap f = new PAS.FJLMap(this, this.firstIndex, this.upperBound, null, dest, this.firstIndex);
            this.ex.invoke(f);
            return new ParallelLongArray(this.ex, dest);
        }

        @Override
        public int size() {
            return this.upperBound - this.firstIndex;
        }

        @Override
        public int anyIndex() {
            return this.firstIndex < this.upperBound ? this.firstIndex : -1;
        }

        @Override
        public WithDoubleMapping withMapping(Ops.MapperFromLongToDouble mapper) {
            return new WithBoundedDoubleMapping(this.pa, this.firstIndex, this.upperBound, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public WithLongMapping withMapping(Ops.LongMapper mapper) {
            return new WithBoundedLongMapping(this.pa, this.firstIndex, this.upperBound, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public <U> WithMapping<U> withMapping(Ops.MapperFromLong<? extends U> mapper) {
            return new WithBoundedMapping<U>(this.pa, this.firstIndex, this.upperBound, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
            double[] array = this.pa.array;
            Ops.MapperFromDoubleToLong mpr = this.mapper;
            for (int i = lo; i < hi; ++i) {
                procedure.apply(mpr.map(array[i]));
            }
        }

        @Override
        long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
            if (lo >= hi) {
                return base;
            }
            double[] array = this.pa.array;
            Ops.MapperFromDoubleToLong mpr = this.mapper;
            long r = mpr.map(array[lo]);
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.combine(r, mpr.map(array[i]));
            }
            return r;
        }

        @Override
        void leafStats(int lo, int hi, PAS.FJLStats task) {
            double[] array = this.pa.array;
            Ops.MapperFromDoubleToLong mpr = this.mapper;
            task.size = hi - lo;
            for (int i = lo; i < hi; ++i) {
                long x = mpr.map(array[i]);
                task.sum += x;
                task.updateMin(i, x);
                task.updateMax(i, x);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class WithLongMapping
    extends PAS.DPrefix {
        final Ops.MapperFromDoubleToLong mapper;

        WithLongMapping(ParallelDoubleArray pa, int firstIndex, int upperBound, Ops.MapperFromDoubleToLong mapper) {
            super(pa, firstIndex, upperBound);
            this.mapper = mapper;
        }

        public void apply(Ops.LongProcedure procedure) {
            this.ex.invoke(new PAS.FJLApply(this, this.firstIndex, this.upperBound, null, procedure));
        }

        public long reduce(Ops.LongReducer reducer, long base) {
            PAS.FJLReduce f = new PAS.FJLReduce(this, this.firstIndex, this.upperBound, null, reducer, base);
            this.ex.invoke(f);
            return f.result;
        }

        public long min() {
            return this.reduce(Ops.naturalLongMinReducer(), Long.MAX_VALUE);
        }

        public long min(Ops.LongComparator comparator) {
            return this.reduce(Ops.longMinReducer(comparator), Long.MAX_VALUE);
        }

        public long max() {
            return this.reduce(Ops.naturalLongMaxReducer(), Long.MIN_VALUE);
        }

        public long max(Ops.LongComparator comparator) {
            return this.reduce(Ops.longMaxReducer(comparator), Long.MIN_VALUE);
        }

        public long sum() {
            return this.reduce(Ops.longAdder(), 0L);
        }

        public ParallelLongArray.SummaryStatistics summary(Ops.LongComparator comparator) {
            PAS.FJLStats f = new PAS.FJLStats(this, this.firstIndex, this.upperBound, null, comparator);
            this.ex.invoke(f);
            return f;
        }

        public ParallelLongArray.SummaryStatistics summary() {
            PAS.FJLStats f = new PAS.FJLStats(this, this.firstIndex, this.upperBound, null, Ops.naturalLongComparator());
            this.ex.invoke(f);
            return f;
        }

        public abstract ParallelLongArray all();

        public abstract int size();

        public abstract int anyIndex();

        public abstract WithDoubleMapping withMapping(Ops.MapperFromLongToDouble var1);

        public abstract WithLongMapping withMapping(Ops.LongMapper var1);

        public abstract <U> WithMapping<U> withMapping(Ops.MapperFromLong<? extends U> var1);

        @Override
        final void leafTransfer(int lo, int hi, long[] dest, int offset) {
            double[] array = this.pa.array;
            Ops.MapperFromDoubleToLong mpr = this.mapper;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = mpr.map(array[i]);
            }
        }

        @Override
        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, long[] dest, int offset) {
            double[] array = this.pa.array;
            Ops.MapperFromDoubleToLong mpr = this.mapper;
            for (int i = loIdx; i < hiIdx; ++i) {
                dest[offset++] = mpr.map(array[indices[i]]);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class WithBoundedFilteredDoubleMapping
    extends WithDoubleMapping {
        final Ops.DoublePredicate selector;
        final Ops.DoubleMapper mapper;

        WithBoundedFilteredDoubleMapping(ParallelDoubleArray pa, int firstIndex, int upperBound, Ops.DoublePredicate selector, Ops.DoubleMapper mapper) {
            super(pa, firstIndex, upperBound);
            this.selector = selector;
            this.mapper = mapper;
        }

        @Override
        public ParallelDoubleArray all() {
            PAS.FJDSelectAllDriver r = new PAS.FJDSelectAllDriver(this);
            this.ex.invoke(r);
            return new ParallelDoubleArray(this.ex, r.results);
        }

        @Override
        public int size() {
            PAS.FJDCountSelected f = new PAS.FJDCountSelected(this, this.firstIndex, this.upperBound, null, this.selector);
            this.ex.invoke(f);
            return f.count;
        }

        @Override
        public int anyIndex() {
            AtomicInteger result = new AtomicInteger(-1);
            PAS.FJDSelectAny f = new PAS.FJDSelectAny(this, this.firstIndex, this.upperBound, null, result, this.selector);
            this.ex.invoke(f);
            return result.get();
        }

        @Override
        public WithDoubleMapping withMapping(Ops.DoubleMapper mapper) {
            return new WithBoundedFilteredDoubleMapping(this.pa, this.firstIndex, this.upperBound, this.selector, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public WithLongMapping withMapping(Ops.MapperFromDoubleToLong mapper) {
            return new WithBoundedFilteredLongMapping(this.pa, this.firstIndex, this.upperBound, this.selector, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public <U> WithMapping<U> withMapping(Ops.MapperFromDouble<? extends U> mapper) {
            return new WithBoundedFilteredMapping<U>(this.pa, this.firstIndex, this.upperBound, this.selector, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
            Ops.DoublePredicate sel = this.selector;
            Ops.DoubleMapper mpr = this.mapper;
            double[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                double x = array[i];
                if (!sel.evaluate(x)) continue;
                procedure.apply(mpr.map(x));
            }
        }

        @Override
        double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
            Ops.DoublePredicate sel = this.selector;
            boolean gotFirst = false;
            double r = base;
            double[] array = this.pa.array;
            Ops.DoubleMapper mpr = this.mapper;
            for (int i = lo; i < hi; ++i) {
                double t = array[i];
                if (!sel.evaluate(t)) continue;
                double y = mpr.map(t);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.combine(r, y);
            }
            return r;
        }

        @Override
        void leafStats(int lo, int hi, PAS.FJDStats task) {
            Ops.DoublePredicate sel = this.selector;
            double[] array = this.pa.array;
            Ops.DoubleMapper mpr = this.mapper;
            int count = 0;
            for (int i = lo; i < hi; ++i) {
                double t = array[i];
                if (!sel.evaluate(t)) continue;
                ++count;
                double x = mpr.map(t);
                task.sum += x;
                task.updateMin(i, x);
                task.updateMax(i, x);
            }
            task.size = count;
        }

        @Override
        void leafTransfer(int lo, int hi, double[] dest, int offset) {
            double[] array = this.pa.array;
            Ops.DoubleMapper mpr = this.mapper;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = mpr.map(array[i]);
            }
        }

        @Override
        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, double[] dest, int offset) {
            double[] array = this.pa.array;
            Ops.DoubleMapper mpr = this.mapper;
            for (int i = loIdx; i < hiIdx; ++i) {
                dest[offset++] = array[indices[i]];
            }
        }

        @Override
        int leafIndexSelected(int lo, int hi, boolean positive, int[] indices) {
            Ops.DoublePredicate sel = this.selector;
            double[] array = this.pa.array;
            int k = 0;
            for (int i = lo; i < hi; ++i) {
                if (sel.evaluate(array[i]) != positive) continue;
                indices[lo + k++] = i;
            }
            return k;
        }

        @Override
        int leafMoveSelected(int lo, int hi, int offset, boolean positive) {
            Ops.DoublePredicate sel = this.selector;
            double[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                double t = array[i];
                if (sel.evaluate(t) != positive) continue;
                array[offset++] = t;
            }
            return offset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class WithBoundedDoubleMapping
    extends WithDoubleMapping {
        final Ops.DoubleMapper mapper;

        WithBoundedDoubleMapping(ParallelDoubleArray pa, int firstIndex, int upperBound, Ops.DoubleMapper mapper) {
            super(pa, firstIndex, upperBound);
            this.mapper = mapper;
        }

        @Override
        public ParallelDoubleArray all() {
            double[] dest = new double[this.upperBound - this.firstIndex];
            PAS.FJDMap f = new PAS.FJDMap(this, this.firstIndex, this.upperBound, null, dest, this.firstIndex);
            this.ex.invoke(f);
            return new ParallelDoubleArray(this.ex, dest);
        }

        @Override
        public int size() {
            return this.upperBound - this.firstIndex;
        }

        @Override
        public int anyIndex() {
            return this.firstIndex < this.upperBound ? this.firstIndex : -1;
        }

        @Override
        public WithDoubleMapping withMapping(Ops.DoubleMapper mapper) {
            return new WithBoundedDoubleMapping(this.pa, this.firstIndex, this.upperBound, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public WithLongMapping withMapping(Ops.MapperFromDoubleToLong mapper) {
            return new WithBoundedLongMapping(this.pa, this.firstIndex, this.upperBound, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public <U> WithMapping<U> withMapping(Ops.MapperFromDouble<? extends U> mapper) {
            return new WithBoundedMapping<U>(this.pa, this.firstIndex, this.upperBound, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
            double[] array = this.pa.array;
            Ops.DoubleMapper mpr = this.mapper;
            for (int i = lo; i < hi; ++i) {
                procedure.apply(mpr.map(array[i]));
            }
        }

        @Override
        double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
            if (lo >= hi) {
                return base;
            }
            double[] array = this.pa.array;
            Ops.DoubleMapper mpr = this.mapper;
            double r = mpr.map(array[lo]);
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.combine(r, mpr.map(array[i]));
            }
            return r;
        }

        @Override
        void leafStats(int lo, int hi, PAS.FJDStats task) {
            task.size = hi - lo;
            double[] array = this.pa.array;
            Ops.DoubleMapper mpr = this.mapper;
            for (int i = lo; i < hi; ++i) {
                double x = mpr.map(array[i]);
                task.sum += x;
                task.updateMin(i, x);
                task.updateMax(i, x);
            }
        }

        @Override
        void leafTransfer(int lo, int hi, double[] dest, int offset) {
            double[] array = this.pa.array;
            Ops.DoubleMapper mpr = this.mapper;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = mpr.map(array[i]);
            }
        }

        @Override
        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, double[] dest, int offset) {
            double[] array = this.pa.array;
            Ops.DoubleMapper mpr = this.mapper;
            for (int i = loIdx; i < hiIdx; ++i) {
                dest[offset++] = array[indices[i]];
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class WithBoundedFilter
    extends WithFilter {
        final Ops.DoublePredicate selector;

        WithBoundedFilter(ParallelDoubleArray pa, int firstIndex, int upperBound, Ops.DoublePredicate selector) {
            super(pa, firstIndex, upperBound);
            this.selector = selector;
        }

        @Override
        public WithFilter withFilter(Ops.DoublePredicate selector) {
            return new WithBoundedFilter(this.pa, this.firstIndex, this.upperBound, Ops.andPredicate(this.selector, selector));
        }

        @Override
        public WithFilter orFilter(Ops.DoublePredicate selector) {
            return new WithBoundedFilter(this.pa, this.firstIndex, this.upperBound, Ops.orPredicate(this.selector, selector));
        }

        @Override
        public <U> WithMapping<U> withMapping(Ops.MapperFromDouble<? extends U> mapper) {
            return new WithBoundedFilteredMapping<U>(this.pa, this.firstIndex, this.upperBound, this.selector, mapper);
        }

        @Override
        public WithDoubleMapping withMapping(Ops.DoubleMapper mapper) {
            return new WithBoundedFilteredDoubleMapping(this.pa, this.firstIndex, this.upperBound, this.selector, mapper);
        }

        @Override
        public WithLongMapping withMapping(Ops.MapperFromDoubleToLong mapper) {
            return new WithBoundedFilteredLongMapping(this.pa, this.firstIndex, this.upperBound, this.selector, mapper);
        }

        @Override
        public int anyIndex() {
            AtomicInteger result = new AtomicInteger(-1);
            PAS.FJDSelectAny f = new PAS.FJDSelectAny(this, this.firstIndex, this.upperBound, null, result, this.selector);
            this.ex.invoke(f);
            return result.get();
        }

        @Override
        public ParallelDoubleArray all() {
            PAS.FJDSelectAllDriver r = new PAS.FJDSelectAllDriver(this);
            this.ex.invoke(r);
            return new ParallelDoubleArray(this.ex, r.results);
        }

        @Override
        public int size() {
            PAS.FJDCountSelected f = new PAS.FJDCountSelected(this, this.firstIndex, this.upperBound, null, this.selector);
            this.ex.invoke(f);
            return f.count;
        }

        @Override
        public ParallelDoubleArray allUniqueElements() {
            PAS.DUniquifierTable tab = new PAS.DUniquifierTable(this.upperBound - this.firstIndex, this.pa.array, this.selector);
            PAS.FJUniquifier f = new PAS.FJUniquifier(this, this.firstIndex, this.upperBound, null, tab);
            this.ex.invoke(f);
            double[] res = tab.uniqueElements(f.count);
            return new ParallelDoubleArray(this.ex, res);
        }

        @Override
        public void removeAll() {
            PAS.FJRemoveAllDriver f = new PAS.FJRemoveAllDriver(this, this.firstIndex, this.upperBound);
            this.ex.invoke(f);
            this.pa.removeSlotsAt(f.offset, this.upperBound);
        }

        @Override
        void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
            Ops.DoublePredicate sel = this.selector;
            double[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                double x = array[i];
                if (!sel.evaluate(x)) continue;
                procedure.apply(x);
            }
        }

        @Override
        double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
            Ops.DoublePredicate sel = this.selector;
            boolean gotFirst = false;
            double r = base;
            double[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                double x = array[i];
                if (!sel.evaluate(x)) continue;
                if (!gotFirst) {
                    gotFirst = true;
                    r = x;
                    continue;
                }
                r = reducer.combine(r, x);
            }
            return r;
        }

        @Override
        void leafStats(int lo, int hi, PAS.FJDStats task) {
            Ops.DoublePredicate sel = this.selector;
            double[] array = this.pa.array;
            int count = 0;
            for (int i = lo; i < hi; ++i) {
                double x = array[i];
                if (!sel.evaluate(x)) continue;
                ++count;
                task.sum += x;
                task.updateMin(i, x);
                task.updateMax(i, x);
            }
            task.size = count;
        }

        @Override
        void leafTransform(int lo, int hi, Ops.DoubleMapper mapper) {
            Ops.DoublePredicate sel = this.selector;
            double[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                double x = array[i];
                if (!sel.evaluate(x)) continue;
                array[i] = mapper.map(x);
            }
        }

        @Override
        void leafIndexMap(int lo, int hi, Ops.MapperFromIntToDouble mapper) {
            Ops.DoublePredicate sel = this.selector;
            double[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                double x = array[i];
                if (!sel.evaluate(x)) continue;
                array[i] = mapper.map(i);
            }
        }

        @Override
        void leafGenerate(int lo, int hi, Ops.DoubleGenerator generator) {
            Ops.DoublePredicate sel = this.selector;
            double[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                double x = array[i];
                if (!sel.evaluate(x)) continue;
                array[i] = generator.generate();
            }
        }

        @Override
        void leafFillValue(int lo, int hi, double value) {
            Ops.DoublePredicate sel = this.selector;
            double[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                double x = array[i];
                if (!sel.evaluate(x)) continue;
                array[i] = value;
            }
        }

        @Override
        void leafCombineInPlace(int lo, int hi, double[] other, int otherOffset, Ops.DoubleReducer combiner) {
            Ops.DoublePredicate sel = this.selector;
            double[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                double x = array[i];
                if (!sel.evaluate(x)) continue;
                array[i] = combiner.combine(x, other[i + otherOffset]);
            }
        }

        @Override
        int leafIndexSelected(int lo, int hi, boolean positive, int[] indices) {
            Ops.DoublePredicate sel = this.selector;
            double[] array = this.pa.array;
            int k = 0;
            for (int i = lo; i < hi; ++i) {
                if (sel.evaluate(array[i]) != positive) continue;
                indices[lo + k++] = i;
            }
            return k;
        }

        @Override
        int leafMoveSelected(int lo, int hi, int offset, boolean positive) {
            Ops.DoublePredicate sel = this.selector;
            double[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                double t = array[i];
                if (sel.evaluate(t) != positive) continue;
                array[offset++] = t;
            }
            return offset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class WithBounds
    extends WithFilter {
        WithBounds(ParallelDoubleArray pa, int firstIndex, int upperBound) {
            super(pa, firstIndex, upperBound);
        }

        WithBounds(ParallelDoubleArray pa) {
            super(pa, 0, pa.limit);
        }

        public WithBounds withBounds(int firstIndex, int upperBound) {
            if (firstIndex > upperBound) {
                throw new IllegalArgumentException("firstIndex(" + firstIndex + ") > upperBound(" + upperBound + ")");
            }
            if (firstIndex < 0) {
                throw new ArrayIndexOutOfBoundsException(firstIndex);
            }
            if (upperBound - firstIndex > this.upperBound - this.firstIndex) {
                throw new ArrayIndexOutOfBoundsException(upperBound);
            }
            return new WithBounds(this.pa, this.firstIndex + firstIndex, this.firstIndex + upperBound);
        }

        @Override
        public WithFilter withFilter(Ops.DoublePredicate selector) {
            return new WithBoundedFilter(this.pa, this.firstIndex, this.upperBound, selector);
        }

        @Override
        public <U> WithMapping<U> withMapping(Ops.MapperFromDouble<? extends U> mapper) {
            return new WithBoundedMapping<U>(this.pa, this.firstIndex, this.upperBound, mapper);
        }

        @Override
        public WithDoubleMapping withMapping(Ops.DoubleMapper mapper) {
            return new WithBoundedDoubleMapping(this.pa, this.firstIndex, this.upperBound, mapper);
        }

        @Override
        public WithLongMapping withMapping(Ops.MapperFromDoubleToLong mapper) {
            return new WithBoundedLongMapping(this.pa, this.firstIndex, this.upperBound, mapper);
        }

        @Override
        public WithFilter orFilter(Ops.DoublePredicate selector) {
            return new WithBoundedFilter(this.pa, this.firstIndex, this.upperBound, selector);
        }

        @Override
        public int anyIndex() {
            return this.firstIndex < this.upperBound ? this.firstIndex : -1;
        }

        public ParallelDoubleArray combine(double[] other, Ops.DoubleReducer combiner) {
            int size = this.upperBound - this.firstIndex;
            if (other.length < size) {
                throw new ArrayIndexOutOfBoundsException();
            }
            double[] dest = new double[size];
            this.ex.invoke(new PAS.FJDCombine(this, this.firstIndex, this.upperBound, null, other, -this.firstIndex, dest, combiner));
            return new ParallelDoubleArray(this.ex, dest);
        }

        public ParallelDoubleArray combine(ParallelDoubleArray other, Ops.DoubleReducer combiner) {
            int size = this.upperBound - this.firstIndex;
            if (other.size() < size) {
                throw new ArrayIndexOutOfBoundsException();
            }
            double[] dest = new double[size];
            this.ex.invoke(new PAS.FJDCombine(this, this.firstIndex, this.upperBound, null, other.array, -this.firstIndex, dest, combiner));
            return new ParallelDoubleArray(this.ex, dest);
        }

        public <U, V> ParallelDoubleArray combine(WithBounds other, Ops.DoubleReducer combiner) {
            int size = this.upperBound - this.firstIndex;
            if (other.size() < size) {
                throw new ArrayIndexOutOfBoundsException();
            }
            double[] dest = new double[size];
            this.ex.invoke(new PAS.FJDCombine(this, this.firstIndex, this.upperBound, null, other.pa.array, other.firstIndex - this.firstIndex, dest, combiner));
            return new ParallelDoubleArray(this.ex, dest);
        }

        @Override
        public ParallelDoubleArray all() {
            double[] array = this.pa.array;
            int size = this.upperBound - this.firstIndex;
            double[] dest = new double[size];
            System.arraycopy(array, this.firstIndex, dest, 0, size);
            return new ParallelDoubleArray(this.ex, dest);
        }

        @Override
        public ParallelDoubleArray allUniqueElements() {
            PAS.DUniquifierTable tab = new PAS.DUniquifierTable(this.upperBound - this.firstIndex, this.pa.array, null);
            PAS.FJUniquifier f = new PAS.FJUniquifier(this, this.firstIndex, this.upperBound, null, tab);
            this.ex.invoke(f);
            double[] res = tab.uniqueElements(f.count);
            return new ParallelDoubleArray(this.ex, res);
        }

        public int indexOf(double target) {
            AtomicInteger result = new AtomicInteger(-1);
            PAS.FJDIndexOf f = new PAS.FJDIndexOf(this, this.firstIndex, this.upperBound, null, result, target);
            this.ex.invoke(f);
            return result.get();
        }

        public int binarySearch(double target) {
            double[] array = this.pa.array;
            int lo = this.firstIndex;
            int hi = this.upperBound - 1;
            while (lo <= hi) {
                int mid = lo + hi >>> 1;
                double m = array[mid];
                if (target == m) {
                    return mid;
                }
                if (target < m) {
                    hi = mid - 1;
                    continue;
                }
                lo = mid + 1;
            }
            return -1;
        }

        public int binarySearch(double target, Ops.DoubleComparator comparator) {
            double[] array = this.pa.array;
            int lo = this.firstIndex;
            int hi = this.upperBound - 1;
            while (lo <= hi) {
                int mid = lo + hi >>> 1;
                int c = comparator.compare(target, array[mid]);
                if (c == 0) {
                    return mid;
                }
                if (c < 0) {
                    hi = mid - 1;
                    continue;
                }
                lo = mid + 1;
            }
            return -1;
        }

        @Override
        public int size() {
            return this.upperBound - this.firstIndex;
        }

        public void cumulate(Ops.DoubleReducer reducer, double base) {
            PAS.FJDCumulateOp op = new PAS.FJDCumulateOp(this, reducer, base);
            PAS.FJDScan r = new PAS.FJDScan(null, op, this.firstIndex, this.upperBound);
            this.ex.invoke(r);
        }

        public void cumulateSum() {
            PAS.FJDCumulatePlusOp op = new PAS.FJDCumulatePlusOp(this);
            PAS.FJDScan r = new PAS.FJDScan(null, op, this.firstIndex, this.upperBound);
            this.ex.invoke(r);
        }

        public double precumulate(Ops.DoubleReducer reducer, double base) {
            PAS.FJDPrecumulateOp op = new PAS.FJDPrecumulateOp(this, reducer, base);
            PAS.FJDScan r = new PAS.FJDScan(null, op, this.firstIndex, this.upperBound);
            this.ex.invoke(r);
            return r.out;
        }

        public double precumulateSum() {
            PAS.FJDPrecumulatePlusOp op = new PAS.FJDPrecumulatePlusOp(this);
            PAS.FJDScan r = new PAS.FJDScan(null, op, this.firstIndex, this.upperBound);
            this.ex.invoke(r);
            return r.out;
        }

        public void sort(Ops.DoubleComparator cmp) {
            this.ex.invoke(new PAS.FJDSorter(cmp, this.pa.array, new double[this.upperBound], this.firstIndex, this.upperBound - this.firstIndex, this.threshold));
        }

        public void sort() {
            this.ex.invoke(new PAS.FJDCSorter(this.pa.array, new double[this.upperBound], this.firstIndex, this.upperBound - this.firstIndex, this.threshold));
        }

        @Override
        public void removeAll() {
            this.pa.removeSlotsAt(this.firstIndex, this.upperBound);
        }

        public void removeConsecutiveDuplicates() {
            int k = this.firstIndex;
            int n = this.upperBound;
            if (k < n) {
                double[] arr = this.pa.array;
                double last = arr[k++];
                for (int i = k; i < n; ++i) {
                    double x = arr[i];
                    if (last == x) continue;
                    arr[k++] = last = x;
                }
                this.pa.removeSlotsAt(k, n);
            }
        }

        @Override
        void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
            double[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                procedure.apply(array[i]);
            }
        }

        @Override
        double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
            if (lo >= hi) {
                return base;
            }
            double[] array = this.pa.array;
            double r = array[lo];
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.combine(r, array[i]);
            }
            return r;
        }

        @Override
        void leafStats(int lo, int hi, PAS.FJDStats task) {
            double[] array = this.pa.array;
            task.size = hi - lo;
            for (int i = lo; i < hi; ++i) {
                double x = array[i];
                task.sum += x;
                task.updateMin(i, x);
                task.updateMax(i, x);
            }
        }

        @Override
        void leafTransform(int lo, int hi, Ops.DoubleMapper mapper) {
            double[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                array[i] = mapper.map(array[i]);
            }
        }

        @Override
        void leafIndexMap(int lo, int hi, Ops.MapperFromIntToDouble mapper) {
            double[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                array[i] = mapper.map(i);
            }
        }

        @Override
        void leafGenerate(int lo, int hi, Ops.DoubleGenerator generator) {
            double[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                array[i] = generator.generate();
            }
        }

        @Override
        void leafFillValue(int lo, int hi, double value) {
            double[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                array[i] = value;
            }
        }

        @Override
        void leafCombineInPlace(int lo, int hi, double[] other, int otherOffset, Ops.DoubleReducer combiner) {
            double[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                array[i] = combiner.combine(array[i], other[i + otherOffset]);
            }
        }

        @Override
        void leafCombine(int lo, int hi, double[] other, int otherOffset, double[] dest, Ops.DoubleReducer combiner) {
            double[] array = this.pa.array;
            int k = lo - this.firstIndex;
            for (int i = lo; i < hi; ++i) {
                dest[k] = combiner.combine(array[i], other[i + otherOffset]);
                ++k;
            }
        }
    }

    public static abstract class WithFilter
    extends WithDoubleMapping {
        WithFilter(ParallelDoubleArray pa, int firstIndex, int upperBound) {
            super(pa, firstIndex, upperBound);
        }

        public void replaceWithTransform(Ops.DoubleMapper mapper) {
            this.ex.invoke(new PAS.FJDTransform(this, this.firstIndex, this.upperBound, null, mapper));
        }

        public void replaceWithMappedIndex(Ops.MapperFromIntToDouble mapper) {
            this.ex.invoke(new PAS.FJDIndexMap(this, this.firstIndex, this.upperBound, null, mapper));
        }

        public void replaceWithGeneratedValue(Ops.DoubleGenerator generator) {
            this.ex.invoke(new PAS.FJDGenerate(this, this.firstIndex, this.upperBound, null, generator));
        }

        public void replaceWithValue(double value) {
            this.ex.invoke(new PAS.FJDFill(this, this.firstIndex, this.upperBound, null, value));
        }

        public void replaceWithCombination(ParallelDoubleArray other, Ops.DoubleReducer combiner) {
            if (other.size() < this.size()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.ex.invoke(new PAS.FJDCombineInPlace(this, this.firstIndex, this.upperBound, null, other.array, 0, combiner));
        }

        public void replaceWithCombination(WithBounds other, Ops.DoubleReducer combiner) {
            if (other.size() < this.size()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.ex.invoke(new PAS.FJDCombineInPlace(this, this.firstIndex, this.upperBound, null, other.pa.array, other.firstIndex - this.firstIndex, combiner));
        }

        public void replaceWithCombination(double[] other, Ops.DoubleReducer combiner) {
            if (other.length < this.size()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.ex.invoke(new PAS.FJDCombineInPlace(this, this.firstIndex, this.upperBound, null, other, -this.firstIndex, combiner));
        }

        public abstract void removeAll();

        public abstract ParallelDoubleArray allUniqueElements();

        public abstract WithFilter withFilter(Ops.DoublePredicate var1);

        public abstract WithFilter orFilter(Ops.DoublePredicate var1);

        final void leafTransfer(int lo, int hi, double[] dest, int offset) {
            double[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = array[i];
            }
        }

        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, double[] dest, int offset) {
            double[] array = this.pa.array;
            for (int i = loIdx; i < hiIdx; ++i) {
                dest[offset++] = array[indices[i]];
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class WithDoubleMapping
    extends PAS.DPrefix {
        WithDoubleMapping(ParallelDoubleArray pa, int firstIndex, int upperBound) {
            super(pa, firstIndex, upperBound);
        }

        public void apply(Ops.DoubleProcedure procedure) {
            this.ex.invoke(new PAS.FJDApply(this, this.firstIndex, this.upperBound, null, procedure));
        }

        public double reduce(Ops.DoubleReducer reducer, double base) {
            PAS.FJDReduce f = new PAS.FJDReduce(this, this.firstIndex, this.upperBound, null, reducer, base);
            this.ex.invoke(f);
            return f.result;
        }

        public double min() {
            return this.reduce(Ops.naturalDoubleMinReducer(), Double.MAX_VALUE);
        }

        public double min(Ops.DoubleComparator comparator) {
            return this.reduce(Ops.doubleMinReducer(comparator), Double.MAX_VALUE);
        }

        public double max() {
            return this.reduce(Ops.naturalDoubleMaxReducer(), -1.7976931348623157E308);
        }

        public double max(Ops.DoubleComparator comparator) {
            return this.reduce(Ops.doubleMaxReducer(comparator), -1.7976931348623157E308);
        }

        public double sum() {
            return this.reduce(Ops.doubleAdder(), 0.0);
        }

        public SummaryStatistics summary(Ops.DoubleComparator comparator) {
            PAS.FJDStats f = new PAS.FJDStats(this, this.firstIndex, this.upperBound, null, comparator);
            this.ex.invoke(f);
            return f;
        }

        public SummaryStatistics summary() {
            PAS.FJDStats f = new PAS.FJDStats(this, this.firstIndex, this.upperBound, null, Ops.naturalDoubleComparator());
            this.ex.invoke(f);
            return f;
        }

        public abstract ParallelDoubleArray all();

        public abstract int size();

        public abstract int anyIndex();

        public abstract WithDoubleMapping withMapping(Ops.DoubleMapper var1);

        public abstract WithLongMapping withMapping(Ops.MapperFromDoubleToLong var1);

        public abstract <U> WithMapping<U> withMapping(Ops.MapperFromDouble<? extends U> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class WithBoundedFilteredMapping<U>
    extends WithMapping<U> {
        final Ops.DoublePredicate selector;

        WithBoundedFilteredMapping(ParallelDoubleArray pa, int firstIndex, int upperBound, Ops.DoublePredicate selector, Ops.MapperFromDouble<? extends U> mapper) {
            super(pa, firstIndex, upperBound, mapper);
            this.selector = selector;
        }

        @Override
        public ParallelArray<U> all() {
            PAS.FJRSelectAllDriver r = new PAS.FJRSelectAllDriver(this, Object.class);
            this.ex.invoke(r);
            return new ParallelArray<Object>(this.ex, r.results);
        }

        @Override
        public ParallelArray<U> all(Class<? super U> elementType) {
            PAS.FJRSelectAllDriver r = new PAS.FJRSelectAllDriver(this, elementType);
            this.ex.invoke(r);
            return new ParallelArray<Object>(this.ex, r.results);
        }

        @Override
        public int size() {
            PAS.FJDCountSelected f = new PAS.FJDCountSelected(this, this.firstIndex, this.upperBound, null, this.selector);
            this.ex.invoke(f);
            return f.count;
        }

        @Override
        public int anyIndex() {
            AtomicInteger result = new AtomicInteger(-1);
            PAS.FJDSelectAny f = new PAS.FJDSelectAny(this, this.firstIndex, this.upperBound, null, result, this.selector);
            this.ex.invoke(f);
            return result.get();
        }

        @Override
        public U any() {
            int idx = this.anyIndex();
            double[] array = this.pa.array;
            Ops.MapperFromDouble mpr = this.mapper;
            return idx < 0 ? null : (U)mpr.map(array[idx]);
        }

        @Override
        public <V> WithMapping<V> withMapping(Ops.Mapper<? super U, ? extends V> mapper) {
            return new WithBoundedFilteredMapping<V>(this.pa, this.firstIndex, this.upperBound, this.selector, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public WithDoubleMapping withMapping(Ops.MapperToDouble<? super U> mapper) {
            return new WithBoundedFilteredDoubleMapping(this.pa, this.firstIndex, this.upperBound, this.selector, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public WithLongMapping withMapping(Ops.MapperToLong<? super U> mapper) {
            return new WithBoundedFilteredLongMapping(this.pa, this.firstIndex, this.upperBound, this.selector, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.Procedure procedure) {
            Ops.DoublePredicate sel = this.selector;
            Ops.MapperFromDouble mpr = this.mapper;
            double[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                double x = array[i];
                if (!sel.evaluate(x)) continue;
                procedure.apply(mpr.map(x));
            }
        }

        @Override
        Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
            boolean gotFirst = false;
            Object r = base;
            Ops.DoublePredicate sel = this.selector;
            Ops.MapperFromDouble mpr = this.mapper;
            double[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                double x = array[i];
                if (!sel.evaluate(x)) continue;
                Object y = mpr.map(x);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.combine(r, y);
            }
            return r;
        }

        @Override
        void leafStats(int lo, int hi, PAS.FJRStats task) {
            double[] array = this.pa.array;
            Ops.DoublePredicate sel = this.selector;
            Ops.MapperFromDouble mpr = this.mapper;
            int count = 0;
            for (int i = lo; i < hi; ++i) {
                double t = array[i];
                if (!sel.evaluate(t)) continue;
                Object x = mpr.map(t);
                ++count;
                task.updateMin(i, x);
                task.updateMax(i, x);
            }
            task.size = count;
        }

        @Override
        int leafIndexSelected(int lo, int hi, boolean positive, int[] indices) {
            Ops.DoublePredicate sel = this.selector;
            double[] array = this.pa.array;
            int k = 0;
            for (int i = lo; i < hi; ++i) {
                if (sel.evaluate(array[i]) != positive) continue;
                indices[lo + k++] = i;
            }
            return k;
        }

        @Override
        int leafMoveSelected(int lo, int hi, int offset, boolean positive) {
            Ops.DoublePredicate sel = this.selector;
            double[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                double t = array[i];
                if (sel.evaluate(t) != positive) continue;
                array[offset++] = t;
            }
            return offset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class WithBoundedMapping<U>
    extends WithMapping<U> {
        WithBoundedMapping(ParallelDoubleArray pa, int firstIndex, int upperBound, Ops.MapperFromDouble<? extends U> mapper) {
            super(pa, firstIndex, upperBound, mapper);
        }

        @Override
        public ParallelArray<U> all() {
            int n = this.upperBound - this.firstIndex;
            Object[] dest = new Object[n];
            PAS.FJRMap f = new PAS.FJRMap(this, this.firstIndex, this.upperBound, null, dest, this.firstIndex);
            this.ex.invoke(f);
            return new ParallelArray<Object>(this.ex, dest);
        }

        @Override
        public ParallelArray<U> all(Class<? super U> elementType) {
            int n = this.upperBound - this.firstIndex;
            Object[] dest = (Object[])Array.newInstance(elementType, n);
            PAS.FJRMap f = new PAS.FJRMap(this, this.firstIndex, this.upperBound, null, dest, this.firstIndex);
            this.ex.invoke(f);
            return new ParallelArray<Object>(this.ex, dest);
        }

        @Override
        public int size() {
            return this.upperBound - this.firstIndex;
        }

        @Override
        public int anyIndex() {
            return this.firstIndex < this.upperBound ? this.firstIndex : -1;
        }

        @Override
        public U any() {
            double[] array = this.pa.array;
            Ops.MapperFromDouble mpr = this.mapper;
            return this.firstIndex < this.upperBound ? (U)mpr.map(array[this.firstIndex]) : null;
        }

        @Override
        public <V> WithMapping<V> withMapping(Ops.Mapper<? super U, ? extends V> mapper) {
            return new WithBoundedMapping<V>(this.pa, this.firstIndex, this.upperBound, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public WithDoubleMapping withMapping(Ops.MapperToDouble<? super U> mapper) {
            return new WithBoundedDoubleMapping(this.pa, this.firstIndex, this.upperBound, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public WithLongMapping withMapping(Ops.MapperToLong<? super U> mapper) {
            return new WithBoundedLongMapping(this.pa, this.firstIndex, this.upperBound, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.Procedure procedure) {
            double[] array = this.pa.array;
            Ops.MapperFromDouble mpr = this.mapper;
            for (int i = lo; i < hi; ++i) {
                procedure.apply(mpr.map(array[i]));
            }
        }

        @Override
        Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
            if (lo >= hi) {
                return base;
            }
            double[] array = this.pa.array;
            Ops.MapperFromDouble mpr = this.mapper;
            Object r = mpr.map(array[lo]);
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.combine(r, mpr.map(array[i]));
            }
            return r;
        }

        @Override
        void leafStats(int lo, int hi, PAS.FJRStats task) {
            double[] array = this.pa.array;
            Ops.MapperFromDouble mpr = this.mapper;
            task.size = hi - lo;
            for (int i = lo; i < hi; ++i) {
                Object x = mpr.map(array[i]);
                task.updateMin(i, x);
                task.updateMax(i, x);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class WithMapping<U>
    extends PAS.DPrefix {
        final Ops.MapperFromDouble<? extends U> mapper;

        WithMapping(ParallelDoubleArray pa, int firstIndex, int upperBound, Ops.MapperFromDouble<? extends U> mapper) {
            super(pa, firstIndex, upperBound);
            this.mapper = mapper;
        }

        public void apply(Ops.Procedure<? super U> procedure) {
            this.ex.invoke(new PAS.FJRApply(this, this.firstIndex, this.upperBound, null, procedure));
        }

        public U reduce(Ops.Reducer<U> reducer, U base) {
            PAS.FJRReduce f = new PAS.FJRReduce(this, this.firstIndex, this.upperBound, null, reducer, base);
            this.ex.invoke(f);
            return (U)f.result;
        }

        public abstract int anyIndex();

        public abstract U any();

        public U min(Comparator<? super U> comparator) {
            return this.reduce(Ops.minReducer(comparator), null);
        }

        public U min() {
            return this.reduce(Ops.castedMinReducer(), null);
        }

        public U max(Comparator<? super U> comparator) {
            return this.reduce(Ops.maxReducer(comparator), null);
        }

        public U max() {
            return this.reduce(Ops.castedMaxReducer(), null);
        }

        public ParallelArray.SummaryStatistics<U> summary(Comparator<? super U> comparator) {
            PAS.FJRStats f = new PAS.FJRStats(this, this.firstIndex, this.upperBound, null, comparator);
            this.ex.invoke(f);
            return f;
        }

        public ParallelArray.SummaryStatistics<U> summary() {
            PAS.FJRStats f = new PAS.FJRStats(this, this.firstIndex, this.upperBound, null, Ops.castedComparator());
            this.ex.invoke(f);
            return f;
        }

        public abstract ParallelArray<U> all();

        public abstract ParallelArray<U> all(Class<? super U> var1);

        public abstract int size();

        public abstract <V> WithMapping<V> withMapping(Ops.Mapper<? super U, ? extends V> var1);

        public abstract WithDoubleMapping withMapping(Ops.MapperToDouble<? super U> var1);

        public abstract WithLongMapping withMapping(Ops.MapperToLong<? super U> var1);

        @Override
        final void leafTransfer(int lo, int hi, Object[] dest, int offset) {
            double[] array = this.pa.array;
            Ops.MapperFromDouble<U> mpr = this.mapper;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = mpr.map(array[i]);
            }
        }

        @Override
        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, Object[] dest, int offset) {
            double[] array = this.pa.array;
            Ops.MapperFromDouble<U> mpr = this.mapper;
            for (int i = loIdx; i < hiIdx; ++i) {
                dest[offset++] = mpr.map(array[indices[i]]);
            }
        }
    }

    public static interface SummaryStatistics {
        public int size();

        public double min();

        public double max();

        public int indexOfMin();

        public int indexOfMax();

        public double sum();

        public double average();
    }
}

