/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.impl.condorcet;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.chorem.pollen.votecounting.api.AbstractVoteCountingStrategy;
import org.chorem.pollen.votecounting.api.model.ChoiceScore;
import org.chorem.pollen.votecounting.api.model.EmptyVoteCountingConfig;
import org.chorem.pollen.votecounting.api.model.VoteCountingResult;
import org.chorem.pollen.votecounting.api.model.VoteForChoice;
import org.chorem.pollen.votecounting.api.model.Voter;
import org.chorem.pollen.votecounting.impl.condorcet.CondorcetBattle;
import org.chorem.pollen.votecounting.impl.condorcet.CondorcetDetailResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CondorcetVoteCountingStrategy
extends AbstractVoteCountingStrategy<EmptyVoteCountingConfig> {
    private static final Logger log = LoggerFactory.getLogger(CondorcetVoteCountingStrategy.class);

    public CondorcetVoteCountingStrategy() {
        super(EmptyVoteCountingConfig.class);
    }

    @Override
    public VoteCountingResult voteCount(Set<Voter> voters) {
        Map<String, ChoiceScore> scores = this.newEmptyChoiceScoreMap(voters);
        CondorcetDetailResult detailResult = new CondorcetDetailResult();
        for (Voter voter : voters) {
            this.addVoterChoices(voter, detailResult);
        }
        this.resolveBattles(detailResult, scores);
        return this.orderByValues(scores.values(), detailResult);
    }

    @Override
    public Set<VoteForChoice> toVoteForChoices(VoteCountingResult voteCountingResult) {
        HashSet voteForChoices = Sets.newHashSet();
        for (ChoiceScore choiceScore : voteCountingResult.getScores()) {
            double score = choiceScore.getScoreOrder();
            VoteForChoice voteForChoice = VoteForChoice.newVote(choiceScore.getChoiceId(), score);
            voteForChoices.add(voteForChoice);
        }
        return voteForChoices;
    }

    protected void addVoterChoices(Voter voter, CondorcetDetailResult detailResult) {
        if (log.isDebugEnabled()) {
            log.debug("Start count for voter " + voter.getVoterId());
        }
        double voterWeight = voter.getWeight();
        for (VoteForChoice voteForChoiceX : voter.getVoteForChoices()) {
            String choiceIdX = voteForChoiceX.getChoiceId();
            for (VoteForChoice voteForChoiceY : voter.getVoteForChoices()) {
                int compare;
                String choiceIdY = voteForChoiceY.getChoiceId();
                if (choiceIdX.equals(choiceIdY) || (compare = this.voteValueComparator.compare(voteForChoiceX, voteForChoiceY)) >= 0) continue;
                this.addBattle(detailResult, choiceIdX, choiceIdY, voterWeight);
                this.addBattle(detailResult, choiceIdY, choiceIdX, -voterWeight);
            }
        }
    }

    protected void addBattle(CondorcetDetailResult detailResult, String opponentId, String runnerId, double score) {
        CondorcetBattle battle2;
        Optional<CondorcetBattle> battleOptional = detailResult.getBattles().stream().filter(battle -> battle.getOpponentId().equals(opponentId) && battle.getRunnerId().equals(runnerId)).findFirst();
        if (battleOptional.isPresent()) {
            battle2 = battleOptional.get();
        } else {
            battle2 = new CondorcetBattle();
            battle2.setOpponentId(opponentId);
            battle2.setRunnerId(runnerId);
            detailResult.getBattles().add(battle2);
        }
        battle2.addScoreValue(score);
    }

    protected void resolveBattles(CondorcetDetailResult detailResult, Map<String, ChoiceScore> scores) {
        for (CondorcetBattle battle : detailResult.getBattles()) {
            ChoiceScore choiceScore = scores.get(battle.getOpponentId());
            choiceScore.addScoreValue(battle.getScore().signum());
        }
    }
}

