/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.api;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.chorem.pollen.votecounting.api.VoteCountingStrategy;
import org.chorem.pollen.votecounting.api.model.ChoiceIdAble;
import org.chorem.pollen.votecounting.api.model.ChoiceScore;
import org.chorem.pollen.votecounting.api.model.ListOfVoter;
import org.chorem.pollen.votecounting.api.model.ListVoteCountingResult;
import org.chorem.pollen.votecounting.api.model.VoteCountingConfig;
import org.chorem.pollen.votecounting.api.model.VoteCountingDetailResult;
import org.chorem.pollen.votecounting.api.model.VoteCountingResult;
import org.chorem.pollen.votecounting.api.model.VoteForChoice;
import org.chorem.pollen.votecounting.api.model.Voter;

public abstract class AbstractVoteCountingStrategy<C extends VoteCountingConfig>
implements VoteCountingStrategy<C> {
    public static final BigDecimal ZERO_D = BigDecimal.valueOf(0.0);
    protected final Comparator<VoteForChoice> voteValueComparator = Comparator.comparing(VoteForChoice::getVoteValue, Comparator.nullsLast(Comparator.naturalOrder()));
    protected C config;
    private final Class<C> configClass;

    public AbstractVoteCountingStrategy(Class<C> configClass) {
        this.configClass = configClass;
    }

    @Override
    public void setConfig(C config) {
        this.config = config;
    }

    @Override
    public final ListVoteCountingResult voteCount(ListOfVoter listOfVoter) {
        HashSet lists = Sets.newHashSet();
        this.recursiveVoteCount(listOfVoter, lists);
        return ListVoteCountingResult.newResult(listOfVoter, lists);
    }

    protected Map<String, ChoiceScore> newEmptyChoiceScoreMap(Set<Voter> voters) {
        Set<String> choiceIds = this.getAllChoiceIds(voters);
        HashMap resultByChoice = Maps.newHashMap();
        for (String choiceId : choiceIds) {
            ChoiceScore choiceScore = ChoiceScore.newScore(choiceId, ZERO_D);
            resultByChoice.put(choiceId, choiceScore);
        }
        return resultByChoice;
    }

    protected VoteCountingResult orderByValues(Collection<ChoiceScore> scores, VoteCountingDetailResult detailResult) {
        ImmutableListMultimap map = Multimaps.index(scores, ChoiceScore::getScoreValue);
        ArrayList values = Lists.newArrayList(map.asMap().keySet());
        Collections.sort(values);
        Collections.reverse(values);
        int rank = 0;
        for (BigDecimal value : values) {
            Collection scoresForValue = map.get((Object)value);
            for (ChoiceScore score : scoresForValue) {
                score.setScoreOrder(rank);
            }
            ++rank;
        }
        ArrayList orderedScores = Lists.newArrayList((Iterable)map.values());
        Collections.sort(orderedScores);
        return VoteCountingResult.newResult(orderedScores, detailResult);
    }

    public Set<String> getAllChoiceIds(Set<Voter> voters) {
        ChoiceIdAble.ChoiceIdAbleById function = new ChoiceIdAble.ChoiceIdAbleById();
        HashSet result = Sets.newHashSet();
        for (Voter voter : voters) {
            voter.getVoteForChoices().stream().map(function).forEach(result::add);
        }
        return result;
    }

    public Map<Voter, List<Set<String>>> buildVoterSortedChoices(Set<Voter> voters) {
        HashMap voterSortedChoices = Maps.newHashMap();
        for (Voter voter : voters) {
            List<Set<String>> sortedChoices = this.sortVoteForChoices(voter.getVoteForChoices());
            voterSortedChoices.put(voter, sortedChoices);
        }
        return voterSortedChoices;
    }

    public List<Set<String>> sortVoteForChoices(Set<VoteForChoice> voteForChoices) {
        ArrayList sortedChoices = Lists.newArrayList(voteForChoices);
        sortedChoices.sort(this.voteValueComparator);
        ArrayList result = Lists.newArrayList();
        HashSet set = Sets.newHashSet();
        result.add(set);
        VoteForChoice lastVoteForChoice = null;
        for (VoteForChoice voteForChoice : sortedChoices) {
            if (lastVoteForChoice != null && this.voteValueComparator.compare(lastVoteForChoice, voteForChoice) != 0) {
                set = Sets.newHashSet();
                result.add(set);
            }
            set.add(voteForChoice.getChoiceId());
            lastVoteForChoice = voteForChoice;
        }
        return result;
    }

    protected void recursiveVoteCount(ListOfVoter listOfVoter, Set<ListOfVoter> listOfVoters) {
        listOfVoters.add(listOfVoter);
        Set<Voter> voters = listOfVoter.getVoters();
        for (Voter voter : voters) {
            if (!(voter instanceof ListOfVoter)) continue;
            this.recursiveVoteCount((ListOfVoter)voter, listOfVoters);
        }
        VoteCountingResult voteCountingResult = this.voteCount(voters);
        listOfVoter.setResult(voteCountingResult);
        Set<VoteForChoice> voteForChoices = this.toVoteForChoices(voteCountingResult);
        listOfVoter.getVoteForChoices().addAll(voteForChoices);
    }

    @Override
    public C parseConfigFromJson(String json) {
        Gson gson = new GsonBuilder().create();
        if (json == null || "null".equals(json)) {
            try {
                return (C)((VoteCountingConfig)this.configClass.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return (C)((VoteCountingConfig)gson.fromJson(json, this.configClass));
    }
}

