/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: AddChoice.java 3698 2012-09-23 13:01:38Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.5/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/poll/vote/AddChoice.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.poll.vote;

import com.opensymphony.xwork2.Preparable;
import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.bean.PollImageChoice;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.ChoiceType;
import org.chorem.pollen.services.PollenServiceFunctions;
import org.chorem.pollen.services.exceptions.PollNotFoundException;
import org.chorem.pollen.ui.actions.FileUploadAware;

import java.io.File;

/**
 * To add a poll comment.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class AddChoice extends AbstractVoteAction implements Preparable, FileUploadAware {

    private static final long serialVersionUID = 1L;

    protected Choice choice;

    private File imageChoice;

    private String imageChoiceFileName;

    public Choice getChoice() {
        return choice;
    }

    @Override
    public void addFile(int index, File file) {
        imageChoice = file;
    }

    @Override
    public void addFileContentType(int index, String contentType) {
    }

    @Override
    public void addFileName(int index, String fileName) {
        imageChoiceFileName = fileName;
    }

    @Override
    public boolean isModerate() {
        return false;
    }

    @Override
    public void prepare() throws PollNotFoundException {

        loadPoll();

        ChoiceType choiceType = getPoll().getChoiceType();
        choice = getPollService().getNewChoice(choiceType);

        // Push image choice data from uploaded file
        if (ChoiceType.IMAGE == choiceType && imageChoice != null) {

            String fileName = imageChoiceFileName;
            String location = imageChoice.getAbsolutePath();
            choice.setName(fileName);
            ((PollImageChoice) choice).setLocation(location);
        }
    }

    @Override
    public void validate() {

        Poll poll = getPoll();

        ChoiceType choiceType = poll.getChoiceType();

        String propName = PollenServiceFunctions.CHOICE_TYPE_TO_PROPERTY_NAME.apply(choiceType);

        String choiceName = choice.getName();

        // -- Validate value notEmpty
        if (StringUtils.isBlank(choiceName)) {
            String typeLabel = getText(choiceType.getI18nKey());
            addFieldError("choice." + propName,
                          _("pollen.error.choice.empty", typeLabel));
        } else {

            if (!poll.isChoiceEmpty()) {

                // check that the choice is not already used

                for (Choice pollChoice : poll.getChoice()) {
                    String pollChoiceName = pollChoice.getName();
                    if (pollChoiceName.equals(choiceName)) {
                        addFieldError("choice." + propName,
                                      _("pollen.error.poll.choice.already.used.name"));
                        break;
                    }
                }
            }
        }
    }

    @InputConfig(methodName = PREPARE_VOTE_PAGE)
    @Override
    public String execute() throws Exception {

        getPollService().addChoice(getPollUri().getPollId(), choice);

        return SUCCESS;
    }

}
