/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: Edit.java 3651 2012-08-28 16:29:38Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.3/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/user/Edit.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.user;

import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.services.exceptions.UserEmailAlreadyUsedException;
import org.chorem.pollen.services.exceptions.UserInvalidPasswordException;
import org.chorem.pollen.ui.actions.PollenActionSupportForEdition;
import org.nuiton.util.StringUtil;

/**
 * Update a user.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class Edit extends PollenActionSupportForEdition {

    private static final long serialVersionUID = 1L;

    protected UserAccount pollenUserAccount;

    protected String newPassword;

    protected String newPassword2;

    public UserAccount getPollenUserAccount() {
        if (pollenUserAccount == null) {
            pollenUserAccount = getUserService().getNewUser();
        }
        return pollenUserAccount;
    }

    public String getNewPassword() {
        return newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String getNewPassword2() {
        return newPassword2;
    }

    public void setNewPassword2(String newPassword2) {
        this.newPassword2 = newPassword2;
    }

    @Override
    public String input() throws Exception {
        UserAccount userAccount = super.getPollenUserAccount();
        pollenUserAccount = getUserService().getEntityById(
                UserAccount.class,
                userAccount.getTopiaId());
        return INPUT;
    }


    @Override
    public void validate() {

        if (StringUtils.isBlank(pollenUserAccount.getLogin())) {
            addFieldError("pollenUserAccount.login",
                          _("pollen.error.login.required"));
        }

        if (StringUtils.isBlank(pollenUserAccount.getPassword())) {
            addFieldError("pollenUserAccount.password",
                          _("pollen.error.password.required"));
        }

        if (StringUtils.isNotBlank(getNewPassword())) {
            if (ObjectUtils.notEqual(getNewPassword(), getNewPassword2())) {
                addFieldError("newPassword",
                              _("pollen.error.passwords.not.equals"));
            }
        }

        // can only change email (for the moment at create time not after)
        if (!isExists()) {
            if (StringUtils.isBlank(pollenUserAccount.getEmail())) {
                addFieldError("pollenUserAccount.email",
                              _("pollen.error.email.required"));
            } else if (!StringUtil.isEmail(pollenUserAccount.getEmail())) {
                addFieldError("pollenUserAccount.email",
                              _("pollen.error.email.invalid"));
            }
        }
    }

    @Override
    public String execute() throws Exception {

        // let's push back admin property to user to save
        pollenUserAccount.setAdministrator(
                super.getPollenUserAccount().isAdministrator());

        String result = INPUT;
        try {
            UserAccount updatedUser =
                    getUserService().updateUser(pollenUserAccount,
                                                newPassword, false);

            // push back user to session
            getPollenSession().setUserAccount(updatedUser);

            addFlashMessage(_("pollen.information.pollAccount.updated"));
            result = SUCCESS;
        } catch (UserEmailAlreadyUsedException e) {
            addFieldError("pollenUserAccount.email",
                          _("pollen.error.user.email.already.used"));
        } catch (UserInvalidPasswordException e) {
            addFieldError("pollenUserAccount.password",
                          _("pollen.error.user.invalid.password"));
        }

        // reset password
        pollenUserAccount.setPassword(null);
        newPassword = newPassword2 = null;

        return result;
    }

    public boolean isExists() {
        return StringUtils.isNotBlank(pollenUserAccount.getTopiaId());
    }

}
