<%--
  #%L
  Pollen :: UI (strust2)
  
  $Id: vote.jsp 3332 2012-04-30 15:52:29Z fdesbois $
  $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3/pollen-ui-struts2/src/main/webapp/WEB-INF/jsp/poll/vote.jsp $
  %%
  Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>
<%@ taglib prefix="sjg" uri="/struts-jquery-grid-tags" %>

<title><s:property value="%{poll.title}"/></title>

<link rel="stylesheet" type="text/css"
      href="<s:url value='/css/vote.css'/>"/>

<script type="text/javascript"
        src="<s:url value='/js/gridHelper.js' />"></script>

<s:url id='deleteImg' value='/img/delete.png'/>
<s:set id='deleteTitle'><s:text name="pollen.action.pollCommentDelete"/></s:set>

<script type="text/javascript">

  function commentFunctions(cellvalue, options, rowObject) {

    var id = rowObject.id;

    var result = "";

    if (cellvalue.indexOf('delete') > -1) {
      var url = "return openDeleteCommentDialog(\"" + id + "\");";
      result += formatLink(id, url, "${deleteImg}", "Delete", "${deleteTitle}")
    }
    return result;
  }
  function formatLink(id, baseUrl, image, imageAlt, imageTitle) {
    //var url = $.prepareUrl(baseUrl, {commentId:id});
    return "<a href='#' onclick='" + baseUrl + "'><image alt='" + imageAlt + "' title='" + imageTitle + "' src='" + image + "'> </a>";
//    return "<a href='" + url + "'><image alt='" + imageAlt + "' title='" + imageTitle + "' src='" + image + "'> </a>";
  }

  function openDeleteCommentDialog(commentId) {
    var dialog = $("#deleteCommentDialog");
    var uriId = "<s:property value='%{uriId}'/>";
    var url = $.prepareUrl("<s:url action='confirmDeleteComment' namespace='/poll'/>",
                           {uriId:uriId, commentId:commentId});
    dialog.load(url);
    dialog.dialog('open');
    return false;
  }

  function openDeleteVoteDialog(voteId) {
    var dialog = $("#deleteVoteDialog");
    var uriId = "<s:property value='%{uriId}'/>";
    var url = $.prepareUrl("<s:url action='confirmDeleteVote' namespace='/poll'/>",
                           {uriId:uriId, voteId:voteId});
    dialog.load(url);
    dialog.dialog('open');
    return false;
  }

  function openDeleteChoiceDialog(choiceId) {
    var dialog = $("#deleteChoiceDialog");
    var uriId = "<s:property value='%{uriId}'/>";
    var url = $.prepareUrl("<s:url action='confirmDeleteChoice' namespace='/poll'/>",
                           {uriId:uriId, choiceId:choiceId});
    dialog.load(url);
    dialog.dialog('open');
    return false;
  }

  jQuery(document).ready(function () {

    $('#poll tr:even').addClass('even');

    var $anonymousField = $('#voteForm [name="vote.anonymous"]');
    var $votingIdField = $('#voteForm [name="pollAccount.votingId"]');

    $votingIdField.attr('disabled', $anonymousField.prop('checked'));

    $anonymousField.change(function() {
      $votingIdField.attr('disabled', $(this).prop('checked'));
    });

  });

</script>

<h1 class="titleVote"><s:property value="poll.title"/></h1>

<!-- Informations sur le sondage -->

<div id="pollTop">
  <div style="white-space:pre-wrap; text-align: start;">
    <s:property value="poll.description"/>
  </div>
  <fieldset>
    <legend><s:text name="pollen.common.aboutPoll"/></legend>
    <div style="float: right">
      <s:if test="poll.publicResults">

        <s:a namespace="/poll" action="results/%{uriId}">
          <img src="<s:url value='/img/count.png'/>"
               title="<s:text name="pollen.common.vote.results-help"/>"
               alt="<s:text name="pollen.common.vote.results"/>"/>
        </s:a>
      </s:if>
      <%--<t:FeedContextLink t:id="feedContext"/>--%>
      <s:if test="feedFileExisting">
        <s:a namespace="/poll" action="getFeed">
          <s:param name="pollId" value="poll.pollId"/>
          <img src="<s:url value='/img/feed.png'/>" title="Atom" alt="Atom"/>
        </s:a>
      </s:if>
    </div>
    <s:label value="%{creatorName}" key='pollen.common.pollCreator'/>
    <s:label value="%{poll.beginDate}" key='pollen.common.beginDate'/>
    <s:label value="%{poll.endDate}" key='pollen.common.endDate'/>
    <s:label value="%{poll.voteCountingType}"
             label='%{getText("pollen.common.voteCountingType")}'
             tooltip="%{getVoteCountingTypeHelp(poll.voteCountingType)}"
             tooltipIconPath="/img/tooltip.png"/>
  </fieldset>
</div>

<div id="pollZone">
<s:if test="pollChoiceOrVoteStarted">

<!-- Sondage -->

<s:if test="poll.anonymous">
  <p>
    <s:text name="pollen.common.voteNbVotes">
      <s:param><s:property value="%{poll.sizeVote()}"/></s:param>
    </s:text>
  </p>
  <%--<t:feedback t:id="voteFeedback"/>--%>
</s:if>
<s:else>
  <div class="p-pager">
    <s:property value="%{voteSizeMessage}"/>
  </div>
  <%--TODO Do me pager !--%>
  <%--<t:pager t:nbRowsPerPage="nbVotesPerPage" t:nbTotalRows="poll.nbVotes"--%>
  <%--t:currentPage="page" t:noPagerText="prop:noPagerText"/>--%>
</s:else>

<sj:dialog id="deleteVoteDialog" height="120" resizable="false"
           title="%{getText('pollen.title.delete.pollVote')}"
           autoOpen="false" modal="true" width="800"/>

<sj:dialog id="deleteChoiceDialog" height="100" resizable="false"
           title="%{getText('pollen.title.delete.pollChoice')}"
           autoOpen="false" modal="true" width="800"/>

<s:form id="voteForm" validate="true">
<s:hidden key="uriId"/>
<table id="poll">
<thead>
<tr>
  <s:if test="accountFieldDisplayed">
    <th style="width:200px;">
      <s:text name="pollen.common.voterName"/>
    </th>
  </s:if>
  <s:else>
    <th></th>
  </s:else>
  <s:if test="textType">
    <s:iterator value="poll.choice" var="choice">
      <s:if test="!isChoiceHidden(#choice)">
        <th>
          <s:if test="!isDescNull(#choice)">

            <span title='<s:property value="escapeLineBreak(#choice.description)"/>'>
                <s:property value="name"/>
            </span>
          </s:if>
          <s:else>
            <s:property value="name"/>
          </s:else>
          <s:if test="pollChoiceRunning">
            <s:if test="creatorUser">
              <s:a action="deleteChoice" namespace="/poll" onclick="return openDeleteChoiceDialog('%{#choice.topiaId}');">
                <s:param name="choiceId"><s:property value="id"/></s:param>
                <img src="<s:url value="/img/delete.png"/>"
                     title="<s:text name="pollen.action.deleteChoice"/>"
                     alt="<s:text name="pollen.action.deleteChoice"/>"/>
              </s:a>
            </s:if>
          </s:if>
        </th>
      </s:if>
    </s:iterator>
  </s:if>

  <s:if test="dateType">
    <s:iterator value="poll.choice" var="choice">
      <s:if test="!isChoiceHidden(#choice)">
        <s:if test="!isDescNull(#choice)">

          <th class="desc">
            <span
              title='<s:property value="escapeLineBreak(#choice.description)"/>'>
                <s:property value="%{getChoiceAsDate(#choice)}"/>
            </span>
          </th>
        </s:if>
        <s:else>
          <th>
            <s:property value="%{getChoiceAsDate(#choice)}"/>
          </th>
        </s:else>
      </s:if>
    </s:iterator>
  </s:if>

  <s:if test="imageType">
    <s:iterator value="poll.choice" var="choice">
      <s:if test="!isChoiceHidden(#choice)">
        <s:url id="imageUrl" namespace="/io"
               action="getPollChoiceImage"
               escapeAmp="false">
          <s:param name="choiceId" value="name"/>
          <s:param name="pollId" value="poll.pollId"/>
          <s:param name="thumb" value="true"/>
        </s:url>
        <s:if test="!isDescNull(#choice)">

          <th class="desc">

            <img alt="<s:property value='name'/>"
                 title='<s:property value="escapeLineBreak(#choice.description)"/>'
                 src="<s:property value='imageUrl'/>">
          </th>
        </s:if>
        <s:else>
          <th>
            <img alt="<s:property value='name'/>"
                 title='<s:property value="escapeLineBreak(#choice.description)"/>'
                 src="<s:property value='imageUrl'/>">
          </th>
        </s:else>
      </s:if>
    </s:iterator>
  </s:if>
</tr>
</thead>
<s:if test="voteAllowed">
  <tfoot>
  <tr>
    <s:if test="accountFieldDisplayed">
      <th id="voterName">
        <s:textfield key='pollAccount.votingId' required="true"
                     value="%{pollAccount.votingId}" theme="simple"/>
      </th>
    </s:if>
    <s:else>
      <th></th>
    </s:else>
    <s:iterator value="poll.choice" var="choice" status="status">

      <s:if test="!isChoiceHidden(#choice)">
        <th>
          <s:if test="normalVoteCounting">
            <s:checkbox name="vote.choiceVoteToChoice[%{#status.index}].voteValue"
                        value="%{vote.choiceVoteToChoice[#status.index].voteValue}" theme="simple"/>
          </s:if>
          <s:if test="percentageVoteCounting">
            <s:textfield name="vote.choiceVoteToChoice[%{#status.index}].voteValue"
                         value="%{vote.choiceVoteToChoice[#status.index].voteValue}"
                         required="true" size="3" theme="simple"/>
            <%--t:validate="required, min=0, max=100"/>%--%>
          </s:if>
          <s:if test="condorcetVoteCounting">
            <s:textfield name="vote.choiceVoteToChoice[%{#status.index}].voteValue"
                         value="%{vote.choiceVoteToChoice[#status.index].voteValue}"
                         id="condorcetInput" size="3" theme="simple"/>
            <%--t:nulls="zero" t:validate="min=0, max=99"/>--%>
          </s:if>
          <s:if test="numberVoteCounting">
            <s:textfield name="vote.choiceVoteToChoice[%{#status.index}].voteValue"
                         value="%{vote.choiceVoteToChoice[#status.index].voteValue}"
                         size="3" theme="simple"/>
          </s:if>
        </th>
      </s:if>
    </s:iterator>
  </tr>
  </tfoot>
</s:if>
<tbody>
<s:if test="!poll.anonymous">
  <s:iterator value="votes" var="vote">
    <tr>
      <td>
        <s:if test="accountFieldDisplayed">
          <s:if test="!#vote.anonymous">
            <s:property value="pollAccount.votingId"/>
          </s:if>
          <s:else>
            ?
          </s:else>
        </s:if>
        <s:if test="!poll.anonymous">
          <s:if test="isModifAllowed(#vote)">
            <s:a action="editVote" namespace="/poll">
              <s:param name="pollId" value="%{pollId}"/>
              <s:param name="accountId" value="%{#vote.pollAccount.accountId}"/>
              <img src="<s:url value="/img/editSmall.png"/>"
                   title="<s:text name="pollen.action.editVote"/>"
                   alt="<s:text name="pollen.action.editVote"/>"/>
            </s:a>
          </s:if>
          <s:if test="isDeleteVoteAllowed(#vote)">
            <s:a action="deleteVote" namespace="/poll" href="#"
                 onclick="return openDeleteVoteDialog('%{#vote.topiaId}');">
              <img src="<s:url value="/img/delete.png"/>"
                   title="<s:text name="pollen.action.deleteVote"/>"
                   alt="<s:text name="pollen.action.deleteVote"/>"/>
            </s:a>
          </s:if>
        </s:if>
      </td>
      <s:iterator value="poll.choice" var="choice">
        <s:if test="!isChoiceHidden(#choice)">
          <s:set name="currentVoteChoice"
                 value="%{#vote.getChoiceVoteToChoice(#choice)}"/>
          <s:if test="poll.anonymous">
            <td class="anonymous">?</td>
          </s:if>
          <s:else>
            <s:if test="normalVoteCounting">
              <s:if test="isChoiceInVote(#currentVoteChoice)">
                <td class="voted">OK</td>
              </s:if>
              <s:else>
                <td class="notVoted"></td>
              </s:else>
            </s:if>
            <s:if test="percentageVoteCounting">
              <s:if test="isChoiceInVote(#currentVoteChoice)">
                <td class="voted">
                  <s:property value="%{#currentVoteChoice.voteValue}"/> %
                </td>
              </s:if>
              <s:else>
                <td class="notVoted"></td>
              </s:else>
            </s:if>
            <s:if test="condorcetVoteCounting">
              <s:if test="isChoiceInVote(#currentVoteChoice)">
                <td class="voted">
                  <s:property value="%{#currentVoteChoice.voteValue}"/>
                </td>
              </s:if>
              <s:else>
                <td class="notVoted"></td>
              </s:else>
            </s:if>
            <s:if test="numberVoteCounting">
              <s:if test="isChoiceInVote(#currentVoteChoice)">
                <td class="voted">
                  <s:property value="%{#currentVoteChoice.voteValue}"/>
                </td>
              </s:if>
              <s:else>
                <td class="notVoted"></td>
              </s:else>
            </s:if>
          </s:else>
        </s:if>
      </s:iterator>
    </tr>
  </s:iterator>
</s:if>
<s:if test="poll.continuousResults">
  <tr>
    <td>
      <s:a namespace="/poll" action="results/%{poll.pollId}">
        <s:text name="pollen.common.vote.results"/>
      </s:a>
    </td>

    <s:iterator value="poll.choice" var="choice">
      <s:if test="!isChoiceHidden(#choice)">
        <td class="result">
          <s:property value="%{getResultValue(#choice)}"/>
        </td>
      </s:if>
    </s:iterator>
  </tr>
</s:if>
</tbody>
</table>
<div id="voteError">
  <s:fielderror fieldName="pollAccount.votingId"/>
  <s:fielderror fieldName="vote.choices"/>
  <%--<t:errors/>--%>
</div>

<s:if test="voteAllowed">
  <div id="buttons">
    <s:if test="poll.anonymousVoteAllowed">
      <s:checkbox key="vote.anonymous"/>
      <%--<t:label for="anonymousVote"/>--%>
      <br/>
    </s:if>
    <s:submit action="vote/%{uriId}" key="pollen.action.pollVote" align="center"/>
      <%--<input id="submitVote" t:type="Submit" t:value="${message:submitVote}"/>--%>
  </div>
</s:if>
</s:form>
</div>

<!-- Ajout de choix -->
<s:if test="pollChoiceRunning">
  <div id="choiceFormDiv">
    <s:form id="choiceForm" method="POST" namespace="/poll" enctype="multipart/form-data">
      <h4><s:text name="pollen.action.addChoice"/></h4>
        <s:if test="textType">
          <s:textfield key="choice.name"
                       label="%{getText('pollen.common.choice')}"
                       required="true"/>
        </s:if>
        <s:elseif test="dateType">
          <sj:datepicker key="choice.date"
                         label="%{getText('pollen.common.choice')}"
                         changeMonth="true" changeYear="true"
                         timepicker="true"
                         displayFormat="%{getText('pollen.common.datePickerPattern')}"
                         required="true"/>
        </s:elseif>
        <s:elseif test="imageType">
          <s:file key="choice.location"
                  label="%{getText('pollen.common.choice')}"
                  cssClass="nameField"
                  required="true"/>
        </s:elseif>
        <br/>
        <s:textarea cols="36" key="choice.description"
                    label="%{getText('pollen.common.description')}"/>
        <br/>
        <s:submit action="addChoice/%{uriId}" key="pollen.action.addChoice" align="center"/>
    </s:form>
  </div>
</s:if>

<!-- Ajout de commentaires -->
<h3><s:text name="pollen.common.comments"/></h3>

<div id="commentZone">
  <div id="commentsDiv">
    <s:iterator value="comments" var="comment" status="status">
      <div
        <s:if test="#status.even">class="even"</s:if>
        <s:else>class="odd"</s:else>
        >
        <s:if test="isDeleteCommentAllowed(#comment)">
          <span class="cmd">
            <s:a href="#"
                 onclick="return openDeleteCommentDialog('%{#comment.topiaId}');">
              <img src="<s:url value='/img/delete.png'/>"
                   title="<s:text name="pollen.action.pollCommentDelete"/>"
                   alt="<s:text name="pollen.action.pollCommentDelete"/>"/>
            </s:a>
          </span>
        </s:if>
        <span class="name"><s:property value='#comment.author'/></span> :
        <span class="date">
          <s:property value='%{formatDateTime(postDate)}'/>
        </span>

        <p>
          <s:property value='text'/>
        </p>
      </div>
    </s:iterator>
  </div>
    <%--div id="commentsDiv">

      <s:url id="loadPollComments" action="getPollComments" namespace="/json"
             escapeAmp="false">
        <s:param name="pollId" value="%{poll.pollId}"/>
      </s:url>

      <sjg:grid id="comments" dataType="json" href="%{loadPollComments}"
                gridModel="comments" sortable="true" pager="true"
                pagerButtons="true" pagerInput="true" navigator="true"
                rownumbers="false" autowidth="true" editinline="false"
                navigatorEdit="false" navigatorDelete="false"
                navigatorSearch="false" navigatorRefresh="false"
                navigatorAdd="false" viewrecords="true" sortorder="desc"
                sortname="postDate" rowList="10,15,20,50,100" rowNum="10">

        <sjg:gridColumn name="id" title="id" hidden="true"/>
        <sjg:gridColumn name="postDate"
                        title='%{getText("pollen.common.postDate")}'
                        sortable="true" formatter="date" width="50"
                        formatoptions="{newformat : 'd.m.Y H:i', srcformat : 'Y-m-d H:i:s'}"/>
        <sjg:gridColumn name="pollAccount.votingId"
                        title='%{getText("pollen.common.commentName")}'
                        sortable="true"/>
        <sjg:gridColumn name="text"
                        title='%{getText("pollen.common.commentText")}'
                        sortable="true"/>
        <sjg:gridColumn name="functions" sortable="false" title='' width="10"
                        formatter="commentFunctions"/>
      </sjg:grid>
    </div--%>

    <%--<br/>--%>

  <div id="commentFormDiv">

    <s:form id='addCommentForm' method="POST" namespace="/poll" validate="true">
      <s:textfield key="commentAuthor" required="true" size="78"
                   label="%{getText('pollen.common.commentAuthor')}"/>
      <s:textarea key="commentText" required="true" value=''
                  label="%{getText('pollen.common.commentText')}"/>

      <div class="cleanBoth">
        <s:submit action="addComment/%{uriId}" key="pollen.action.addComment"
                  align="center"/>
      </div>
    </s:form>

  </div>

  <sj:dialog id="deleteCommentDialog" resizable="false"
             title="%{getText('pollen.title.delete.pollComment')}"
             autoOpen="false" modal="true" width="800"/>

</div>
</s:if>