/*
 * #%L
 * Pollen :: UI (strust2)
 * 
 * $Id: AdminUserRequired.java 3207 2012-03-23 21:32:36Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/security/AdminUserRequired.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.security;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.persistence.UserAccount;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class AdminUserRequired extends AbstractPollenAuthorization {

    private static final Log log =
            LogFactory.getLog(AdminUserRequired.class);

    @Override
    protected boolean isAccessAllowed(ServletRequest request,
                                      ServletResponse response,
                                      Object mappedValue) {

        UserAccount userAccount = getPollenUSerAccount(request);

        boolean isAccessAllowed = userAccount != null &&
                                  userAccount.isAdministrator();

        if (log.isDebugEnabled()) {
            if (isAccessAllowed) {
                log.debug("granting access to an admin-reserved page");
            } else {
                log.debug("illegal access to an admin-reserved page, user will be sent to " + getUnauthorizedUrl());
            }
        }

        return isAccessAllowed;
    }

}
