/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.job;

import org.chorem.pollen.services.PollenServicesApplicationContext;
import org.chorem.pollen.services.PollenTechnicalException;
import org.chorem.pollen.services.config.PollenServicesConfig;
import org.chorem.pollen.services.job.AnonymizeOlderVoteJob;
import org.chorem.pollen.services.job.CheckMailBoxJob;
import org.chorem.pollen.services.job.DeleteObsoleteSessionTokensJob;
import org.chorem.pollen.services.job.SendEmailInErrorsJob;
import org.chorem.pollen.services.job.SendPollEndReminderJob;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollenJobsScheduler {
    private static final Logger log = LoggerFactory.getLogger(PollenJobsScheduler.class);
    private final Scheduler scheduler;
    private final PollenServicesConfig applicationConfig;
    private final PollenServicesApplicationContext applicationContext;

    public PollenJobsScheduler(Scheduler scheduler, PollenServicesConfig applicationConfig, PollenServicesApplicationContext applicationContext) {
        this.scheduler = scheduler;
        this.applicationConfig = applicationConfig;
        this.applicationContext = applicationContext;
    }

    public void scheduleJobs() {
        JobDataMap data = new JobDataMap();
        data.put("applicationContext", (Object)this.applicationContext);
        JobDetail sendPollEndReminderJob = JobBuilder.newJob(SendPollEndReminderJob.class).usingJobData(data).withIdentity("sendPollEndReminderJob", "pollenJobs").build();
        JobDetail resendEmailsJob = JobBuilder.newJob(SendEmailInErrorsJob.class).usingJobData(data).withIdentity("resendEmailsJob", "pollenJobs").build();
        JobDetail deleteObsoleteSessionTokensJob = JobBuilder.newJob(DeleteObsoleteSessionTokensJob.class).usingJobData(data).withIdentity("deleteObsoleteSessionTokensJob", "pollenJobs").build();
        JobDetail checkMailBoxJob = JobBuilder.newJob(CheckMailBoxJob.class).usingJobData(data).withIdentity("checkMailBoxJob", "pollenJobs").build();
        JobDetail anonymizeOlderVotesJob = JobBuilder.newJob(AnonymizeOlderVoteJob.class).usingJobData(data).withIdentity("anonymizeOlderVotesJob", "pollenJobs").build();
        try {
            Trigger sendPollEndReminderTrigger = TriggerBuilder.newTrigger().withIdentity("sendPollEndReminderTrigger", "pollenTriggers").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.applicationConfig.getSendEndPollRemindersCronSchedule())).build();
            this.scheduler.scheduleJob(sendPollEndReminderJob, sendPollEndReminderTrigger);
            Trigger resendEmailsTrigger = TriggerBuilder.newTrigger().withIdentity("resendEmailsTrigger", "pollenTriggers").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.applicationConfig.getResendEmailsCronSchedule())).build();
            this.scheduler.scheduleJob(resendEmailsJob, resendEmailsTrigger);
            Trigger deleteObsoleteSessionTokensTrigger = TriggerBuilder.newTrigger().withIdentity("deleteObsoleteSessionTokensTrigger", "pollenTriggers").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.applicationConfig.getDeleteObsoleteSessionTokensCronSchedule())).build();
            this.scheduler.scheduleJob(deleteObsoleteSessionTokensJob, deleteObsoleteSessionTokensTrigger);
            Trigger checkMailBoxTrigger = TriggerBuilder.newTrigger().withIdentity("checkMailBoxTrigger", "pollenTriggers").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.applicationConfig.getMailBoxCronSchedule())).build();
            this.scheduler.scheduleJob(checkMailBoxJob, checkMailBoxTrigger);
            Trigger anonymizeOlderVotesTrigger = TriggerBuilder.newTrigger().withIdentity("anonymizeOlderVotesTrigger", "pollenTriggers").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.applicationConfig.getAnonymizeOlderVotesCronSchedule())).build();
            this.scheduler.scheduleJob(anonymizeOlderVotesJob, anonymizeOlderVotesTrigger);
            log.info("Jobs scheduled");
        }
        catch (SchedulerException se) {
            log.error("Error while launching the jobs", (Throwable)se);
            throw new PollenTechnicalException("Unable to schedule jobs", se);
        }
    }
}

