/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Date;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import org.chorem.pollen.persistence.entity.PollenUserEmailAddress;
import org.chorem.pollen.services.PollenTechnicalException;
import org.chorem.pollen.services.service.PollenServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoService
extends PollenServiceSupport {
    private static final Logger log = LoggerFactory.getLogger(CryptoService.class);
    public static final String PROVIDER = "BC";
    static final SecureRandom SECURE_RANDOM = new SecureRandom();

    public Optional<PGPPublicKey> getPublicKey(String email) {
        Optional<String> pgpPublicKeyOptional = this.getPollenUserEmailAddressDao().forEmailAddressEquals(email).tryFindUnique().map(PollenUserEmailAddress::getPgpPublicKey);
        return pgpPublicKeyOptional.map(publicKeyString -> {
            try {
                ByteArrayInputStream publicKeyInput = new ByteArrayInputStream(publicKeyString.getBytes());
                return this.readPublicKey(publicKeyInput);
            }
            catch (IOException | PGPException e) {
                throw new PollenTechnicalException("Unable to read PGP public key for email : " + email, e);
            }
        });
    }

    protected PGPPublicKey readPublicKey(InputStream input) throws IOException, PGPException {
        PGPPublicKeyRingCollection pgpPub = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)input), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        Iterator keyRingIterator = pgpPub.getKeyRings();
        while (keyRingIterator.hasNext()) {
            PGPPublicKeyRing keyRing = (PGPPublicKeyRing)keyRingIterator.next();
            Iterator keyIterator = keyRing.getPublicKeys();
            while (keyIterator.hasNext()) {
                PGPPublicKey key = (PGPPublicKey)keyIterator.next();
                if (!key.isEncryptionKey()) continue;
                return key;
            }
        }
        throw new IllegalArgumentException("Can't find encryption key in key ring.");
    }

    protected byte[] compressMessage(byte[] message) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        OutputStream pOut = null;
        PGPCompressedDataGenerator comData = null;
        try {
            comData = new PGPCompressedDataGenerator(1);
            try (OutputStream cos = comData.open((OutputStream)bOut);){
                PGPLiteralDataGenerator lData = new PGPLiteralDataGenerator();
                pOut = lData.open(cos, 'b', "_CONSOLE", (long)message.length, new Date());
                pOut.write(message);
            }
        }
        catch (Exception e) {
            log.error("Unexpected exception", (Throwable)e);
            throw e;
        }
        finally {
            if (pOut != null) {
                pOut.close();
            }
            if (comData != null) {
                comData.close();
            }
        }
        return bOut.toByteArray();
    }

    protected byte[] encryptMessage(byte[] message, PGPPublicKey pgpPublicKey) throws IOException, PGPException {
        byte[] compressMessage = this.compressMessage(message);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (ArmoredOutputStream out = new ArmoredOutputStream((OutputStream)bout);
             OutputStream encOut = this.createEncryptedDataGenerator(pgpPublicKey).open((OutputStream)out, (long)compressMessage.length);){
            encOut.write(compressMessage);
        }
        catch (Exception e) {
            log.error("Unexpected exception", (Throwable)e);
            throw e;
        }
        return bout.toByteArray();
    }

    private PGPEncryptedDataGenerator createEncryptedDataGenerator(PGPPublicKey pgpPublicKey) {
        JcePGPDataEncryptorBuilder encryptorBuilder = new JcePGPDataEncryptorBuilder(3).setSecureRandom(SECURE_RANDOM).setWithIntegrityPacket(true).setProvider(PROVIDER);
        PGPEncryptedDataGenerator encryptedDataGenerator = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)encryptorBuilder);
        JcePublicKeyKeyEncryptionMethodGenerator method = new JcePublicKeyKeyEncryptionMethodGenerator(pgpPublicKey).setProvider(PROVIDER).setSecureRandom(SECURE_RANDOM);
        encryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)method);
        return encryptedDataGenerator;
    }

    public Optional<String> encryptMailIfHasPgpKey(String body, Set<String> emails) {
        block4: {
            if (emails.size() != 1) {
                return Optional.empty();
            }
            Optional<PGPPublicKey> publicKey = this.getPublicKey(emails.iterator().next());
            if (publicKey.isPresent()) {
                try {
                    byte[] encryptMessage = this.encryptMessage(body.getBytes(), publicKey.get());
                    String encryptedBody = new String(encryptMessage);
                    return Optional.of(encryptedBody);
                }
                catch (IOException | PGPException e) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error("error on encrypte mail to email", e);
                }
            }
        }
        return Optional.empty();
    }

    public byte[] encryptMessageSymmetric(byte[] message) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS7Padding", PROVIDER);
            cipher.init(1, this.getSecretKey());
            return cipher.doFinal(message);
        }
        catch (GeneralSecurityException e) {
            throw new PollenTechnicalException("error on encrypt message", e);
        }
    }

    public byte[] decryptMessageSymmetric(byte[] encryptMessage) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS7Padding", PROVIDER);
            cipher.init(2, this.getSecretKey());
            return cipher.doFinal(encryptMessage);
        }
        catch (GeneralSecurityException e) {
            throw new PollenTechnicalException("error on decrypt message", e);
        }
    }

    protected SecretKey getSecretKey() {
        byte[] keyBytes = this.getPollenServiceConfig().getTokenSecretBytes();
        return new SecretKeySpec(keyBytes, "AES");
    }

    static {
        if (Security.getProvider(PROVIDER) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

