/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.callao.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.callao.entity.CallaoDAOHelper;
import org.chorem.callao.entity.Period;
import org.chorem.callao.entity.TimeSpan;
import org.chorem.callao.entity.TimeSpanDAO;
import org.chorem.callao.entity.Transaction;
import org.chorem.callao.service.PeriodServiceImpl;
import org.chorem.callao.service.TransactionServiceImpl;
import org.chorem.callao.service.convertObject.ConvertTimeSpan;
import org.chorem.callao.service.dto.TimeSpanDTO;
import org.chorem.callao.service.utils.ContextCallao;
import org.chorem.callao.service.utils.DateUtil;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;

public class TimeSpanServiceImpl {
    private static final Log log = LogFactory.getLog(TimeSpanServiceImpl.class);
    private TopiaContext rootContext = ContextCallao.getInstance().getContext();
    private ConvertTimeSpan convertTimeSpan = new ConvertTimeSpan();
    private static TransactionServiceImpl transactionServiceImpl = new TransactionServiceImpl();

    public String createTimeSpan(Date beginTimeSpan, Date endTimeSpan, Period period, boolean locked) {
        DateUtil dateutil = new DateUtil();
        beginTimeSpan = dateutil.InitDateFirstDayMonth(beginTimeSpan);
        endTimeSpan = dateutil.InitDateEndDayMonth(beginTimeSpan);
        if (log.isInfoEnabled()) {
            log.info((Object)("Nouveau timeSpan du " + beginTimeSpan.toString() + " au " + endTimeSpan.toString()));
        }
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            TimeSpanDAO timeSpanDAO = CallaoDAOHelper.getTimeSpanDAO((TopiaContext)topiaContext);
            TimeSpan newtimeSpan = (TimeSpan)timeSpanDAO.create(new Object[0]);
            newtimeSpan.setBeginTimeSpan(beginTimeSpan);
            newtimeSpan.setEndTimeSpan(endTimeSpan);
            newtimeSpan.setLocked(locked);
            newtimeSpan.setPeriod(period);
            topiaContext.commitTransaction();
            topiaContext.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)"Ajout avec succes du timeSpan");
            }
            return "success";
        }
        catch (TopiaException e) {
            log.error((Object)e);
            return "error";
        }
    }

    public TimeSpan searchTimeSpanByDate(Date d) {
        TimeSpan timeSpan = null;
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            TimeSpanDAO timeSpanDAO = CallaoDAOHelper.getTimeSpanDAO((TopiaContext)topiaContext);
            DateUtil dateutil = new DateUtil();
            Date searchDate = dateutil.InitDateFirstDayMonth(d);
            timeSpan = timeSpanDAO.findByBeginTimeSpan(searchDate);
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return timeSpan;
    }

    public TimeSpan searchTimeSpanByDate(TimeSpanDTO timeSpanDTO) {
        TimeSpan timeSpan = this.searchTimeSpanByDate(timeSpanDTO.getBeginTimeSpan());
        return timeSpan;
    }

    public TimeSpan searchTimeSpanWithTopiaId(String topiaId) {
        TimeSpan timeSpan = null;
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            TimeSpanDAO timeSpanDAO = CallaoDAOHelper.getTimeSpanDAO((TopiaContext)topiaContext);
            timeSpan = (TimeSpan)timeSpanDAO.findByTopiaId(topiaId);
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return timeSpan;
    }

    public TimeSpanDTO searchTimeSpanDTOByDate(Date d) {
        TimeSpan timeSpan = this.searchTimeSpanByDate(d);
        TimeSpanDTO timeSpanDTO = this.convertTimeSpan.timeSpanEntityToDto(timeSpan);
        return timeSpanDTO;
    }

    public List<TimeSpan> searchListTimeSpan(Period period) {
        List listTimeSpan = null;
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            TimeSpanDAO timeSpanDAO = CallaoDAOHelper.getTimeSpanDAO((TopiaContext)topiaContext);
            listTimeSpan = timeSpanDAO.findAllByPeriod(period);
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return listTimeSpan;
    }

    public List<TimeSpanDTO> searchListTimeSpanDTO(Period period) {
        ArrayList<TimeSpanDTO> listTimeSpanDTO = new ArrayList<TimeSpanDTO>();
        List<TimeSpan> listTimeSpan = this.searchListTimeSpan(period);
        for (TimeSpan timeSpan : listTimeSpan) {
            TimeSpanDTO timeSpanDTO = this.convertTimeSpan.timeSpanEntityToDto(timeSpan);
            listTimeSpanDTO.add(timeSpanDTO);
        }
        return listTimeSpanDTO;
    }

    public String blockTimeSpan(TimeSpan timespan) {
        String result = "error";
        if (timespan.getLocked()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Timespan deja bloqu\u00e9 !");
            }
        } else {
            Period period = this.getPeriodWithTimeSpan(timespan);
            if (period.getLocked()) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"La p\u00e9riode du timespan est bloqu\u00e9e !");
                }
            } else {
                boolean AllTimeSpanBlock = this.alltimeSpanBlocked(timespan, period);
                if (AllTimeSpanBlock) {
                    try {
                        TopiaContext topiaContext = this.rootContext.beginTransaction();
                        TimeSpanDAO timeSpanDAO = CallaoDAOHelper.getTimeSpanDAO((TopiaContext)topiaContext);
                        List<Transaction> listTransaction = transactionServiceImpl.searchListTransactionWithTimeSpan(timespan);
                        boolean isTransactionBalanced = true;
                        boolean existTransactionNotBalanced = false;
                        for (Transaction transaction : listTransaction) {
                            isTransactionBalanced = transactionServiceImpl.isTransactionBalanced(transaction);
                            if (isTransactionBalanced) continue;
                            if (log.isInfoEnabled()) {
                                log.info((Object)"La transaction n'est pas bloqu\u00e9e.");
                            }
                            existTransactionNotBalanced = true;
                        }
                        if (!existTransactionNotBalanced) {
                            timespan.setLocked(true);
                            timeSpanDAO.update((TopiaEntity)timespan);
                            topiaContext.commitTransaction();
                            if (log.isInfoEnabled()) {
                                log.info((Object)"Timespan bloqu\u00e9 avec succ\u00e8s");
                            }
                            result = "success";
                        } else {
                            result = "transaction_not_balanced";
                        }
                        topiaContext.closeContext();
                    }
                    catch (TopiaException e) {
                        log.error((Object)e);
                    }
                } else {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Il existe un ou plusieurs timespans pr\u00e9c\u00e9dents non bloqu\u00e9s.");
                    }
                    result = "timespan_prec_not_block";
                }
            }
        }
        return result;
    }

    public String blockTimeSpan(TimeSpanDTO timespanDTO) {
        return this.blockTimeSpan(this.searchTimeSpanByDate(timespanDTO));
    }

    public String unblockTimeSpan(TimeSpan timespan) {
        String result = "error";
        if (!timespan.getLocked()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Timespan non bloqu\u00e9 !");
            }
        } else {
            Period period = this.getPeriodWithTimeSpan(timespan);
            if (period.getLocked()) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"La p\u00e9riode du timespan est bloqu\u00e9e !");
                }
            } else {
                boolean NextTimeSpanUnblock = this.nextTimeSpanUnblock(timespan, period);
                if (NextTimeSpanUnblock) {
                    try {
                        TopiaContext topiaContext = this.rootContext.beginTransaction();
                        TimeSpanDAO timeSpanDAO = CallaoDAOHelper.getTimeSpanDAO((TopiaContext)topiaContext);
                        timespan.setLocked(false);
                        timeSpanDAO.update((TopiaEntity)timespan);
                        topiaContext.commitTransaction();
                        if (log.isInfoEnabled()) {
                            log.info((Object)"Timespan d\u00e9bloqu\u00e9 avec succ\u00e8s");
                        }
                        result = "success";
                        topiaContext.closeContext();
                    }
                    catch (TopiaException e) {
                        log.error((Object)e);
                    }
                } else {
                    result = "timespan_next_not_block";
                }
            }
        }
        return result;
    }

    public String unblockTimeSpan(TimeSpanDTO timespanDTO) {
        return this.unblockTimeSpan(this.searchTimeSpanByDate(timespanDTO));
    }

    private boolean nextTimeSpanUnblock(TimeSpan timespan, Period period) {
        boolean NextTimeSpanUnblock = false;
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            TimeSpanDAO timeSpanDAO = CallaoDAOHelper.getTimeSpanDAO((TopiaContext)topiaContext);
            List listeTimeSpanOfPeriod = timeSpanDAO.findAllByPeriod(period);
            NextTimeSpanUnblock = true;
            for (TimeSpan timeSpanNext : listeTimeSpanOfPeriod) {
                if (timeSpanNext.getBeginTimeSpan().compareTo(timespan.getBeginTimeSpan()) != 1 || !timeSpanNext.getLocked()) continue;
                NextTimeSpanUnblock = false;
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Timespan " + timeSpanNext.toString() + " est bloqu\u00e9"));
            }
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return NextTimeSpanUnblock;
    }

    private Period getPeriodWithTimeSpan(TimeSpan timeSpan) {
        PeriodServiceImpl periodServiceImpl = new PeriodServiceImpl();
        Date beginTimeSpan = timeSpan.getBeginTimeSpan();
        Period period = periodServiceImpl.searchPeriodWithDate(beginTimeSpan);
        return period;
    }

    private boolean alltimeSpanBlocked(TimeSpan timespan, Period period) {
        boolean AllTimeSpanBlock = false;
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            TimeSpanDAO timeSpanDAO = CallaoDAOHelper.getTimeSpanDAO((TopiaContext)topiaContext);
            List listeTimeSpanOfPeriod = timeSpanDAO.findAllByPeriod(period);
            topiaContext.closeContext();
            AllTimeSpanBlock = true;
            for (TimeSpan timeSpanPrev : listeTimeSpanOfPeriod) {
                if (timeSpanPrev.getBeginTimeSpan().compareTo(timespan.getBeginTimeSpan()) != -1 || timeSpanPrev.getLocked()) continue;
                AllTimeSpanBlock = false;
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Timespan " + timeSpanPrev.toString() + " non bloqu\u00e9"));
            }
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return AllTimeSpanBlock;
    }

    public String removeTimeSpan(TimeSpan timeSpan) {
        String result = "error";
        if (timeSpan.getLocked()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Timespan bloqu\u00e9 !");
            }
        } else {
            try {
                TopiaContext topiaContext = this.rootContext.beginTransaction();
                TimeSpanDAO timeSpanDAO = CallaoDAOHelper.getTimeSpanDAO((TopiaContext)topiaContext);
                timeSpanDAO.delete(timeSpan);
                topiaContext.commitTransaction();
                if (log.isInfoEnabled()) {
                    log.info((Object)"Timespan supprim\u00e9 avec succ\u00e8s");
                }
                result = "success";
                topiaContext.closeContext();
            }
            catch (TopiaException e) {
                log.error((Object)e);
            }
        }
        return result;
    }

    public boolean isTimeSpanBlocked(TimeSpan timeSpan) {
        boolean isTimeSpanBlocked = true;
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            TimeSpanDAO timeSpanDAO = CallaoDAOHelper.getTimeSpanDAO((TopiaContext)topiaContext);
            TimeSpan timeSpanSearch = (TimeSpan)timeSpanDAO.findByTopiaId(timeSpan.getTopiaId());
            isTimeSpanBlocked = timeSpanSearch.getLocked();
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return isTimeSpanBlocked;
    }

    public String[] getMethods() {
        return null;
    }

    public void destroy() {
    }

    public void init(TopiaContext arg0) {
    }
}

