/**
 * *##% Callao DateUtil
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */

package org.chorem.callao.service.utils;

import java.util.Date;
import java.util.Calendar;
import java.util.GregorianCalendar;

import org.apache.commons.logging.LogFactory;


/**
 * Cette classe permet de manipuler des dates.
 * @author Rémi Chapelet
 */
public class DateUtil {

    /** log */
    private static final org.apache.commons.logging.Log log = LogFactory.getLog(DateUtil.class);


    /**
     * Initialise la date d'entrée le premier du mois à minuit.
     * Exemple : 15 janvier 2009, alors date de sortie 1 Janvier 2009 00h00m00s
     * @param d date
     * @return
     */
    public Date InitDateFirstDayMonth (Date d)
    {
        Date date_result = new Date(d.getYear(),d.getMonth(),1,0,0,0);
        return date_result;
    }

    /**
     * Permet de retourner la date de fin de mois. Si on lui donne la date
     * 5 Janv 2000, elle retourne alors 31 Jan 2000.
     * @param d date de référence
     * @return la date du fin de mois
     */
    public Date InitDateEndDayMonth (Date d)
    {    
        Calendar c = new GregorianCalendar (d.getYear()+1900,d.getMonth(),d.getDate());
        // Calcul le dernier jour du mois, prend en compte les années bixestiles
        Integer maxDay = c.getActualMaximum(Calendar.DAY_OF_MONTH);
        //Date dateEnd = new Date(d.getYear(),d.getMonth(),maxDay,23,59,59);
        Calendar dateEnd = new GregorianCalendar (d.getYear()+1900,d.getMonth(),maxDay,23,59,59);
        Date result = dateEnd.getTime();
        return result;
    }

    /**
     * Permet de comparer deux dates. Si d1 est plus grande que d2, alors true
     * @param d1 Date 1
     * @param d2 Date 2
     * @return
     */
    public boolean DateGreatThan (Date d1, Date d2)
    {
        boolean result = false;
        long diff = d1.getTime() - d2.getTime();
        if (diff > 0 )
        {
            result=true;
        }
        return result;
    }

    /**
     * Permet de calculer le nombre de mois entre les deux dates.
     * @param d1 date 1
     * @param d2 date 2
     * @return
     */
    public int numberOfMonths (Date d1, Date d2)
    {
        GregorianCalendar gc1 = new GregorianCalendar();
        gc1.setTime(d1);
        GregorianCalendar gc2 = new GregorianCalendar();
        gc2.setTime(d2);
        int number_months = 0;
        gc1.add(GregorianCalendar.MONTH, 1);
        while(gc1.compareTo(gc2)<=0) {
            number_months++;
            gc1.add(GregorianCalendar.MONTH, 1);
        }
        return number_months;
    }

    /**
     * Permet de renvoyer la date précédente à celle donnée en paramètre.
     * Exemple : d = 17 avril 2000, return 16 avril 2000
     * @param d
     * @return
     */
    public Date previousDay(Date d)
    {
        Calendar c = new GregorianCalendar (d.getYear()+1900,d.getMonth(),d.getDate(),23,59,59);
        // Calcul le jour précédent
        c.add(Calendar.DATE, -1);
        Date result = c.getTime();
        return result;
    }

    /**
     * Permet de copier une date.
     * @param d
     * @return
     */
    public Date copyDate (Date d)
    {
        Date date_result = new Date(d.getYear(),d.getMonth(),d.getDay(),d.getHours(),d.getMinutes(),d.getSeconds());
        return date_result;
    }

    /**
     * Implémentation de compareTO. Si il y a besoin, il est possible de la modifier.
     * @param d1
     * @param d2
     * @return
     */
    public int compareDate(Date d1, Date d2)
    {
        return d1.compareTo(d2);
    }

    /**
     * Permet de renvoyer vrai si une date d donnée est entre deux dates.
     * @param d date se trouvant ou non dans la période
     * @param dateBegin date de début de période
     * @param dateEnd date de fin de période
     * @return
     */
    public boolean betweenDate (Date d, Date dateBegin, Date dateEnd)
    {
        boolean result = false;
        if (  ( (compareDate(d,dateBegin) == 0) || (compareDate(d,dateBegin) == 1) )
                && ( (compareDate(d,dateEnd) == 0) || (compareDate(d,dateEnd) == -1) )  )
        {
            result = true;
        }
        return result;
    }

    /**
     * Permet de découper une date dans un tableau.
     * Indices :
     * 0 : année
     * 1 : mois
     * 2 : jour
     * @param d
     * @return
     */
    public String[] arrayDate (Date d)
    {
        String dateTab[] = new String[3];
        // année
        dateTab[0] = Integer.toString(d.getYear()+1900);
        // mois
        dateTab[1] = Integer.toString(d.getMonth());
        // jour
        dateTab[2] = Integer.toString(d.getDate());
        return dateTab;
    }


}
