/**
 * *##% Callao TimeSpanDTO
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */

package org.chorem.callao.service.dto;

import java.util.Date;

import org.chorem.callao.service.utils.DateUtil;

/**
 * Classe DTO - représente une période (TimeSpan) mensuelle
 *
 * @author Rémi Chapelet
 */
public class TimeSpanDTO implements Comparable {

    private String id; // Identifiant Topia

    private Date beginTimeSpan;

    private Date endTimeSpan;

    private boolean locked;

    private static DateUtil dateUtil = new DateUtil();


    public TimeSpanDTO ()
    {
        this.id = "";
        this.beginTimeSpan = new Date();
        this.beginTimeSpan = dateUtil.InitDateFirstDayMonth(this.beginTimeSpan);
        this.endTimeSpan = new Date();
        this.endTimeSpan = dateUtil.InitDateEndDayMonth(this.endTimeSpan);
        this.locked = false;
    }

    public TimeSpanDTO (String id, Date beginTimeSpan,Date endTimeSpan,boolean locked)
    {
        this.id = id;
        this.beginTimeSpan = dateUtil.InitDateFirstDayMonth(beginTimeSpan);
        this.endTimeSpan = dateUtil.InitDateEndDayMonth(endTimeSpan);
        this.locked = locked;
    }

    /**
     * Implémente la classe comparable pour permettre le tri d'une liste avec
     * des objets timeSpanDTO.
     * @param other
     * @return
     */
    @Override
    public int compareTo(Object other) {
        int result = 1;
        Date date1 = ((TimeSpanDTO) other).beginTimeSpan;
        Date date2 = this.beginTimeSpan;
        result = dateUtil.compareDate(date2,date1);
        return result;
   }

    /**
     * @return the id
     */
    public String getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * @return the beginTimeSpan
     */
    public Date getBeginTimeSpan() {
        return beginTimeSpan;
    }

    /**
     * @param beginTimeSpan the beginTimeSpan to set
     */
    public void setBeginTimeSpan(Date beginTimeSpan) {
        this.beginTimeSpan = dateUtil.InitDateFirstDayMonth(beginTimeSpan);
    }

    /**
     * @return the endTimeSpan
     */
    public Date getEndTimeSpan() {
        return endTimeSpan;
    }

    /**
     * @param endTimeSpan the endTimeSpan to set
     */
    public void setEndTimeSpan(Date endTimeSpan) {
        this.endTimeSpan = dateUtil.InitDateEndDayMonth(endTimeSpan);
    }

    /**
     * @return the locked
     */
    public boolean isLocked() {
        return locked;
    }

    /**
     * @param locked the locked to set
     */
    public void setLocked(boolean locked) {
        this.locked = locked;
    }


    
}