/**
 * *##% Callao ConvertJournal
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */

package org.chorem.callao.service.convertObject;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.callao.entity.Journal;
import org.chorem.callao.service.dto.JournalDTO;

/**
 * Transforme les objets Account : DTO, DAO et entity
 *
 * @author Rémi Chapelet
 */
public class ConvertJournal  extends ConvertTopiaContext {

    private static final Log log = LogFactory.getLog(ConvertJournal.class);


    /**
     * Permet de transformer une entité journal en objet DTO
     * @param journal
     * @return
     */
    public JournalDTO journalEntityToDto(Journal journal)
    {
        JournalDTO journalDTO = new JournalDTO();
        journalDTO.setId(journal.getTopiaId());
        journalDTO.setLabel(journal.getLabel());
        journalDTO.setPrefix(journal.getPrefix());
        journalDTO.setDescription(journal.getDescription());
        return journalDTO;
    }


}