/**
 * *##% Callao FilesServiceImpl
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */

package org.chorem.callao.service;

import java.io.*;
import java.util.Date;
import java.util.List;
import java.util.Iterator;

import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.*;
import org.jdom.output.*;
import org.chorem.callao.service.dto.AccountDTO;
import org.chorem.callao.service.dto.EntryDTO;
import org.chorem.callao.service.dto.JournalDTO;
import org.chorem.callao.service.dto.PeriodDTO;
import org.chorem.callao.service.dto.TimeSpanDTO;
import org.chorem.callao.service.dto.TransactionDTO;
import org.chorem.callao.service.utils.DateUtil;
import org.chorem.callao.service.utils.ServiceHelper;
import org.nuiton.topia.TopiaContext;


/**
 * Cette classe permet d'importer et exporter des données comptables. Ces données
 * sont au format xml.
 *
 * @author Rémi Chapelet
 */
public class FilesServiceImpl { // implements FilesService {

    /**
     * log
     */
    private static final Log log = LogFactory.getLog(FilesServiceImpl.class);

    static Element racine = new Element("Callao");

    static org.jdom.Document document = new Document(racine);

    private static DateUtil dateUtil = new DateUtil();

    private AccountServiceImpl accountServiceImpl = new AccountServiceImpl();

    private EntryServiceImpl entryServiceImpl = new EntryServiceImpl();

    private JournalServiceImpl journalServiceImpl = new JournalServiceImpl();

    private PeriodServiceImpl periodServiceImpl = new PeriodServiceImpl();

    private TimeSpanServiceImpl timeSpanServiceImpl = new TimeSpanServiceImpl();

    private TransactionServiceImpl transactionServiceImpl = new TransactionServiceImpl();


    /**
     * Cete méthode permet d'exporter des données de Callao vers un fichier au
     * format xml.
     * @param namefile
     * @return
     */
	//@Override
	public String exportDatas(String nameFile)
    {
        if (log.isDebugEnabled()) {
            log.debug("Save file XML : ");
        }
        /**
         * Partie Informations
         */
        Element info = new Element("informations");
        racine.addContent(info);
        Attribute date = new Attribute("date",new Date().toString());
        info.setAttribute(date);
        Attribute user = new Attribute("user","Name user");
        info.setAttribute(user);
        Attribute company = new Attribute("company","Name company");
        info.setAttribute(company);
        /**
         * Partie Save
         */
        // Création Element save
        Element save = new Element("save");
        racine.addContent(save);
        /**
         * Period
         */
        // Création élément liste de périods
        Element periods = new Element("periods");
        // Création élément liste de timespans
        Element timeSpans = new Element("timespans");
        save.addContent(periods);
        save.addContent(timeSpans);
        // Recherche de la liste de toutes les périodes et leurs timeSpans en DTO
        List<PeriodDTO> listPeriodDTO = periodServiceImpl.getAllPeriod();
        // Pour chaque période
        for (PeriodDTO periodDTO : listPeriodDTO)
        {
            // Création élément périod
            Element period = new Element("period");
            periods.addContent(period);
            // Identifiant période
            Attribute id = new Attribute("id",periodDTO.getId());
            period.setAttribute(id);
            // BeginPeriod
            // Découpage date
            String dateTab[] = dateUtil.arrayDate(periodDTO.getBeginPeriod());
            Attribute beginYear = new Attribute("beginYear",dateTab[0]);
            period.setAttribute(beginYear);
            Attribute beginMonth = new Attribute("beginMonth",dateTab[1]);
            period.setAttribute(beginMonth);
            Attribute beginDay = new Attribute("beginDay",dateTab[2]);
            period.setAttribute(beginDay);
            // EndPeriod
            dateTab = dateUtil.arrayDate(periodDTO.getEndPeriod());
            Attribute endYear = new Attribute("endYear",dateTab[0]);
            period.setAttribute(endYear);
            Attribute endMonth = new Attribute("endMonth",dateTab[1]);
            period.setAttribute(endMonth);
            Attribute endDay = new Attribute("endDay",dateTab[2]);
            period.setAttribute(endDay);
            // Locked Period
            if ( periodDTO.isLocked() )
            {
                Attribute locked = new Attribute("locked","true");
                period.setAttribute(locked);
            } else {
                Attribute locked = new Attribute("locked","false");
                period.setAttribute(locked);
            }
            /**
             * TimeSpan
             */
            // Recherche des timeSpans de la période
            List<TimeSpanDTO> listTimeSpanDTO = periodDTO.getListTimeSpan();
            // Pour chaque timeSpan
            for (TimeSpanDTO timeSpanDTO : listTimeSpanDTO)
            {
                Element timeSpan = new Element("timespan");
                timeSpans.addContent(timeSpan);
                // Identifiant timeSpan
                Attribute idTimeSpan = new Attribute("id",timeSpanDTO.getId());
                timeSpan.setAttribute(idTimeSpan);
                Attribute idPeriod = new Attribute("idPeriod",periodDTO.getId());
                timeSpan.setAttribute(idPeriod);
                // Begin TimeSpan
                // Découpage date
                dateTab = dateUtil.arrayDate(timeSpanDTO.getBeginTimeSpan());
                Attribute beginYearTimeSpan = new Attribute("beginYear",dateTab[0]);
                timeSpan.setAttribute(beginYearTimeSpan);
                Attribute beginMonthTimeSpan = new Attribute("beginMonth",dateTab[1]);
                timeSpan.setAttribute(beginMonthTimeSpan);
                Attribute beginDayTimeSpan = new Attribute("beginDay",dateTab[2]);
                timeSpan.setAttribute(beginDayTimeSpan);
                // End TimeSpan
                dateTab = dateUtil.arrayDate(timeSpanDTO.getEndTimeSpan());
                Attribute endYearTimeSpan = new Attribute("endYear",dateTab[0]);
                timeSpan.setAttribute(endYearTimeSpan);
                Attribute endMonthTimeSpan = new Attribute("endMonth",dateTab[1]);
                timeSpan.setAttribute(endMonthTimeSpan);
                Attribute endDayTimeSpan = new Attribute("endDay",dateTab[2]);
                timeSpan.setAttribute(endDayTimeSpan);
                // Lock timeSpan
                if ( timeSpanDTO.isLocked() )
                {
                    Attribute locked = new Attribute("locked","true");
                    timeSpan.setAttribute(locked);
                } else {
                    Attribute locked = new Attribute("locked","false");
                    timeSpan.setAttribute(locked);
                }
            }            
        }
        /**
         * Journal
         */
        Element journals = new Element("journals");
        save.addContent(journals);
        List<JournalDTO> listJournalDTO = journalServiceImpl.getAllJournal();
        for (JournalDTO journalDTO : listJournalDTO)
        {
            Element journal = new Element ("journal");
            journals.addContent(journal);
            // Identification du journal
            Attribute idJournal = new Attribute ("id",journalDTO.getId());
            journal.setAttribute(idJournal);
            // Label
            Attribute label = new Attribute ("label",journalDTO.getLabel());
            journal.setAttribute(label);
            // Prefix
            Attribute prefix = new Attribute ("prefix",journalDTO.getPrefix());
            journal.setAttribute(prefix);
            // Description
            Attribute description = new Attribute ("description",journalDTO.getDescription());
            journal.setAttribute(description);
        }
        /**
         * Account
         */
        Element accounts = new Element("accounts");
        save.addContent(accounts);
        List<AccountDTO> listAccountDTO = accountServiceImpl.getAllAccount();
        // Appel une fonction récursive pour parcourir l'arborescence des comptes
        accountXML(listAccountDTO,accounts);     
        /**
         * Transaction
         */
        Element transactions = new Element("transactions");
        save.addContent(transactions);
        Element entries = new Element("entries");
        save.addContent(entries);
        // Recherche de toutes les transactions
        List<TransactionDTO> listTransactionDTO = transactionServiceImpl.getAllTransactionDTO();
        // Pour chaque transaction
        for (TransactionDTO transactionDTO : listTransactionDTO)
        {
            Element transaction = new Element ("transaction");
            transactions.addContent(transaction);
            // Identification de la transaction
            Attribute idTransaction = new Attribute ("id",transactionDTO.getId());
            transaction.setAttribute(idTransaction);
            // EntryDate
            String dateTab[] = dateUtil.arrayDate(transactionDTO.getEntryDate());
            Attribute entryDateYear = new Attribute ("entryDateYear",dateTab[0]);
            transaction.setAttribute(entryDateYear);
            Attribute entryDateMonth = new Attribute ("entryDateMonth",dateTab[1]);
            transaction.setAttribute(entryDateMonth);
            Attribute entryDateDay = new Attribute ("entryDateDay",dateTab[2]);
            transaction.setAttribute(entryDateDay);
            // VoucherRef
            Attribute voucherRef = new Attribute ("voucherRef",transactionDTO.getVoucherRef());
            transaction.setAttribute(voucherRef);
            // Description
            Attribute description = new Attribute ("description",transactionDTO.getDescription());
            transaction.setAttribute(description);
            // Id journal
            Attribute IdJournal = new Attribute ("idJournal",transactionDTO.getJournalDTO().getId());
            transaction.setAttribute(IdJournal);
            // Id timeSpan
            Attribute IdTimeSpan = new Attribute ("idTimeSpan",transactionDTO.getTimeSpanDTO().getId());
            transaction.setAttribute(IdTimeSpan);
            /**
             * Entry
             */           
            List<EntryDTO> listEntryDTO = entryServiceImpl.searchEntryDTOWithTransaction(transactionDTO);
            for (EntryDTO entryDTO : listEntryDTO)
            {
                Element entry = new Element ("entry");
                entries.addContent(entry);
                // Identification du entry
                Attribute idEntry = new Attribute ("id",entryDTO.getId());
                entry.setAttribute(idEntry);
                // Description
                Attribute descriptionEntry = new Attribute ("description",entryDTO.getDescription());
                entry.setAttribute(descriptionEntry);
                // Amount
                Attribute amount = new Attribute ("amount",entryDTO.getAmount());
                entry.setAttribute(amount);
                // Lettering
                Attribute lettering = new Attribute ("lettering",entryDTO.getLettering());
                entry.setAttribute(lettering);
                // Detail
                Attribute detail = new Attribute ("detail",entryDTO.getDetail());
                entry.setAttribute(detail);
                // Debit / crédit
                if ( entryDTO.isDebit() )
                {
                    Attribute debit = new Attribute("debit","true");
                    entry.setAttribute(debit);
                } else {
                    Attribute debit = new Attribute("debit","false");
                    entry.setAttribute(debit);
                }
                // Transaction
                Attribute idrefTransaction = new Attribute ("idTransaction",transactionDTO.getId());
                entry.setAttribute(idrefTransaction);
                // Account
                Attribute idAccount = new Attribute ("idAccount",entryDTO.getAccountDTO().getId());
                entry.setAttribute(idAccount);
            }
        }
        //affiche();
        enregistre(nameFile);
        return ServiceHelper.RESPOND_SUCCESS;
    }


    /**
     * Converti la liste des comptes pour être ajouté au document xml.
     * @param listAccountDTO
     * @param accounts
     */
    public void accountXML(List<AccountDTO> listAccountDTO,Element accounts)
    {
        for (AccountDTO accountDTO : listAccountDTO)
        {
            Element account = new Element ("account");
            accounts.addContent(account);
            // Identification du account
            Attribute idAccount = new Attribute ("id",accountDTO.getId());
            account.setAttribute(idAccount);
            // Label
            Attribute label = new Attribute ("label",accountDTO.getLabel());
            account.setAttribute(label);
            // Type
            Attribute type = new Attribute ("type",accountDTO.getType());
            account.setAttribute(type);
            // AccountNumber
            Attribute accountNumber = new Attribute ("accountNumber",accountDTO.getAccountNumber());
            account.setAttribute(accountNumber);
            // MasterAccountNumber
            Attribute masterAccountNumber = new Attribute ("masterAccount",accountDTO.getMasterAccount());
            account.setAttribute(masterAccountNumber);
            // Ajoute les comptes enfants à la liste
            accountXML(accountDTO.getAccountChildDTO(),accounts);
        }
    }


    // Affiche le fichier xml
    static void affiche()
    {
       try
       {
          XMLOutputter sortie = new XMLOutputter(Format.getPrettyFormat());
          sortie.output(document, System.out);
       }
       catch (java.io.IOException e){}
    }


    /**
     * Permet d'enregistrer le fichier xml.
     * @param fichier
     */
    static void enregistre(String fichier)
    {
       try
       {
          XMLOutputter sortie = new XMLOutputter(Format.getPrettyFormat());
          sortie.output(document, new FileOutputStream(fichier));
       }
       catch (java.io.IOException e){}
    }


    /**
     * Permet d'importer un fichier de données au format xml dans Callao. Si le
     * fichier n'est pas disponible, il est alors renvoyé un message d'erreur.
     * @param file
     * @return
     */
    //@Override
	public String importDatas(String file) {
        if (log.isDebugEnabled()) {
            log.debug("Load file XML : ");
        }
        String result = ServiceHelper.RESPOND_ERROR;
        boolean existError = false;

        /**
         * Chargement du fichier et construction du Dom
         */
        try {
            /* On crée une instance de SAXBuilder */
            SAXBuilder sxb = new SAXBuilder();
            document = sxb.build(file);
        } catch (IOException e) {
            log.error("Erreur lors de la lecture du fichier "
				+ e.getMessage() );
            e.printStackTrace();
        } catch (JDOMException e){
            log.error("Erreur lors de la construction du fichier JDOM "
				+ e.getMessage() );
            e.printStackTrace();
        }

        /**
         * Ecriture dans la base de données
         */
        try {
            // Recherche de la racine
            Element racine = document.getRootElement();

            /**
             * Journal
             */
            XPath requeteXpath = XPath.newInstance("//journal");
            List results = requeteXpath.selectNodes(racine);

            Iterator iter = results.iterator();
            // Pour tous les journaux
            while (iter.hasNext()){
                Element noeudCourant = (Element) iter.next();
                // Recherche attributs
                String label = noeudCourant.getAttribute("label").getValue();
                String prefix = noeudCourant.getAttribute("prefix").getValue();
                String description = noeudCourant.getAttribute("description").getValue();
                // Création bdd
                result = journalServiceImpl.createJournal(label, prefix, description);
                // Control erreur
                if ( result.equals(ServiceHelper.RESPOND_ERROR) )
                {
                    existError = true;
                }                
            }

            /**
             * Account
             */
            requeteXpath = XPath.newInstance("//account");
            results = requeteXpath.selectNodes(racine);

            iter = results.iterator();
            // Pour tous les accounts
            while (iter.hasNext()){
                Element noeudCourant = (Element) iter.next();
                // Recherche attributs
                String label = noeudCourant.getAttribute("label").getValue();
                String accountNumber =  noeudCourant.getAttribute("accountNumber").getValue();
                String masterAccount =  noeudCourant.getAttribute("masterAccount").getValue();
                String typeAccount =  noeudCourant.getAttribute("type").getValue();
                // Création bdd
                result = accountServiceImpl.createAccount(accountNumber, label, masterAccount,typeAccount);
                // Control erreur
                if ( result.equals(ServiceHelper.RESPOND_ERROR) )
                {
                    existError = true;
                }
            }

            /**
             * Period
             */
            requeteXpath = XPath.newInstance("//period");
            results = requeteXpath.selectNodes(racine);

            iter = results.iterator();
            // Pour tous les periods
            while (iter.hasNext())
            {
                Element noeudCourant = (Element) iter.next();
                // Recherche attributs
                String idPeriod =  noeudCourant.getAttribute("id").getValue();
                int year =  Integer.parseInt(noeudCourant.getAttribute("beginYear").getValue());
                int month =  Integer.parseInt(noeudCourant.getAttribute("beginMonth").getValue());
                int day =  Integer.parseInt(noeudCourant.getAttribute("beginDay").getValue());
                Date beginPeriod = new Date (year-1900,month,day);
                year =  Integer.parseInt(noeudCourant.getAttribute("endYear").getValue());
                month =  Integer.parseInt(noeudCourant.getAttribute("endMonth").getValue());
                day =  Integer.parseInt(noeudCourant.getAttribute("endDay").getValue());
                Date endPeriod = new Date (year-1900,month,day);                
                // Création bdd
                result = periodServiceImpl.createPeriod(beginPeriod, endPeriod, false);
                // Control erreur
                if ( result.equals(ServiceHelper.RESPOND_ERROR) )
                {
                    existError = true;
                }
         
                /**
                 * Transaction
                 */
                requeteXpath = XPath.newInstance("//transaction[@idTimeSpan=//timespan[@idPeriod='"+ idPeriod +"']/@id]");
                List resultsTransaction = requeteXpath.selectNodes(racine);
                Iterator iterTrans = resultsTransaction.iterator();
                // Pour tous les transactions
                while (iterTrans.hasNext())
                {
                    Element noeudCourantTrans = (Element) iterTrans.next();
                    /**
                     * Recherche attributs
                     */
                    // Id transaction XMl
                    String idTransactionXML = noeudCourantTrans.getAttribute("id").getValue();
                    // Recherche du journal en DTO
                    String idJournal = noeudCourantTrans.getAttribute("idJournal").getValue();
                    requeteXpath = XPath.newInstance("//journal[@id='" + idJournal + "']/@label");
                    String label = requeteXpath.valueOf(racine) ;
                    JournalDTO journalDTO = journalServiceImpl.searchJournalDTOWithLabel(label);
                    // Recherche du timeSpan en DTO
                    String idtimeSpan = noeudCourantTrans.getAttribute("idTimeSpan").getValue();
                    requeteXpath = XPath.newInstance("//timespan[@id='" + idtimeSpan + "']/@beginYear");
                    year = Integer.parseInt(requeteXpath.valueOf(racine));
                    requeteXpath = XPath.newInstance("//timespan[@id='" + idtimeSpan + "']/@beginMonth");
                    month = Integer.parseInt(requeteXpath.valueOf(racine));
                    requeteXpath = XPath.newInstance("//timespan[@id='" + idtimeSpan + "']/@beginDay");
                    day = Integer.parseInt(requeteXpath.valueOf(racine));
                    Date beginTimeSpan = new Date(year-1900,month,day);
                    TimeSpanDTO timeSpanDTO = timeSpanServiceImpl.searchTimeSpanDTOByDate(beginTimeSpan);
                    /**
                     * Création de transaction DTO
                     */
                    TransactionDTO transactionDTO = new TransactionDTO();
                    transactionDTO.setJournalDTO(journalDTO);
                    transactionDTO.setTimeSpanDTO(timeSpanDTO);
                    // entryDate
                    year =  Integer.parseInt(noeudCourantTrans.getAttribute("entryDateYear").getValue());
                    month =  Integer.parseInt(noeudCourantTrans.getAttribute("entryDateMonth").getValue());
                    day =  Integer.parseInt(noeudCourantTrans.getAttribute("entryDateDay").getValue());
                    Date entryDate = new Date(year-1900,month,day);
                    transactionDTO.setEntryDate(entryDate);
                    // voucherRef
                    String  voucherRef =  noeudCourantTrans.getAttribute("voucherRef").getValue();
                    transactionDTO.setVoucherRef(voucherRef);
                    // description
                    String  description =  noeudCourantTrans.getAttribute("description").getValue();
                    transactionDTO.setDescription(description);

                    // Création bdd
                    String idTransactionCallao = transactionServiceImpl.createTransaction(transactionDTO);
                    /**
                     * Entry
                     */
                    requeteXpath = XPath.newInstance("//entry[@idTransaction='" + idTransactionXML + "']");
                    List resultsEntry = requeteXpath.selectNodes(racine);

                    Iterator iterEntry = resultsEntry.iterator();
                    // Pour tous les entries
                    while (iterEntry.hasNext()){
                        Element noeudEntry = (Element) iterEntry.next();
                        /**
                         * Recherche attributs
                         */
                        // Transaction DTO
                        transactionDTO = transactionServiceImpl.searchTransactionDTO(idTransactionCallao);
                        // Account DTO
                        String idAccount = noeudEntry.getAttribute("idAccount").getValue();
                        requeteXpath = XPath.newInstance("//account[@id='" + idAccount + "']/@accountNumber");
                        String accountNumber = requeteXpath.valueOf(racine) ;
                        AccountDTO accountDTO = accountServiceImpl.searchAccountDTO(accountNumber);
                        // Entry DTO
                        EntryDTO entryDTO = new EntryDTO();
                        entryDTO.setAccountDTO(accountDTO);
                        entryDTO.setTransactionDTO(transactionDTO);
                        // Description
                        description =  noeudEntry.getAttribute("description").getValue();
                        entryDTO.setDescription(description);
                        // Amount
                        String amount =  noeudEntry.getAttribute("amount").getValue();
                        entryDTO.setAmount(amount);
                        // Debit
                        boolean debit =  noeudEntry.getAttribute("debit").getValue().equals("true");
                        entryDTO.setDebit(debit);
                        // Lettering
                        String lettering =  noeudEntry.getAttribute("lettering").getValue();
                        entryDTO.setLettering(lettering);
                        // Detail
                        String detail =  noeudEntry.getAttribute("detail").getValue();
                        entryDTO.setDetail(detail);
                        // Création bdd
                        result = transactionServiceImpl.addEntry(entryDTO);
                        // Control erreur
                        if ( result.equals(ServiceHelper.RESPOND_ERROR) )
                        {
                            existError = true;
                        }
                    }
                }

                /**
                 * Bloquer Period
                 */
                boolean lock =  noeudCourant.getAttribute("locked").getValue().equals("true");
                // Si la période est bloquée
                if ( lock )
                {
                    // Bloque tous ses timeSpans
                    result = periodServiceImpl.blockAllTimeSpanOfPeriod(periodServiceImpl.searchPeriodWithDate(beginPeriod));
                    // Control erreur
                    if ( result.equals(ServiceHelper.RESPOND_ERROR) )
                    {
                        existError = true;
                    }
                    // bloque la période
                    result = periodServiceImpl.blockPeriod(periodServiceImpl.searchPeriodWithDate(beginPeriod));
                    
                } else {
                    // On regarde si il y a besoin de bloquer les timeSpans
                    requeteXpath = XPath.newInstance("//timespan[@idPeriod = '"+idPeriod+"']");
                    List resultsTimeSpan = requeteXpath.selectNodes(racine);
                    Iterator iterTimeSpan = resultsTimeSpan.iterator();
                    // Pour tous les timeSpans
                    while (iterTimeSpan.hasNext()){
                        Element noeudCourantTimeSpan = (Element) iterTimeSpan.next();
                        // Recherche attributs
                        year =  Integer.parseInt(noeudCourantTimeSpan.getAttribute("beginYear").getValue());
                        month =  Integer.parseInt(noeudCourantTimeSpan.getAttribute("beginMonth").getValue());
                        day =  Integer.parseInt(noeudCourantTimeSpan.getAttribute("beginDay").getValue());
                        Date beginTimeSpan = new Date (year-1900,month,day);
                        lock =  noeudCourantTimeSpan.getAttribute("locked").getValue().equals("true");
                        // Bloque le timeSpan
                        if (lock)
                        {
                            timeSpanServiceImpl.blockTimeSpan(timeSpanServiceImpl.searchTimeSpanByDate(beginTimeSpan));
                        }
                        // Control erreur
                        if ( result.equals(ServiceHelper.RESPOND_ERROR) )
                        {
                            existError = true;
                        }
                    }
                }            

            }

            
        } catch (JDOMException e) {
            log.error("Erreur JDOM " + e.getMessage() );
            e.printStackTrace();
        }

        // Détection des erreurs
        if ( !existError )
        {
            result = ServiceHelper.RESPOND_SUCCESS;
        }
		return result;
	}



	//@Override
	public String[] getMethods() {
		// TODO Auto-generated method stub
		return null;
	}

	

	//@Override
	public void destroy() {
		// TODO Auto-generated method stub

	}

	//@Override
	public void init(TopiaContext arg0) {
		// TODO Auto-generated method stub

	}

}
