/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary.impl;

import boofcv.alg.filter.binary.ThresholdBlock;
import boofcv.alg.filter.binary.ThresholdBlockMinMax;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.InterleavedF32;

public class ThresholdBlockMinMax_F32
extends ThresholdBlockMinMax<GrayF32, InterleavedF32> {
    float scale;

    public ThresholdBlockMinMax_F32(float minimumSpread, float scale, boolean down) {
        super(minimumSpread, down);
        this.scale = scale;
    }

    @Override
    public void thresholdBlock(int blockX0, int blockY0, GrayF32 input, InterleavedF32 stats, GrayU8 output) {
        int y;
        int blockY1;
        int blockX1;
        int y1;
        int x0 = blockX0 * this.blockWidth;
        int y0 = blockY0 * this.blockHeight;
        int x1 = blockX0 == stats.width - 1 ? input.width : (blockX0 + 1) * this.blockWidth;
        int n = y1 = blockY0 == stats.height - 1 ? input.height : (blockY0 + 1) * this.blockHeight;
        if (this.thresholdFromLocalBlocks) {
            blockX1 = Math.min(stats.width - 1, blockX0 + 1);
            blockY1 = Math.min(stats.height - 1, blockY0 + 1);
            blockX0 = Math.max(0, blockX0 - 1);
            blockY0 = Math.max(0, blockY0 - 1);
        } else {
            blockX1 = blockX0;
            blockY1 = blockY0;
        }
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        for (int y2 = blockY0; y2 <= blockY1; ++y2) {
            for (int x = blockX0; x <= blockX1; ++x) {
                float localMin = stats.getBand(x, y2, 0);
                float localMax = stats.getBand(x, y2, 1);
                if (localMin < min) {
                    min = localMin;
                }
                if (!(localMax > max)) continue;
                max = localMax;
            }
        }
        float textureThreshold = (float)this.minimumSpread;
        if (this.down) {
            for (y = y0; y < y1; ++y) {
                int indexInput = input.startIndex + y * input.stride + x0;
                int indexOutput = output.startIndex + y * output.stride + x0;
                int x = x0;
                while (x < x1) {
                    if (max - min <= textureThreshold) {
                        output.data[indexOutput] = 1;
                    } else {
                        float average = this.scale * (max + min) / 2.0f;
                        output.data[indexOutput] = input.data[indexInput] <= average ? (byte)1 : 0;
                    }
                    ++x;
                    ++indexOutput;
                    ++indexInput;
                }
            }
        } else {
            for (y = y0; y < y1; ++y) {
                int indexInput = input.startIndex + y * input.stride + x0;
                int indexOutput = output.startIndex + y * output.stride + x0;
                int x = x0;
                while (x < x1) {
                    if (max - min <= textureThreshold) {
                        output.data[indexOutput] = 1;
                    } else {
                        float average = this.scale * (max + min) / 2.0f;
                        output.data[indexOutput] = input.data[indexInput] > average ? (byte)1 : 0;
                    }
                    ++x;
                    ++indexOutput;
                    ++indexInput;
                }
            }
        }
    }

    @Override
    public ThresholdBlock.BlockProcessor<GrayF32, InterleavedF32> copy() {
        return new ThresholdBlockMinMax_F32((float)this.minimumSpread, this.scale, this.down);
    }

    @Override
    public InterleavedF32 createStats() {
        return new InterleavedF32(1, 1, 2);
    }

    @Override
    public void computeBlockStatistics(int x0, int y0, int width, int height, int indexMinMax, GrayF32 input, InterleavedF32 stats) {
        float max;
        float min = max = input.unsafe_get(x0, y0);
        for (int y = 0; y < height; ++y) {
            int indexInput = input.startIndex + (y0 + y) * input.stride + x0;
            for (int x = 0; x < width; ++x) {
                int n = indexInput++;
                float value = input.data[n];
                if (value < min) {
                    min = value;
                    continue;
                }
                if (!(value > max)) continue;
                max = value;
            }
        }
        stats.data[indexMinMax] = min;
        stats.data[indexMinMax + 1] = max;
    }
}

